Cfp       +
R  "{'*-0m35,8);B>k@AXE:HIKNURjUX\`ScM     Use PgDn for the next page, PgUp for the previous page, or Esc to exit       ͻ
 > Version 2.00 @
 l
 l
 l
 : ͻ;
 :  P E R I S C O P E ;
 : ͼ;
 l
 9:
 9  The Undercover Debugger :
 9:
 l
 l
      This demo program is not copyrighted and may be freely distributed     
 ͼ

 ͻ
  Thank you for your interest in Periscope. The following pages describe and 
  demonstrate the debugging system guaranteed to solve your debugging prob-  
  lems and save you time! If you have any questions, don't hesitate to call  
  us toll-free at 800/722-7006. Press PgDn to begin the demonstration.       
 ͼ

Hͻ
H An overview ... 
Hͼ

Periscope is a debugging system for the IBM PC, XT, AT, Compaq and other close
compatibles.  It is a full-featured symbolic debugger and break-out switch
that will save you hours of debugging time.  It supports the most popular
languages, including Assembly, BASIC, C, and Pascal.

There are two models of Periscope.  Periscope I includes the Submarine
memory board with 16K of write-protected RAM and a break-out switch.
Periscope II does not include the memory board, but does include a remote
break-out switch.  The two models are functionally very similar -- Periscope I
provides a greater degree of security since the debugger is protected from a
run-away program, but Periscope II does not require an expansion slot.

The Periscope system includes the Submarine board, a remote break-out switch,
the debugger software, a 150+ page manual in a 3-ring binder and a quick-
reference card.  The Submarine board contains 16K of write-protected RAM.  The
critical code and data for the debugger is loaded into the memory and then the
memory is write-protected to prevent a runaway program from modifying it.

Periscope is fast, because it's written entirely in assembler.  Some of
Periscope's other time-saving features include --

Debug your program using symbol names instead of addresses.  For some
compilers, source code line numbers and actual source code are shown too.

Run your program on a monochrome monitor while debugging it on a color
monitor, or vice-versa.  For single-monitor systems, switch from the debugger
screen to the program's screen with one keystroke -- great for debugging
screen-intensive programs.

Set a breakpoint on the 500th iteration of a loop, or find where a pointer is
corrupting memory using Periscope's 'monitor' breakpoints.

Stop guessing what your program is doing -- the break-out switch stops the
system and lets you see what's happening.  Recover from parity errors, a
'dead' keyboard, and other situations where the system locks up!  After
Periscope has been installed, the break-out switch can be used to interrupt
the program that is currently executing and enter the resident debugger --
even when the system is hung.

Periscope is built to be able to recover from most anything your program can
do to hang the system.  Some of the safeguards built into Periscope include:

- On entry, the BIOS vectors that Periscope uses are saved.  Periscope then
changes these interrupts back to their power-on (ROM) values, for maximum
reliability.  On exit from Periscope, the program's vectors are restored.

- Periscope uses BIOS interrupts for all but the file-oriented functions, so
that there is no chance of Periscope calling DOS when DOS is already active.
The use of BIOS also allows you to trace DOS.

- The break-out switch is effective even when interrupts are disabled.  Active
timer and keyboard interrupts are detected and handled by Periscope.  If
needed, the keyboard is also reset.

- Whenever possible, Periscope restores the state of the system so that an
interrupted program will not be affected.  The original keyboard buffer and
CRT control buffers are saved on entry to Periscope and restored on exit.

Hͻ
H Recover from a hung system! 
Hͼ

The resident debugger is command-driven and has a command structure similar to
the standard PC-DOS debugger.  On-line help is available for all of the
commands.  The debugger has all the usual functions plus:

- User-selected windowing of data, register, stack, and/or disassembly
information.  You choose the data that is to be shown in windows and the size
of the windows when Periscope is loaded from disk or on the fly.

- Display memory in ASCII, byte, integer, signed integer, word, and double
word formats, skipping lines of repetitive values.

- Display a block of memory by individual fields within a record.  For
example, you can display the Program Segment Prefix with each field in the
'record' labeled and on a separate line.  You can define records as needed.

- View a text file from within Periscope.

- Interactively add and change symbol definitions.

@ͻ
@ The standard functions, plus ... 
@ͼ
- Search memory for procedure and address references -- you can find all jumps
or calls to a particular address or all references to a data item.

- Set up to 16 'sticky' code breakpoints that are remembered until cleared.

- Set breakpoints on register, byte, and word values; reads or writes of
ranges of memory or ports; execution of software interrupts; or perform user
breakpoint tests.  For example, you can set breakpoints when register CX
equals 0FFFH, when a word in memory is less than some value, or when memory
from specified ranges is read.  These breakpoints cause the system to run much
slower than normal, but when they're needed, they can be invaluable.

- Debug device drivers, memory-resident, and non-DOS programs!

- Jump to the next instruction at the same level -- useful for executing
subroutine calls and interrupts at full speed.

- Trace back through previously-executed instructions.

- Enter multiple commands on one line and then repeat the entire command
string with one keystroke.  Assign commands to function keys too!
@ͻ
- And much more ...- ... more important features 
@ͼ

Periscope is symbolic -- you can use names from your program instead of
addresses.  Anywhere an address can be used, Periscope also accepts a symbol
name.  The symbol names are read from the MAP file generated by the linker.
Line number symbols let you view high-level source code for some compilers.
You can use linkers produced by Microsoft, IBM, Phoenix, and Digital Research.

Each symbol corresponds to a segment and an offset.  For example, to display
memory starting at the address labeled 'BUFFER', enter D @BUFFER.  If you
have a subroutine named 'PRINT_LINE', you can Go to the first invocation of
the subroutine by typing G .PRINT_LINE.  (@ or a period precedes a symbol
name).

If you disassemble the program, the start of PRINT_LINE is shown as well as
any data elements that PRINT_LINE uses.  This symbolic capability can speed up
debugging tremendously, since you do not have to look for a particular
sequence of instructions to find a certain section of code, nor do you have to
worry about the location of code or data -- you can access it by name!  You
can also define new symbols or redefine existing symbols while the debugger is
active.
Hͻ
H Symbols are wonderful! 
Hͼ

Now, let's see a sample debugging session.

A>run sample.com
RUN (Version 2.00) Copyright 1984, 1985 Data Base Decisions
Program Segment Prefix (PSP) is 0B75:0000
Address references loaded into symbol table%ͻ
Record definitions loaded into record table% From the DOS prompt,#
P use the program loader 
P RUN to load SAMPLE.COM 
Pͼ


AX=0000  BX=0000  CX=008B  DX=0000  SP=FFFD  BP=0000  SI=0000  DI=0000
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0100#NV UP EI PL ZR NA PE NC
0SAMPLE:
0B75:0100 EB35*JMP%START,ͻ
>P The first instruction 
Q is shown -- note the  
Q symbol names SAMPLE#
Q and START.,
Qͼ
Hͻ
H To get Help, enter '?' 
Hͼ
>?
The commands are:  Assemble (A AU), Breakpoint (BA BB BC BI BL BM BP BR BU BW),
Compare (C), Display (D DA DB DD DE DI DN DR DW), Enter (E ES), Fill (F), Go
(G GT), Hex (H), In (I), Jump (J JL JN), Klear (K), Load (LA LF), Move (M),
Name (N), Out (O), Quit (Q), Register (R RR RS), Search (S SA SU), Trace (T TB
TN), Unassemble (U UA US), View (V), Write (WA WF), Xlate (XA XD XH), & Options
(/S /U /W)

Hͻ
H To get help for the Dis-#
>? daC play command, enter '? da' 
Syntax:  DA [<range>]3ͼ

This command is used to display a block of memory in ASCII. Each line of the
display shows the starting segment and offset and up to 64 bytes of ASCII
characters. All characters are displayed as is, except for the control
characters NUL, backspace, carriage return, and line feed. Nuls are converted
to spaces and the other three control characters are converted to a period. A
new line is started when a CR/LF is found. If TAB characters are found, the
output position is moved to the next tab stop.
>d cs:0
0B75:0000  CD 20 C0 27 00 9A F0 FE-1D F0 3A 01 E3 02 07 01#M @'..p~.p:.c...
0B75:0010  E3 02 96 01 E3 02 00 00-00 00 00 00 00 00 00 00#c...c...........
+* 0003 LINES OF 00 SKIPPED *
0B75:0050  00 00 00 00 00 00 00 00-00 00 00 00 00 20 20 20#.............
0B75:0060  20 20 20 20 20 20 20 20-00 00 00 00 00 20 20 20+.....
0B75:0070  20 20 20 20 20 20 20 20-00 00 00 00 59 D9 59 00+....YYY.

>dw @totmem l 2
0B75:0133  009F

>dd 0:0 l 30
0000:0000  00BF:1501$BFF0:0B4B$BFF0:0B4B$BFF0:0B44
0000:0010  0060:0086$F000:FF54$0000:0000$0000:0000
0000:0020  F000:FEA5$F000:E987$0000:0000$0000:0000

Hͻ
H You can display memory in the 
H normal fashion, or in ASCII,  
H double word, integer, or word 
H formats. Or, for complex rec- 
H ords ...6
Hͼ
>dr cs:0 @psp
Int 20%CD 20MM
Top Mem$5000
Reserved#00P.
Long Call  9AP.
DOS Func#F01D:FEF0
Terminate  0B42:012C
Ctrl-Break 0B42:0139
Error&0B42:0481
DOS Use$42 0B 01 01 01 00 02 FF FF FF FF FF FF FF FF FF#B...............
+FF FF FF FF FF FFA......
Environ$125B
DOS Use$E2 FF 61 12 14 00 18 00 61 12 00 00 00 00 00 00#................
+* 0001 LINES OF 00 SKIPPED *
+00 00 CD 21 CB 00 00 00 00 00 00 00 00 00)..M!K.........
PSP1'00 20 20 20 20 20 20 20 20 20 20 20 00 00 00 00#.+....
PSP2'00 20 20 20 20 20 20 20 20 20 20 20 00 00 00 00#.+....
+00 00 00 00G....
Hͻ
H ... Display memory in record 
H formats of you own design,#
H such as the one shown here!  
Hͼ

Hͻ
H The Trace command is used to 
H single-step instructions%
Hͼ
>t
AX=0000  BX=0000  CX=008B  DX=0000  SP=FFFD  BP=0000  SI=0000  DI=0000
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0137#NV UP EI PL ZR NA PE NC
WR SS:FFFB = F346
0START:
0B75:0137 E81700(CALL$GETMEM

8ͻ
8 Note the two symbols -- START for this instruc-  
8 tion and GETMEM for the called procedure.  Also, 
8 the effective address for any memory reads or$
8 writes is shown.  In this case, one word will$
8 be written to SS:FFFB.  The current value of%
8 F346 is also shown.>
8ͼ
>u
0START:
0B75:0137 E81700(CALL$GETMEM
0B75:013A A13301(MOV%AX,[TOTMEM]
0B75:013D BF1001(MOV%DI,01105; TMEMORY
0B75:0140 E82400(CALL$CONVERT
0B75:0143 A13501(MOV%AX,[FREMEM]
0B75:0146 BF2C01(MOV%DI,012C5; AMEMORY
0B75:0149 E81B00(CALL$CONVERT
0B75:014C E83400(CALL$DISPLAY
0DOSRET:
0B75:014F CD20*INT%20
0GETMEM:
0B75:0151 B106*MOV%CL,06
0B75:0153 BE0200(MOV%SI,0002
0B75:0156 8B04*MOV%AX,[SI]

@ͻ
@ The Unassemble command uses all available 
@ symbols to make the disassembly easier to 
@ read.  Compare this with the next page.#
@ͼ

>u
0B75:0137 E81700(CALL$0151
0B75:013A A13301(MOV%AX,[0133]
0B75:013D BF1001(MOV%DI,0110
0B75:0140 E82400(CALL$0167
0B75:0143 A13501(MOV%AX,[0135]
0B75:0146 BF2C01(MOV%DI,012C
0B75:0149 E81B00(CALL$0167
0B75:014C E83400(CALL$0183
0B75:014F CD20*INT%20
0B75:0151 B106*MOV%CL,06
0B75:0153 BE0200(MOV%SI,0002
0B75:0156 8B04*MOV%AX,[SI]



@ͻ
@ This disassembly is of the same code as 
@ the previous page, but without symbols. 
@ See how symbols improve readability?$
@ͼ


A10:(lower = 0;)/* lower limit */
0E0E:0088 33C0*XOR%AX,AX
A11:(upper = 300;'/* upper limit */
0E0E:008A C7060A002C01  MOV%WORD PTR [UPPER],012C
A12:(step = 20;)/* step size */
0E0E:0090 C7060C001400  MOV%WORD PTR [STEP],0014
A13:(fahr = lower;
0E0E:0096 A30800(MOV%[LOWER],AX
0E0E:0099 E81704(CALL$CXV04

0ͻ
0 This is Periscope's disassembly of the Kernighan &  
0 Ritchie program FTOC.C.  Note the source code, line 
0 symbols, and the symbols UPPER, STEP, and LOWER.$
0ͼ

>sa @start @display @convert
0B75:0140 E82400(CALL$CONVERT
0B75:0149 E81B00(CALL$CONVERT

>sa @start @display @totmem
0B75:013A A13301(MOV%AX,[TOTMEM]
0B75:015A A33301(MOV%[TOTMEM],AX

@ͻ
@ You can search a range of memory for in-  
@ structions that reference an address -- a 
@ quick way to find all jumps or calls to a 
@ procedure or all lines that use a data$
@ variable.  The examples above search from 
@ 'START' to 'DISPLAY' for references to$
@ the symbols 'CONVERT' and 'TOTMEM'.'
@ You can also search for assembler strings 
@ to find all instructions matching a'
@ pattern such as 'POP' or 'MOVS'.*
@ͼ
0B75:012C  AMEMORY
0B75:011A  AVAIL
0B75:0135  FREMEM
0B75:0137  START0ͻ
0B75:014F  DOSRET/ Symbols are read from the program's MAP 
0B75:0151  GETMEM/ file when the program loader is used to 
0B75:0167  CONVERT. load the program.  The supported link-  
0B75:0173  CVTCHAR. ers include Microsoft, IBM, Phoenix,$
0B75:0183  DISPLAY. and Digital Research.3
0B75:0100  SAMPLE/ͼ
0B75:0110  TMEMORY
0B75:0102  TOTAL
0B75:0133  TOTMEM


>es ds:200 @array
8ͻ
8 You can add or redefine symbols while#
8 Periscope is active, using the Enter$
8 Symbol command, an address, and a name. 
8ͼ




>bc @dosret

>bw @totmem ne 0

>bm 0:0 0:3ff rw


/ͻ
/ Periscope supports up to 16 'sticky' code breakpoints#
/ as well as a wide variety of 'monitor' breakpoints.%
/ The commands above set a 'sticky' breakpoint at the%
/ symbol DOSRET, a word breakpoint when the data variable 
/ TOTMEM is not equal to zero, and a memory breakpoint$
/ on any reads or writes of memory from 0:0 to 0:3FF.%
/ͼ



>x 58
0058h'88d%0000 0000 0101 1000b%X


>x ax
0058h'88d%0000 0000 0101 1000b%X


>xd 88
0058h'88d%0000 0000 0101 1000b%X


8ͻ
8 You can translate hex to decimal or vice-versa.  
8 The binary and ASCII equivalents are also shown. 
8ͼ

>tb 3
AX=0000  BX=0000  CX=008B  DX=0000  SP=FFFE  BP=0000  SI=0000  DI=0000
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0137#NV UP EI PL ZR NA PE NC##0001
0START:
0B75:0137  E81700'CALL$GETMEM

AX=0000  BX=0000  CX=008B  DX=0000  SP=FFFC  BP=0000  SI=0000  DI=0000
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0137#NV UP EI PL ZR NA PE NC##0002
0GETMEM:
0B75:0151  B106)MOV%CL,06

AX=0000  BX=0000  CX=0006  DX=0000  SP=FFFC  BP=0000  SI=0000  DI=0000
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0137#NV UP EI PL ZR NA PE NC##0003
0B75:0153  BE0200'MOV%SI,0002

8ͻ
8 Periscope's Traceback command answers the ques-  
8 tion 'How did I get here?' by showing you the$
8 previously executed instructions. Note the'
8 sequence number shown to the right of the flags. 
8ͼ

>r
AX=009F  BX=002D  CX=0006  DX=0000  SP=FFFD  BP=0000  SI=0002  DI=0110
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0140#NV UP EI PL NZ NA PE NC
WR SS:FFFB = F206
0B75:0140 E82400(CALL$CONVERT
>j
AX=0000  BX=002D  CX=000A  DX=0031  SP=FFFD  BP=0000  SI=0002  DI=0110
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0143#NV UP EI PL ZR NA PE NC
RD DS:0135 = 0072
0B75:0143 A13501(MOV%AX,[FREMEM]


@ͻ
@ The Jump command lets you skip over 
@ CALLs and INTs to get to the next#
@ instruction on the same level. The  
@ Jump Line command (not shown) is$
@ used to get to the next source line 
@ when source line numbers are used.  
@ͼ





>h 270+150
03C0

>h ax-bx8ͻ
0120< Periscope also supports hex arith- 
@ metic -- addition, subtraction,$
>h 270*1506 multiplication, and division. You  
0003 33007 can use registers as arguments.$
@ͼ
>h 270/150
0001 r 0120
0B75:0102  54 6F 74 61 6C 20-6D 65 6D 6F 72 79 3A 20)Total memory:
0B75:0110  33 32 30 20 4B 42 20 20-20 20 4D 65 6D 6F 72 79#320 KB$Memory
0B75:0120  20 61 76 61 69 6C 61 62-6C 65 3A 20 32 37 31 20$available: 271
0B75:0130  4B 42 24 40 01 0F 01 E8-17 00 A1 33 01 BF 10 01#KB$@...h..!3.?..
D
AX=0000  BX=0031  CX=000A  DX=0032  SP=FFFC  BP=0000  SI=0002  DI=012C
DS=0B75  ES=0B75  SS=0B75  CS=0B75  IP=0183#NV UP DI PL ZR NA PE NC
R
0DISPLAY:
0B75:0183 B409*MOV%AH,09
0B75:0185 BA0201(MOV%DX,01025; TOTAL
0B75:0188 CD21*INT%21
0B75:018A C3,RET
U
>g @display
>d @total/ͻ
>7 Periscope does windows, too!  This screen$
8 shows Data, Register, and Unassembly windows 
8 in use (a Stack window is available too).$
8 You choose the window types to be used, as#
8 well as the order and size of the windows.#
8 Windows can be changed on the fly.+
8ͼ


?+Help
A+Assemble instructions into memory
AU*Assemble then unassemble
BA*Display/clear/enable/disable all breakpoints
BB*Display/clear/enable/disable/set byte breakpoints
BC*Display/clear/enable/disable/set code breakpoints
BI*Display/clear/enable/disable/set interrupt breakpoint
BL*Display/clear/enable/disable/set source line breakpoint
BM*Display/clear/enable/disable/set memory breakpoints
BP*Display/clear/enable/disable/set port breakpoints
BR*Display/clear/enable/disable/set register breakpoints
BU*Display/clear/enable/disable/set user breakpoints
BW*Display/clear/enable/disable/set word breakpoints
C+Compare memory=ͻ
D+Display meory in current format, These are some 
DA*Display memory in ASCII format- of Periscope's 
DB*Display memory in byte format. commands ...#
DD*Display memory in double word format'ͼ
DE*Display effective address of current instruction
DI*Display memory in unsigned integer format


DN*Display memory in signed integer format
DR*Display memory using a record format or template
DW*Display memory in word format
E+Enter changes to memory
ES*Enter symbol definition
F+Fill memory with a byte/string pattern
G+Go until code breakpoint reached
GT*Go until code/monitor breakpoint reached
H+Hex arithmetic
I+Read I/O port
J+Jump to next instruction
JL*Jump to next source code line
JN*Jump to next instruction with no display swap
K+Clear debug screen9ͻ
LA*Load absolute sectors from disk, These are some#
LF*Load file from disk8 more of Peri-$
M+Move (copy) a block of memory. scope's commands 
N+Format PSP for disk I/O4ͼ
O+Write I/O port
Q+Quit Periscope


R+Display or change registers
RR and RS#Save and restore registers
S+Search memory for a byte/string pattern
SA*Search for address references
SU*Search for disassembly string
T+Trace execution
TB*Trace back through previously executed instructions
TN*Trace execution with no display swap
U+Unassemble memory in current format
UA*Unassemble memory in ASM format
US*Unassemble memory in Source/ASM format
V+View a text file
WA*Write absolute sectors to disk
WF*Write file to disk9ͻ
X or XH%Translate hex number7 These are the$
XA*Translate address: rest of Peri-$
XD*Translate decimal number3 scope's commands 
/S*Change segment in symbol table-ͼ
/U*Execute user exit
/W*Change Periscope's window settings

Periscope works for programs written in any language, but the greatest
benefits are available to languages that are able to generate symbols as
desired.  To check your compiler, read through the tips below and then run the
linker, specifying a MAP file and the /LI and /M options.  Now, look at
the MAP file -- any of the names in the Publics by Name list or any of the
line numbers at the end of the MAP file can be used as symbols.  External
references to other modules or subroutines are always included in the MAP
file.

For Assembly programs, any data item or procedure declared PUBLIC will
generate an entry in the MAP file.  One of the utility programs on the
Periscope disk generates PUBLIC statements for assembler programs.  Use this
program to get maximum symbols.  When you use as many publics as possible, a
disassembly of your program looks almost the same as the original -- without
comments of course!

Hͻ
H The languages supported 
H include ASM ...)
Hͼ

For Lattice, Microsoft, and Computer Innovations C compilers, external data
variables will generate entries in the MAP file, allowing you to access them
by name.  The source program line numbers and source code are available when a
compiler option is used.  Periscope's memory breakpoint is great for tracking
down memory corruption caused by C pointers gone awry.

For Microsoft or IBM Pascal programs, data variables declared as PUBLIC will
generate entries in the MAP file, allowing you to access them by name.  The
source program line numbers and source code are also available.

For BASIC programs, the symbol names available are the ones used by the
BASIC compiler and any external subroutines.  To debug an assembly language
subroutine, you can use G @SUBNAME to get to the first execution of SUBNAME.
For interpretive BASIC, you can insert a CCH as the first byte of a subroutine
to transfer control to Periscope when the subroutine is executed.


Hͻ
H ... C, Pascal and BASIC 
Hͼ


The system requirements for Periscope are:

&- An IBM PC, XT, AT, Compaq, Columbia, Leading Edge, Sperry, Zenith
(Z-150, or other close compatible

&- PC-DOS/MS-DOS 2.00 or later

&- 128K RAM

&- One disk drive

&- An 80-column monitor (two preferred)

&- An available expansion slot (Periscope I only)

Pͻ
P System Requirements 
Pͼ

If an IBM AT is used, Periscope intercepts exception interrupts 06H (illegal
opcode) and 0DH (segment wraparound) to keep these exceptions from locking the
system.  The real-mode opcodes of the 80286 are also supported by Periscope.
The Periscope system includes:

  - The Submarine board with 16K of write-protected memory (Periscope I only)
  - A remote break-out switch
  - The debugger software
  - A 150+ page manual in a three-ring binder
  - A quick-reference card

The memory board is warranted to be free from manufacturing defects for one
year from the date of purchase.  The first software update is free to
registered users.  Subsequent updates cost $10.00 or less.

Periscope I costs $295 and Periscope II costs $145.  We're so sure you'll like
Periscope that we offer a 30-day money-back guarantee! Order your Periscope
today from your dealer or directly from Data Base Decisions.

-ͻ
- Get your programs up and running -- UP PERISCOPE! 
-ͼ

#Data Base Decisions * 14 Bonnie Lane * Atlanta, GA 30328 * 404/256-3860
)For orders or more information, call toll-free 800/722-7006
9MasterCard and Visa Accepted
<u
  h@ãb  K6
` / <t5< u6
IuNNQuFFI;wٸ;r҉6
 "  ô 
 & 3Ë6
4>&< rF<t<
t%<t3<t8< t4<t:<t@  PXPǹ 3@X	PXPXPXF   듸  &$0<0u  &eP$X33= u 