CONST
  max_columns = 5;
  max_solvents = 3;
  max_solutes = 9;
  Max_samples = 30;

TYPE
  column_type = record
                  name : string[40];
                  particle_dia : real;     {microns}
                  length : real;           {cm}
                  column_dia : real;       {cm}
                END;

  solvent_type = record
                   name : string[50];
                   abr : string[50];
                   avS : real;   {mean solvent strength index}
                 END;            {not used in calculations}

  solute_type = record
                  name : string[50];
                  A,B,S : array[1..max_solvents] of real; {y-int. and slope of log k' vs. organic phase % plot}
                  eps, mol_wt : real;
                END;

  sample_type = record
                  ID : string[10];
                  component : array[1..max_solutes] of real;
                END;

VAR
  column : array[0..max_columns] of column_type;
  solvent : array[0..max_solvents] of solvent_type;
  solute : array[1..max_solutes] of solute_type;
  sample : array[0..max_samples] of sample_type;
  column_num, solvent_num, sample_num, total_samp : integer;
  flow, inj_vol, mo_phase : real;
  lastpt, I : integer;
  power, pumps, de_pow, iflag, gradsw : boolean;
  range, WL, mode : integer;
  sens : real;
  init_comp, final_comp, duration, grad : real;

Procedure Initialize;

    BEGIN
      column_num := 0;
      solvent_num := 0;
      sample_num := 0;
      total_samp := 0;
      sample[0].ID := 'none';
      column[0].name := 'none';
      solvent[0].name := 'none';
      flow := 0;
      mo_phase := 100;
      inj_vol := 0;
      power := false;
      pumps := false;
      lastpt := 0;
      de_pow := false;
      mode := 1;
      range := 3;
      WL := 254;
      sens := 0.5;
      iflag := false;
      init_comp := 100;
      final_comp := 100;
      duration := 0;
      gradsw := false;

      WITH column[1] do BEGIN
        name := 'DuPont C-18';
        particle_dia := 6;
        length := 23;
        column_dia := 0.46;
      END;
      WITH column[2] do BEGIN
        name := 'DuPont C-8';
        particle_dia := 6;
        length := 23;
        column_dia := 0.46;
      END;
      WITH column[3] do BEGIN
        name := 'Waters C-18';
        particle_dia := 10;
        length := 30;
        column_dia := 0.39;
      END;
      WITH column[4] do BEGIN
        name := 'Merck C-8';
        particle_dia := 10;
        length := 25;
        column_dia := 0.46;
      END;
      WITH column[5] do BEGIN
        name := 'Hypercil C-18';
        particle_dia := 6;
        length := 16;
        column_dia := 0.5;
      END;

      WITH solvent[1] do BEGIN
        name := 'methanol';
        abr := 'MeOH';
        avS := 3.0;
      END;
      WITH solvent[2] do BEGIN
        name := 'acetonitrile';
        abr := 'AN';
        avS := 3.1;
      END;
      WITH solvent[3] do BEGIN
        name := 'tetrahydrofuran';
        abr := 'THF';
        avS := 4.4;
      END;

      WITH solute[1] do BEGIN
        name := 'phenol';
        A[1] := 1.53;
        A[2] := 1.54;
        A[3] := 1.75;

        B[1] := -2.778;
        B[2] := -3.52;
        B[3] := -4.12;

        S[1] := 2.6;
        S[2] := 2.7;
        S[3] := 4.1;

        eps := 2.5;

      END;
      WITH solute[2] do BEGIN
        name := 'p-nitrophenol';
        A[1] := 2.29;
        A[2] := 1.84;
        A[3] := 2.33;

        B[1] := -4.048;
        B[2] := -4.15;
        B[3] := -5.12;

        S[1] := 3.0;
        S[2] := 3.6;
        S[3] := 5.2;

        eps := 1.5;

      END;
      WITH solute[3] do BEGIN
        name := 'p-cresol';
        A[1] := 2.10;
        A[2] := 1.53;
        A[3] := 2.21;

        B[1] := -3.25;
        B[2] := -3.08;
        B[3] := -4.91;

        S[1] := 3.0;
        S[2] := 3.1;
        S[3] := 4.9;

        eps := 0.8;

      END;
      WITH solute[4] do BEGIN
        name := '2,5-xylenol';
        A[1] := 2.61;
        A[2] := 2.24;
        A[3] := 2.01;

        B[1] := -3.64;
        B[2] := -3.89;
        B[3] := -3.98;

        S[1] := 3.0;
        S[2] := 3.0;
        S[3] := 4.0;

        eps := 0.3

      END;
      WITH solute[5] do BEGIN
        name := 'methyl benzoate';
        A[1] := 2.49;
        A[2] := 1.85;
        A[3] := 1.48;

        B[1] := -3.22;
        B[2] := -2.79;
        B[3] := -2.96;

        S[1] := 3.6;
        S[2] := 2.8;
        S[3] := 3.0;

        eps := 0.5;

      END;
      WITH solute[6] do BEGIN
        name := 'anisole';
        A[1] := 2.54;
        A[2] := 1.89;
        A[3] := 1.85;

        B[1] := -3.25;
        B[2] := -2.82;
        B[3] := -3.44;

        S[1] := 3.0;
        S[2] := 2.8;
        S[3] := 3.4;

        eps := 0.5;

      END;
      WITH solute[7] do BEGIN
        name := 'benzene';
        A[1] := 3.37;
        A[2] := 1.91;
        A[3] := 1.975;

        B[1] := -4.42;
        B[2] := -2.785;
        B[3] := -3.476;

        S[1] := 2.7;
        S[2] := 2.2;
        S[3] := 3.5;

        eps := 1.5;

      END;
      WITH solute[8] do BEGIN
        name := 'phenetole';
        A[1] := 2.74;
        A[2] := 2.29;
        A[3] := 2.225;

        B[1] := -3.26;
        B[2] := -3.21;
        B[3] := -3.94;

        S[1] := 3.0;
        S[2] := 3.1;
        S[3] := 3.9;

        eps := 1.4;

      END;
      WITH solute[9] do BEGIN
        name := 'toluene';
        A[1] := 3.14;
        A[2] := 1.92;
        A[3] := 2.36;

        B[1] := -3.73;
        B[2] := -2.445;
        B[3] := -3.99;

        S[1] := 3.4;
        S[2] := 2.5;
        S[3] := 4.0;

        eps := 1.2;

      END;
  END;