program Fractal;

var
  i,cx,cy,px,py : integer;
  x,y,s,t,lx,ly,tx,ty,sc : real;
  a : char;

procedure Square_Root;
begin
   t := y;
   s := sqrt(abs(x * x - y * y));
   x := sqrt(abs((-x + s)/2));
   y := sqrt(abs((x + s)/2));
   if t < 0.0 then x := -x;
end;

procedure Four_Over_L;
begin
   s := lx * lx + ly * ly;
   lx := 4 * lx/s;
   ly := -4 * ly/s;
end;

procedure XY_Times_L;
begin
   tx := x;
   ty := y;
   x := tx * lx - ty * ly;
   y := tx * ly + ty * lx;
end;

procedure Function_of_XY;
begin
   XY_Times_L;
   x := 1 - x;
   Square_Root;
   if Random < 0.5 then
   begin
      x := -x;
      y := -y;
   end;
   x := 1 - x;
   x := x/2;
   y := y/2;
end;

procedure Get_Values;
begin
   TextMode;
   writeln;
   writeln('What is Lambda? (X,Y) ');
   read(lx,ly);
   Four_Over_L;
   writeln;
   writeln;
   writeln('what is Scale? ');
   read(sc);
   sc := 2 * cx / sc;
end;

procedure Plot_XY;
begin
   px := Round(sc * (2 * x - 0.5) + cx);
   py := Round(cy - sc * y);
   Plot(px,py,1);
end;

begin
   cx := 320;
   cy := 100;
   x := 0.50001;
   y := 0.0;
   Get_Values;
   HiRes;
   HiResColor(White);
   for i := 1 to 10 do Function_of_XY;
   repeat
      Plot_XY;
      Function_of_XY;
   until Keypressed;
end.


