program fractal(input,output);
   {$I complex.pas}
   {plot fractal curve by recursive evaluation of f-1(z) where
                f(z)=Lambda*z*(1-z)
    Turbo Pascal Version of Sorensen article in Byte Mag. Sept. 1984
             Requires Complex Function Library
       J.M.Weiss, 1572 Peacock Ave., Sunnyvale, CA 94087
                        3/6/85 }
   var
      Lambda,One,Two,Four:Complex;

   procedure fractal_func(z:Complex;VAR Result:Complex);
      var
         temp1,temp2,temp3,temp4,temp5:Complex;
         temp6:Complex;
         xx:Real;

      begin {fractal_func}
         Cdiv(z,Lambda,temp1);
         Cmult(Four,temp1,temp2);
         Csub(One,temp2,temp6);
         Csqrt(temp6,temp3);
         xx:=Random;
         if xx>0.5 then Csub(One,temp3,temp4)
                       else Cadd(one,temp3,temp4);
         Cdiv(temp4,Two,temp5);
         Result:=temp5
      end; {fractal_func}

      var
         z,temp1,temp2,temp3:Complex;
         Scale,x,y:Real;
         i,ix,iy:Integer;
      const
         cx:Real=320.;
         cy:Real=100.;
         Initial:Integer=10;

      begin {main}

         Cmplx(1.0,0.0,One);
         Cmplx(2.0,0.0,Two);
         Cmplx(4.0,0.0,Four);
      {initial value of z}
         Cmplx(0.5,0.0,z);
      {get parameters}
         Writeln(' =============== FRACTAL GENERATOR ===============');
         Writeln(' For samples, try complex Lambda = 3. 0.  Scale=1.');
         Writeln('              or                   0. 1.        5.');
         Writeln('              or                   1. 0.        5.');
         Writeln(' Each display will terminate by pressing any key.');
         Writeln(' Then explore.');
         Writeln(' =================================================');
         Writeln;
         Writeln(' Enter Complex Value of Lambda: ');
         Readln(Lambda.re,Lambda.im);
         Writeln(' Enter Scale Factor: ');
         Readln(Scale);  Scale:=2.*Cx/Scale;
         ClrScr;
         HiRes;
         HiResColor(2);
      {initialize calc. by 10 iterations}
         for i:=1 to Initial do fractal_func(z,z);
         repeat
            i:=i+1;
            x:=z.re;
            y:=z.im;
            x:=Scale*(x-0.5)+cx;
            y:=cy-0.5*Scale*y;
            ix:=Trunc(x);
            iy:=Trunc(y);
            if (ix <= 640) and (iy <= 320) then
               Plot(ix,iy,1);
            fractal_func(z,z);
         until KeyPressed
      end. {main}
