page 72,130
;**************************************************************;
;      PROGRAMM      AutoPark                                  ;
;      geschrieben   von Th.BERGLER                            ;
;      August 1986   V2                                        ;
;**************************************************************;
; Automatisches Festplattenparkprogramm                        ;
; Fr alle IBM-kompatiblen MS-DOS-Computer mit Festplatte      ;
;                                                              ;
; Assemblieren: MASM AutoPark <CR>                             ;
;               LINK AutoPark <CR>                             ;
;               EXE2BIN AutoPark.EXE AutoPark.COM <CR>         ;
;                                                              ;
;                                                              ;
; Dieses Programm wurde mit MASM 3.0 erstellt !                ;
; Eine fehlerfreie Asssemblierung mit niedrigeren Versionen    ;
; kann nicht gewhrleistet werden.                             ;
; Die Meldung des Linkers No Stack Segment ist belanglos,      ;
; es ist tatschlich keines angelegt.                          ;
;                                                              ;
;**************************************************************;

CSeg       SEGMENT
           ORG     100H
           ASSUME  CS:CSeg,DS:CSeg
;..............................................................
;Constants
;
TimeOut       equ     10*18 		;Zeitverzgerung
ClockInt      equ     1CH               ;Timer Interrupt
DiskInt       equ     13H               ;Disk  Interrupt
parked        equ     0ffH              ;signalisiert geparkt

main:         jmp     Install     	;Installiere 
;					 dieses Programm
;...............................................................
;Vars resident
;
OldTimeVek    dw       0                ;to save original
              dw       0                ;TimerVektor
OldDiskVek    dw       0                ;to save original
              dw       0                ;DiskVektor
ParkFlag      db       0                ;Platte geparkt?
ParkCyl       dw       0                ;Cylinder zu Parken
Time          dw   TimeOut              ;Timervalue in 1/18 sec

;...............................................................
;Code  resident
;...............................................................

TimeCount proc far
;...............................................................
;
;Interrupt Hndler Zhler,hngt in der Systemtaktkette
;...............................................................
        sti
        pushf                           ;Nur CS gltig!
        push    ax                      
        mov     ax,CS:Time              ;Ist der Zhler
        cmp     ax,TimeOut              ;abgelaufen?
        jge     TC1                     
        inc     ax                      ;nein,dann erhhe
        mov     CS:time,ax              
        jmp     TC2                     
TC1:    mov     al,CS:ParkFlag          ;ja,dann ist geparkt?
        cmp     al,parked               
        je      TC2                     ;ja,dann Ende
;...............................................................
        push    cx                      ;Register sichern
        push    dx                      
     ;  mov     ah,11H                  ; Recalibrate
     ;  mov     dx,0080H                ; (nur zum Test)
     ;  int     13h                     
        mov     ah,0Ch                  ;Seek
        mov     dx,0080h                ;erste Festplatte
        mov     cx,CS:ParkCyl	        ;auf Parkzylinder
        int     13H                     
        pop     dx                      ;Register restaurieren
        pop     cx                      
;................................................................
        mov     CS:ParkFlag,parked      ;gerade C: bettigt
TC2:    pop     ax                      ;Ende,also Stack leeren
        popf                            
TC3:    jmp     dword Ptr CS:[OldTimeVek] 	
;					 Kette nicht unterbrechen

TimeCount endp

DiskWatch proc far
;...............................................................
;
;Disk Aktivitt beobachten
;...............................................................
        cmp     dl,80H                  ;Ist C: benutzt?
        jne     DW1                     ;
        mov     CS:ParkFlag,parked      ;ParkFlag set
        pushf                           ;Simulierter Interrupt
        call    dword ptr CS:[OldDiskVek]    ;Call(!!) Int 13h
        mov     CS:Time,0               ;zurck,dann Zhler 
        mov     CS:ParkFlag,0           ;und ParkFlag reset
        iret                            ;return from Interrupt

DW1:    Jmp     dword ptr CS:[OldDiskVek]  ;springe zum Int 13h

DiskWatch endp

ResidentEnd:                            ;bis hier Code resident
;...............................................................
; Code transient
;...............................................................

Install proc near
;...............................................................
;
; AutoPark Logo ausgeben
;...............................................................
        mov      ah,09h                 
        mov      dx,offset msg1         ;Message "AutoPark...
        int      21h                    
;...............................................................
;
; Prfe, ob bereits installiert
; Stellt nichts fest, wenn beide Vektoren 
; spter noch verndert wurden!
;...............................................................
        mov     al,ClockInt             ;lies ClockInt in ES:BX
        mov     ah,35H                  ;
        int     21H                     ;
        cmp     bx,offset TimeCount     ;Off ClockInt richtig?
        je      in0                     ;ja, ist installiert
In6:    mov     al,DiskInt              ;lies DiskInt in ES:BX
        mov     ah,35H                  ;
        int     21H                     ;
        cmp     bx,offset DiskWatch     ;Off DiskInt richtig?
        jne     in4                     ;nein,dann installieren
In0:    mov     dx,offset msg2          ;mindestens einer der 
        mov     ah,09h                  ;Ints richtig,also
        int     21H                     ;Message "Installiert...
        mov     ah,4Ch                  ;
        Int     21h                     ;Ende normal

;...............................................................
;
; Bestimme ParkCylinder
;...............................................................
In4:    mov     byte ptr [Drv],00H      ;Festplatte 1, meist C:
        mov     ah,11h                  ;Recalibrate Befehl
        call    DskInt                  ;
        mov     ah,08h                  ;GetParameter Befehl
        call    DskInt                  ;
        rol     cl,1                    ;Cylinder in CX im BIOS
        rol     cl,1                    ;Format CH:=7..0,CL:=9,8
        xchg    ch,cl                   ;in eine Hexzahl
        and     cx,03ffh                ;zurckverwandeln
        mov     [maxcyl],cx             ;und speichern
        inc     word ptr [maxcyl]       ;wg. IN1:eins spendieren
In1:    mov     [cyl],01h               ;zuerst auf Cyl 01
        mov     ah,04h                  ;positionieren
        call    DskInt                  ;
        dec     word ptr [maxcyl]       ;MaxCyl vermindern
        mov     ax,[maxcyl]             ;und einen Versuch
        mov     [cyl],ax                ;wagen
        mov     ah,04h                  ;Seek Befehl
        call    DskInt                  ;Positionierversuch
        jc      IN1                     ;Fehler aufgetreten?
        mov     cx,[cyl]                ;hole positionierb. Cyl
        xchg    ch,cl                   ;errechne hier
        ror     cl,1                    ;das richtige
        ror     cl,1                    ;Format fr Int13
        or      cl,01h                  ;
        mov     ParkCyl,cx              ;und lege es ab

;...............................................................
;
; Install Timer
;...............................................................
        mov     al,ClockInt             ;lies ClockInt in ES:BX
        mov     ah,35H                  ;
        int     21H                     ;
        mov     OldTimeVek[0],bx        ;und sichere Vektor
        mov     OldTimeVek[2],es        ;
        mov     ax,cs                   ;dann
        mov     ds,ax                   ;setze durch DOS
        mov     al,ClockInt             ;neuen Vektor in DS:DX
        mov     ah,25H                  ;der auf die Procedur
        mov     dx,offset TimeCount     ;TimeCount in diesem 
        int     21H                     ;Segment zeigt

;...............................................................
;
;Install DiskWatcher
;...............................................................
        mov     al,DiskInt              ;lies DiskInt in ES:BX
        mov     ah,35H                  ;
        int     21H                     ;
        mov     OldDiskVek[0],bx        ;und sichere Vektor
        mov     OldDiskVek[2],es        ;
        mov     ax,cs                   ;dann auch hier
        mov     ds,ax                   ;setze durch DOS
        mov     al,DiskInt              ;neuen Vektor in DS:DX
        mov     ah,25H                  ;der auf die Procedur
        mov     dx,offset DiskWatch     ;DiskWatch in diesem 
        int     21H                     ;Segment zeigt

;................................................................
;
; Install Code Resident and Quit
;...............................................................
        mov     dx,offset msg3          ;Message "Cylinder..
        mov     ah,09h                  ;
        int     21H                     ;
        mov     dx,ParkCyl              ;Parkcylinder anzeigen
        xchg    dh,dl                   ;Umrechnen
        rol     dh,1                    ;
        rol     dh,1                    ;
        and     dh,3                    ;
        call    NrOut                   ;ausgeben
        mov     dx,offset msg4          ;Message "Timeout...
        mov     ah,09h                  ;
        int     21H                     ;
        mov     dx,timeOut              ;
        mov     cl,4                    ;in 18tel also ca div 16
        sar     dx,cl                   ;
        call    NrOut                   ;
        mov     dx,offset msg5          ;Message "installed
        mov     ah,09h                  ;
        int     21H                     ;
        mov     dx,cs                   ;Code wird "versenkt"
        mov     ds,dx                   ;CodeSeg:Lnge in DS:DX
        mov     dx,offset ResidentEnd   ;und ende resident
        int     27H                     ;
Install endp

msg1:   db      10,13,'AutoPark parkt die '
	db	'Festplatte C: automatisch'
        db      10,13,'auf dem hchsten erreichbaren '
	db	'Zylinder.',13,10,'$'
msg2:   db      13,10,'AutoPark ist bereits installiert!'
	db	13,10,'$'
msg3:   db         13,' Parkzylinder . . . . . . . : $'
msg4:   db      10,13,' Verzgerung in Sekunden  . : $'
msg5:   db      10,13,' AutoPark resident installiert.'
msg6:   db      10,13, '$'


;...............................................................
;
; Disk Interrupt Interface
;...............................................................
DskInt  proc    near                    ;BIOS Disk Interupt
        call    outcyl                  ;melde cylinder
        mov     DL,[drv]                ;Laufwerk 0
        or      DL,80H                  ;braucht Drive
        mov     DH,[hd]                 ;Kopf (Dummy)
        mov     CX,DS:[Cyl]             ;Cylinder,korrigiert
        xchg    CH,CL                   ;10 Bits wie folgt
        ror     CL,1                    ;CH:= 7..0
        ror     CL,1                    ;CL:= 8,9 auf 0,1
        or      CL,[sec]                ;erster Sector ist 1
        int     13H                     ;
        ret                             ;

Drv     db      0                       ;Laufwerk 0
cyl     dw      0                       ;Cylinder
Hd      db      0                       ;Kopf
sec     db      1                       ;Sector
maxcyl  dw      0

;...............................................................
;
; Zylinder dezimal umrechnen und ausgeben
;...............................................................
                                        ;
outcyl: push    ax                      ;Register sichern
        push    bx                      ;
        push    cx                      ;
        push    dx                      ;
        push    di                      ;
        mov     dx,offset msg7          ;Message "Trying..
        mov     ah,09H                  ;ausgeben
        int     21h                     ;
        mov     dx,[cyl]                ;Cylinder holen
        call    NrOut                   ;und auch ausgeben
        pop     di                      ;
        pop     dx                      ;Register restaurieren
        pop     cx                      ;
        pop     bx                      ;
        pop     ax                      ;
        ret                             ;
msg7:   db      '      ',13,'Positioniere auf Cylinder :$' ;
                                        ;
NrOut:  mov     cx,0                    ;Eine Zahl in DX 
;					 als ASCII ausgeben
        lea     di,AscBuffer            ;Stringpuffer
NR1:    push    cx                      ;Zhler sichern
        mov     ax,dx                   ;Zhler
        mov     dx,0                    ;obere Hlfte auf 0
        mov     cx,10                   ;durch 10 teilen
        div     cx                      ;
        xchg    ax,dx                   ;Quotient holen
        add     al,30H                  ;ASCII-Versatz addieren
        mov     [di],al                 ;im Puffer ablegen
        inc     di                      ;nchstes Byte
        pop     cx                      ;Zhler zurckholen
        inc     cx                      ;weiterstellen
        cmp     dx,0                    ;alles abgearbeitet?
        jnz     NR1                     ;nein,dann nochmal
NR2:    dec     di                      ;nun rckwrts durch den
        mov     dl,[di]                 ;Puffer die Zeichen 
        mov     ah,2                    ;holen und DOS ausgeben 
        int     21h                     ;lassen bis der
        loop    NR2                     ;Zhler abgelaufen ist
        ret                             ;

AscBuffer db 10 dup (0)
DskInt  endp
;...............................................................

CSeg    ends                            ;
        end main                        ;
