{+--------------------------------------------------------------------------+
 ! File Compressing Utility                        (c) by Groauer Harry    !
 !      Version  1.3                                     15.9.1986          !
 +--------------------------------------------------------------------------+}

PROGRAM Compress_File;
CONST  maximum =  100;                        { maximale lnge von helpstr  }
       maximum2 = 101;                        { maximale lnge von compstr  }
VAR    input:     FILE OF BYTE;               { inputfile                   }
       output:    FILE OF BYTE;               { outputfile                  }
       sourcename:STRING[20];                 { filename des inputfiles     }
       destname:  STRING[20];                 { filename des outputfiles    }
       command:   CHAR;                       { enthlt commando c,r oder q }

{***************************************************************************}
PROCEDURE Compress;
VAR    helpstr:   ARRAY[1..maximum] OF BYTE;  { zu komprimierender array    }
       compstr:   ARRAY[1..maximum2] OF BYTE; { erzeugter komprimerter array}
       length:    INTEGER;                    { aktuelle lnge des arrays   }
       filelen:   REAL;                       { gesamtlnge des files       }
       complen:   REAL;                       { gesamtlnge des kompr files }
       percent:   REAL;                       { verkrzung in prozent       }
       bytes:     REAL;                       { gesparte bytes              }
       clusters:  REAL;                       { effektiv gesparte cluster(K)}
{---------------------------------------------------------------------------}
PROCEDURE Read_from_Disk;            { liest bytewise in den array helpstr  }
VAR    pos:  INTEGER;                { die lnge des arrays steht in length }
BEGIN                                { soda CONVERT weiterarbeiten kann    }
 pos:=1;
 REPEAT
  Read(input,helpstr[pos]);          { lies einzelnes byte in array         }
  pos:=pos+1;
 UNTIL (pos>maximum) OR EOF(input);  { bis array zu klein oder EOF          }
 length:=pos-1;
 filelen:=filelen+length;
END; { Read_from_Disk }
{---------------------------------------------------------------------------}
PROCEDURE Convert_and_Write;
VAR   z:    INTEGER;         { zeiger in quellarray helpstr            }
      x:    INTEGER;         { zeiger in zielarray compstr             }
      last: INTEGER;         { position des zu generierenden Kennbytes }
      i:    BYTE;            { enthlt zahl der gleichartigen Bytes    }
      mode:(compress,normal);{ gibt den jeweiligen letzten Zustand an  }
BEGIN
 last:=1; x:=2; compstr[last]:=0; z:=1;  { initialisierung der zeiger }
 WHILE (z<=length) DO BEGIN
  IF(z<=length-2) AND (helpstr[z]=helpstr[z+1]) AND (helpstr[z]=helpstr[z+2])
   THEN BEGIN         {^^^^^ liegt eine 3er Kombination vor dann komprimiere }
         mode:=compress;
         i:=0;
         IF z=1 THEN x:=1;              { Korrektur falls sofort kompr. wird }
         WHILE(z+i<=length) AND (helpstr[z]=helpstr[z+i]) DO i:=i+1;
         compstr[x]:=128+i;             { berechne kennbyte                  }
         compstr[x+1]:=helpstr[z];      { hnge einzelnes datenbyte dahinter }
         z:=z+i; x:=x+2;                { berichtige zeiger auf arrays       }
         last:=x; x:=last+1;            { berichtige zeiger auf kennbyte     }
         compstr[last]:=0;              { initilalisiere fr den fall nichtk.}
        END
   ELSE BEGIN                   { behandlung wenn keine kombination vorliegt }
         mode:=normal;
         compstr[x]:=helpstr[z];          { kopiere byte direkt  }
         compstr[last]:=compstr[last]+1;  { erhhe kennbyte      }
         x:=x+1;  z:=z+1;                 { initialisiere zeiger }
        END;
 END;
 IF mode=normal THEN length:=x-1 ELSE length:=x-2;
 complen:=complen+length;                         { schreibe komprimierten }
 FOR i:=1 TO length DO write(output,compstr[i]);  { array in output        }
END; { Convert_and_Write }
{---------------------------------COMPRESS----------------------------------}
BEGIN
 Writeln; Write(' Name of Sourcefile           >'); Readln(sourcename);
          Write(' Name of Destinationfile      >'); Readln(destname);
 Assign(input,sourcename);  Assign(output,destname); Writeln;
 Reset(input);              Rewrite(output);         Writeln;
 filelen:=0;  complen:=0;
 WHILE NOT EOF(input) DO BEGIN
  Read_from_Disk;
  Convert_and_Write;
  GotoXY(1,WhereY-1);              { ausgabe effektivitt der kompression }
  bytes:=filelen-complen;   percent:=complen/filelen*100;
  Writeln('Filelen.: ',filelen:6:0,'  saved Bytes: ',bytes:5:0,
          '   Percent: ',percent:3:0);
 END;
 Writeln; Writeln('The compressed file is ',complen:6:0,' bytes long');
 clusters:=Trunc((filelen-1)/1024)-Trunc((complen-1)/1024);
 IF clusters>0 THEN Writeln('You save ',clusters:2:0,' Cluster(s), ',
                            clusters*1024:6:0,' Bytes on your disk')
               ELSE Writeln('You should delete ',destname,
                            ' because you save NO cluster (1K) on your disk');
 Close(input);  Close(output);
END; { Compress }

{***********************************************************************}
PROCEDURE Recompress;
VAR   i:      INTEGER;     { hilfszhler                            }
      length: BYTE;        { kennbyte das in lnge umgerechnet wird }
      data:   BYTE;        { datenbyte das gelesen wird             }
      geslen: REAL;        { gesamtlnge des gewonnenen files       }
BEGIN
 geslen:=0;
 Writeln; Write(' Name of Compressed File      >'); Readln(sourcename);
          Write(' Name of Destinationfile      >'); Readln(destname);
 Assign(input,sourcename);  Assign(output,destname); Writeln;
 Reset(input);              Rewrite(output);         Writeln;
 REPEAT
  Read(input,length);                  { lies kennbyte    }
  IF length>128
   THEN BEGIN                          { es lag eine kombination vor      }
     length:=length-128;               { errechne zahl der gleichen bytes }
     Read(input,data);
     FOR i:=1 TO length DO Write(output,data); { schreibe gleiche bytes   }
    END
   ELSE BEGIN                          { es lag keine kombination vor }
     FOR i:=1 TO length DO BEGIN       { kopiere daher in --> out     }
       Read(input,data); Write(output,data);  END;
    END;
  geslen:=geslen+length;
  GotoXY(1,WhereY-1);
  Writeln('Dest.-Filelen.: ',geslen:6:0,' Bytes');
 UNTIL EOF(input);
 Close(input); Close(output); Writeln;
 Writeln('Compressed File ',sourcename,' reconverted in ',destname);
END; { Recompress }

{******************************* MAIN-PROGRAM ****************************}
BEGIN
 ClrScr; Write('FILE COMPRESSING UTILITY     Version 1.3      1986');
 Writeln('      (c) by Groauer Harry');
 REPEAT
  TextColor(Black); TextBackGround(Red);
  Writeln; Write(' Select:   C-ompress      R-ecompress      Q-uit  >');
  TextColor(Yellow); TextBackGround(Black);
  Read(kbd,command); command:=Upcase(command); Writeln(' ',command,' ');
  CASE command OF
   'C': Compress;
   'R': Recompress;
  END;
 UNTIL command='Q'
END.
