		page    65,120
                title   PCDOS   40/80-Track-Treiber
;***************************************************************
;*                                                             *
;* Diskettentreiber beliebig einstellbar ueber Commandozeile   *
;* DRIVE.SYS 40/80 0..3 {S}                                    *
;* Programmname       : DRIVE.ASM                              *
;* Ersteller          : Martin Ernst                           *
;* Erstellungsdatum   : 11.03.86                               *
;* letzte Aenderung am: 05.12.86                               *
;* letzter Test am    : 05.12.86                               *
;* Versionsnummer     : 2.0                                    *
;* Revisionsnummer    : 4.0                                    *
;*                                                             *
;***************************************************************

false           equ     0
true            equ     not false

NUMDRV          EQU     1

;
; zu beachten ist, dass bedingt durch die erweiterten Treiber-
; aufrufe von PCDOS 3.1 an die Funktionstabelle drei weitere 
; Adressen fuer Funktionen hinzugefuegt werden mussten, sowie 
; das Attribut-Bit des Treibers geaendert werden musste. Diese
; Aenderungen haben keine Auswirkungen auf das Verhalten mit
; PCDOS 2.0, 2.1 oder 3.0
;
;
;
;---------------------------------------------------------------

monitoreprom            segment at 0f000H
                        org     0e000h
monitor                 label   far
monitoreprom            ends
 
CODE            SEGMENT para public
ASSUME          CS:CODE,DS:CODE,ES:CODE,SS:CODE

;===============================================================

DSKDEV: DW      -1,-1
        DW      00000100000000000b      ;%%%% das Attribut-Bit 
                                        ;         fuer DOS 3.1
        DW      STRATEGY
        DW      DSKINT
DRVMAX  DB      1
        DB      7 DUP(?)

;--------------------------------------------------------------

DSKTBL: DW      DSKINIT ;Init Device Treiber
        DW      MEDIAC  ;Check Media Type
        DW      GETBPB  ;Get Bios Parameter Block of 
                        ;selected Media Type
        DW      CMDERR  ;IO Control Input (nicht implementiert)
        DW      DSKRED  ;READ Data
        DW      BUSEXIT ;Non destructive READ Data (n.i.)
        DW      EXIT    ;Input Status
        DW      EXIT    ;Input Flush Buffer
        DW      DSKWRT  ;WRITE Data
        DW      DSKWRV  ;WRITE Data mit Verify
        DW      EXIT    ;Output Status
        DW      EXIT    ;Output Flush Buffer
        DW      EXIT    ;IO Control Output
        dw      exit    ;%%%% open
        dw      exit    ;%%%% close
        dw      exit    ;%%%% "removable media" gleich nach 
                        ;exit, kein Busy, da Diskette


;---------------------------------------------------------------

IODAT   STRUC
CMDLEN  DB      ?               ;Laenge der Tabelle
UNIT    DB      ?               ;Einheiten-Code
CMD     DB      ?               ;Befehles-Code
STATUS  DW      ?               ;Status der Operation
        DB      8 DUP (?)
MEDIA   DB      ?               ;Media Descriptor Byte
TRANS   DD      ?               ;Transfer Adresse
COUNT   DW      ?               ;Anzahl der Bloecke oder 
                                ;Character, die uebertragen 
                                ;werden sollen
START   DW      ?               ;erster Block, der transferiert 
                                ;werden soll
IODAT   ENDS


;---------------------------------------------------------------

BPBS    STRUC
        DB      13 DUP (?)
BPB1    DB      ?       ;Struktur fuer die Ruecklieferung von 
BPB2    DW      ?       ;Werten ueber die Anforderungskopfzeile
        DW      ?
BPB3    DW      ?
        DW      ?
BPBS    ENDS

;---------------------------------------------------------------

DBP     STRUC
SECSIZE DW      ?               ;Sectorgroesse (512 Bytes)
ALLOC   DB      ?               ;Anzahl Sectoren pro Cluster
RESSEC  DW      ?               ;wieviele reservierte Sectoren
FATS    DB      ?               ;Anzahl der FATs
MAXDIR  DW      ?               ;Anzahl Directory Eintraege
SECTORS DW      ?               ;Gesamtzahl der Sectoren
MEDIAID DB      ?               ;Media Descriptor Byte
FATSEC  DW      ?               ;Anzahl Sectoren pro FAT
SECTRK  DW      ?               ;Anzahl Sectoren pro 
                                ;Track (nicht Cylinder) 
KOEPFE  dw      ?
DBP     ENDS

lsdriv1 DBP	<512,1,1,2,14*16,15*2*80,0F9H,7,15,2>
DDRIVE2 DBP	<512,2,1,2,14*16,17*2*80,0FdH,7,17,2>
DDRIVE3 DBP	<1024,2,1,2,14*16,9*2*80,0FeH,7,9,2>

INITTAB1:       dw      lsdriv1.secsize

ptrsav		dd	0	;hier wird der Zeiger auf die
				;Anforderungskopfzeile gesichert
					
;===============================================================

stratp  proc    far
; Registerbelegung beim Aufruf:
; BX = Offset der Anforderungszeile
; ES = Segment der Anforderungszeile

STRATEGY:
        MOV     WORD PTR CS:[PTRSAV],BX
        MOV     WORD PTR CS:[PTRSAV+2],ES
        RET
STRATP  ENDP

;===============================================================

diskint proc    far
DSKINT: PUSH    SI
        MOV     SI,OFFSET DSKTBL        ;Tabelle der Befehle

ENTRY:  PUSH    AX
        PUSH    CX
        PUSH    DX
        PUSH    DI
        PUSH    BP
        PUSH    DS
        PUSH    ES
        PUSH    BX              ;erst alle Register retten
        LDS     BX,CS:[PTRSAV]  ;in BX der Offset der 
                                ;Anforderungskopfzeile
        MOV     AL,[BX.UNIT]    ;AL welche Einheit
        MOV     AH,[BX.MEDIA]   ;Media Descriptor Byte
        MOV     CX,[BX.COUNT]   ;Anzahl Bytes oder Bloecke
        MOV     DX,[BX.START]   ;Startadresse des ersten Bytes 
                                ;oder Blocks
        XCHG    DI,AX           ;AX sichern, da nun die Adresse 
        MOV     AL,[BX.CMD]     ;der Befehlsroutine berechnet 
        XOR     AH,AH           ;wird. Dazu muss der Befehlscode 
        ADD     SI,AX           ;zweimal auf die Startadresse 
        ADD     SI,AX           ;der Tabelle (Wert in SI) 
                                ;addiert werden
        CMP     AL,18           ;%%%% Funktionsnummer > 18 ?
        JA      CMDERR          ;ja, dann Fehler
        XCHG    AX,DI           ;altes AX zurueck
        LES     DI,[BX.TRANS]   ;DI nun Transferadresse Offset
                                ;ES Segment der Transferadresse 
        PUSH    CS              ;Datensegment gleich Codesegment
        POP     DS
        JMP     WORD PTR [SI]   ;und zur Befehlsroutine des 
                                ;betreffenden Treib.

;---------------------------------------------------------------

BUSEXIT:MOV     AH,00000011B    ;wenn entsprechendes Device 
        JMP     SHORT EXIT1     ;busy, dann hierher und weiter 
                                ;zum gemeinsamen Ausgang

;Fehlercodes :
;               0 = schreibgeschuetzt
;               1 = unbekannte Einheit
;               2 = Laufwerk nicht bereit
;               3 = unbekannter Befehl in Anfoderungskopfzeile
;               4 = CRC-Fehler
;               5 = falsche Laufwerk-Anforderungszeilen-Laenge
;               6 = Seek Fehler
;               7 = unbekanntes MEDIA DESCRIPTOR BYTE
;               8 = Sector nicht gefunden
;               9 = Drucker hat kein Papier mehr
;              10 = Fehler beim Schreiben
;              11 = Fehler beim Lesen
;              12 = allgemeiner Fehler

CMDERR: MOV     AL,3            ;unbekannter Befehl 
                                ;springt hierher
ERREXIT:MOV     AH,10000001B    ;Bits fuer "Fertig" und 
        STC                     ;"Fehler" setzen
        JMP     SHORT EXIT1     ;und weg

EXIT:   MOV     AH,00000001B
EXIT1:  LDS     BX,CS:[PTRSAV]
        MOV     [BX.STATUS],AX  ;in der Anfoderungskopfzeile 
        POP     BX              ;den Status melden
        POP     ES
        POP     DS
        POP     BP
        POP     DI
        POP     DX
        POP     CX              ;alle Register zurueck 
        POP     AX              ;vom BIOS-Stack
        POP     SI
        RET                     ;zurueck zum DOS
diskint endp

;===============================================================

localer proc    near
dskinit:mov     es,dx
        mov     bx,cx           ;ES:BX zeigt auf die Zeile 
        add     bx,10           ;in CONFIG.SYS
        push    bx
        push    es
        mov     ax,0f000h
        mov     es,ax
        mov     bx,0fffeh       ;erst mal schauen, ob es ein PC 
        mov     al,es:[bx]      ;oder ein c't86 ist. Denn beim 
        test    al,80h          ;c't kann man mit CALLF MONITOR 
        jnz     istibmpc        ;arbeiten (ist schneller)
istct86:mov     al,22h
        call    romcall         ;ist eine IFC Karte vorhanden?
        test    al,20h          ;wenn ja, dann auf jeden Fall 
        jnz     mitifckarte     ;ueber CALLF
        mov     ibmifcflg,1
        jmp     short weiterinit
istibmpc:
        mov     ibmifcflg,0
        jmp     short weiterinit
mitifckarte:
        mov     ibmifcflg,2     ;IBMIFCFLG auf entsprechenden 
				;Wert setzen

weiterinit:
	mov	si,offset startmes
	call	ausgabe
	pop	es
	pop	bx
	mov	al,es:[bx]
	or	al,al
	jnz	node
	jmp	default_init
node:	cmp	al,'0'
	jl	errordata
	cmp	al,'3'
	jg	errordata
	sub	al,'0'
store:	mov	drivesel,al
xxxx:   mov     si,offset crlf
	call	ausgabe
	mov	dx,cs
	lea	ax,endetreiber
	mov	cl,4
	sar	ax,cl
	add	dx,ax
	push	ds
	lds	bx,[ptrsav]
	mov	[bx.bpb2],0
	mov	[bx.bpb2+2],dx
	pop	ds
	mov	ax,1
	MOV	SI,OFFSET INITTAB1 ; und Standardanpassung 
	JMP	GET_BP5	           ; zurueckgeben

errordata:
	mov	si,offset fehlertxt
	call	ausgabe
default_init:
	mov	drivesel,1
	mov	si,offset deftxt
	call	ausgabe
	jmp	short xxxx

;---------------------------------------------------------------

MEDIAC: mov     di,1            ;1=not changed   
                                ;0=dont' know   -1=changed 

        mov     al,ibmifcflg    ;wenn nicht IFC-Karte, nicht 
        or      al,al           ;auf "Motor Aus" pruefen
        jz      media1
        cmp     al,2
        jz      media1
        mov     al,24h          ;nur bei IFC ueber CALLF MONITOR 
        call    romcall         ;auf "Motor Aus" kontrollieren
        or      al,al           
        jnz     MEDIA1
        JMP     SHORT MEDIAEXIT


MEDIA1: xor     di,di           ;sonst eine Null, da 
                                ;nicht bekannt
MEDIAEXIT:
        LDS     BX,[PTRSAV]     ;in der Anfoderungszeile den 
        MOV     WORD PTR [BX].TRANS,DI   ;Status sichern
        mov     al,0
        JMP     EXIT

;---------------------------------------------------------------

GETBPB: 
        MOV     AH,AL           ;bei PCDOS wird es schon ueber 
                                ;Pointer  in DI geliefert
        MOV     AL,ES:[DI]      ;MEDIA Byte holen Unit Code 
                                ;jetzt in AH
        push    ax
        push    bx
        xchg    ah,al

        call    getpara         ;den richtigen Parameterblock 
                                ;ermitteln
        mov     si,bx
        pop     bx
        pop     ax

GETBP4: 

GET_BP5:LDS     BX,[PTRSAV]     ;und beide Werte in der 
        MOV     [BX.BPB1],AL    ;Anforderungszeile sichern
        MOV     [BX.BPB3],SI
        MOV     [BX.BPB3+2],CS
        xor     al,al           ;kein Fehler
        JMP     EXIT            ;weg

DSKRED:
ASSUME  DS:CODE
        CALL    SETUP           ;Track/Sector berechnen aus BPB
        JC      DISK$IO         ;bei Fehler ->
        CALL    DISKRD          ;versuchen zu lesen
        JMP     SHORT DISK$IO

DSKWRV:
DSKWRT:
        CALL    SETUP           ;wie Lesen, nur eben Schreiben
        JC      DISK$IO
        CALL    DISKWRT
DISK$IO:JNC     DSKOK           ;Fehler beim Lesen/Schreiben? 
        CALL    DERROR          ;wenn ja, dann DERROR aufrufen 
        JMP     ERREXIT         ;(wandelt Floppy-Code in IBM 
                                ;Treiber Code)
DSKOK:  JMP     EXIT            ;sonst mit o.k. weg

;---------------------------------------------------------------

SETUP:  mov     si,0

        call    getpara

        XCHG    BX,DI                   ;nach DI mit dem Pointer
        MOV     AL,BYTE PTR [DI].koepfe
        MOV     AH,BYTE PTR [DI].SECTRK
        IMUL    AH                      ;Anzahl der Sectoren pro 
        MOV     [MAXSEC],AL             ;Track fuer spaeter 
                                        ;(Ueberlauf in naechsten 
        push    si                      ;Track)
        MOV     SI,CX                   ;CX = Anz. zu les. Sect.
        ADD     SI,DX                   ;DX = Startsector
        CMP     SI,WORD PTR [DI].SECTORS ; groesser als gesamte 
        JBE     INRANGE                 ;Disk Sect. hat? nein ->
        pop     si
        MOV     AL,8                    ;Fehler 8 = Sector 
        STC                             ;nicht gefunden
        RET

INRANGE:MOV     [SECCNT],CX             ;Anzahl zu lesende 
        pop     si                      ;Sectoren sichern
        add     dx,si
        MOV     SI,BX                   ;BX: Offset Transferadr.
        AND     BX,0FH                  ; Offset soll so klein 
                                        ;wie moeglich sein,
        MOV     [DMAADR],BX             ;darum wird Segment 
        MOV     AX,DX                   ;in DX erhoeht
        XOR     DX,DX
        MOV     BL,[MAXSEC]             ;logischen Sector durch 
        xor     bh,bh                   ;Maximalzahl Sect./Track 
        DIV     BX                      ;teilen => relativen 
        INC     DL                      ;Sect. innerhalb Track 
        MOV     [CURSEC],DL
        MOV     [CURTRK],AX             ;und als Quotient den 
        MOV     CL,4                    ;Track-Wert
        CLC
        SHR     SI,CL                   ;hier jetzt die Segment- 
        MOV     CX,ES                   ;Vergroesserung
        ADD     CX,SI
        mov     [dmasegment],cx         ;Segmentadresse sichern 
                                        ;fuer spaeter
driveeq:mov     cx,[CURTRK]             ;sicher ist sicher
        CLC                             ;kein Fehler
DIRF:   RET

getpara:
	mov	bx,offset lsdriv1
	CMP	AH,0F9H
	JZ	SFOU
	MOV	BX,OFFSET ddrive2
	cmp	ah,0fdh
	jz	sfou
	mov	bx,offset ddrive3
	cmp	ah,0feh
	jz	sfou
	mov	bx,offset lsdriv1
SFOU:	ret

;---------------------------------------------------------------

DISKRD:
RDLP:   CALL    PRESET          ;Werte fuer Track, Sector, Kopf, 
                                ;Anzahl Sectoren
        cmp     ibmifcflg,2     ;nur bei IFC mit UEBERCALLF
        jnz     ueberintles
        mov     al,16h
        call    uebercallf
        jmp     short rdlp2
ueberintles:
        mov     ah,2            ;eintragen und INT 13H aufrufen
        int     13h
rdlp2:  JC      ERRORR          ;in AH steht Errorcode

        DEC     [SECCNT]        ;naechsten Sector
        JNZ     RDLP
        CLC                     ;kein Fehler
        RET
ERRORR: STC                     ;bei Fehler hierher
        RET

DISKWRT:
WRLOOP: CALL    PRESET          ;wie RDLP, nur eben Schreiben
        cmp     ibmifcflg,2
        jnz     ueberintsch
        mov     al,18h
        call    uebercallf
        jmp     short wrlp2     
ueberintsch:
        mov     ah,3
        int     13h

wrlp2:  JC      ERRORR
        
        DEC     [SECCNT]
        JNZ     WRLOOP
        CLC
        RET

uebercallf:
        push    ax
        push    cx
        push    dx
        push    bx
        mov     cx,es
        mov     al,14h          ;setze Segment
        call    romcall
        pop     cx
        mov     al,0ch          ;setze Offset
        call    romcall
        pop     ax
        push    ax
        inc     al
        mov     ah,[secpertrak]
        mov     cx,ax

        or      cl,10h          ;^^^^ fuer AT-Format/IFC Karte 

        mov     al,10h          ;setze Laufwerk
        call    romcall
        pop     dx
        mov     cl,dh
        mov     ch,0
        mov     al,[secpertrak]
        mov     ah,0
        mul     cl
        pop     cx
        push    cx
        mov     ch,0
        add     cx,ax
        mov     al,12h          ;setze Sector
        call    romcall
        pop     cx
        mov     cl,ch
        mov     ch,0
        mov     al,0eh          ;setze Spur
        call    romcall
        pop     ax              ;lesen oder schreiben
        call    romcall
        mov     ah,al
        or      al,al
        jz      noerr
        stc
        ret
noerr:  clc
        ret

PRESET: MOV     BX,[DMAADR]     ;fuer den INT 13H muessen die 
                                ;Register belegt werden
        mov     ES,[dmasegment] ;Segment laden
        mov     al,[cursec]
        cmp     al,[maxsec]
        jbe     gotsec1         ;zu lesender Sector schon im 
                                ;naechsten Track ?
        inc     [curtrk]        ;ja , dann eben Track erhoehen
        mov     al,1            ;relativer Sector wird 1
        mov     [cursec],al
        mov     cl,al
        xor     dh,dh           ;Kopf ist dann logischerweise 0
        jmp     short wegvon
gotsec1:push    bx              ;kein Ueberlauf
        mov     bx,word ptr [di].sectrk ; dann den Kopf 
        mov     [secpertrak],bl ;berechnen, indem man solange 
        xor     dh,dh           ;SECTRK abzieht, bis o.k.
loopinc:cmp     al,bl
        jbe     nohead
        inc     dh              ;Kopf immer um 1 erhoehen 
        sub     al,bl           
        jmp     short loopinc
nohead: mov     cl,al           ;richtiger Sector und Kopf
        pop     bx              ;DMA-Adresse wieder vom Stack


wegvon:
nodec:  mov     ax,word ptr [di].secsize
        add     [dmaadr],ax
        inc     [cursec]        ;schon den naechsten 
        mov     ax,[curtrk]     ;Sector einstellen
        mov     ch,al
        and     ah,03h          ;und in CL (Sector) zusaetzlich 
        ror     ah,1            ;die beiden oberen Bits als 
        ror     ah,1            ;Track benutzen
        or      cl,ah           ;oberes Byte der Track-Nummer
        mov     dl,[drivesel]
        mov     al,1
        ret

DERROR: LDS     BX,CS:[PTRSAV]
        MOV     [BX.COUNT],0
        PUSH    CS              ;Fehlermeldung des INT 13h in 
        POP     DS              ;Fehlermeldung fuer DOS umsetzen
        TEST    AL,80H
        JNZ     DE1
        MOV     AL,2
        JMP     SHORT DEE
DE1:    TEST    AL,40H
        JNZ     DE2
        MOV     AL,6
        JMP     SHORT DEE
DE2:    TEST    AL,3
        JNZ     DE3
        xor     al,al
        JMP     SHORT DEE
DE3:    TEST    AL,10H
        JNZ     DE4
        MOV     AL,4
        JMP     SHORT DEE
DE4:    test    al,2
        jnz     de5
        mov     al,8
        jmp     short dee
de5:    MOV     AL,12
DEE:    RET

siemolli        db      0               ;Dritter Parameter
tr4080          db      0               ;40 oder 80 Track

drivesel        db      0               ;Sicherungsspeicher fuer 
CURSEC          DB      0               ;verschiedene Daten
CURTRK          DW      0
DMAADR          DW      0
dmasegment      dw      0

MAXSEC          DB      0               ;Anz. Sectoren/Zylinder

SECCNT          DW      0
secpertrak      db      0

ibmifcflg       db      0               ;IFC, FDC oder IBM PC

crlf            db      0dh,0ah,0

deftxt		db	"Default Werte :",0dh,0ah
		db	"80 Track Drive 1",0dh,0ah,0
fehlertxt	db	"Fehler in Parameterfeld",0dh,0ah,0

startmes	db	0dh,0ah,"AT Disk Treiber (ct86)    "
		db	"V 1.4 (12.11.86)"
		db	0dh,0ah,0

; CALLF MONITOR Aufruf

ROMCALL:PUSH    BX
        PUSH    DI
        CALL    monitor
        POP     DI
        POP     BX
        RET

ausgabe:mov     al,[si]         ;Textausgabe ueber INT 10H
        or      al,al           ;Endezeichen ist 00H
        jz      ausgend
        mov     ah,0eh
        push    si
        int     10h
        pop     si
        inc     si
        jmp     short ausgabe
ausgend:ret

endetreiber     db      ?       

localer endp
CODE    ENDS

        if1
        %out    End of Pass 1
        endif

        if2
        %out    End of Pass 2
        endif

        END
 
