program PATCH (input,output);

CONST
      STRING_LENGTH       = 80;               { allgemeine String-Laenge      }
      ERROR_VAL : integer = -1;               { allgemeiner Fehler-Wert       }
      DOSbreak  : boolean = true;             { Abbruch im Fehler-Fall        }
      CARRY_F             = 1;                { Maske fuer Carry-Flag         }
      ZERO_F              = 64;               { Maske fuer Zero-Flag          }

      READONLY            = 1;                { Masken fuer File-Attribute    }
      HIDDEN              = 2;
      SYSTEM              = 4;
      VOLUME              = 8;
      SUBDIR              = 16;
      ARCHIVE             = 32;


TYPE
     AccessType       = (ro,wo,rw);           { ReadOnly,WriteOnly,ReadWrite  }
     IOType           = (Reading,Writing);    { Ein- bzw. Ausgabetyp          }

     RegType          = RECORD
                        CASE Boolean OF
                          True : (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags:Integer);
                          False: (AL,AH,BL,BH,CL,CH,DL,DH:Byte);
                        END;
                                              { Registerabbild des Prozessors }

     StringType     = String[STRING_LENGTH];  { allgemeiner String-Typ        }

     PathNameType   = ARRAY[1..67] OF Char;   { kann einen Pfadnamen halten   }


VAR
     Reg              : RegType;              { Prozessor-Variable            }

     ErrFunc          : Integer;              { zur Fehlerbehandlung          }
     ErrCode          : Integer;

     biosbuffer       : array [0..$3577] of byte;
     formatbuffer     : array [0..$255b] of byte;
     version          : integer;
     handle           : integer;
     res              : integer;

{=============================================================================}


{$V-  Keine Ueberpruefung der Stringlaengen, muss desaktiviert werden}

procedure DOSError(where,what : integer);
{einfache Error-Handling-Prozedur}
begin
  if DOSbreak then
  begin
    writeln('DOS-Function : ',where);
    writeln('Error-Code   : ',what);
    halt;
  end
  else
  begin
    ErrFunc:=where;
    ErrCode:=what;
  end;
end;

procedure ConvertToASCIIZ(st : StringType;var AsciiZ : PathNameType);
{konvertiert Pascal-String nach ASCIIZ-String}
begin
  st:=st+#0;
  move(st[1],AsciiZ,length(st));
end;


function OpenFile(name : StringType;Mode : AccessType) : integer;
{oeffnet Datei}
var reg:RegType;
    dummy:PathNameType;
begin
  ConvertToASCIIZ(name,dummy);
  reg.ah:=$3d;
  reg.al:=ord(Mode);
  reg.ds:=seg(dummy);
  reg.dx:=ofs(dummy);
  MsDos(reg);
  OpenFile:=ERROR_VAL;
  if reg.flags and CARRY_F=CARRY_F then DOSError($3d,reg.ax)
  else OpenFile:=reg.ax;
end;


function CreateFile(name:StringType;Attribute:integer):integer;
{erzeugt neue Datei}
var reg:RegType;
    dummy:PathNameType;
begin
  ConvertToASCIIZ(name,dummy);
  reg.ah:=$3c;
  reg.cx:=Attribute;
  reg.ds:=seg(dummy);
  reg.dx:=ofs(dummy);
  MsDos(reg);
  CreateFile:=ERROR_VAL;
  if reg.flags and CARRY_F=CARRY_F then DOSError($3c,reg.ax)
  else CreateFile:=reg.ax;
end;


procedure CloseFile(FileHandle : integer);
{schliesst Datei}
var reg:RegType;
begin
  reg.ah:=$3e;
  reg.bx:=FileHandle;
  MsDos(reg);
  if reg.flags and CARRY_F=CARRY_F then DOSError($3e,reg.ax)
end;


function FileIO(    FileHandle : integer;
                var Buffer;
                    Num        : integer;
                    Mode       : IOType) : integer;

{fuehrt File-IO durch}
var reg:RegType;
begin
  if mode=reading then reg.ah:=$3f
  else reg.ah:=$40;
  reg.bx:=FileHandle;
  reg.cx:=Num;
  reg.ds:=seg(Buffer);
  reg.dx:=ofs(Buffer);
  MsDos(reg);
  if reg.flags and CARRY_F=CARRY_F then
  begin
    if mode=reading then DOSError($3f,reg.ax)
    else DOSError($40,reg.ax);
    FileIO:=ERROR_VAL;
  end
  else FileIO:=reg.ax;
end;

function GetAttribute(name : StringType) : integer;
{holt Attribut eines Files}
var reg:RegType;
    dummy:PathNameType;
begin
  ConvertToASCIIZ(name,dummy);
  reg.ax:=$4300;
  reg.ds:=seg(dummy);
  reg.dx:=ofs(dummy);
  MsDos(reg);
  GetAttribute:=ERROR_VAL;
  if reg.flags and CARRY_F=CARRY_F then DOSError($43,reg.ax)
  else GetAttribute:=reg.cl and $3f;
end;

procedure SetAttribute(name : StringType;NewAttr : integer);
{setzt Attribut eines Files}
var reg:RegType;
    dummy:PathNameType;
begin
  ConvertToASCIIZ(name,dummy);
  reg.ax:=$4301;
  reg.cx:=NewAttr;
  reg.ds:=seg(dummy);
  reg.dx:=ofs(dummy);
  MsDos(reg);
  if reg.flags and CARRY_F=CARRY_F then DOSError($43,reg.ax);
end;

{=============================================================================}

begin {main}
  clrscr;
  writeln ('           PATCH Programm fuer PC DOS 2.1 und 3.1 - deutsch -');
  writeln ('           --------------------------------------------------');
  writeln ;
  writeln ('  05.12.86 1986 by Martin Ernst');
  writeln ;
  writeln ;
  writeln ;
  writeln ;
  writeln ;

  { Wenn Version nicht 3.1 oder 2.1, dann mit Fehlermeldung beenden }
  reg.ax:=$3000;
  MsDos(reg);
  if (reg.ax <> $0a03) and (reg.ax <> $0a02)
  then
    writeln ('keine korrekte PCDOS-Version')
  else
  begin
    writeln ('PCDOS-Version : ',lo(reg.ax),'.',hi(reg.ax));
    version := lo(reg.ax);

    writeln ('Aendern des SYSTEM-Attributes fuer IBMBIO.COM und IBMDOS.COM');

    setattribute ('IBMBIO.COM',$20);
    setattribute ('IBMDOS.COM',$20);

    writeln ('Einlesen von IBMBIO.COM');
    handle := openfile ('IBMBIO.COM',ro);

{ Wenn es Version 2.1 ist, dann nur 4724 Bytes einlesen, bei 3.1 9591 Bytes }
    if version = 2 then
      res := fileio(handle, biosbuffer, $1274, reading)
    else
      res := fileio(handle, biosbuffer, $2577, reading);

    closefile(handle);

    writeln ('Veraendern des Parameterblocks');

      if version=2 then
        if biosbuffer[$45e] = $01 then
        begin
          biosbuffer[$45e] := $03;
          biosbuffer[$461] := $70;
          biosbuffer[$463] := $a8;
          biosbuffer[$464] := $02;
          biosbuffer[$47f] := $e0;
        end
        else
        begin
          biosbuffer[$45e] := $01;
          biosbuffer[$461] := $40;
          biosbuffer[$463] := $40;
          biosbuffer[$464] := $01;
          biosbuffer[$47f] := $70;
        end;

      if version=3 then
       if biosbuffer[$500] = $01 then
       begin
         biosbuffer[$500] := $03;
         biosbuffer[$503] := $70;
         biosbuffer[$505] := $a8;
         biosbuffer[$506] := $02;
         biosbuffer[$51e] := $e0;
       end
       else
       begin
         biosbuffer[$500] := $01;
         biosbuffer[$503] := $40;
         biosbuffer[$505] := $40;
         biosbuffer[$506] := $01;
         biosbuffer[$51e] := $70;
       end;

    writeln ('Zurueckschreiben als neue Datei NEWBIO.COM');
    handle := createfile ('NEWBIO.COM',$20);

    if version = 2 then
      res := fileio(handle, biosbuffer, $1274, writing)
    else
      res := fileio(handle, biosbuffer, $2577, writing);

    closefile(handle);

    writeln ('Einlesen von FORMAT.COM');
    handle := openfile ('FORMAT.COM',ro);

    if version = 2 then
      res := fileio(handle, formatbuffer, $1ba1, reading)
    else
      res := fileio(handle, formatbuffer, $255b, reading);

    closefile(handle);

    writeln ('Veraendern des Parameterblocks');

      if version=2 then
        if formatbuffer[$1319] = $28 then
        begin
          formatbuffer[$1319] := $50;
          formatbuffer[$1642] := $70;
          formatbuffer[$1644] := $d0;
          formatbuffer[$1645] := $02;
          formatbuffer[$1647] := $04;
          formatbuffer[$1654] := $e0;
          formatbuffer[$1656] := $a0;
          formatbuffer[$1657] := $05;
          formatbuffer[$1659] := $04;
        end
        else
        begin
          formatbuffer[$1319] := $28;
          formatbuffer[$1642] := $40;
          formatbuffer[$1644] := $68;
          formatbuffer[$1645] := $01;
          formatbuffer[$1647] := $02;
          formatbuffer[$1654] := $70;
          formatbuffer[$1656] := $d0;
          formatbuffer[$1657] := $02;
          formatbuffer[$1659] := $02;
        end;

      if version=3 then
       if formatbuffer[$1af1] = $28 then
       begin
         formatbuffer[$1af1] := $50;
         formatbuffer[$1f32] := $70;
         formatbuffer[$1f34] := $d0;
         formatbuffer[$1f35] := $02;
         formatbuffer[$1f37] := $04;
         formatbuffer[$1f44] := $e0;
         formatbuffer[$1f46] := $a0;
         formatbuffer[$1f47] := $05;
         formatbuffer[$1f49] := $04;
       end
       else
       begin
         formatbuffer[$1af1] := $28;
         formatbuffer[$1f32] := $40;
         formatbuffer[$1f34] := $68;
         formatbuffer[$1f35] := $01;
         formatbuffer[$1f37] := $02;
         formatbuffer[$1f44] := $70;
         formatbuffer[$1f46] := $d0;
         formatbuffer[$1f47] := $02;
         formatbuffer[$1f49] := $02;
       end;

      writeln ('Zurueckschreiben als neue Datei NEWFORM.COM');
      handle := createfile ('NEWFORM.COM',$20);

      if version = 2 then
        res := fileio(handle, formatbuffer, $1ba1, writing)
      else
        res := fileio(handle, formatbuffer, $255b, writing);

      closefile(handle);
  end;
end.
