program huffman;
{ Programm zur Codierung eines ASCII-Files nach dem Huffman-
  Algorithmus.
  Autor:  Frank Streichert, Juni 1986 }


type eintrag     = (blatt,knoten);
     ptrnode     = ^node;
     node        = record
                     ptrl,ptrr:ptrnode;
                     anz      :integer;
                     case art:eintrag of blatt:(ASCII:0..255)
                   end;
     tabelle     = array[0..255] of node;
     string20    = string[20];
     CodeTabelle = array[0..255] of string20;

 var feld        : tabelle;
     tafel       : CodeTabelle;
     zeichen     : char;
     zaehler,i   : integer;
     quelle      : text;
     ziel        : file of byte;
     wurzel      : ptrnode;
     entropie    : real;
     mittelpfad  : real;


procedure File_Oeffnen;
{ liest den Namen des zu kodierenden Files ein und oeffnet
  dieses als quelle und das Codefile als ziel, in das ueber-
  setzt wird.
  quelle,ziel : text sind globale Groessen }

var OK                 : boolean;
    quellname,zielname : string20;

begin
   repeat
      writeln;
      write('Codiere das File: ');
      readln(quellname);
      assign(quelle,quellname);
      {$I-} reset(quelle) {I+};
      OK:=(IOResult=0);
      if not OK then
         writeln('File ',quellname:length(quellname),
                 ' nicht vorhanden');
   until OK;
   if pos('.',quellname)>0 then
      zielname:=copy(quellname,1,pos('.',quellname))+'cod'
   else
      zielname:=zielname+'.cod';
   writeln('File ',quellname:length(quellname),' wird in ',
           zielname:length(zielname),' uebersetzt');
   assign(quelle,quellname);
   assign(ziel,zielname);
   reset(quelle);
   rewrite(ziel)
end; { File_Oeffnen }




procedure sort(var feld:tabelle;max:integer);
{ BubbleSort, es wird absteigend nach Anzahl sortiert }

var index     : integer;
    getauscht : Boolean;


   function tausche(var a,b:node):boolean;

   var temp : node;

   begin
      temp:=a;
      a:=b;
      b:=temp;
      tausche:=true
   end; { tauschen }


begin
   repeat
      getauscht:=false;
      for index:=max downto 1 do
         if feld[index].anz>feld[index-1].anz then
            getauscht:=tausche(feld[index],feld[index-1])
   until not getauscht
end; { sort }


function Baum_Erzeugen(feld:tabelle):ptrnode;
{ Erzeugt einen Codebaum nach dem Huffman-Algorithmus und
 gibt den Zeiger auf die Wurzel des Baumes zurueck }

var grad                                     : integer;
    neues_element,rechter_nachf,linker_nachf : ^node;


   function reduziere(var feld:tabelle):integer;
   { Das Feld wird auf die Komponenten reduziert, deren
     zugehrige Zeichen im Text erkannt wurden.
     Zurckgegeben wird die Anzahl der Zeichen }

   var zaehler,i,j : integer;

   begin
      zaehler:=0;
      for i :=255 downto 0 do
         if feld[i].anz>0 then zaehler:=zaehler+1
         else for j:=i to 254 do
                 feld[j]:=feld[j+1];
      reduziere:=zaehler-1;
   end; { reduziere }


begin
   grad:=reduziere(feld);
   while grad>0 do
        { hier ist noch nicht abgefangen, dass ein File nur
                            aus einer Art Zeichen besteht! }
      begin
      sort(feld,grad);
      new(rechter_nachf);
      new(linker_nachf);
      rechter_nachf^:=feld[grad];
      linker_nachf^:=feld[grad-1];
      with feld[grad-1] do
               { fasse die letzten beiden Eintraege im Feld
                zu einem neuen Element zusammen, das erstmal
                      an das Ende des Feldes gestellt wird }
         begin
         art:=knoten;
         ptrl:=linker_nachf;
         ptrr:=rechter_nachf;
         anz:=rechter_nachf^.anz+linker_nachf^.anz
      end;
      grad:=grad-1
   end;
   new(neues_element);
   neues_element^:=feld[0];
   Baum_Erzeugen:=neues_element
    { Ptr auf Wurzel des Baumes soll zurckgegeben werden }
end; { Baum_Erzeugen }



procedure Tabelle_Erzeugen(wurzel:ptrnode; var temp: codeTabelle);
{ Erzeugt aus dem Codebaum eine Codetabelle, die zur
  Codierung des Textfiles dienen soll und ueber die ASCII-
  Ordnung indiziert wird }

   procedure umwandeln(baum_element:ptrnode;bin:string20);
   { hangelt sich rekursiv durch den Codebaum, eine linke
     Verzweigung erzeugt eine '0', eine rechte eine '1',
     bei Erreichen eines Blattes wird die Bitfolge als
     String in die Codetabelle eingetragen }

   begin
      with baum_element^ do
         if art<>blatt then
            begin
            umwandeln(ptrl,bin+'0');
            umwandeln(ptrr,bin+'1')
            end
         else
            begin
            temp[ASCII]:=bin;
            entropie:= entropie + feld [ascii].anz
                       * ln (feld[ascii].anz/zaehler);
            mittelpfad:= mittelpfad + length (bin) * anz;
            end;
   end; { umwandeln }



   procedure init (var tab: CodeTabelle);
   { Die Codetabelle muss in einen definierten Ausgangszu-
     stand versetzt werden um Fehler bei der Codeausgabe
     auszuschliessen }

   var i : integer;

   begin
      for i:= 0 to 255 do tab[i]:=''
   end;



begin
   init(temp);
   entropie:=0;
   mittelpfad:=0;
   umwandeln(wurzel,'');
   entropie:=entropie / zaehler / ln (2);
   mittelpfad:= mittelpfad / zaehler;
   writeln ('Entropie der Verteilung: ',entropie);
   writeln ('Mittlere Codelaenge    : ',mittelpfad);
end; { Tabelle_Erzeugen }



function zwei_hoch(exponent:byte):byte;
{ Berechnet Zweierpotenzen }

var i,erg : byte;

begin
   erg:=1;
   for i:=1 to exponent do
      erg:=erg*2;
   zwei_hoch:=erg
end; { zwei_hoch }



procedure Code_Ausgabe( var tafel: codetabelle;
                     anzahl:integer; wurzel:ptrnode);
{ Anzahl der gelesenen Zeichen, Codebaum und erzeugter Code
  wird in das Codefile geschrieben.
  quelle,ziel : text sind globale Groessen }

var akt_Bit  : 0..7;
    akt_Byte : byte;


   procedure Anzahl_Schreiben(anz:integer);
   { Schreibt die Anzahl der gelesenen Zeichen in das
     Codefile }

   var hibyt,lobyt : byte;

   begin
      hibyt:=anz div 256;
      write(ziel,hibyt);
      lobyt:=anz mod 256;
      write(ziel,lobyt)
   end; { Anzahl_Schreiben }


   procedure Bit_Schreiben(chr:char);
   { Character wird in 0 oder 1 umgewandelt und in
     Abhaengigkeit von akt_Bit entsprechend in akt_Byte
     gesetzt, das nach dem achten Bit in das Codefile
     geschrieben wird }

   var bit,fehler : integer;

   begin
      val(chr,bit,fehler);
      akt_Byte:=akt_Byte+zwei_hoch(7-akt_Bit)*bit;
      if akt_Bit=7 then
         begin
         write(ziel,akt_Byte);
         akt_Bit:=0;
         akt_Byte:=0 end
      else akt_Bit:=akt_Bit+1
   end; { Bit_Schreiben }


   procedure Baum_Schreiben(zeiger:ptrnode);
   { Codebaum wird durchlaufen, wobei fr jeden Knoten
     eine '1', danach rekursiv der linke und rechte Unter-
     baum, fr jedes Blatt eine '0', gefolgt von der ASCII-
     Codierung des entsprechenden Zeichens ausgegeben wird }

   var index,zahl : byte;
       bit        : string[1];

   begin
      if zeiger^.art = blatt then
         begin
         Bit_Schreiben('0');
         zahl:=zeiger^.ASCII;
         for index:=1 to 8 do
            begin
            str(zahl mod 2,bit);
            Bit_Schreiben(bit);
            zahl:=zahl div 2
            end
         end
      else
         begin
         Bit_Schreiben('1');
         Baum_Schreiben(zeiger^.ptrl);
         Baum_Schreiben(zeiger^.ptrr)
      end
   end;  { Baum_Schreiben }


   procedure Code_Schreiben;
   { Codierung der Zeichen des Textfiles, indem fuer jedes
     Zeichen aus der Code_Tabelle, indiziert ueber die
     ASCII-Ordnung, der neue Code geholt und ausgegeben
     wird }

   var zeichen : char;
       index   : byte;

   begin
      reset(quelle);
      while not EOF(quelle) do
         begin
         read (quelle,zeichen);
         for index:=1 to length(tafel[ord(zeichen)]) do
            { Binaercode bitweise schreiben }
            Bit_Schreiben(copy(tafel[ord(zeichen)],index,1))
      end;
      while akt_Bit>0 do Bit_Schreiben('0')
         { letztes Byte mit '0' auffllen }
   end; { Code_Schreiben }


begin
   Anzahl_Schreiben(anzahl);
   { Anzahl der gelesenen Zeichen in Codefile schreiben }

   akt_Bit:=0; akt_Byte:=0;
   Baum_Schreiben(wurzel);
   { Baum wird in Codefile geschrieben }

   Code_Schreiben;
   { Quellfile wird codiert in Codefile geschrieben }
end; { Code_Ausgabe }





begin
   { Initialisieren des Feldes }
   for i:=0 to 255 do
      with feld[i] do
         begin
         art:=blatt;
         ptrl:=nil;
         ptrr:=nil;
         ASCII:=i;
         anz:=0
      end;

   zaehler:=0;
   File_Oeffnen;

   { Auszaehlen der Zeichen des Textfiles }
   while not EOF(quelle) do
      begin
         read(quelle,zeichen);
         feld[ord(zeichen)].anz:=feld[ord(zeichen)].anz+1;
         zaehler:=zaehler+1
   end;
   Writeln ('Nun wird der Baum gepflanzt');
   wurzel:=Baum_Erzeugen(feld);
   writeln ('Seine Blaetter liefern den Code');
   Tabelle_Erzeugen(wurzel,tafel);
   Code_Ausgabe (tafel,zaehler,wurzel);
   writeln ('Das wars');
   close(quelle);
   close(ziel)
end.