program decodieren;
{ Programm zum Decodieren des nach dem Huffman-Algorithmus
  codierten Files.
  Autor :  Frank Streichert, Juni 1986 }


type eintrag = (blatt,knoten);
     ptrnode = ^node;
     node    = record
                 ptrl,ptrr:ptrnode;
                 case art:eintrag of blatt:(ASCII:0..255)
               end;
     binaer  = 0..1;

var akt_Bit       : 0..7;
    bit           : binaer;
    akt_Byte      : byte;
    anzahl,i      : integer;
    wurzel,zeiger : ptrnode;
    codefil       : file of byte;
    txtfil        : text;



function zwei_hoch(exponent:byte):byte;

var i,erg:byte;

begin
   erg:=1;
   for i:=1 to exponent do
      erg:=erg*2;
   zwei_hoch:=erg
end;  { zwei_hoch }



function Anzahl_Lesen:integer;
{ liest aus dem Codefile die ersten beiden Bytes und inter-
  pretiert sie als Anzahl der zu decodierenden Zeichen }

var hibyt,lobyt:byte;

begin
   read(codefil,hibyt);
   read(codefil,lobyt);
   Anzahl_Lesen:=hibyt*256+lobyt
end; { Anzahl_Lesen }



function Bit_Lesen:binaer;
{ liest ein Byte aus dem Codefile und gibt ein Bit daraus
  zurueck.
  Globale Variablen sind
                akt_Byte : byte    aktuelles Byte
                akt_Bit  : byte    Position des naechsten
                                   zu lesenden Bits }

var erg:byte;
    bit:binaer;

begin
   if akt_Bit=7 then
      begin
      if not EOF(codefil) then
         read(codefil,akt_Byte);
      akt_Bit:=0 end
   else akt_Bit:=akt_Bit+1;

   erg:=akt_Byte;
   for i:=7 downto akt_Bit do
      begin
      bit:=erg mod 2;
      erg:=erg div 2
   end;

   Bit_Lesen:=bit
end; { Bit_Lesen }


procedure Baum_Lesen(var zeiger:ptrnode);
{ rekonstruiert den Codebaum, indem, analog zur Prozedur
  Baum_Schreiben, rekursiv ein Codebaum erzeugt wird }

var bit:binaer;
    i : integer;

begin
   bit:=Bit_Lesen;
   if bit=1 then
      with zeiger^ do
         begin
         art:=knoten;
         new(ptrl); new(ptrr);
         Baum_Lesen(ptrl);
         Baum_Lesen(ptrr)
      end
   else
      with zeiger^ do
         begin
         art:=blatt;
         ASCII:=0;
         for i:=0 to 7 do
            ASCII:=ASCII+Bit_Lesen*zwei_hoch(i);
         ptrl:=nil;
         ptrr:=nil
      end
end; { Baum_lesen }

procedure File_Oeffnen;
{ liest den Namen des zu dekodierenden Files ein und
  Nffnet dieses als Quellfile und das ASCII-File als
  Zielfile, in das uebersetzt wird }

var OK                 : boolean;
    quellname,zielname : string[80];


begin
   repeat
      writeln;
      write('Decodiere das File: ');
      readln(quellname);
      assign(codefil,quellname);
      {$I-} reset(codefil) {I+};
      OK:=(IOResult=0);
      if not OK then
         writeln('File ',quellname:length(quellname),
                 ' nicht vorhanden');
   until OK;
   if pos('.',quellname)>0 then
      zielname:=copy(quellname,1,pos('.',quellname))+'txt'
   else
      zielname:=zielname+'.txt';
   writeln('File ',quellname:length(quellname),' wird in ',
           zielname:length(zielname),' uebersetzt');
   assign(codefil,quellname);
   assign(txtfil,zielname);
   reset(codefil);
   rewrite(txtfil)
end; { File_Oeffnen }





begin
   File_Oeffnen;           { erstmal die Files oeffnen }

   anzahl:=Anzahl_Lesen;
   { wieviel Zeichen waren im urspruenglichen
                            ASCII-File enthalten? }
   akt_Bit:=7;             { akt_Bit vorbesetzen  }

   new(wurzel);
   Baum_Lesen(wurzel);     { Codebaum wiederherstellen }

   { File wird rekonstruiert, indem bitweise das Codefile
      gelesen und im Baum von der Wurzel ausgehend
      solange der entsprechende Pfad verfolgt wird, bis
      ein Blatt erreicht und somit ein Zeichen erkannt
      und dekodiert ist }

   for i:=1 to anzahl do
      begin
      zeiger:=wurzel;
      while zeiger^.art<>blatt do
         begin
         bit:=Bit_Lesen;
         if bit=1 then zeiger:=zeiger^.ptrr
         else zeiger:=zeiger^.ptrl
      end;
      write(txtfil,chr(zeiger^.ASCII))
         { dekodiertes Zeichen in neuen ASCII-File schreiben }
   end;
   Write (txtfil,^Z);
   close(txtfil);
   close(codefil)
end.
