(* Druckt WordStar-Dateien. Aufruf mit:

   TPRINT           - fragt nach Dateiname und druckt gesamte Datei
   TPRINT Dateiname                          - druckt gesamte Datei
   TPRINT Dateiname Start-Seite              - druckt von ... bis Dateiende
   TPRINT Dateiname Start-Seite End-Seite    - druckt von ... bis ...

   Abbruch/Unterbrechung waehrend des Drucks mit Tastendruck  *)


Program TPRINT;

CONST
     MaxRecs = 10;
     BufSize = 1280;       {Puffer: 10 Records}

     Ph_Hyphen = #31;           {Trennstrich am Zeilenende}
     Ph_Space  = #15;           {^PO: nicht-trennendes Leerzeichen}

{*** Druckerspezifische Steuerzeichen ***}

     CR        = #13;  LF        = #10;  CRLF      = #13#10;

     BOLDON    = #27'E';        {^B: Fettdruck ein}
     BOLDOFF   = #27'F';             {aus}
     UNDLON    = #27'-'#1;      {^S: Unterstreichen ein}
     UNDLOFF   = #27'-'#0;           {aus}
     SLANTON   = #27'4';        {^D: Kursiv ein}
     SLANTOFF  = #27'5';              {aus}
     SUBSON    = #27'S'#1;      {^V: Subscript ein}
     SUBSOFF   = #27'T';             {aus}
     SUPSON    = #27'S'#0;      {^T: Supersript ein}
     SUPSOFF   = #27'T';             {aus}
     ALTSET    = #27'R'#0;      {^A: alternativer Zeichensatz}
     NORMSET   = #27'R'#2;      {^N: normaler Zeichensatz (DEUTSCH)}

     NLQON     = #27'x'#1;       {^Q: NLQ ein}
     NLQOFF    = #27'x'#0;           {aus}
     WEITON    = #28'E'#1;      {^W: Breitdruck ein}
     WEITOFF   = #28'E'#0;           {aus}
     ENGON     = #27#15;        {^E: Engschrift ein (17 cpi)}
     ENGOFF    = #18;                {aus}
     RIESIGON  = #28'V'#1;      {^R: zweizeilig ein}
     RIESIGOFF = #28'V'#0;            {aus}
                                {^X: nicht benutzt}
                                {^Y: nicht benutzt}

     INISTR    = '';            {Printer INIT}
     UNISTR    = '';            {(nach Druckende)}


VAR
   Infile: File;       ENDFILE: Boolean;              {Input-Datei + Endflag}
   ENDBUF: Boolean;    InBuf: Integer;                {Flag: Pufferende, Index}
   Buffer: ARRAY[1..BufSize] of Byte;

   Pstart, Pend, Pcount: Integer;                 {Seiten-Counter}
   PrintON: Boolean;  Fname: String[12];          {Flag: Ausgabe ja/nein}


Procedure SetOpen;
Begin
     If ParamCount = 0
        then begin write ('Name der auszudruckenden Datei: ');
                   readln (Fname);
             end
        else Fname:= ParamStr(1);

     Assign(Infile,Fname); {$I-} Reset(Infile); {$I+}
     If IOresult <> 0 then begin
                             close (Infile);
                             writeln ('Nicht gefunden: ',Fname);
                             Halt;
                           end;
End;


Function Getch: Char;
VAR Recsgot: Integer;
Begin
     If ENDBUF then begin
                  Blockread (Infile, Buffer, MaxRecs, Recsgot);
                  ENDBUF:= False; InBuf:= 1;
                  If Recsgot = 0 then begin
                                        writeln ('Unexpected EOF!');
                                        Close (Infile); Halt;
                                      end;
                  end;

        Getch:= chr(Buffer[InBuf] AND 127);
        InBuf:= InBuf + 1; If InBuf > BufSize then ENDBUF:= True;
End; {Getch}


Procedure PrintFile;
VAR
   BOLD, SLANT, UNDL, SUBS, SUPS, NLQ, WEIT, ENG,
   RIESIG, UNDLSET, NEWLINE, PAGE: Boolean;
   POffs, MTop, MBot, PLen, PNumber,
   Lcount, Hpos, x: Integer;
   ch: Char;

Procedure ResetPrt;
Begin
  write (lst, BOLDOFF); write (lst, SLANTOFF);
  write (lst,UNDLOFF); UNDLSET:= False;
  write (lst, SUBSOFF); write (lst, SUPSOFF);
  write (lst, WEITOFF); write (lst, ENGOFF);
end;

Procedure SetPrt;
Begin
  If BOLD then write (lst, BOLDON); If SLANT then write (lst, SLANTON);
  If SUBS then write (lst, SUBSON); If SUPS then write (lst, SUBSON);
  If WEIT then write (lst, WEITON); If ENG then write (lst, ENGON);
End;

Procedure Printpn;
VAR x: Integer;
Begin
     If PAGE then begin
                    ResetPrt;
                    write (lst,CRLF); write (lst,CRLF);
                    for x:= 1 to 37 + POffs do write (lst, ' ');
                    if PNumber < 10 then write (lst, ' ');
                    write (lst, '- ',PNumber,' -',CRLF);
                    write (lst, #12);                    {Formfeed}
                    SetPrt;
                  end
     else begin write (lst,CRLF); write (lst, #12); end;
End;


Procedure NextLine;
Begin
     Lcount:= Lcount + 1;
     If Lcount >= (PLen - MTop - MBot)
        then begin Lcount:= 0;
                   If PrintON then Printpn;
                   PNumber:= PNumber + 1; Pcount:= Pcount + 1;
                   If Pcount >= (Pstart - 1) then PrintON:= True;
                   If (Pcount >= Pend) and (Pend <> 0) then ENDFILE:= True;
             end;
 End; {NextLine}

Procedure LastPage;
Begin
     If not NEWLINE then begin
                           If PrintON then write (lst,CRLF);
                           NextLine;
                         end;
   while (Lcount <> 0) do begin
                            If PrintON then write (lst,CRLF);
                            NextLine;
                          end;
End; {LastPage}

Procedure DODOTCMD;
CONST
      CMDCHARS = 15;
      CMDS: Array[2..CMDCHARS] of Char = 'MTMBPLPNPOPAOP';

VAR Cmdnum, Arg, ok, x: Integer;
    ARGSTR: String[5]; Line: String[120];

Begin
     Line:= '';
   repeat ch:= Getch; Line:= Line + UpCase(ch); until (ch = chr(10));
     If length(Line)<2 then Exit;

     Cmdnum:= 0;
     for x:= 1 to CMDCHARS div 2 do
         If (Line[1]=CMDS[x*2]) and (Line[2]=CMDS[x*2+1]) then Cmdnum:= x;
     If (Cmdnum = 0) then Exit;
     If (Cmdnum < (CMDCHARS DIV 2) - 1) then begin
                            x:= 3;
                            while (Line[x]=' ') and (x<=Length(Line))
                                do x:=x + 1;
                            Argstr:='';
                            while (Line[x] in ['0'..'9'])
                            do begin
                                 Argstr:= Argstr + Line[x]; x:= x + 1;
                               end;
                            Val(Argstr,Arg,ok); If (ok <> 0) then Exit;
                          end;
     case cmdnum of
        1: MTop:= Arg;
        2: MBot:= Arg;
        3: PLen:= Arg;
        4: PNumber:= Arg;
        5: POffs:= Arg;
        6: LastPage;
        7: PAGE:= False;
     end; {case}
End; {DODOTCMD}

Procedure TestStop;
VAR  ch: Char;
Begin
     GotoXY (25,10); write ('* Druck unterbrochen *');
     GotoXY (25,12); write ('A: Abbruch   W: Weiter');
  repeat
     Gotoxy (36,12); read (kbd,ch); ch:= Upcase(ch); write(ch);
  until (ch in ['A','W']);
     If (ch = 'A') then ENDFILE:= True;
     Delay (500); GotoXY (25,10); ClrEol; GotoXY (25,12); ClrEol;
End;


Begin {PrintFile}
      BOLD:= False; SLANT:= False; UNDL:= False;
      UNDLSET:=False; SUBS:= False; SUPS:= False;
      WEIT:= False; ENG:= False; NLQ:= False; RIESIG:= False;

      NEWLINE:= True; ENDBUF:= True; ENDFILE:= False;
      MTop:= 0; MBot:= 11; POffs:= 2;  PLen:= 72; PNumber:= 1;
      Lcount:= 0; Hpos:= 1; PAGE:= True;

 Repeat
      ch:= Getch;
      If (ch = '.') and NEWLINE then DODOTCMD
         else begin
            If (ch = Ph_Space) then ch:= ' ';
            If (ch = Ph_Hyphen) then ch:= '-';

            If ch < ' ' then case ch of

              ^A: write (lst, ALTSET);
              ^B: begin BOLD:= not BOLD;
                               If BOLD then write (lst, BOLDON)
                                       else write (lst, BOLDOFF); end;
              ^C: TestStop;
              ^D: begin SLANT:= not SLANT;
                               If SLANT then write (lst, SLANTON)
                                        else write (lst, SLANTOFF); end;
              ^E: begin ENG:= not ENG;
                               If ENG then write (lst, ENGON)
                                       else write (lst, ENGOFF);  end;
              ^H: If PrintON then write(lst,ch);
              ^I: If PrintON then for x:= Hpos to (Hpos div 8) * 8 + 8 do
                             begin write (lst, ' '); Hpos:= Hpos + 1; end;
              ^J: begin If PrintON then write (lst,LF);
                               NextLine; end;
              ^M: begin If PrintON then write (lst,CR);
                               NEWLINE:= True; Hpos:= 1; UNDLSET:= False;
                               If UNDL then write (lst, UNDLOFF); end;
              ^N: write (lst, NORMSET);
              ^Q: begin NLQ:= not NLQ;
                               If NLQ then write (lst, NLQON)
                                       else write (lst, NLQOFF);  end;
              ^R: begin RIESIG:= not RIESIG;
                               If RIESIG then begin
                                            Lcount:= Lcount + 1;
                                            write (lst, RIESIGON);
                                              end
                                       else write (lst, RIESIGOFF); end;
              ^S: begin UNDL:= not UNDL; UNDLSET:= False;
                               If not UNDL then write (lst, UNDLOFF); end;
              ^T: begin SUPS:= not SUPS;
                               If SUPS then write (lst, SUPSON)
                                       else write (lst, SUPSOFF); end;
              ^V: begin SUBS:= not SUBS;
                               If SUBS then write (lst, SUBSON)
                                       else write (lst, SUBSOFF); end;
              ^W: begin WEIT:= not WEIT;
                               If WEIT then write (lst, WEITON)
                                       else write (lst, WEITOFF); end;
              ^Z: begin LastPage; ENDFILE:= True; end;
             #30: ;   {Soft-Hyphen im Text ignorieren}
          end {Case}

         else begin {ch nicht kleiner ' '}
              If NEWLINE then begin
                                NEWLINE:= False;
                                If PrintON then begin
                                      ResetPrt;
                                      for x:= 0 to POffs do write (lst, ' ');
                                      SetPrt;
                                                end;
                              end;
              If (UNDLSET=False) and UNDL and (ch <> ' ')
                 then begin
                           UNDLSET:= True; write (lst, UNDLON);
                      end;

              If PrintON then write (lst, ch);
              Hpos:= HPos + 1;
              end;
         end; {If ch = '.' and NEWLINE}

         If KeyPressed then begin read (kbd, ch); TestStop; end;

  until ENDFILE;
End; {PrintFile}


Procedure SetParms;
VAR
   Parmsok, x: Integer;
   Argstr: String[5];
Begin
     Val (Paramstr(2), Pstart, Parmsok);
     If (ParamCount > 2) and (Parmsok = 0)
        then begin
                 Val (Paramstr(3), Pend, Parmsok);
                 If Pstart > Pend then Parmsok:= 99;
             end;
     If Parmsok <> 0 then begin
                               writeln ('Falscher Parameter!'); Halt;
                          end;
     If Pstart > 1 then PrintON:= False;
End;

Procedure DspParms;
Var Prompt: Char;
Begin
     ClrScr;
     GotoXY(28,1); writeln ('*** WordStar-Ausdruck ***');
     GotoXY(35,2); writeln ('(c) as 1986');
     writeln; writeln;
     writeln ('Auszudruckende Datei: ', Fname);
     writeln ('Start mit Seitennr. : ', Pstart);
     write ('Ende mit Seitennr.  : ');
           If Pend = 0 then writeln ('...') else writeln (Pend);
     writeln;
     write ('^C = Abbruch, <RETURN> = Weiter: '); readln (Prompt);
     GotoXY (1,9); ClrEol;
End;


{----- Hauptprogramm ----}
Begin
     Pcount:= 0; Pstart:= 1; Pend:= 0; PrintON:= True;
     If ParamCount > 1 then SetParms;
     SetOpen;
     write (lst,Inistr);
     DspParms;                {Meldung erst wenn Drucker o.k. und Datei Open}
     PrintFile;
     write (lst,Unistr);
     Close (Infile);
End.

