program crossreference;     { c't 10/87  Waldemar Masurek    21.02.87 }

const len = 20;              { maximale Lnge eines Schlsselwortes }
      zln = 80;              { maximale Lnge einer Ausgabezeile     }

type word = string[len];
     line = string[zln];

     list = ^item;           { Liste der Zeilennummern, }
                             { in denen Wort steht      }
     item = record           { Listenelement }
              numb: integer;
              next: list
            end;

     node = ^ref;            { Verweis auf Knoten des "Ausgabebaumes" }

     ref  = record
              key : word;
              freq,
              head: list;
              lt  ,
              rt  : node
            end;

     avl = ^avl_node;        { Verweis auf Knoten des AVL-Baumes }

     avl_node = record
                  key    : word;
                  up     ,           { Zeiger auf Vaterknoten }
                  left   ,
                  right  : avl;      { Teilbaum-Zeiger        }
                  balance: -1..1;
                  dir    : char      { Erklrung siehe "avl_insert" }
                end;


var root    : node;      { Wurzel des Ausgabebaumes }
    avl_root: avl ;      { Wurzel des AVL-Baumes }
    outfile : text;      { evtl. bentigtes Ausgabefile }
    filnam  : word;      { Name des Ausgabefiles }
    zeile   : line;      { Ausgabezeile im Hauptprogramm }
    dev     : byte;      { dient zur Auswahl des Ausgabegertes }
    wahl    : char;      { Men-Auswahl im Hauptprogramm }

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure avl_insert( x: word; var root: avl );

{ Dient zum Einfgen eines Elementes in den AVL-Baum mit
  anschlieendem Ausgleich der Knotenballance bis zur Wurzel.
  Die Variable "auf" zeigt an, da weiter oben ausgeglichen werden
  mu. Die zustzliche "avl"-Komponente "dir" (fr direction) dient
  als Zeiger fr das Ausgleichen des Baumes nach dem Einfgen;
  dir = 'l': es wurde von diesem Knoten aus links eingefgt;
  dir = 'r': es wurde nach rechts verzweigt.
  Die bergebene Wurzel kann nicht leer sein (s. "make_avl") }

var oben    ,          { Hilfszeiger auf Vaterknoten }
    p       ,          { ntig, um Baumstruktur nicht zu zerstren }
    p1      ,
    p2      : avl    ;
    auf     ,
    inserted: boolean; { true, wenn mit dem Ausgleichen begonnen }
                       { werden soll }

begin
  inserted := false;
  auf := true;
  p := root;
  { Nichtrekursives binres Einfgen: }
  repeat  { until inserted }
    if x = p^.key  { dann nichts zu tun }
    then
      begin
        auf := false;
        inserted := true
      end
    else
      if x < p^.key
      then
        if p^.left = nil
        then
          begin
            new(p^.left);
            oben := p;
            p^.dir := 'l';
            p := p^.left;
            p^.key := x;
            p^.balance := 0;
            p^.up := oben;
            p^.left := nil;
            p^.right := nil;
            inserted := true
          end
        else
          begin
            p^.dir := 'l';
            p := p^.left
          end
      else    { x > p^.key }
        if p^.right = nil
        then
          begin
            new(p^.right);
            oben := p;
            p^.dir := 'r';
            p := p^.right;
            p^.key := x;
            p^.balance := 0;
            p^.up := oben;
            p^.left := nil;
            p^.right := nil;
            inserted := true
          end
        else
          begin
            p^.dir := 'r';
            p := p^.right
          end
  until inserted;
  { Nun wird ausgeglichen: }
  while auf do
  begin
    if p^.up = nil   { dann Wurzel erreicht }
    then auf := false
    else
      begin
        p := p^.up;     { vom Sohn zum Vater "klettern" }
        if p^.dir = 'l'
        then
          case p^.balance of
            1: begin
                 p^.balance := 0;
                 auf := false     { ...und fertig }
               end;
            0: p^.balance := -1;  { weitermachen (oberh. des Knotens) }
           -1: begin              { hier mu rotiert werden }
                 p1 := p^.left;
                 auf := false;
                 if p1^.balance = -1
                 then
                   begin   { R-Rotation }
                     p^.left := p1^.right;
                     if p1^.right <> nil
                     then p1^.right^.up := p;
                     p1^.right := p;
                     p^.balance := 0;
                     p1^.balance := 0;
                     if p = root  { dann mu man die Referenzen zu  }
                     then         { den Vaterknoten anders behandeln }
                       begin      { als sonst }
                         root^.up := p1;
                         p1^.up := nil;
                         root := p1
                       end
                     else    { hier mssen die Nachfolger des Vaters }
                       begin { entsprechend umgesetzt werden          }
                         case p^.up^.dir of
                           'l' : p^.up^.left := p1;
                           'r' : p^.up^.right := p1
                         end;
                         p1^.up := p^.up;
                         p^.up := p1
                       end;
                     p := p1
                   end
                 else         { alles analog zu oben, nur "andersrum" }
                   begin      { L-R-Rotation }
                     p2 := p1^.right;
                     p1^.right := p2^.left;
                     if p2^.left <> nil
                     then p2^.left^.up := p1;
                     p^.left := p2^.right;
                     if p2^.right <> nil
                     then p2^.right^.up := p;
                     p2^.left := p1;
                     p1^.up := p2;
                     p2^.right := p;
                     if p = root
                     then
                       begin
                         root^.up := p2;
                         p2^.up := nil;
                         root := p2
                       end
                     else
                       begin
                         case p^.up^.dir of
                           'l' : p^.up^.left := p2;
                           'r' : p^.up^.right := p2
                         end;
                         p2^.up := p^.up;
                         p^.up := p2
                       end;
                     if p2^.balance = -1
                     then p^.balance := 1
                     else p^.balance := 0;
                     if p2^.balance = 1
                     then p1^.balance := -1
                     else p1^.balance := 0;
                     p2^.balance := 0;
                     p := p2
                   end
               end
          end {case}
        else  { p^.dir = 'r' }   { auch hier alles wie schon gehabt, }
          case p^.balance of     { auer, da alle Rotationen      }
           -1 : begin            { umgekehrt laufen.                 }
                  p^.balance := 0; { Die Balance-Zahlen werden jetzt }
                  auf := false     { (entsprechend der Definition von}
                end;               { AVL-Bumen) anders als oben ge-}
            0 : p^.balance := 1;   { handhabt; rechte Unterbume    }
            1 : begin              { drfen um eins hher sein als }
                  p1 := p^.right;  { linke. }
                  auf := false;
                  if p1^.balance = 1
                  then
                    begin   { L-Rotation }
                      p^.right := p1^.left;
                      if p1^.left <> nil
                      then p1^.left^.up := p;
                      p1^.left := p;
                      p^.balance := 0;
                      p1^.balance := 0;
                      if p = root
                      then
                        begin
                          root^.up := p1;
                          p1^.up := nil;
                          root := p1
                        end
                      else
                        begin
                          case p^.up^.dir of
                            'l' : p^.up^.left := p1;
                            'r' : p^.up^.right := p1
                          end;
                          p1^.up := p^.up;
                          p^.up := p1
                        end;
                      p := p1
                    end
                  else
                    begin   { R-L-Rotation }
                      p2 := p1^.left;
                      p1^.left := p2^.right;
                      if p2^.right <> nil
                      then p2^.right^.up := p1;
                      p^.right := p2^.left;
                      if p2^.left <> nil
                      then p2^.left^.up := p;
                      p2^.right := p1;
                      p1^.up := p2;
                      p2^.left := p;
                      if p = root
                      then
                        begin
                          root^.up := p2;
                          p2^.up := nil;
                          root := p2
                        end
                      else
                        begin
                          case p^.up^.dir of
                            'l' : p^.up^.left := p2;
                            'r' : p^.up^.right := p2
                          end;
                          p2^.up := p^.up;
                          p^.up := p2
                        end;
                      if p2^.balance = 1
                      then p^.balance := -1
                      else p^.balance := 0;
                      if p2^.balance = -1
                      then p1^.balance := 1
                      else p1^.balance := 0;
                      p2^.balance := 0;
                      p := p2
                    end
                end
          end {case}
      end {else}
  end {while}
end {avl_insert};


procedure make_avl( var avl_root: avl );

{ liest reservierte Wrter aus einem File ein
  und bergibt sie an "avl_insert" }

var infile: text;
    st    ,
    filnam: word;

begin
  write('Name des Files mit reservierten Wrtern: ');
  readln(filnam);
  assign(infile, filnam);
  reset(infile);
  if not eof(infile)
  then
    begin                 
      readln(infile, st);
      new(avl_root);
      with avl_root^ do    { Es ist eine Vereinfachung fr }
      begin                { "avl_insert, wenn die bergebene Wurzel }
        key := st;         { nicht leer ist. Deshalb wird die Wurzel  }
        left := nil;       { "manuell" besetzt. }
        right := nil;
        up := nil;
        balance := 0
      end {with};
      while not eof(infile) do
      begin
        readln(infile, st);         { je Zeile nur ein Wort aus }
        avl_insert(st, avl_root)    { Grobuchstaben ! }
      end {while};
      close(infile)
    end {then}
  else
    begin
      writeln('File mit reservierten Wrtern leer.');
      HALT
    end {else}
end {make_avl};

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure scanner( wahl: char; var root: node; var avl_root: avl );

{ Untersucht Eingabefile und baut den "Ausgabebaum" auf. "wahl" wird im
  Hauptprogramm eingelesen (bestimmt, welche Art von Bezeichnern in den
  Baum aufgenommen wird). }

const cr    = #13;
      lf    = #10;
      bs    = #08;
      empty = '';

var line   : integer;   { aktuelle Zeilennummer }
    infile : text   ;   { zu untersuchendes File }
    st     ,            { aus dem File einzulesendes Wort }
    filnam : word;      { Filename }
    ch     ,
    ch2    : char;
    alfa   ,
    alfanum,
    comment: set of char;
    gewollt: boolean;

  procedure open_file;
  begin
    write('Name des zu untersuchenden Files: ');
    readln(filnam);
    assign(infile, filnam);
    reset(infile);
    if eof(infile)
    then begin
           writeln('Zu untersuchendes File leer.');
           HALT
         end
  end {open_file};

  procedure insert( line: integer; x: word; var current: node );
  { sucht im Ausgabebaum nach x; falls nich da, wird es eingefgt }
  begin
    if current = nil
    then begin
           new(current);
           with current^ do
           begin
             lt := nil;
             rt := nil;
             key := x;
             new(freq);
             freq^.numb := line;
             freq^.next := nil;
             head := freq
           end {with}
         end {then}
    else
      if x < current^.key
      then insert(line, x, current^.lt)
      else
        if x > current^.key
        then insert(line, x, current^.rt)
        else
          with current^ do
          begin                  { x bereits im Baum vorhanden; }
            new(freq^.next);     { nun Zeilennummer einhngen }
            freq := freq^.next;
            freq^.numb := line;
            freq^.next := nil
          end {with}
  end {insert};

  function avl_member( x: word; var current: avl ): boolean;
  { prft nach, ob x im AVL-Baum steht }
  begin
    if current = nil
    then avl_member := false
    else
      if x = current^.key
      then avl_member := true
      else
        if x < current^.key
        then avl_member := avl_member(x, current^.left)
        else avl_member := avl_member(x, current^.right)
  end {avl_member};

begin { scanner }
  open_file;
  { Initialisierung }
  alfa := ['A'..'Z','a'..'z','_']; { Unterstrich in Bezeichnern   }
  alfanum := alfa + ['0'..'9'];    { mglich                     }
  comment := ['{','}',''''];       { Kommentare und Zitate werden }
  line := 1;                       { ignoriert                    }
  root := nil;
  { Durchlauf des Eingabefiles }
  write('Bitte warten...   ');
  write(line:6);
  while not eof(infile) do
  begin
    read(infile, ch);
    if ch in alfa
    then begin     { lies ein Wort }
           st := empty;
           while (not eof(infile)) and (ch in alfanum) do
           begin
             st := st + upcase(ch);
             read(infile, ch)
           end {while};  { nun ist das Wort komplett }
           { Entscheidung, ob es in den Baum eingehngt wird }
           case wahl of
             'F': gewollt := not avl_member(st, avl_root);
             'A': gewollt := true;
             'R': gewollt := avl_member(st, avl_root)
           end {case};
           if gewollt then insert(line, st, root)
         end {then};
    if ch in [cr, lf]
    then begin
           readln(infile);
           line := succ(line);
           write(bs,bs,bs,bs,bs,bs);
           write(line:6)
         end;
    if ch in comment
    then { berspringen von Kommentaren bzw. Zitaten }
      begin                   { korrekte Syntax sei vorausgesetzt; }
                              { dann auch kein eof mgl. }
        if ch = '{' then ch2 := '}' else ch2 := '''';
        repeat
          read(infile, ch);
          if ch in [cr, lf]
          then begin
                 readln(infile);
                 line := succ(line);
                 write(bs,bs,bs,bs,bs,bs);
                 write(line:6)
               end
        until ch = ch2
      end {then}
  end {while};
  close(infile)
end {scanner};

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure out( dev: byte; zeile: line );

{ dev = 1: Bildschirm, 2: Drucker, 3: File.
  Falls Ausgabe ins File erfolgt, 
  mu es im Hauptprogramm geffnet werden. }

begin
  case dev of
    1: write(zeile);
    2: write(lst, zeile);
    3: write(outfile, zeile)
  end {case}
end {out};


procedure printtree( dev: byte; var current: node );

const form  = 6  ; { Format einer Zeilennummer }
      anz   = 8  ; { Anzahl der Zeilennummern je Ausgabezeile }
      cr    = #13;
      lf    = #10;
      empty = '' ;

var i: integer;
    x: line;     { zu generierende Ausgabezeile     }
    h: word;     { Hilfsstring zur Zahlenumwandlung }

begin
  if current <> nil
  then with current^ do
    begin
      printtree(dev, lt);
      x := empty; x := key;
      for i := length(key) to 24 do x := x + ' ';
      out(dev, x); x := empty;
      freq := head;
      i := 0;
      while freq <> nil do
      begin
        str(freq^.numb : form, h);
        x := x + h;
        freq := freq^.next;
        i := succ(i);
        if i = anz
        then begin
               x := x + cr + lf; out(dev, x); x := empty;
               if freq <> nil then for i := 1 to 25 do x := x + ' ';
               i := 0
             end {then}
      end {while};
      if i <> 0
      then begin
             x := x + cr + lf; out(dev, x); x := empty
           end;
      for i := 1 to 73 do x := x + '-';
      x := x + cr + lf; out(dev, x); x := empty;
      printtree(dev, rt)
    end {with}
end {printtree};

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

begin { Hauptprogramm }
  writeln('            C R O S S - R E F E R E N C E');
  writeln;
  writeln('  Tabelle nur fr frei gewhlte Bezeichner erstellen: f');
  writeln('  Tabelle fr alle Bezeichner erstellen             : a');
  writeln('  Tabelle nur fr reservierte Wrter erstellen      : r');
  writeln;
  write('                      Bitte whlen: ');
  repeat
    read(kbd, wahl);
    wahl := upcase(wahl)
  until wahl in ['F','A','R'];
  writeln(wahl); writeln;
  if wahl <> 'A' then make_avl( avl_root );
  scanner(wahl, root, avl_root);
  writeln;
  writeln('Ausgabe der Tabelle auf Bildschirm: b');
  writeln('                    auf Drucker   : d');
  writeln('                    in ein File   : f');
  write('                                                 ?_');
  repeat
    read(kbd, wahl);
    wahl := upcase(wahl)
  until wahl in ['B','D','F'];
  writeln(wahl); writeln;
  case wahl of
    'B': dev := 1;
    'D': dev := 2;
    'F': dev := 3
  end {case};
  if dev <> 1
  then
    begin
      write('Soll die Tabelle mit einer berschrift versehen werden?  j/n ');
      repeat
        read(kbd, wahl);
        wahl := upcase(wahl)
      until wahl in ['J','N'];
      writeln(wahl);
      if wahl = 'J'
      then begin
             writeln('berschrift eingeben (max. ',zln,'Zeichen):');
             readln(zeile);
             zeile := zeile + #13 + #10 + #13 + #10
           end;
      if dev = 3
      then begin
             write('Name des Files, in das die Ausgabe erfolgen soll:');
             readln(filnam);
             assign(outfile, filnam);
             rewrite(outfile);
             writeln('Ausgabe der Tabelle ins File...')
           end
      else begin
             writeln('Drucker einschalten, bel. Taste drcken');
             repeat until keypressed;
             writeln('Druck der Tabelle...')
           end;
      if wahl = 'J' then out(dev, zeile)
    end {then};
  printtree(dev, root);
  if dev = 3 then close(outfile)
end.



