Program pcwbenchmarks;
var
   bm, switch : char;
   ta,te,td:real;

Function time:real;

   Type parec = record
                ax,bx,cx,dx,bp,si,di,ds,es,flags: integer;
                end;

   var dospar: parec;

begin
    with dospar do
       begin
       ax:=$2c00;
       intr ($21,dospar);
       time:= hi(cx)*3600+lo(cx)*60+hi(dx)+lo(dx)/100;
       end;
end;

procedure intmath;

   var i,x,y :integer;

begin
   ta:=time;
   x := 0;
   y := 3;
   writeln ('Start');
   for i := 1 to 10000 do
   begin
      x := x + (y * y - y) div y
   end;
   writeln ('Finish',x);
end;

procedure realmath;

   var i :integer;
    x, y : real;

begin
   ta:=time;
   x := 0.0;
   y := 9.9;
   writeln ('Start');
   for i := 1 to 10000 do
      x := x + (y * y - y) / y;
   writeln ('Finish',x);
end;

procedure triglog;

   var i :integer;
    x, y : real;

begin
   ta:=time;
   x := 0.0;
   y := 9.9;
   writeln ('Start');
   for i := 1 to 1000 do
      x := x + sin (arctan(cos (ln (y))));
   writeln ('Finish',x);
end;

Procedure textscreen;

   var i : integer;

begin
   ta:=time;
   writeln ('Start');
   for i:= 1 to 1000 do
      writeln ('1234567890qwertyuiop',i);
   writeln ('Finish');
end;

procedure graphscreen;

   var x,y : integer;

begin
   ta:=time;
   writeln ('Start');
   hires;
   for x := 1 to 100 do
      for y := 1 to 100 do
         plot (x,y,5);
   textmode(bw80);
   writeln ('Finish');
end;

procedure store;

   var        i : integer ;
              x : string[20];
       testfile : text;

begin
   ta:=time;
   writeln ('Start');
   x := '1234567890qwertyuiop';
   assign (testfile, 'test.$$$');
   rewrite (testfile);
   for i := 1 to 1000 do
      write (testfile,x);
   close (testfile);
   erase(testfile);
   writeln ('Finish');
end;

begin
   clrscr;
   repeat
   writeln (' PCW-Benchmarks in Turbo-Pascal');
   writeln;
   writeln (' (I)nteger-Rechnung');
   writeln (' (R)eal-Rechnung');
   writeln (' (T)rigonometrisches  LN statt LOG !! ');
   writeln (' Te(X)tausgabe');
   writeln (' (G)rafikausgabe');
   writeln (' Test(F)ile schreiben');
   writeln;
   writeln (' (A)ufhren');
   writeln;
   write ('Kennbuchstaben des Benchmarks eingeben:  ');
   readln (BM);
   writeln;

   case bm of
     'I','i' : intmath;
     'R','r' : realmath;
     'T','t' : triglog;
     'X','x' : textscreen;
     'G','g' : graphscreen;
     'F','f' : store;
     'A','a' : halt;
   end;
   te:=time;
   td:=te-ta;
   writeln (td:6:2,' Sekunden');
   writeln;
   until (false);

end.
