(********************************************************)
(*         D I R E C T O R Y  -  S E A R C H            *)
(*                                                      *)
(*            (C) by  Dr. Peter Schulz 1987             *)
(********************************************************)

program DIRDIR;
const
   kein_Fehler          = 0;
   existiert_nicht      = 2;
   keine_weiteren_Daten = 18;

type
   stringtyp     = string[12];

var
   es_saved      : integer;
   bx_saved      : integer;
   error_code    : byte;
   search_string : stringtyp;


(*---------------------ERROR_CHECK----------------------*)
procedure error_check;
begin
   if (error_code <> existiert_nicht) and
      (error_code <> keine_weiteren_Daten) and
      (error_code <> kein_Fehler)
     then
   begin
      writeln('Es ist ein Fehler mit der Nummer ',
               error_code,' aufgetreten!!');
      halt;
   end;
end;

(*-------------------READ_DTA---------------------------*)
procedure read_DTA;
   (* mit DOS-CALL 02Fh die Daten-Transfer-Adresse
      ermitteln: nach dem Aufruf enthlt ES:BX die DTA *)
begin
  inline
    ( $b4/$2f/            (* mov ah,2f                  *)
      $cd/$21/            (* int,21                     *)
      $89/$1e/bx_saved/   (* mov (bx_saved),bx          *)
      $8c/$c3/            (* mov bx,es                  *)
      $89/$1e/es_saved)   (* mov (es_saved),bx          *)
end;

(*-------------------FIND_FIRST_ENTRY-------------------*)
procedure find_first_entry(var search_string : stringtyp);
    (* Mit DOS-CALL 04eh den ersten Eintrag im Verzeichnis
       suchen, der mit search_string bereinstimmt; die
       Folgeeintrge werden mit dem DOS-CALL 04fh
       ermittelt;es wird nach allen Files und Directories
       gesucht, da der Eintrag in search_string die
       "Wildcards" <*.*> enthlt und das Attribut-Byte
       auf 10H gesetzt wird.                            *)
begin
  inline
    ( $8b/$56/$04/
          (*mov dx,[bp+04] Zeiger auf den Such-String;  *)
      $81/$c2/$01/$00/
          (*add dx,0001    Laengen-Byte ueberspringen;  *)
      $b9/$10/$00/      (*mov cx,0010    Attribute-Byte = 10H => auch *)
      $b4/$4e/          (*mov ah,4e      DIR-Eintraege mit DOS-CALL   *)
      $cd/$21/          (*int 21h        04EH und INT 21H ermitteln;  *)
      $a2/error_code);  (*mov (error_code),al   Fehlercode retten.       *)
end;

(*-----------------------------DECODE_DATE-------------------------------*)
procedure decode_date(var year : integer;var month : byte;var day : byte);
begin
   year := (mem[es_saved:bx_saved+25] shr 1) + 1980;
   month := (mem[es_saved:bx_saved+25] and 1) * 8 +
            (mem[es_saved:bx_saved+24] shr 5);
   day := (mem[es_saved:bx_saved+24] and 31);
end;

(*-----------------------------DECODE_NAME-------------------------------*)
procedure decode_name(var file_name : stringtyp);
var offset : byte;           (* Ab dieser Position steht der Name *)

begin
   offset:=30;
   file_name := '';
   while mem[es_saved:bx_saved + offset] <> 0 DO
   begin
      file_name:= concat(file_name,chr(mem[es_saved:bx_saved+offset]));
      offset := offset + 1;
   end;
end;

(*-----------------------------FIND_NEXT_ENTRY---------------------------*)
procedure find_next_entry;
begin
   inline
     ( $b4/$4f/          (* mov ah,4f       Naechsten uebereinstimmen-   *)
       $cd/$21/          (* int 21h         den Eintrag mit DOS 04fh;    *)
       $a2/error_code);  (* mov (error_code),al   Fehler-Code retten ;   *)
end;

(*--------------------------LOOK_FOR_DIRECTORIES-------------------------*)
procedure look_for_directories(var search_string : stringtyp);
var
   entries, files, year   : integer;
   month, day             : byte;
   file_name              : stringtyp;

begin
   entries := 0;
   files := 0;
   clrscr;
   if ParamCount = 0 then           (* Fuer aeltere TURBO's entfernen   *)
   writeln('Das aktuelle Verzeichnis enthaelt folgende Subdirectories:')
   else writeln('Das Verzeichnis ',ParamStr(1),
                ' enthaelt folgende Subdirectories:');
   writeln;
   find_first_entry(search_string);
   error_check;
   while (error_code <> existiert_nicht) and
         (error_code <> keine_weiteren_Daten) do
   begin
      if mem[es_saved:bx_saved+21] = $010 then  (* DIR-Eintrag, wenn     *)
                                                (* Attribute-Byte = 10H. *)
      begin
         if (entries mod 3 = 0) and (entries <> 0) then writeln;
         decode_date(year,month,day);
         decode_name(file_name);
         if (file_name <> '.') and (file_name <> '..') then
         begin
            write(file_name:10,' ':2);
            write(day:2,'.',month:2,'.',year:4,' ':4);
            entries := entries + 1;
         end;
      end else files := files + 1;
      find_next_entry;
  end;
  writeln;
  writeln;
  if error_code = keine_weiteren_Daten then
    writeln('In diesem Directory sind ',entries:3,' Subdirectories und ',
           files:3,' Files enthalten.');
end;

(***************************** M A I N ***********************************)
(* Fuer aeltere TURBO-Versionen sind die Zeilen, die ParamCount und      *)
(* ParamStr enthalten zu entfernen. Laeuft ungeaendert unter TURBO 3.0   *)
(*************************************************************************)

begin
   read_DTA;
   if ParamCount = 1 then search_string := paramStr(1) + '*.*' + chr(0)
   else search_string := '*.*' + chr(0);
   look_for_directories(search_string);
end.   (* M A I N *)
