;Listing 2: Assemblerprogramm schaltet Hercules-Karte in Textmodus

	name	TextMode	; M.Bach
;Protokoll
;=========
;17.12.86 Begonnen
;18.12.86 lieber als .COM, Exe2Bin mu angewendet werden
;20.12.86 BIOS zum Lschen verwendet, IRET eingebaut
;02.01.87 Schirm nicht gelscht, Rcksprung wie Original-BIOS
;10.03.87 Attribute lschen macht Text sichtbar, z.B. bei SNOWBALL
;14.06.87 80286-OpCodes raus, nur noch 8086
;25.97.87 @CRT-MODE einfacher, 6845 mit 16Bit-Output programmiert
;	  SysReq/Break mit bedingter Assemblierung
;26.07.87 Auch Print Screen geht jetzt, EQ ist der Vergleichsoperator
;Ende Protokoll



; Hier kann man whlen, welche Tasten aktivieren.
; 2 der 3 folgenden EQU-Anweisungen mssen "auskommentiert" sein
;IntNr	equ	15H	; Interrupt "Cassette" (geht nur auf AT),
			; Aktivierung mit SysReq-Taste
IntNr	equ	1BH	; Interrupt "Keyboard Break" (PC/XT/AT),
			; Aktivierung mit Control+Break-Taste
;IntNr	equ	5	; Interrupt "Print Screen" (PC/XT/AT),
			; Aktivierung mit Shift+Print-Screen-Taste

CSEG	segment	'code'
	assume	cs:CSEG,ds:CSEG

	org	100h
; Beginn des residenten Teils
TxtMod:	jmp	INSTAL		; zum Installieren springen

; Hierher fhrt der neue Einsprung beim Interrupt IntNr
NeuVek:	nop
if IntNr eq 15H
	cmp	ax,8500h	; SysReq-Taste gedrckt?
	jne	AltJmp		; wenn nicht, dann normal weiter
endif
	push	ax		; Register sichern
	push	bx
	push	cx
	push	dx
	push	ds
; Herculeskarte auf TextModus einstellen
	mov	dx,03B8H	; Hercules mode select port
	mov	al,101000B	; Video enable, alphanumeric
	out	dx,al
; Videocontroller 6845 auf Textmodus programmieren
	mov	dx,3B4H		; Indexregisterport des 6845
	mov	bx,offset TTable; in dieser Tabelle stehen die Werte
	mov	cx,12		; 12 Register gibt's
	xor	al,al		; es beginnt mit Register 0
M0:	mov	ah,cs:[bx]	; Registerwert aus Tabelle holen
	out	dx,ax		; 2-Byte: AL=Index, AH=Registerwert!
	inc	bx		; Tabellenadressierung weiterschalten
	inc	al		; nchstes Register
	loop	M0
; alle Attribute im Bildschirm auf "normal" schalten
	mov	ax,0b000H
	mov	ds,ax		; Segment des Bildschirms
	xor	bx,bx		; Offset des Bildschirms
	mov	cx,25*80	; soviele Attribute verndern
M1:	inc	bx		; Attribut addressieren
	mov	[bx],byte ptr 7	; 7 ist der Attribut-Kode "normal"
	inc	bx		; Zeichen berspringen
	loop	M1
; jetzt noch dem BIOS den Bildschirmzustand mitteilen
	mov	ax,040h
	mov	ds,ax		; Datensegment vom ROM BIOS (p.5-20)
	mov	@CRT_MODE,7	; @CRT_MODE auf 7 setzen
; fertig
	pop	ds		; Register wiederherstellen
	pop	dx
	pop	cx
	pop	bx
	pop	ax
;	iret			; weiter in der Interrupt-Kette
AltJmp:	db	0eah		; jmp far
	dw	?,?		; hier trgt INSTAL das Sprungziel ein

; 6845-Registerwerte fr den Text-Modus
; siehe BIOS-Listing p. 5-193 "SET UP FOR 80X25 BW CARD"
; Bedeutung der Register:
; Horizontal total-1, Horiz. displayed, Horiz. sync position
; VSync & HSync widths, Vertical total-1, Vert. total adjust
; Vertical displayed, Vertical sync position, Mode control
; Scan lines-1, Cursor start, Cursor end
TTABLE	db	61h,50H,52H,0FH,19H,06H,19H,19H,02H,0DH,0BH,0CH
; Ende des residenten Teils


; Jetzt kommt der Installierungsteil, der bleibt nicht im Speicher
INSTAL:	mov	ax,cs		; Segmentadressierung sicherstellen
	mov	ds,ax
	mov	dx,offset Text1	; Offset des Textes in dx, Seg. in ds
	mov	ah,9		; Funktion 9: Print String
	int	21h		; Mitteilung ausgeben
; Alten Vektor holen & Speichern
	mov	ax,3500h or IntNr	; Get Vector IntNr
	int	21h
	mov	word ptr AltJmp+1,bx	; speichere Offset
	mov	ax,es	
	mov	word ptr AltJmp+3,ax	; speichere Segment
; berlagern mit neuem Vektor
	mov	ax,2500h or IntNr	; Set Vector IntNr
	mov	dx,offset NeuVek	; Segment in ds
	int	21h
; Beenden, aber im Speicher lassen
	mov	dx,offset INSTAL-offset TxtMod+100h
	mov	cl,4		; Programmgre in "Paragraphen"
	shr	dx,cl		; daher 4 mal Schieben
	inc	dx		; Aufrunden
	mov	ax,3100h	; terminate but stay resident
	int	21h		; das war's

Text1:	db	0dh,0ah,'TextMode Vs. 25.07.87/2 ist installiert, '
if IntNr eq 15H
	db	'reagiert auf "SysReq"',0dh,0ah,'$'
endif
if IntNr eq 1BH
	db	'reagiert auf "Control+Break"',0dh,0ah,'$'
endif
if IntNr eq 5
	db	'reagiert auf "Shift+Print-Screen"',0dh,0ah,'$'
else
	db	'unbekannter Interrupt!',0dh,0ah,'$'
endif
; Ende von Instal

	org	49H		; im Segment 0040H bei diesem Offset
@CRT_MODE db	?		; speichert ROM BIOS den Video-Modus

CSEG	ends
	end	TxtMod
; Ende von TEXTMODE.ASM
