(*   Automatisches Patchen des TURBO-Compilers   *)

(*$R- 'Range-Check' mu abgeschaltet sein! *)

program Patch_TURBO;

const Compilername = 'TURBO.COM';
      Version      = 'PCDOS';        {'PCDOS' oder 'MSDOS'}

      (*---- An diesen Adressen mu gepatched werden ----*)
      (*---- hier: IBM PC 3.01A                      ----*)
      Addr1   = $32DF;                           {"Escape"}
      Addr2   = $923A;                           {Tastatur}
      Addr3   = $0878;                  {Input-Redirection}

      (*----- Die Patches hchstpersnlich -----*)
      p1 : array[0..4] of byte = ($b8,$02,$4c,$cd,$21);
      p2 : array[0..3] of byte = ($90,$90,$90,$30);
      p3 : array[0..3] of byte = ($b4,$08,$cd,$21);

      AnzRecs = 400;

var f        : file;
    RecsRead : integer;
    buffer   : array[1..128,1..AnzRecs] of byte;
    Prog     : array[0..1] of byte absolute buffer;

procedure DoPatch(var p; addr, anzahl : integer);
var i:integer;
    pr : array[0..9] of byte absolute p;
begin
  (*----- Eintragen des Patches in den Buffer -----*)
  (*----- Achtung!!! Versatz um 100H Bytes!!! -----*)
  for i:=0 to anzahl - 1 do prog[addr - $100 + i] := pr[i];
end;

begin
  (*----- Einlesen der Datei in den Buffer -----*)
  assign(f,compilername);
  reset(f);
  BlockRead(f,buffer,AnzRecs,RecsRead);
  close(f);

  (*----- Die Patches, ihre Zieladresse -----*)
  (*----- und ihre Lnge bergeben      -----*)
  DoPatch(p1,Addr1,sizeof(p1));
  DoPatch(p2,Addr2,sizeof(p2));
  if (Version = 'PCDOS') then
     DoPatch(p3,Addr3,sizeof(p3));

  (*----- und den Buffer wieder rausschreiben -----*)
  assign(f,'tpatch.com');
  rewrite(f);
  BlockWrite(f,buffer,RecsRead);
  close(f);
end.
