(*$V-*)
program PascalCompiler;

(*----- Rckgabewerte des Programms -----*)
Const PC_OK     = 0;
      BAD_USAGE = 1;
      NOTFOUND  = 2;
      CMDERROR  = 3;
      PC_ERROR  = 4;

type AnyStr  = string[255];
     RegPack = record case integer of
                 1 : ( AX, BX, CX, DX, BP,
                       DI, SI, DS, ES, flags : integer );
                 2 : ( AL, AH, BL, BH, CL, CH, DL, DH,
                       BPL,BPH,DIL,DIH, SIL,SIH, DSL,
                       DSH, ESL,ESH, flagsL,flagsH :byte);
               end;

var f : text;
    ComFile : Boolean;  (* soll COM-File erzeugt werden? *)
    Dir,                (* hier befindet das Quellfile   *)
    QuellFile,          (* Name des Quellfiles           *)
    OutputFile,         (* Name des ereugten Files       *)
    ZielFile : Anystr;  (* dort soll das Produkt hin!    *)
    cmd      : AnyStr;

(*----- Text ausgeben und auf <RETURN> warten -----*)
procedure wait(s:AnyStr);
var ch : char;
begin
  writeln(s);
  write('Weiter mit <Return>');
  repeat
    read(kbd,ch);ch:=upcase(ch);
  until ch=#13;
end;

(*  Ersetzt in diesem Programm die Procedure "halt"
    Ausgabe der Fehlermeldung, warten und mit gesetztem
    Errorlevel zurck zum Betriebssystem                *)

procedure MyHalt(par : integer);
var s:AnyStr;

  procedure Error(err : AnyStr);
  begin
    Writeln('Error: ',err);
    wait(s);
  end;

begin
  s := '-------------------------------------'+
       '------------------------------'+#10;
  chdir(dir);
  Writeln;
  case par of
    PC_OK     : writeln(s);
    BAD_USAGE : error('bad usage');
    NOTFOUND  : error('Quellfile nicht gefunden');
    CMDERROR  : error('Fehler in COMMAND.COM');
    PC_ERROR  : error('Compilerfehler');
  end;
  halt(par);
end;

function exist(fname : AnyStr) : boolean;
var f : file;
begin
  assign(f,fname);
  (*$I- *)  reset(f);  (*$I+ *)
  exist := (ioresult = 0);
end;

(*----- Aufbereitung der Parameter -----*)
procedure GetParam;

(* Bedienungshinweise ausgeben und "quer" aussteigen *)
   procedure Usage;
   begin
     writeln('Aufruf mit: pc H Quelldatei Zielpath',
             ' erzeugt ein ".CHN"-File.');
     writeln('            pc C Quelldatei Zielpath',
             ' erzeugt ein "normales ".COM"-File.');
     writeln('            pc C Quelldatei Zielpath',
             ' Optionen erzeugt ein ".COM" mit den');
     writeln('                                    ',
             '      angegebenen Optionen.');
     writeln;
     MyHalt(BAD_USAGE);
   end;

   (*  aus einem geg. String den Dateinamen und den
       vorne stehenden Path extrahieren             *)
   procedure BauPath(s:AnyStr;var Path,Datei : AnyStr);
   var i:integer;
       hilf : AnyStr;
   begin
     hilf  := s;
     path  := '';
     datei := '';
     i     := length(hilf);

     while (i>0) and (hilf[i]<>'\') do i:=i-1;

     datei := copy(hilf,i+1,255);
     path  := copy(hilf,1,i-1);
   end;

   (* Hilfsfkt, die "Returns lesbar" macht *)
   function Ausgabe(s:anystr) : Anystr;
   var erg : AnyStr;
       i   : integer;
   begin
     ausgabe := '';
     erg := '';
     for i:=1 to length(s) do
     begin
       if s[i] = #13 then erg := erg + '<CR> '
                       else erg := erg + s[i];
       Ausgabe := erg;
     end;
   end;

var s,
    path,
    datei,
    option: anystr;
    ext   : string[4];
    i     : integer;

begin (* GetParam   Vorsicht! Viele Querausstiege *)
  (* drei Parameter sind es mindestens ! *)
  if ParamCount < 3 then usage;

  (* Nur C oder H sind erlaubt! *)
  s := ParamStr(1);
  if length(s)<>1 then usage;

  s[1] := upcase(s[1]);
  if not (s[1] in ['C','H']) then usage;
  ComFile := (s[1]='C');

  (* Namen des Quellfiles holen und
     gucken, ob es existiert        *)
  s := ParamStr(2);
  if not exist(s) then
  begin
    s:=s+'.pas';
    if not exist(s) then
    begin
      Wait('Datei '+s+' nicht gefunden!');
      MyHalt(NOTFOUND);
    end;
  end;
  QuellFile  := s;

  (* Filenamen aufspalten *)
  BauPath(QuellFile,Path,Datei);

  (* Zielfilenamen und Outputfilenamen erzeugen *)
  s := paramstr(3)+'\'+datei;
  if ComFile then ext := '.com' else ext := '.chn';
  ZielFile   := copy(s,1,length(s)-4) + ext;
  OutputFile := copy(Quellfile,1,length(Quellfile)-4)+ext;

  (* Optionen einlesen und aufbereiten *)
  option := '';
  if paramcount > 3 then
  begin
    i := 4;
    while i<=paramcount do
    begin
      option := option + ParamStr(i)+#13;
      i := i + 1;
    end;
  end;

  (* das ist erzeugt worden: *)
  writeln('Quelle: "',Quellfile,'"');
  writeln('Output: "',OutputFile,'"');
  writeln('Ziel:   "',Zielfile,'"');
  if ComFile then writeln('Option: "',Ausgabe(Option),'"');

  (* erzeugen des Files mit der Tastatureingabe *)
  assign(f,'pc.inp');
  rewrite(f);

  if ComFile then
   writeln(f,'ya',path,#13,'oc',option,'qc',datei,#13,'q')
  else
   writeln(f,'ya',path,#13,'ohqc',datei,#13,'q');
  close(f);

end;

(* Aufruf von command.com *)
procedure CallCommand(cmd : AnyStr);
var block : array[0..6] of integer;
    reg   : RegPack;
    prog  : AnyStr;
    fcb_1,
    fcb_2 : array[0..11] of byte;
    i     : integer;

    (* grozgige Fehlermeldungen *)
    procedure Fehler(i : byte);
    var ch : char;
    begin
      write('Fehler ',i,': ');
      case i of
           $01 : writeln('unbekannter Funktionscode');
           $02 : writeln('Programm nicht gefunden');
           $08 : writeln('zu wenig freier Speicherplatz');
           $0A : writeln('inkonsistente Programmumgebung');
           $0B : writeln('inkonsistente ".EXE"-Datei');
           else  writeln('unbekannter Fehler!');
      end;
    end;

 begin
  prog := '\command.com' + #0;
  cmd  :=  '/C' + cmd + #13;
  cmd:=chr(length(cmd)-1)+cmd;

  for i:=0 to 11 do
  begin
    fcb_1[i] := mem[ cseg:$5c + i ];
    fcb_2[i] := mem[ cseg:$6c + i ];
  end;

  block[0] := 0;
  block[1] := ofs(cmd)+1;
  block[2] := seg(cmd);

  with reg do
  begin
    AX := $4B00;
    ES := seg(block);
    BX := ofs(block[0]);
    DS := seg(prog);
    DX := ofs(prog[1])+1;

    MSDOS(reg);
    if odd(flags) then
    begin
      fehler(AL);
      MyHalt(CMDERROR);
    end;
  end;
end;

procedure PascalCompiler;

begin (* PascalCompiler *)
  writeln('compiling ',QuellFile,'.');
  cmd := 'TPATCH <PC.INP';
  CallCommand(cmd);
end;

(* Lschen einer Datei *)
procedure DoDelete(s:Anystr);
var f:file;
begin
  Writeln('deleting ',s,'.');
  assign(f,s);
  Erase(f);
end;

(* BAK-File Lschen *)
procedure DelBak;
var s : AnyStr;
begin
  s := copy(quellfile,1,length(Quellfile)-4)+'.bak';
  if exist(s) then DoDelete(s);
end;

begin
  ClrScr;
  Writeln('------------------------- Pascal-Compiler',
          ' -------------------------');
  Writeln;

  GetDir(0,dir);
  chdir('\');
  GetParam;
  DelBak;
  PascalCompiler;

  (* Compiler hat nichts erzeugt! *)
  if not exist(OutputFile) then Myhalt(PC_ERROR);

  if OutPutFile<>Zielfile then
     begin
     cmd := 'copy '+OutPutFile+' '+Zielfile;
     Writeln(cmd);
     CallCommand(cmd);
     end;

  MyHalt(PC_OK);
end.
