             PAGE 62,132 ;
             TITLE 704 KB / 736 KB RAM UNTER DOS
;
; EQUATES, MAKROS UND SEGMENT-DEFINITIONEN
;

             .LFCOND              ;LIST FALSE CONDITIONALS
             .SALL                ;SUPPRESS MACRO-EXPANSION

TRUE         EQU 1
FALSE        EQU 0

VIDEO_RAM    EQU false         ;FUER BEDINGTE ASSEMBLIERUNG
                               ; VIDEO_RAM = TRUE => 736KB
                               ; VIDEO_RAM = FALSE => 704KB

OLD_MEM_SIZE EQU 640

IF VIDEO_RAM
 NEW_MEM_SIZE EQU 736
 IF1
  %OUT **** PROGRAMM FUER 736KB UNTER DOS ****
 ENDIF
ELSE
 NEW_MEM_SIZE EQU 704
 IF1
  %OUT **** PROGRAMM FUER 704KB UNTER DOS ****
 ENDIF
ENDIF

DISPLAY      MACRO   STRING             ;DISPLAY STRING
             MOV     DX,OFFSET &STRING
             MOV     AH,09
             INT     21H
             ENDM

BIOSDATA     SEGMENT AT 40H      ;BIOS-DATEN BLOCK
             ORG     13H
MEMSIZE      LABEL WORD      ;0413H: SPEICHERGROESSE IN KB
BIOSDATA     ENDS

EXTSEG       SEGMENT AT 0A000H   ;EXTRA RAM SEGMENT
EXTSEG       ENDS

IF VIDEO_RAM
 EXTSEG2      SEGMENT AT 0B000H  ;EXTRA RAM SEGMENT
 EXTSEG2      ENDS
ENDIF

;
; BEGINN DES PROGRAMMES
;

CSEG         SEGMENT 'CODE'
             ASSUME CS:CSEG,DS:CSEG,ES:CSEG

             ORG     100H
START:
             MOV     AX,0040H
             MOV     ES,AX
             ASSUME  ES:BIOSDATA

             CMP     ES:MEMSIZE,NEW_MEM_SIZE ;BEI 2.BOOT
             JE      ENDE

             CMP     ES:MEMSIZE,OLD_MEM_SIZE ;640KB ?
             JNE     ERROR

             MOV     AX,0A000H
             MOV     ES,AX
             ASSUME  ES:EXTSEG

             MOV     AX,5A5AH
             MOV     DI,0000H
             MOV     CX,8000H ;GANZES SEGMENT (STORE WORD)
             CLD
REP          STOSW     ;INIT SEGMENT (SONST PARITY-ERROR!)

IF VIDEO_RAM
             MOV     AX,0B000H
             MOV     ES,AX
             ASSUME  ES:EXTSEG2

             MOV     AX,5A5AH
             MOV     DI,0000H
             MOV     CX,4000H ;HALBES SEGMENT (STORE WORD)
             CLD
REP          STOSW     ;INIT SEGMENT (SONST PARITY-ERROR!)
ENDIF

             MOV     AX,0040H
             MOV     ES,AX
             ASSUME  ES:BIOSDATA
                                        ;NEUE RAM-GROESSE
             MOV     ES:MEMSIZE,NEW_MEM_SIZE

             DISPLAY FILL_MSG
             INT     19H                ;REBOOT SYSTEM

ERROR:       DISPLAY ERR_MSG            ;FEHLER AUFGETRETEN

ENDE:        DISPLAY END_MSG            ;PROGRAMM BEENDET

             MOV     AH,0               ;TERMINATE
             INT     21H

FILL_MSG     DB      13,10,'SPEICHER ERWEITERT'
             DB      13,10,'PC-WARMSTART '
             DB      'WIRD DURCHGEFUEHRT',13,10,'$'

ERR_MSG      DB      13,10,'SPEICHERGROESSE FEHLERHAFT !'
             DB      13,10,'PROGRAM CANCELLED',13,10,'$'

END_MSG      DB      13,10,'704 TERMINATED',13,10,'$'

CSEG         ENDS
             END START
