TITLE	 KBD
PAGE	,79;	set printer pitch to condensed
.RADIX	16
.186

;THIS KEYBOARD DRIVER IS ESSENTIALLY THE SAME DRIVER LIKE THE SPECIAL
;V20-BIOS-DRIVER.NATURALLY,BECAUSE WE DO NOT HAVE DIRECT ACCESS TO THE
;TIMER-INT-ROUTINE,THE REPEAT MUST HOOK TO INT 1C.THIS IS THE MAIN
;DIFFERENCE BETWEEN THE DRIVERS,ANYTHING ELSE WORKS EXACTLY THE SAME.
;THIS DRIVER WILL REPLACE KEYBGR.COM,IT WILL DO ANYTHING THAT DRIVER
;DOES PLUS A LITTLE MORE.
;IT DOES NOT SUPPORT THE ASCII-MODE VIA ALT-CTRL-F1/ALT-CTRL-F2
;BECAUSE THERE'S NO NEED FOR THAT
;NOTE THAT SOME TABLES ARE MOVED DOWN TO THE PSP TO CONSERVE SPACE

VERS	EQU	28
;SET FOLLOWING VALUES ACCORDING TO REQEUESTED DRIVER
PC	EQU	0	;SET TO 1 IF FOR PC / XT,0 FOR AT
V20	EQU	1	;SET TO 1 IF V20 PROCESSOR OR AT
SPEEDREP EQU	1	;SET TO 1 FOR HIGH SPEED REPEAT		

VERNUM	MACRO
HIDIG	=	VERS/16D+'0'
LODIG	=	(VERS AND 15D)+'0'
	DB	HIDIG,'.',LODIG
	ENDM

LF		EQU	0AH
CR		EQU	0DH
KB_DATA_PORT	EQU	60H
KB_CTRL_PORT	EQU	61H
INT_CTRL_PORT	EQU	20H
EOI		EQU	20H	;END OF INTERRUPT FOR 8259
SYS_CTRL_PORT	EQU	61H
;
S0000	SEGMENT
	ASSUME CS:S0000
KEYB	PROC	NEAR
	ORG	0100H
START:	JMP	TRANSIENT	;INIT PROGRAM

CTRL_ASCII	EQU	53H
GER_MAIN_KEYS	EQU	53H + (OFFSET G_M_K - OFFSET C_ASC)
GER_UCASE	EQU	GER_MAIN_KEYS + (OFFSET G_U - OFFSET G_M_K)

CTR_KEY DB	52,3A,45,46,38,1DH,2A,36	;INS,CAPS,NUMLOCK,SCROLLOCK,
						;ALT,CTRL,SHIFT-L,SHIFT-R

F21_F30 DB	5E,5F,60,61,62,63,64,65,66,67
	DB	0FF,0FF,77,0FF,84,0FF,73,0FF
	DB	74,0FF,75,0FF,76,0FF,0FF
F11_F20	DB	54,55,56,57,58,59,5A,5BH,5C,5DH
F31_F40 DB	68,69,6A,6BH,6C,6DH,6E,6F,70,71

ALT_NUMBERS	DB	52,4F,50,51,4BH,4C,4DH,47,48,49
	DB	10,11,12,13,14,15,16,17,18,19
	DB	1E,1F,20,21,22,23,24
	DB	25,26,2C,2DH,2E,2F,30,31,32

GER_NUMPAD	DB	'789-456+1230',2C
ARROWS	DB	47,48,49,0FF
	DB	4BH,0FF,4DH,0FF
	DB	4F,50,51,52,53

UMLAUTS	DB	''

	
ALT_SHIFT_KEYS	DB	'Ŀųٗ'

ALT_CTRL_KEYS	DB	'ͻκͼ'

ALTERNATE_KEYS	DB	' @[]\|{}~'
	
ALT_CTRL_COMP	LABEL BYTE
	DB	2E
ALTX	LABEL BYTE
	DB	47,48,49,4BH,4CH,4DH,4FH,50,51,16,1E,12,18,17

ALT_CTRL_NUM	EQU	($ - ALT_CTRL_COMP)

		DB	39,3,1A,1BH,29H+2*PC,35,27,28,0C,5,4,33H,34H
ALT_CTRL_END	EQU $

KEYHOLD	EQU	102H
REPLOC	EQU	101H

KB_INT: STI
	IF	V20
	PUSHA
	PUSH	DS
	PUSH	ES
	PUSH	40H
	POP	DS
	ELSE
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	PUSH	ES
	MOV	AX,40H
	MOV	DS,AX
	ENDIF
	IN	AL,KB_DATA_PORT
	XCHG	AX,DI
	IN	AL,SYS_CTRL_PORT
	MOV	AH,AL
	OR	AL,80			;ENBLE KEYBOARD
	OUT	SYS_CTRL_PORT,AL
	XCHG	AH,AL			;SEND SCAN CODE BACK
	OUT	SYS_CTRL_PORT,AL
	XCHG	AX,DI			;GET SCAN CODE
	MOV	AH,AL			;SAVE FOR LATER
	IF	SPEEDREP
	XCHG	AL,BYTE PTR CS:KEYHOLD	;PUT SCAN CODE INTO REPEAT-BUFFER
	OR	AH,AH			;IF KEY RELEASED,THIS TELLS THE
	JS	SET_KEYREP		;TIMER-ROUTINE NOT TO ACT ON IT,
	CMP	AL,AH			;BECAUSE THE BIT 7 IS SET
	JZ	PROCESS			;SAME CODE,LET TIMER DECREMENT AS
SET_KEYREP:				;LONG AS KEY IS PRESSED
	OR	BYTE PTR CS:REPLOC,1FH	;NOT THE SAME CODE,SO RESET TIME-COUNT

PROCESS:
	ENDIF
	CMP	AH,0FF		;TEST FOR KEYBOARD-BUFFER FULL
	JNZ	NOT_FULL	

BEEP:
	IF	SPEEDREP
	OR	WORD PTR CS:REPLOC,801FH	;RESET COUNT,SET KEY RELEASED
	ENDIF
	CLI
	MOV	AL,EOI				;AND NOW WAKE THAT SLEEPY USER
	OUT	INT_CTRL_PORT,AL
	STI
	MOV	CX,80H
	IN	AL,SYS_CTRL_PORT
	PUSH	AX
NO_SOUND:
	PUSH	CX
	AND	AL,0FCH
	OUT	SYS_CTRL_PORT,AL
	MOV	CL,48H
	LOOP	$
	OR	AL,2
	OUT	SYS_CTRL_PORT,AL
	MOV	CL,48H
	LOOP	$
	POP	CX
	LOOP	NO_SOUND
	POP	AX
	OUT	SYS_CTRL_PORT,AL
	JMP	INT_END			;RESTORE REGS,EXIT

NOT_FULL:
	CLD
	MOV	AL,AH
	AND	AL,7FH		;MASK RELEASE-BIT
	PUSH	CS
	POP	ES
	MOV	DI,OFFSET CTR_KEY
	MOV	CX,0AH		;TEST IF A SPECIAL KEY IS PRESSED
	REPNZ	SCASB		;THESE KEYS ARE INS,CAPS,NUMLOCK,SCROLLOCK,
				;ALT,CTRL,SHIFT-L,SHIFT-R
	MOV	AL,AH		;GET OLD SCAN-CODE BACK IN CASE IT'S RELEASE
	MOV	DX,DS:17H	;GET KEY FLAG 1 AND 2
	JCXZ	NO_SPECIAL_KEY	;IF NZ,NO SPECIAL KEYS PRESSED

SPECIAL_KEY:
	MOV	AH,80H		;SET BEGIN VALUE,WILL BE 80,40,20,10,8,4,2,1
	RCL	AH,CL		;ROTATE TO GET BIT MASK TO SET
	OR	AL,AL		;TEST IF KEY RELEASED
	JS	KEY_RELEASE	;IF SIGN,KEY IS RELEASED
	CMP	AH,10H		;SCROLL-LOCK,ALT,CTRL,SHIFT ?
	JNB	CTR_ALT_NUM_SHIFT	;IF STATUS TO BE SET
	OR	DS:17H,AH	;set SCROLL-LOCK,ALT,CTRL,SHIFT pressed
	JMP	SHORT LEAVE	;DONE

CTR_ALT_NUM_SHIFT:
	TEST	DL,4		;CTRL
	JNZ	NO_SPECIAL_KEY
	CMP	AL,52H		;INS
	JNZ	SHIFT2
	TEST	DL,8		;ALT
	JNZ	NO_SPECIAL_KEY
	TEST	DL,20H		;NUM-LOCK-STAT
	JNZ	NUM_LOCK
	TEST	DL,3		;SHIFT
	JZ	SHIFT2		;IF NO SHIFT PRESSED
SHIFT1:	MOV	AX,5230H	;SET NUMBLOCK-0
	JMP	GOT_SCAN

NUM_LOCK:
	TEST	DL,3		;SHIFT ?
	JZ	SHIFT1		;IF NO SHIFT PRESSED
SHIFT2:	TEST	AH,DH		;KEY-FLAG 1
	JNZ	LEAVE		;SEE IF STATUS ALREADY SET
	OR	DS:18H,AH	;ELSE PUT INTO KEY-FLAGS 1/2
	XOR	DS:17H,AH
	CMP	AL,52H		;INS
	JNZ	LEAVE
	JMP	EXTEND_CODE	;INS IS EXTENDED CODE

NO_SPECIAL_KEY:
	OR	AL,AL
	JS	LEAVE		;IF SIGN,KEY IS RELEASED
	TEST	DH,8		;CTRL-NUMLOCK-STATUS
	JZ	TEST_ALT
	CMP	AL,45H		;NUM-LOCK
	JZ	LEAVE
	MOV	AH,0F7H		;NUM-LOCK OFF
AND_18:	AND	DS:18H,AH	;MASK IT OFF
LEAVE:	CLI			;DONE,RESET INT-CONTROLLER
	MOV	AL,EOI
	OUT	INT_CTRL_PORT,AL
INT_END:
	POP	ES		;GET REGISTERS BACK
	POP	DS
	IF	V20
	POPA
	ELSE
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	ENDIF
	IRET			;KEYBOARD DONE

KEY_RELEASE:
	CMP	AH,10H
	NOT	AH		;INVERT BITS
	JNB	AND_18		;IF INS,CAPS,NUMLOCK,SCROLLOCK
	AND	DS:17H,AH	;LEAVE ONLY BITS 7 TO 4 ON IF SET
	CMP	AL,0B8H		;ALT KEY RELEASED ?
	JNZ	LEAVE		;ONLY ALT IS INTERESTING HERE
	XOR	AX,AX		;ALT XXX IS ENDED
	XCHG	AL,DS:19H	;GET VALUE ALREADY COMPUTED FOR ALT XXX
	CMP	AL,AH		;SEE IF VALUE WAS 0
	JZ	LEAVE
	JMP	TEST_CASE	;ELSE TAKE AS NORMAL KEY-INPUT

SPEED:
	IF	PC
	IN	AL,61H		;SWITCH SPEED BIT ON PC EQUIPPED
	XOR	AL,0CH		;WITH HARDWARE TO DO IT BY SOFTWARE
	OUT	61H,AL		;TOGGLE SPEED BIT
	MOV	AH,0FH
	INT	10H
	CMP	AL,7		;GET VIDEO MODE
	MOV	CX,0607H	;COLOR VALUES
	JNZ	IS_COLOR	;IF NOT MONO
	ADD	CX,0505H	;ON MONO,WE NEED BIGGER VALUES
IS_COLOR:	
	IN	AL,61H
	AND	AL,8		;SEE IF SLOW OR FAST
	JZ	SLOW		;MAKE NORMAL CURSOR
	XOR	CH,CH		;MAKE BLOCK CURSOR
SLOW:	MOV	AH,1		;SET CURSOR FORM
	INT	10H	
	JMP	SHORT LEAVE	;DONE WITH IT,NO FURTHER ACTION
	ENDIF

RESET_SYS:
	MOV	WORD PTR DS:72H,1234H	;RAM TESTED
	DB	0EAH			;INIT SYSTEM
	DW	0,0FFFFH		

DIFFERENCE	EQU	OFFSET ALTX-OFFSET ALT_CTRL_KEYS

NUMB_ALT EQU	OFFSET ALT_CTRL_END -(OFFSET ALT_CTRL_COMP + ALT_CTRL_NUM)

TEST_ALT:
	TEST	DL,8			;ALT PRESSED ?
	JZ	KEYB_ABORT		;IF NOT

ALT_PRESSED:
	MOV	DI,OFFSET ALT_CTRL_COMP + ALT_CTRL_NUM
	TEST	DL,4			;CTRL
	MOV	CX,NUMB_ALT
	JNZ	CTR_ALT_DEL		;ALT - CTRL PRESSED IF NZ
	TEST	BYTE PTR CS:REPLOC,40H	;SEE IF ONLY ALT-CTRL ALLOWED
	JZ	CTRL_ALT		;IF ZERO,BOTH POSSIBLE
	JMP	SHORT	ALT_ENTRY	;ELSE ALT-CTRL NEEDED,NOT PRESSED HERE
	
CTR_ALT_DEL:
	CMP	AL,53H			;DEL
	JZ	RESET_SYS		;IF Z,ALT-CTRL-DEL IS PRESSED

TEST_SPEED:
	IF	PC			;NORMALLY,ONLY PC'S WITH THIS
	CMP	AL,4AH			;GREY MINUS ?
	JZ	SPEED
	ENDIF
	CMP	AL,3CH			;F2 ?
	JZ	REP_OFF
	CMP	AL,3BH			;F1 ?
	JNZ	ALT_CTRL_KEY
	MOV	AL,0FBH			;PREPARE BITS
REP_OFF:	
	XOR	AL,0BCH			;BIT MASK TO TOGGLE
	XOR	BYTE PTR CS:REPLOC,AL	;TOGGLE HERE ALT-CTRL-BIT OR REPEAT
	JMP	LEAVE			;DONE,NO FURTHER ACTION
	
ALT_CTRL_KEY:
	SUB	DI,ALT_CTRL_NUM		;ALL SPECIALS ACCESSIBLE
	ADD	CX,ALT_CTRL_NUM		;SO WE NEED MORE IN CX
CTRL_ALT:
	REPNZ	SCASB			;DI POINTS TO SPECIAL CHARACTERS
	JNZ	ALT_ENTRY		;IF NONE FOUND
	SUB	DI,DIFFERENCE		;WE GOT ONE
	CMP	DI,OFFSET ALTERNATE_KEYS
	JNB	GOT_EM
	TEST	DL,3			;SHIFT
	JZ	GOT_EM			;IF NO SHIFT
	SUB	DI,OFFSET ALT_CTRL_KEYS - OFFSET ALT_SHIFT_KEYS
GOT_EM:	MOV	AL,CS:[DI]		;GOT SPECIAL CHARACTER,TRANSLATE
	JMP	SHORT	YGOT		;NORMAL CHARACTER ACTION FROM HERE

KEYB_ABORT:
	TEST	DL,4			;CTRL PRESSED ?
	JZ	NUM_BLOCK		;IF ZERO,NOT
	CMP	AL,46H			;SCROLL-LOCK AND CTRL
	JNZ	CTRL_NUMLOCK		;NOT SCROLL-LOCK
	MOV	BX,DS:80H		;IT'S KEYBOARD-ABORT
	MOV	DS:1AH,BX		;RESET THE POINTERS
	MOV	DS:1CH,BX
	MOV	BYTE PTR DS:71H,80H	;SET BIOS-ABORT FLAG
	INT	1BH			;DO THIS INT
	SUB	AX,AX			;SET ALL ZERO
YGOT:	JMP	GOT_SCAN		;AND DO THE REST

ALT_ENTRY:
	MOV	DI,OFFSET ALT_NUMBERS	;ALT IS PRESSED HERE
	MOV	CL,0AH
	REPNZ	SCASB			;TEST IF NUM-BLOCK-KEYS
	JNZ	ALT_MAIN_KEYS		;IF NOT
	SUB	DI,OFFSET ALT_NUMBERS+1	;NUM-BLOCK-KEY FOUND
	MOV	AL,DS:19H		;GET VALUE PERHAPS PRESENT FROM LAST
	MOV	AH,0AH			;MUST MULTPLY
	MUL	AH		
	ADD	AX,DI			;DI HAS DECIMAL OFFSET
	MOV	DS:19H,AL		;NOW NEW VALUE
XLEAVE:	JMP	LEAVE			;DONE FOR NOW,ALT RELEASED WILL DO
					;THE REST
ALT_MAIN_KEYS:
	MOV	BYTE PTR DS:19H,CH	;RESET OLD ALT-VALUE
	MOV	CL,1AH			;#  OF POSSIBLE KEYS
	REPNZ	SCASB			;TEST FOR ALT Q-P,A-L,Y,M
	JZ	XTEND			;IF KEY FOUND
	CMP	AL,2			;NONE OF MAIN KEYBOARD
	JB	FUNC_KEYS		;TEST FOR ESC
	CMP	AL,0EH			;TEST FOR NUMBERS-ROW
	JNB	FUNC_KEYS		;IF NOT
	ADD	AH,76H			;MAKE 78 - 83H
	JMP	SHORT XTEND		;EXTENDED CODE

CTRL_NUMLOCK:
	CMP	AL,45H			;CTRL IS PRESSED HERE
	JNZ	TEST_CTRL_PRTSC		;TEST FOR NUM-LOCK
	OR	BYTE PTR DS:18H,8	;IT'S CTRL-NUMLOCK
	MOV	AL,EOI			;RESET INT-CONTROLLER	
	OUT	INT_CTRL_PORT,AL
	CMP	BYTE PTR DS:49H,7	;NOW WAIT
	JZ	STOP_DISPLAY
	MOV	DX,3D8H
	MOV	AL,DS:65H
	OUT	DX,AL
STOP_DISPLAY:
	TEST	BYTE PTR DS:18H,8	;SEE IF STATUS RESET
	JNZ	STOP_DISPLAY		;IF NOT,WAIT
	JMP	INT_END			;OK,BACK TO WORK

PRINTSC:
	MOV	AL,EOI			;IT'S PRINTING TIME
	OUT	INT_CTRL_PORT,AL	;RESET INT-CONTROLLER
	INT	5			;INT 5 WILL DO THE REST
	JMP	INT_END			;NOW DONE

NUM_BLOCK:
	CMP	AL,47H			;HOME
	JNB	TEST_SCRL_LOCK
	TEST	DL,3			;SHIFT
	JZ	NOT_SHIFTED
	CMP	AL,0FH			;TAB
	JZ	EXTEND_CODE		;CTRL TAB

PRTSC:	CMP	AL,37H			;TEST IF SHIFT-PRINTSCREEN
	JZ	PRINTSC			;IF SO
MAIN_SHIFTED:
	CMP	AL,3BH			;TEST IF F-KEY
	MOV	BX,OFFSET F11_F20
	JNB	CTRl_FUNC		;IF SO,JUMP
	MOV	BX,OFFSET GER_UCASE	;ELSE TAKE NORMAL KEYBOARD
	JMP	SHORT	TRANSLATE	;AND GET CHARACTER

TEST_CTRL_PRTSC:
	CMP	AL,37H			;CTRL IS PRESSED,PRINT SCREEN ALSO ?
	JNZ	CTRL_CODE		;IF NOT
	MOV	AH,72H			;printer on
	JMP	SHORT	XTEND		;THATS AN EXTENDED CODE

FUNC_KEYS:
	CMP	AL,3BH			;F-KEY ?
	JB	XLEAVE			;IF NOT
	CMP	AL,47H			;HOME KEY
	JNB	XLEAVE			;IF HOME AND BIGGER
	MOV	BX,OFFSET F31_F40	;NO,WE GOT F1-10 OR NUMLOCK/SCROLLOCK
	JMP	SHORT CTRl_FUNC		;NOW DO THE REST

CTRL_CODE:
	MOV	BX,OFFSET CTRL_ASCII	;CTRL IS PRESSED
	CMP	AL,3BH			;IF LESS THAN F1
	JB	TRANSLATE
	MOV	BX,OFFSET F21_F30	;F1 - DEL
CTRl_FUNC:
	SUB	AL,3BH			;SUBTRACT SCAN-CODE AND GET VALUE
XLATE:	XLAT	CS:[BX]
EXTEND_CODE:
	MOV	AH,AL			;IT'S AN EXTENDED CODE
XTEND:	MOV	AL,0			;SO,NO ASCII
	JMP	SHORT	GOT_SCAN	;DO THE REST

TEST_SCRL_LOCK:
	TEST	DL,20H			;SCROLL-LOCK
	JNZ	SCRL_LOCK	
	TEST	DL,3			;SHIFT
	JNZ	NOT_SCRL_LOCK_SHIFTED
SHIFTED:
	CMP	AL,4AH			;PAD-MINUS
	JZ	PAD_MINUS
	CMP	AL,4EH			;PAD-PLUS
	JZ	PAD_PLUS
	SUB	AL,47H			;SUBTRACT HOME-VALUE
	MOV	BX,OFFSET ARROWS	;GET ARROWS-VALS
	JMP	SHORT	XLATE		;GET VALUE

PAD_MINUS:
	MOV	AX,4A2DH		
	JMP	SHORT	GOT_SCAN

PAD_PLUS:
	MOV	AX,4E2BH
	JMP	SHORT	GOT_SCAN

NOT_SHIFTED:
	CMP	AL,3BH
	JNB	XTEND			;IS F1 - F10 ?
	MOV	BX,OFFSET GER_MAIN_KEYS
TRANSLATE:
	DEC	AL			;GET THE VALUE FROM TABLE POINTED TO
	XLAT	CS:[BX]			;BY BX
GOT_SCAN:
	CMP	AL,0FFH			;TEST IF VALUE ASSIGNED TO KEY
	JZ	YLEAVE
	CMP	AH,0FFH
	JZ	YLEAVE
TEST_CASE:
	TEST	DL,40H			;CAPS
	JZ	NOCAPS			;IF NOT
	MOV	DI,OFFSET UMLAUTS	;THE GERMAN UMLAUTS NEED SPECIAL
	MOV	CL,6			;TREATMENT IF USED WITH CAPS
	REPNZ	SCASB			;TRY TO FIND 
	JNZ	TST_SHIFT		;IF NOT FOUND
	MOV	AL,CS:[DI+2]		;WE HAVE AN UMLAUT,SO GET UPPER
	JMP	SHORT	NOCAPS		;OR LOWER CASE OF IT
	
TST_SHIFT:
	TEST	DL,3			;SHIFT
	JZ	TEST_LOWER		;NO SHIFT PRESSED
	CMP	AL,41H			;"A"
	JB	NOCAPS
	CMP	AL,5AH			;"Z"
	JMP	SHORT UPPER_LOWER

SCRL_LOCK:
	TEST	DL,3
	JNZ	SHIFTED			;SHIFT PRESSED
NOT_SCRL_LOCK_SHIFTED:
	SUB	AL,46H
	MOV	BX,OFFSET GER_NUMPAD
	JMP	SHORT	TRANSLATE

TEST_LOWER:
	CMP	AL,61H			;"a"
	JB	NOCAPS
	CMP	AL,7AH			;"z"
UPPER_LOWER:
	JA	NOCAPS
	XOR	AL,20H			;ASCII CAN BE TRANSLATED SO
NOCAPS:	CALL	BUF_UPD			;SEE IF BUFFER FULL
	JZ	IS_FULL			;SEEMS SO
	MOV	[SI],AX			;PUT INTO BUFFER
	MOV	DS:1CH,BX		;AND ADJUST POINTER
YLEAVE:	JMP	LEAVE			;DONE

IS_FULL:
	JMP	BEEP			;BUFFER IS FULL,TELL USER
	
BUF_UPD:
	MOV	BX,DS:1CH		;TAIL-PTR
	MOV	SI,BX
	CLI
	INC	BX
	INC	BX
	CMP	BX,DS:82H		;BUFFER-END
	JNZ	COMP_HEAD
	MOV	BX,DS:80H		;BUFFER-START
COMP_HEAD:
	CMP	BX,DS:1AH		;HEAD-PTR
	STI
	RET

	IF	SPEEDREP
INT1C:
	IF	V20
	PUSHA				;THE TIMER INT IS CALLED 18.2 TIMES
	ELSE				;PER SECOND.IT WILL NOW LOOK IF
	PUSH	AX			;THERE'S A KEY HELD DOWN LONGER
	PUSH	BX			;THAN 1FH TIMER-TICKS.
	PUSH	CX			;IF SO,THE KEYBOARD-ROUTINE
	PUSH	DX			;WILL BE CALLED WITH THE LAST
	PUSH	DI			;SCAN-CODE PRESSED AND NOT YET
	PUSH	SI			;RELEASED.
	ENDIF
	PUSH	DS
	PUSH	ES

	MOV	AX,WORD PTR CS:REPLOC	;GET COUNT AND LAST KEY
	MOV	BX,AX			;NEED AX LATER IF REPEAT
	AND	BL,9FH			;MASK OUT ALT-CTRL-BIT
	OR	BH,BL			;TEST IF REP OFF OR KEY RELEASED
	JLE	LEAVE1C			;IF SIGN FLAG OR ZERO FLAG SET
	OR	BL,BL			;TEST IF COUNT ALREADY 0
	JZ	REP_KEY			;IF SO,REPEAT THE KEY
DEC_CNTR:
	DEC	BYTE PTR CS:REPLOC	;DEC COUNT
LEAVE1C:
	POP	ES	;WE COME ONLY HERE IF NO REPEAT,ELSE REST
	POP	DS	;IS HANDLED BY KEYBOARD-DRIVER
	IF	V20
	POPA
	ELSE
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	ENDIF
	DB	0EAH	;JUMP FAR
XINT1C	LABEL	DWORD	;TO INT1C-VECTOR
OFFS	DW	0
SEGM	DW	0

REP_KEY:
	MOV	BX,40H			;THE KEYBOARD ROUTINE ASSUMES
	MOV	DS,BX			;THAT DS POINTS TO BIOS-DATA
	CALL	BUF_UPD			;TEST BUFFER
	JZ	LEAVE1C			;BUFFER IS FULL IF ZERO
	PUSHF				;PREPARE FOR IRET
	CALL	DWORD PTR CS:XINT1C	;CALL THE INT 1C-VECTOR FIRST
	STI
	JMP	PROCESS			;THEN PROCESS REPEAT
	ENDIF

;THESE TABLES ARE RELOCATED TO THE PSP DURING INIT TO CONSERVE SPACE
;THE PROGRAM SPACE FROM HERE IS DISCARDED AFTER INIT
	
C_ASC	DB	1BH,0FF,0,0FF,0FF,0FF,1E,0FF
	DB	0FF,0FF,0FF,1F,0FF,7F,0FF
	DB	11,17,5,12,14,1A,15,9,0F,10,1BH,1DH,0A
	DB	0FF,1,13,4,6,7,8,0A
	DB	0BH,0C,0FF,0FF,0FF,0FF
	DB	1C,19,18,3,16,2,0E,0DH,0FF
	DB	0FF,0FF,0FF,0FF,0FF,' ',0FF

G_M_K	DB	1BH,'1234567890'
	DB	27,8,9,'qwertzuiop'
	DB	'+',CR,0FF
	DB	'asdfghjkl'
	IF	PC
	DB	'#',0FF,'<'
	ELSE
	DB	'<',0FF,'#'
	ENDIF
	DB	'yxcvbnm',2C,'.-',0FF
	DB	'*',0FF,' ',0FF

G_U	DB	1BH,'!',22,15,'$'
	DB	'%&/()=?',60H,8,8,'QWERTZUIOP*',CR,0FF
	DB	'ASDFGHJKL'
	IF	PC
	DB	'^',0FF,'>'
	ELSE
	DB	'>',0FF,'^'
 	ENDIF
	DB	'YXCVBNM;:_',0FF,0,0FF,' ',0FF
;
.RADIX	10
TRANSIENT:
	PUSH	CS
	POP	DS
	PUSH	CS
	POP	ES

	MOV	DX,OFFSET SIGN_ON
	MOV	AH,9
	INT	21H

	IF	V20	
	MOV	AX,SP	;GET OLD SP
	PUSHA		;WILL NOT EXECUTE ON 8088/8086
	CMP	AX,SP	;MUST BE DIFFERENT IF PUSHA EXECUTED
	MOV	DX,OFFSET VCHERR
	JZ	MSGEX	;IF NOT DIFFERENT
	POPA		;RECTIFY STACK
	ENDIF
	
	MOV	AH,34H	;GET VERSION,WILL ONLY RUN FROM 2.X ON
	INT	21H
	CMP	AL,2
	JNB	VERSION_OK	;IF OBSOLETE VERSION 1.X
	MOV	DX,OFFSET WRONG
MSGEX:	MOV	AH,9
	INT	21H
	INT	20H	;MUST USE OLD INT 20 FOR VERSION 1.X
	
VERSION_OK:
	PUSH	CS
	POP	ES
	CLD
	MOV	SI,OFFSET C_ASC
	MOV	DI,53H
	MOV	CX,OFFSET TRANSIENT - OFFSET C_ASC
	REP	MOVSB		;MOVE TABLES TO PSP
	MOV	DX,OFFSET KB_INT
	MOV	AX,2509H	;SET NEW INT9-VECTOR TO KBD
	INT	21H
	IF	SPEEDREP
	CLI
	MOV	AX,351CH	;GET TIMER-VECTOR
	INT	21H
	MOV	WORD PTR CS:OFFS,BX	;SAVE
	MOV	WORD PTR CS:SEGM,ES
	MOV	DX,OFFSET INT1C		;SET NEW TIMER-VECTOR TO KBD
	MOV	AX,251CH
	INT	21H
	MOV	WORD	PTR CS:REPLOC,0FF1FH	;INIT THE REPEAT-BUFFER
	STI
	ENDIF
	MOV	AX,OFFSET C_ASC			;FROM HERE FREE
	ADD	AX,15
	MOV	CL,4 
	SHR	AX,CL
	MOV	DX,AX
	MOV	AX,3100H			;TERMINATE,STAY RESIDENT
	INT	21H
	
SIGN_ON DB	'GERMAN Keyboard Remapping Utility V. '
	VERNUM
	IF	PC
	DB	'-PC'
	IF	V20
	DB	' V-Chip'
	ENDIF
	ELSE
	DB	'-AT'	
	ENDIF
	DB	LF,CR
	IF	SPEEDREP
	DB	'with Keyboard-Speedup',LF,CR
	ENDIF
	DB	'(c) Copyright 05.08.1987 Peter Khlmann',LF,CR,'$'

	IF	V20
VCHERR	DB	'This utility MUST run on 8018X/V20/V30 or 80286 !',LF,CR
	DB	'KBD not installed !',LF,CR,'$'
	ENDIF

WRONG	DB	'Wrong DOS-Version.Must be 2.00 or higher !',LF,CR,'$'
KEYB	ENDP
S0000	ENDS
	END	START
;	reset printer pitch to normal
