{$R+} PROGRAM TiereRaten;

TYPE Knoten = RECORD
                 Ende  : boolean;              (* wahr fr Zweig-Ende *)
                 Frage : string[80];
                 JaZweig,  NeinZweig : integer (* Zeiger zu den Teilbumen *)
              END;

VAR  Baum    : ARRAY [ 1..750] of Knoten;
     LetzterKnoten : integer; (* Index der letzten bentzten Komponente
                                 des ARRAYs Baum *)
     Daten   : FILE OF Knoten;   KnotenNr : integer;

PROCEDURE Hallo; (* Nach Bedarf auszuschmcken *)
BEGIN
   ClrScr; writeln ('T I E R E - R A T E N :'); writeln;
END;

FUNCTION JaNeinAntwort : char;
VAR c : char;
BEGIN
   write ( ' (j/n) ');
   REPEAT read(kbd,c); c := UpCase(c) UNTIL c in ['J','N'];
   writeln(c); writeln;
   JaNeinAntwort := c
END;

FUNCTION DatenGeladen : boolean;
VAR KnotenNr : integer;
    DateiName: string[14];
BEGIN
   write('Datei-Name: '); readln(DateiName);
   assign(Daten,DateiName);
   {$I-} reset(Daten) {$I+} ;
   IF IOResult = 0 THEN BEGIN
      LetzterKnoten := FileSize(Daten);
      FOR KnotenNr := 1 TO LetzterKnoten DO read ( Daten, Baum[KnotenNr] );
      DatenGeladen := true END
   ELSE DatenGeladen := false;
   close(Daten);
END;

PROCEDURE DatenSpeichern;
VAR KnotenNr : integer;
BEGIN
   writeln;
   write ('Neu erworbenes Wissen auf Diskette abspeichern?');
   IF JaNeinAntwort = 'J' THEN BEGIN
      rewrite(Daten);
      FOR KnotenNr := 1 TO LetzterKnoten DO
         write ( Daten, Baum[KnotenNr] );
      close(Daten)
   END
END;

PROCEDURE StartDialog;
BEGIN
                (* In den 1. Knoten kommt das 1. Tier *)
   writeln('Bitte gib das erste Tier ein:');
   Baum[1].Ende := true;
   readln(Baum[1].Frage);
   LetzterKnoten := 1
END;

PROCEDURE Dialog ( KnotenNr : integer );
BEGIN
   WITH Baum[KnotenNr] DO
      IF Ende = true  (* das Ende eines Zweiges ist also erreicht *)
         THEN BEGIN
            write ( 'Dachtest du an: ', Frage, ' ?' );
            CASE JaNeinAntwort OF
             'J' : writeln('Siehst du, wie schlau ich bin?'); (* Dialog-Ende *)
             'N' : BEGIN   (* Ein Knoten wird in den Baum eingefgt *)
                    Baum[LetzterKnoten + 1]  := Baum[KnotenNr];
                    JaZweig   := LetzterKnoten + 1;
                    NeinZweig := LetzterKnoten + 2;
                    Ende      := false;
                    Baum[NeinZweig].Ende := true;
                    write  ( 'Worum handelt es sich dann? ' );
                    readln ( Baum[NeinZweig].Frage );
                    writeln;
                    write  ( 'Gib nun eine Frage ein, fr die bei: ' );
                    writeln( Baum[JaZweig].Frage, ' die Antwort JA ist, ' );
                    write  ( 'und bei: ', Baum[NeinZweig].Frage );
                    writeln( ' die Antwort NEIN ist.' );
                    writeln;
                    readln ( Frage );
                    LetzterKnoten := LetzterKnoten + 2
                   END
            END  (* von CASE *)
         END   (* von THEN *)
         ELSE BEGIN  (* der Knoten ist kein End-Knoten *)
            write( Frage );
            CASE JaNeinAntwort OF
               'J' : Dialog ( JaZweig );
               'N' : Dialog ( NeinZweig )
            END  (* von CASE *)
         END  (* von ELSE *)
END;

BEGIN
   Hallo;
   IF not DatenGeladen THEN StartDialog;
   REPEAT
      clrscr;
      writeln ( 'Denk dir ein Tier!   ( dann drcke <RETURN> )' );
      readln;
      Dialog(1);
      writeln;
      writeln;
      write   ( 'Noch ein Durchgang?');
   UNTIL JaNeinAntwort = 'N';
   DatenSpeichern;  (* falls gewnscht *)
END.