PROGRAM Lohnberechnung;

TYPE Stammtyp = RECORD
                   Stammblattnummer : integer;
                   Name             : string[40];
                   Stuecklohn       : real;
                   Akkordrichtzahl  : integer;
                END;

     Akkordtyp = RECORD
                    Akkordscheinnummer : integer;
                    Stueckzahl         : integer;
                    Bruttolohn         : real;
                 END;

CONST Personenmaximum = 10;

VAR Stammdatei  : file of Stammtyp;
    Akkorddatei : file of Akkordtyp;
    ch          : char;
    Stammsatz   : array[1..Personenmaximum] of Stammtyp;
    Akkordsatz  : array[1..Personenmaximum] of Akkordtyp;

PROCEDURE Stammdateneingabe;

VAR i : integer;


BEGIN
   clrscr;
   writeln('Mitteilung an Heinz Binder: ');
   writeln;writeln;
   writeln('UNERLAUBTER Zugriffsversuch auf die Stammdatendatei');
   writeln;writeln;writeln;
   writeln('Herr Binder, Sie sind nicht befugt, die Stammdatei zu ndern!');
   writeln;writeln('                               Mitschke(Chef)');
   writeln;writeln;
   FOR i := 1 to 80 DO
   write('*');
   writeln;writeln('Mitteilung an den Bentzer von "WERKZEUG COMPUTER": ');
   writeln;writeln;
   writeln('Um die Stammdaten vor dem Lschen zu sichern, wird die Auswahl');
   writeln('S(tammdateneingabe) erst im Kapitel 6 besprochen.');
   writeln;writeln;writeln;
   writeln('Weiter mit RETURN');
   readln
END;

PROCEDURE Bruttolohnberechnung;

VAR Leistung         : real;
    Maximum          : integer;
    Stammblattnummer : integer;
    Antwort          : char;

BEGIN
   clrscr;
   rewrite(Akkorddatei);
   writeln('L O H N B E R E C H N U N G S P R O G R A M M');
   writeln;writeln('            Bruttolohnberechnung');
   writeln;writeln;
   writeln('Drucker einschalten!');
   writeln;
   reset(Stammdatei);Maximum := 0;
   WHILE not eof(Stammdatei) DO
                             BEGIN
                               Maximum := Maximum + 1;
                               read(Stammdatei,Stammsatz[Maximum]);
                             END;
   close(Stammdatei);
   Antwort := 'J';
   WHILE upcase(Antwort) = 'J' DO
    BEGIN
      writeln;
      write('Personalnummer: ');
      readln(Stammblattnummer);
      IF (Stammblattnummer <= Maximum) and               (* Datensatzprfung *)
         (Stammblattnummer >0)
         THEN WITH Stammsatz[Stammblattnummer],
                   Akkordsatz[Stammblattnummer] DO
            BEGIN
               writeln('          Name: ',Name);
               write('    Stueckzahl: ');
               readln(Stueckzahl);
               IF Stueckzahl < Akkordrichtzahl
               THEN Bruttolohn := Akkordrichtzahl * Stuecklohn
               ELSE Bruttolohn := Stueckzahl * Stuecklohn;
               Leistung := 100 * (Stueckzahl/Akkordrichtzahl);
               writeln(lst);
               write  (lst,' Personalnummer:  ',Stammblattnummer:2);
               writeln(lst,'               Name: ',Name);
               write  (lst,'Akkordrichtzahl:',Akkordrichtzahl:4);
               writeln(lst,'         Stueckzahl:  ',Stueckzahl:4);
               write  (lst,'       Leistung: ',Leistung:6:2,' %');
               writeln(lst,'    Bruttolohn: ',Bruttolohn:8:2,' oeS');
               Akkordscheinnummer := Stammblattnummer;
               write(Akkorddatei,Akkordsatz[Akkordscheinnummer]);
               writeln;
            END
         ELSE writeln('Kein Datensatz unter dieser Nummer');
      REPEAT
         BEGIN
            writeln('Weitere Eingabe? (J/N)');             (* Eingabeprfung *)
            read(kbd,Antwort);
         END;
      UNTIL upcase(Antwort) IN ['J','N'];
   END;
   close(akkorddatei);
END;


PROCEDURE Letzte_Eingaben;
          var i:integer;
BEGIN
clrscr;
writeln('L O H N B E R E C H N U N G S P R O G R A M M');
writeln;writeln('Liste der letzten Eingaben:'); writeln;writeln;
reset(Akkorddatei);
IF eof(Akkorddatei) THEN writeln('Die Eingabedatei ist leer!')
ELSE BEGIN
       i := 0;
       REPEAT
          i := i + 1;
          read(Akkorddatei,Akkordsatz[i]);
          WITH Akkordsatz[i] DO
          BEGIN
             write('Personalnummer: ',Akkordscheinnummer:2);
             writeln('   zuletzt eingegebene Stckzahl:  ',Stueckzahl:5);
             writeln;
          END;
       UNTIL eof(Akkorddatei);
     END;
writeln;
close(Akkorddatei);
writeln('WEITER mit beliebiger Taste');
read(kbd,ch);
END;

BEGIN (*Hauptprogramm *)
   assign(Stammdatei,'stamm.dat');
   assign(Akkorddatei,'akkord.dat');
   REPEAT
     clrscr;  (* BS lschen *)
     write('L O H N B E R E C H N U N G S P R O G R A M M : HAUPTMEN');
     writeln;writeln;writeln;
     writeln('Auswahl durch Eintippen des Anfangsbuchstabens:');
     writeln;
     writeln('          S(tammdatenpflege)');
     writeln('          B(ruttolohnberechnung)');
     writeln('          L(etzte Bruttolohnberechnung/en)');
     writeln('          E(nde)');
     read(kbd,ch);
     CASE upcase(ch) OF
        'S' : Stammdateneingabe;
        'L' : Letzte_Eingaben;
        'B' : Bruttolohnberechnung;
        'E' :               ;
     END;
   UNTIL (ch='E') OR (ch='e');
   clrscr;
END.
