PROGRAM Lohnberechnung;

TYPE Stammtyp = RECORD
                   Stammblattnummer : integer;
                   Name             : string[40];
                   Stuecklohn       : real;
                   Akkordrichtzahl  : integer;
                END;

     Akkordtyp = RECORD
                    Akkordscheinnummer : integer;
                    Stueckzahl         : integer;
                    Bruttolohn         : real;
                 END;

CONST Personenmaximum = 100;

VAR Stammdatei  : file OF Stammtyp;
    Akkorddatei : file OF Akkordtyp;
    hauptwahl   : char;
    Stammsatz   : ARRAY[1..Personenmaximum] OF Stammtyp;
    Akkordsatz  : ARRAY[1..Personenmaximum] OF Akkordtyp;


 PROCEDURE Eingabe;

 VAR ch : char;

 BEGIN
    clrscr;
    writeln('L O H N B E R E C H N U N G S P R O G R A M M');
    writeln('              Stammdateneingabe');
    writeln; writeln; writeln('Noch nicht implementiert!');
    writeln; writeln('Weiter mit beliebiger Taste'); read(kbd,ch);
 END;


 PROCEDURE Stammdatenliste;

 VAR ch : char;

 BEGIN
    clrscr;
    writeln('L O H N B E R E C H N U N G S P R O G R A M M');
    writeln('              Stammdatenliste');
    writeln; writeln; writeln('Noch nicht implementiert!');
    writeln; writeln('Weiter mit beliebiger Taste'); read(kbd,ch);
 END;


 PROCEDURE Korrektur;

 VAR ch : char;

 BEGIN
    clrscr;
    writeln('L O H N B E R E C H N U N G S P R O G R A M M');
    writeln('              Stammdatenkorrektur');
    writeln; writeln; writeln('Noch nicht implementiert!');
    writeln; writeln('Weiter mit beliebiger Taste'); read(kbd,ch);
 END;


 PROCEDURE Loeschen;

 VAR ch : char;

 BEGIN
    clrscr;
    writeln('L O H N B E R E C H N U N G S P R O G R A M M');
    writeln('            Stammdaten lschen');
    writeln; writeln; writeln('Noch nicht implementiert!');
    writeln; writeln('Weiter mit beliebiger Taste'); read(kbd,ch);
 END;



 PROCEDURE Stammdatenpflege;

 VAR stammwahl : char;

 BEGIN
  REPEAT
    clrscr;
    writeln('L O H N B E R E C H N U N G S P R O G R A M M:');
    writeln;
    writeln('STAMMDATEI - Untermen:');
    writeln; writeln;
    writeln; writeln('       E...........Eingabe eines neuen Datensatzes');
    writeln; writeln('       K...........Korrektur eines Datensatzes');
    writeln; writeln('       L...........Lschen eines Datensatzes');
    writeln; writeln('       B...........Blttern in der Stammdatendatei');
    writeln; writeln('       H...........Hauptmen');
    REPEAT
       read(kbd,stammwahl)
    UNTIL upcase(stammwahl) IN ['E','K','L','B','H'];
    CASE upcase(stammwahl) OF
       'E' : Eingabe;
       'K' : Korrektur;
       'L' : Loeschen;
       'B' : Stammdatenliste;
    END;
  UNTIL upcase(stammwahl) = 'H';
END;


 PROCEDURE Bruttolohnberechnung;

 VAR Leistung         : real;
     Maximum          : integer;
     Stammblattnummer : integer;
     Antwort          : char;

 BEGIN
    clrscr;
    rewrite(Akkorddatei);
    writeln('L O H N B E R E C H N U N G S P R O G R A M M');
    writeln; writeln('            Bruttolohnberechnung');
    writeln; writeln;
    writeln('Drucker einschalten!');
    writeln;
    reset(Stammdatei); Maximum := 0;
    WHILE NOT eof(Stammdatei) DO
    BEGIN
       Maximum := Maximum + 1;
       read(Stammdatei,Stammsatz[Maximum]);
    END;
    close(Stammdatei);
    Antwort := 'J';
    WHILE upcase(Antwort) = 'J' DO
    BEGIN
       writeln;
       write('Personalnummer: ');
       readln(Stammblattnummer);
       IF (Stammblattnummer <= Maximum) and            (* Datensatzprfung *)
          (Stammblattnummer >0)
          THEN WITH Stammsatz[Stammblattnummer],
                    Akkordsatz[Stammblattnummer] DO
             BEGIN
                writeln('          Name: ',Name);
                write('    Stckzahl: ');
                readln(Stueckzahl);
                IF Stueckzahl < Akkordrichtzahl
                THEN Bruttolohn := Akkordrichtzahl * Stuecklohn
                ELSE Bruttolohn := Stueckzahl * Stuecklohn;
                Leistung := 100 * (Stueckzahl/Akkordrichtzahl);
                writeln(lst);
                write  (lst,' Personalnummer:  ',Stammblattnummer:2);
                writeln(lst,'               Name: ',Name);
                write  (lst,'Akkordrichtzahl:',Akkordrichtzahl:4);
                writeln(lst,'         Stueckzahl:  ',Stueckzahl:4);
                write  (lst,'       Leistung: ',Leistung:6:2,' %');
                writeln(lst,'    Bruttolohn: ',Bruttolohn:8:2,' oeS');
                Akkordscheinnummer := Stammblattnummer;
                write(Akkorddatei,Akkordsatz[Akkordscheinnummer]);
                writeln;
             END
          ELSE writeln('Kein Datensatz unter dieser Nummer');
       REPEAT
          BEGIN
             writeln('Weitere Eingabe? (J/N)');          (* Eingabeprfung *)
             read(kbd,Antwort);
          END;
       UNTIL upcase(Antwort) IN ['J','N'];
    END;
    close(akkorddatei);
 END; (* Bruttolohnberechnung *)


 PROCEDURE Letzte_Eingaben;

 VAR  j : integer;
     ch : char;

 BEGIN
    clrscr; writeln;
    writeln('L O H N B E R E C H N U N G S P R O G R A M M'); writeln;
    writeln;writeln('Liste der letzten Eingaben:'); writeln;writeln;
    reset(Akkorddatei);
    j := 0;
    WHILE NOT EOF(Akkorddatei) DO
    BEGIN
       j := j + 1;
       read(Akkorddatei,Akkordsatz[j]);
       WITH Akkordsatz[j] DO
          BEGIN
             write('Personalnummer: ',Akkordscheinnummer:2);
             writeln('   zuletzt eingegebene Stckzahl:  ',Stueckzahl:5);
          END;
    END;
    if j = 0 THEN BEGIN
                      writeln; writeln; writeln;
                      writeln('Die Eingabedatei ist leer!');
                   END;
    writeln;
    close(Akkorddatei);
    writeln('WEITER mit beliebiger Taste');
    read(kbd,ch);
 END; (* Letzte_Eingaben *)




BEGIN (* Lohnberechnung *)
   assign(Stammdatei,'stamm.dat');
   assign(Akkorddatei,'akkord.dat');
   REPEAT
      clrscr;  (* BS lschen *)
      write('L O H N B E R E C H N U N G S P R O G R A M M : HAUPTMEN');
      writeln; writeln; writeln;
      writeln('Auswahl durch Eintippen des Anfangsbuchstabens:');
      writeln;
      writeln('          S(tammdatenpflege)');
      writeln('          B(ruttolohnberechnung)');
      writeln('          L(etzte Bruttolohnberechnung/en)');
      writeln('          E(nde)');
      read(kbd,hauptwahl);
      CASE upcase(hauptwahl) OF
         'S' : Stammdatenpflege;
         'L' : Letzte_Eingaben;
         'B' : Bruttolohnberechnung;
      END;
   UNTIL upcase(hauptwahl)='E';
   clrscr;
END.
