{$R+,U+}
PROGRAM Nullstelle;

VAR xv,xb,yv,yb,n:real;
    c : char;

FUNCTION f ( x : real ) : real;
BEGIN
   f := 0.004*x*x*x - 0.1*x*x - 0.4*x - 0.3*sqrt(abs(x)) + 5
END;

PROCEDURE BerechneNullstelle;

   FUNCTION sgn ( x : real) : integer;
   BEGIN
      IF      x > 0 THEN sgn :=  1
      ELSE IF x = 0 THEN sgn :=  0
      ELSE (* x < 0 *)   sgn := -1
   END;

   FUNCTION Nullstelle ( a,b : real ) : real;
   BEGIN
      WHILE b-a > 1E-10 DO
         IF sgn(f(a)) = sgn(f((a+b)/2))
            THEN a := (a+b)/2
            ELSE b := (a+b)/2;
      Nullstelle := (a+b)/2
   END;

BEGIN
   gotoxy(1,25);ClrEol;
   write('linke Grenze: '); read(xv);
   write('  rechte Grenze: '); read(xb);
   IF sgn(f(xv)) = sgn(f(xb))
      THEN write('Fehlerhafte Eingabe!')
      ELSE
         BEGIN
            n := Nullstelle(xv,xb);
            write('  Nullstelle: ',n:12:9,' (',f(n):12:10,')')
         END
END;




{$I PLOTGRAF.PAS}

BEGIN
 REPEAT
   write('x von ');read(xv);write(' bis ');readln(xb);
   write('y von ');read(yv);write(' bis ');readln(yb);
   HiRes;
   plotgraf(xv,xb,yv,yb);
   gotoxy(65,20);write('G)raph');
   gotoxy(65,21);write('N)ullstelle');
   gotoxy(65,22);write('E)nde');
   REPEAT
      REPEAT read(kbd, c); c := UpCase(c) UNTIL c in ['N','G','E'];
      IF c = 'N' THEN BerechneNullstelle
   UNTIL c <> 'N';
   TextMode(C80);
 UNTIL c = 'E'
END.