(*$C-*)
PROGRAM Reaktionstest;

CONST Versuchsanzahl = 20;
      MaxZeit        = 15000;
      StrafZeit      = 15000;

VAR   Spalte, Zeile,
      Zeit, Versuch  : integer;
      Mittelwert     : real;
      ok             : boolean;
      c, c1          : char;
      Ergebnis       : array[1..Versuchsanzahl] OF integer;


BEGIN
   (* 1: Vorbereitung der Versuchsreihe *)   (* Die Zahlen in den Erluterungen
                                             geben die Verfeinerungsstufe an *)
   Randomize;
   ClrScr;
   gotoxy(18,12); write('Um mit dem Test zu beginnen, tippe <RETURN>.');
   readln;
   Textmode(C40);

   FOR Versuch := 1 TO Versuchsanzahl DO  (* 1: Versuchsdurchfhrung *)
      BEGIN
         (* 2: Schreibe zuflligen Buchstaben nach zuflliger
               Zeit an zufllige Stelle des Bildschirms *)
         c := chr(97 + random(26));

         (* 3: Spalte <-- Zufallszahl von 1 bis 39 *)
         Spalte := 1 + random(39);

         (* 3: Zeile <-- Zufallszahl von 1 bis 24 *)
         Zeile := 1 + random(24);

         delay( random (3000) );
         gotoxy(Spalte,Zeile);
         write(c);

         (* 2: Mi Zeit bis zum nchsten Tastendruck oder bis maxZeit
              berschritten ist *)
         Zeit := 0;

         (* 3: Leere den Tastatur-Puffer *)
         WHILE keypressed DO read (kbd,c1);

         REPEAT
            Zeit := Zeit + 1
         UNTIL keypressed or (Zeit = MaxZeit);
         ClrScr;

         (* 2: ok ist, wenn Taste gedrckt und Buchstabe richtig war *)
         IF keypressed
            THEN read(kbd,c1)
            ELSE c1 := ' ';
         ok := ( c = c1 ) AND (Zeit < MaxZeit);

         IF ok THEN (* 2: halte Zeit in Ergebnis[Versuch] fest *)
                    Ergebnis[Versuch] := Zeit

               ELSE BEGIN  (* 2: gib Signal und halte Zeit + Strafzeit
                                 in Ergebnis[Versuch] fest *)
                       Ergebnis[Versuch] := Zeit + StrafZeit;
                       write(chr(7))
                    END;
      END;

   (* 1: Berechnung der mittleren Reaktionszeit *)
   Mittelwert := 0;
   FOR Versuch := 1 TO Versuchsanzahl DO
      Mittelwert := Mittelwert + Ergebnis[Versuch];
   Mittelwert := Mittelwert / Versuchsanzahl;

   (* 1: Ausgabe des Resultats *)
   TextMode(C80);

   (* 2: Ausgabe des Mittelwerts der Reaktionszeit *)
   gotoxy(18,12); writeln('Mittlere Reaktionszeit war:', Mittelwert:6:0);

   (* 2: Ausgabe eines Urteils nach einer 5-stufigen Skala *)
   gotoxy(18,14); write('Das ist ');
   CASE Round(Mittelwert) OF
        0..2999 : writeln('hervorragend.');
     3000..4999 : writeln('sehr gut.');
     5000..6999 : writeln('gut.');
     7000..9999 : writeln('ausreichend.');
     ELSE writeln('ungengend.');
   END;
END.