PROGRAM Textverarbeitung;

TYPE Textzeile = string[75];

VAR  Zeile          : ARRAY[1..15] OF Textzeile; (* Feld mit 15 Zeilen *)
     VAR  TextDatei : File OF TextZeile;
     i              : integer;  (* Zhlvariable *)
     Antwort        : char;


PROCEDURE Menuezeile( z : Textzeile );
   (* Zeigt eine Meldungszeile z am BS in Zeile 25, ab Spalte 1 an *)
   (* Beim Aufruf von Menuezeile mu fr z die jeweils gewnschte  *)
   (* String-Konstante oder String-Variable eingesetzt werden.     *)
   BEGIN
      gotoxy(1,25); (* Cursor wird am BS auf 1. Spalte der 25. Zeile gesetzt *)
      write(z);
      ClrEol;
   END;

PROCEDURE InZeile ( Nr : integer );
   (* positioniert Cursor am Anfang der Textzeile mit der Nummmer Nr *)
   (* und lscht die Bildschirmzeile *)
   BEGIN
      gotoxy(4,3 + Nr);
      ClrEol;
   END;


PROCEDURE Laden;
    (* bertrgt 15 Zeilen von Diskette in Hauptspeicher*)

   VAR Nr        : integer;
       DateiName : string[14];

   BEGIN
      Menuezeile('Namen fr die Datei eingeben: ');
      read(DateiName);
      assign(Textdatei,DateiName); (* Dem Diskettendateinamen wird
                                      der DateiName zugeordnet      *)
      reset(Textdatei);            (* Datei wird zum Lesen geffnet *)
      Menuezeile('Text wird von Diskette in Computer geladen');
      FOR Nr := 1 TO 15 DO
         BEGIN
            read(Textdatei,Zeile[Nr]);    (* Zeile wird von Diskette gelesen *)
            InZeile(nr);write(Zeile[nr]); (* ............und am BS angezeigt *)
         END;
      close(Textdatei);                   (* Datei wird geschlossen *)
   END;


PROCEDURE Sichern;

   VAR Nr        : integer;
       DateiName : string[14];

   BEGIN
      Menuezeile('Namen fr die Datei eingeben: ');
      read(DateiName);
      assign(Textdatei,DateiName);
      rewrite(Textdatei);             (* Datei wird zum Schreiben geffnet *)
      Menuezeile('Text wird auf Diskette gesichert.');
      FOR Nr := 1 TO 15 DO
         write(Textdatei,Zeile[Nr]);  (* Zeile wird auf Diskette geschrieben *)
      close(Textdatei);               (* Datei wird geschlossen *)
   END;



PROCEDURE NichtImplementiert;
VAR Mist : char;
BEGIN
   Menuezeile('Nicht implementiert.    Weiter mit beliebiger Taste ');
   read(kbd,Mist);
END;


PROCEDURE Drucken;
   (* VAR ...     *)
   BEGIN
      (* Menzeile erklrt, da gedruckt wird;
         Alle 15 Zeilen werden auf den Drucker ( Gertebezeichnung lst )
         ausgegeben  *)
      NichtImplementiert;
   END;


PROCEDURE Bearbeiten; (* Bearbeitet die 15 Zeilen der Feldvariablen Zeile *)

(* VAR  ...     *)

   (* Es folgen die drei "lokalen" Unterprogramme von Bearbeiten:       *)

   PROCEDURE NeuBeschreiben;
   (* VAR ....        *)
   BEGIN
      NichtImplementiert
   END;

   PROCEDURE Einfuegen;
   (* VAR ....         *)
   BEGIN
      NichtImplementiert
   END;

   PROCEDURE Loeschen;
   (* VAR ...    *)
   BEGIN
      NichtImplementiert
   END;

BEGIN
   (* Wiederhole
         Menzeile, die die Alternativen angibt;
         Buchstaben einlesen zwecks Auswahl der Alternative;
         Falls der zugehrige Grobuchstabe gleich
           'N' : NeuBeschreiben;
           'E' : Einfuegen;
           'L' : Loeschen;
           'H' :         ;
      bis Grobuchstabe gleich H   *)
   NichtImplementiert
END;


BEGIN  (* Hauptprogramm *)

   (* 1. Teil: Variable "initialisieren" und Bildschirm herrichten *)

   FOR i:=1 TO 15 DO
      Zeile[i]:='';                 (* Alle 15 Zeilen mit Leerstring belegen *)
   ClrScr;                          (* Bildschirm Lschen *)
   FOR i:=1 TO 15 DO
      BEGIN                         (* Zeilennummern werden am BS angezeigt *)
         gotoxy(1,3+i);
         write(i:2,':');
      END;
   gotoxy(20,1); writeln('Demonstrationsprogramm zur Textverarbeitung');
   gotoxy(1,23);
   writeln('Immer ersten Buchstaben der Alternative deiner Wahl eintippen:');

   (* 2. Teil: Hauptmen *)

   REPEAT
      Menuezeile('L(aden)   B(earbeiten)   S(ichern)   D(rucken)   E(nde) ');
      read(kbd, Antwort);
         (* Verzweigung zu UP entsprechend gewhlter Funktion *)
      CASE UpCase(Antwort) OF
         'L' : Laden;
         'B' : Bearbeiten;
         'S' : Sichern;
         'D' : Drucken;
         'E' :        ;
      END
   UNTIL UpCase(Antwort) = 'E';
   ClrScr;  (* abschlieendes BS-Lschen *)
END.