program MX256PR;                       {By Glen Weien
                                          based upon a BYTE Magazine article
                                          published in March, 1983 titled:
                                          "A Peek into the IBM PC - Expanding
                                           the Printer Character Set."
                                           by Tim Field
                                           Byte Pg. 331, Vol 8, No. 3}

label 100;
type
  mode = 1..3;
var
  Ok:   boolean;
  Ch:   char;
  I,AsciiNo,Ascii:       integer;
  FileName: string[14];
  FilVar: file of char;
  PrMode: mode;
  LowBitVal: array[0..31] of array[1..12] of byte;
  HiBitVal:  array[127..255] of array[1..12] of byte;
procedure   ReadHex;
 var
  FontFileName:  string[14];
  FontFilVar:    text;
 begin
   FontFileName := 'IBMFONTS.HEX';     {This file must be present for the
                                          program to work!}
   assign(FontFilVar,FontFileName);
   reset(FontFilVar);
   for AsciiNo := 0 to 31 do begin
     for I := 2 to 9 do begin
       read(FontFilVar,LowBitVal[AsciiNo,I])
     end;
     readln(FontFilVar,LowBitVal[AsciiNo,10])
   end;
   for AsciiNo := 127 to 255 do begin
     for I := 2 to 9 do begin
       read(FontFilVar,HiBitVal[AsciiNo,I])
     end;
     readln(FontFilVar,HiBitVal[AsciiNo,10])
   end;
 end;{ReadHex}
procedure SetMode;
  begin
    writeln('MX256PR has three different methods for handling control characters:');
    writeln;
    writeln('     1.  PASS-EM THRU  -  This mode sends any CONTROL character');
    writeln('          on to the printer as a control character.  This mode');
    writeln('          allows full user access to all Epson modes and functions');
    writeln('          (I.E. emphasized, double width, etc.)');
    writeln;
    writeln('     2.  PRINT IT OUT  -  This mode interprets any CONTROL character');
    writeln('          as a printing character.  It allows no control codes to be');
    writeln('          sent to the Epson.');
    writeln;
    writeln('     3.  PRINT ALL BUT CR & LF - This mode sees only ASCII 13 and');
    writeln('          ASCII 10 (carriage return and line feed) as valid CONTROL');
    writeln('          codes.  All other CONTROL characters are assumed to be');
    writeln('          printing characters.');
    writeln;
    writeln;
    write('What mode should MX256PR be set into? (1, 2, 3) ');
    readln(PrMode);
    writeln;
    write('The mode is now set.  Press any key to continue');
    while not keypressed do;
    clrscr
  end;{SetMode}
procedure PrLoByte;
  begin
    Ascii := ord(Ch);
    LowBitVal[Ascii,1] := 0;
    LowBitVal[Ascii,11] := 0;
    LowBitVal[Ascii,12] := 0;
    write(Lst,chr(27),'L',chr(12),chr(0)); {Sets up printer for 12 Bytes in bit-mode}
    for I := 1 to 12 do
      begin
        write(Lst,chr(LowBitVal[Ascii,I]));
      end;
  end; {PrLoByte}
procedure PrHiByte;
  begin
    Ascii := ord(Ch);
    HiBitVal[Ascii,1] := 0;
    HiBitVal[Ascii,11] := 0;
    HiBitVal[Ascii,12] := 0;
    write(Lst,chr(27),'L',chr(12),chr(0)); {Sets up printer as above}
    for I := 1 to 12 do
      begin
        write(Lst,chr(HiBitVal[Ascii,I]));
      end;
  end; {PrHiByte}
procedure PrExtend;
  begin
    Ascii := ord(ch);
    HiBitVal[Ascii,1] := HiBitVal[Ascii,2];
    HiBitVal[Ascii,11] := HiBitVal[Ascii,10];
    HiBitVal[Ascii,12] := HiBitVal[Ascii,10];
    write(Lst,chr(27),'L',chr(12),chr(0)); {Sets up printer as above}
    for I := 1 to 12 do
      begin
        write(Lst,chr(HiBitVal[Ascii,I]));
      end;
  end;{PrExtend}
begin {Main}
  ReadHex;
  SetMode;
  repeat
    write('Enter name of file to list: ');
    readln(FileName);
    assign(FilVar ,FileName);
    {$I-} reset(FilVar) {$I+} ;
    Ok := (IOresult = 0);
    if not Ok then writeln('Cannot find file ', FileName);
  until Ok;
  while not Eof(FilVar) do
    begin
       read(FilVar,Ch);
       if ord(Ch) in [32..126] then begin write(Lst,Ch); goto 100 end;
       if ord(Ch) in [1..6,21..25,28..31] then begin PrLoByte; goto 100 end;
       if ord(Ch) in [127..178,224..255] then begin PrHiByte; goto 100 end;
       if ord(Ch) in [179..223] then begin PrExtend; goto 100 end;
       {Now we deal with the control codes 0,7..20,26,27}
       if PrMode = 1 then begin write(Lst,Ch); goto 100 end;
       if PrMode = 2 then begin PrLoByte; goto 100 end;
       if PrMode = 3 then
          if ord(Ch) in [10,13] then write(Lst,Ch)
             else PrLoByte;
       100:
    end; {while not Eof}
  writeln(Lst);
end.
