cseg	segment			;tell assembler we are starting a segment
assume cs:cseg			;all assembler needs to know
sort	proc	far		;FAR procedure beginning
	cld			;set direction flag to forward
	push	bp		;always save frame pointer
	mov	bp,sp		;set up to get variable
	mov	bx,[bp+10]	;address of N%
	mov	cx,[bx]		;value of N% in CX
	dec	cx		;one less than N%
	mov	ax,[bp+8]	;address of pointer array P%(1)
	shl	cx,1		;multiply by 2 bytes per address
	add	ax,cx		;this is the end of pointer array
	mov	[bp+10],ax	;store end of pointers here
	sub	word ptr[bp+6],3 ;start of string array table
	mov	bx,[bp+8]       ;address of P%(1)
s5:	xor	cx,cx		;clear CX register
	push	cx		;save this value
s3:	mov	ax,[bx]		;value of P%(I)
	mov	dx,ax		;mulitiply X3 bytes per entry in
	shl	ax,1		;the string descriptor table
	add	ax,dx		;mult x2 and add
	mov	di,[bp+6]	;address of string table
	add	di,ax		;+ offset of table in AX
	mov	cl,[di]		;length of string
	mov	si,[di+1]	;address of A$(P(I))
	mov	ax,[bx+2]	;value of P%(I+1)
	mov	dx,ax		;again multiply x3 for
	shl	ax,1		;3 byte offset into string
	add	ax,dx		;descriptor table
	push	bx		;save the address of pointer
	mov	bx,[bp+6]	;address of string desc. table
	add	bx,ax		;+ offset of table in AX
	mov	di,[bx+1]	;address of A$(P(I+1))
	cmp	cl,[bx]		;compare lengths
	jl	s1		;put shortest length
	mov	cl,[bx]		;into CL with CH=0
s1:	repz	cmpsb		;compare strings until not equal
	pop	bx		;restore address of pointer
	jle	s2		;if not less or equal then..
swap:	mov	ax,[bx]		;swap pointer values P(I)..
	mov	dx,[bx+2]	;with P(I+1)
	mov	[bx],dx
	mov	[bx+2],ax
	pop	ax		;indicate that a swap took place
	mov	ax,0ffffh	;by pushing -1 onto stack
	push	ax
s2:	add	bx,2		;goto the next pointer
	cmp	bx,[bp+10]	;and see if at end of array
	jl	s3		;if not go again
	pop	cx		;did a swap occur?
	cmp	cx,0		;check swap flag pushed above
	jz	s4		;if no swap we are done otherwise...
	sub	word ptr [bp+10],2 ;we need to check one less string
				;since the largest bubbled to the top
	mov	bx,[bp+8]	;retrieve end of pointer array
	cmp	bx,[bp+10]	;are we at end?
	jnz	s5		;if not do sort again
s4:	pop	bp		;restore BASIC's frame pointer
	ret	6		;return to BASIC and get rid of 6 bytes
				;on the stack (3 arguments)
sort	endp			;close procedure
cseg	ends			;close segment
	end			;we are finished
                                                                                                                                                                                                                                                                                                                           