':*********************************** ':* PROGRAM CHASM    Version 2.01   * $':*                                 * 3.':* CHeap ASseMbler for the IBM PC. * ^8':*                                 * B':* Begun 6/15/82 by Dave Whitman   * L':*********************************** V': `':main program j'    P   :initialize t'  :wipe out transient code 7~'    "chasm.ovl",',ALL, Pr Y'   M   :set up sym table '   '   :pass 1: build sym table '   (   :pass 2: generate obj code & listing '   "L   :clean up ' ':******************************************* >':* SUBROUTINE PASSONE                      * q':* Adds user-defined symbols to sym table. * ':******************************************* ': 'PASS   'LOCTR      :0-255 reserved for p.s. prefix  (LINENUM   
(  () 0( :get source line, initialize J(    |)   :getline [(( :parse it r2(    )  :parse <( :if label, enter in sym table F(    LABEL$  ""   x-  :newentry P( :if op, decode, & update loctr Z(    OP$  ""   0   :update_loctr -d( :progress report :n(    M Ax(  G( p(:********************************* (:* SUBROUTINE PASSTWO            * (:* Generates obj code & listing. * (:********************************* (: ( K  :pass2_init (: #(  () G( :get source line, initialize a(    |)   :getline t( :parse line (    )   :parse ) :phase error? )    LABEL$  ""   .  :check_phase ) :if op, update loctr, generate obj. code ,")    OP$  ""   0   :update_loctr T,) :output obj. code & listing line l6)    LJ  :output @) :progess report J)    M T)  ^):wipe out msg h)  X  (): Y  :  ,:  O):  Y,X r) |):******************************************** G):* SUBROUTINE GETLINE                       * {):* Gets line of source code for processing. * ):* and initializes for new iteration.       * ):******************************************** ): ) #, INPLINE$ )LINENUM  LINENUM   ?)NEEDOFFSET  NONE: DSFLAG  FALSE N)OBJLEN   T) ):***************************************************** ):* SUBROUTINE PARSE                                  * ):* Parses input line for any label, op, or operands. * H*:***************************************************** P*: n*LINEPTR  : LINEPTR2   &*LABEL$  "": OP$  "": SOURCE$  "": DEST$  "" 0*: :*:set endptr to end of code D*  ENDPTR  (INPLINE$,";")              :just before comment WN*   ENDPTR    ENDPTR  (INPLINE$)  :no comment, set to eol _X*: xb*:no code? (return) l*   ENDPTR    p+ v*: *:convert to all caps *   + *: *:label (if any) *   (DELIM$,(INPLINE$,))   * !*     ,  :getfield 7*    LABEL$  FLD$ ?*: N*:op-code g*   ,  :getfield }*    FOUND  p+ *    OP$  FLD$ *:save ptr to start of operands +  OPDPTR  LINEPTR +: +:destination operand (if any)  +   ,  :getfield '*+    FOUND  p+ :4+  DEST$  FLD$ B>+: aH+:source operand (if any) zR+   ,  :getfield \+    FOUND  p+ f+  SOURCE$  FLD$ p+ z+: +:internal subroutine caps +:Scans inpline$ up to comment field, 9+:converting l.c. chars. to u.c.. Skips over strings. N+ I    ENDPTR j+  C$  (INPLINE$,I,) +  :skip strings +     C$  "'"  + +      STRGEND  (I,INPLINE$,C$) +       STRGEND    I  STRGEND:  + +  :convert d+     (C$)  a  (C$)  z  C$  ((C$)   ):                  (INPLINE$,I,)  C$ n+   I t+ ,:*********************************************************** ,:* SUBROUTINE GETFIELD                                     * =,:* Starting at lineptr, trys to return next field in FLD$. * $,:* Sets found if sucessful. Moves lineptr past field.      * .,:*********************************************************** 8,: B,:find next non-delimiter or run off end L,  LINEPTR  ENDPTR GV,    (DELIM$,(INPLINE$,LINEPTR,))    t, d`,   LINEPTR  LINEPTR   mj,    t,:if past end, not found ~,  LINEPTR  ENDPTR   , ,   FOUND  FALSE ,    ,: ,:strings terminated by '  ,  (INPLINE$,LINEPTR,)  "'"  , F ,   STRGEND  (LINEPTR,INPLINE$,"'") a ,    STRGEND    ,  ,     LINEPTR2  STRGEND    ,      2-  ,:  ,:otherwise, find next delimter or go 1 past end  , LINEPTR2  LINEPTR ! -  LINEPTR2  ENDPTR 6!
-    (DELIM$,(INPLINE$,LINEPTR2,))    2- U!-   LINEPTR2  LINEPTR2   ^!-    f!(-: x!2-:copy field !<- FLD$  (INPLINE$,LINEPTR,LINEPTR2LINEPTR) !F-: !P-:move lineptr past field, set found & return !Z- LINEPTR  LINEPTR2 "d- FOUND  TRUE "n-  L"x-:********************************************** "-:* SUBROUTINE NEWENTRY                        * "-:* Adds new symbol to sym table with default  * "-:* attributes. (may be changed by pseudo-ops) * $#-:********************************************** ,#-: M#-:already in table? (error) d#-  TARGET$  LABEL$ #-  .     :operand_lookup #-   FOUND  . #-   ERRS  ERRS   #-   #,"****Error: Duplicate definition of ";LABEL$;" in ";LINENUM $-    	$-: $$.:table full? (error) A$.  NUMSYM  MAXSYM  @. X$.   ERRS  ERRS   $".   #, "****Error: Too many user symbols in "; LINENUM $,.    $6.: $@.:else make new entry $J. NUMSYM  NUMSYM   $T. SYM$(NUMSYM)  LABEL$ %^. VAL1(NUMSYM)  LOCTR *%h. SYMTYPE(NUMSYM)  NEAR 2%r.: 8%|. a%.:********************************* %.:* SUBROUTINE CHECK_PHASE        * %.:* Label value same both passes? * %.:********************************* %. OP$  "EQU"  . 	&.TARGET$  LABEL$ &&. .  :operand_lookup .&.: e&. (SYMTYPE(TABLEPTR)  (NEAR  MEM))  FALSE  . &.   VAL1(TABLEPTR)  LOCTR  . &.    ERRS  ERRS  : #, "****Phase Error" &. &.:************************************************* 2'/:* SUBROUTINE OPERAND_LOOKUP                     * k'/:* Trys to find TARGET$ in sym table.  If there, * '/:* sets FOUND true, & TABLEPTR to its'position.  * '&/:************************************************* '0/:scan table for symbol (:/   TABLEPTR    NUMSYM J(D/     SYM$(TABLEPTR)  TARGET$  / :found ](N/     TABLEPTR e(X/: (b/:failure exit point (l/  FOUND  FALSE (v/   (/:sucess exit point (/  FOUND  TRUE (/   )/:********************************************************* Q)/:* SUBROUTINE LOOKUP_OP                                  * )/:* Given op-code in op$, & operand types in dtype &      * )/:* stype, trys to find op in opcode table. If sucessful, * */:* sets found true, & opptr to its' position.            * U*/:********************************************************* */:binary search for good starting pt. */ MOVE  NUMOP: ST  MOVE */  MOVE   */   MOVE  MOVE +0    OP$  OPCODE$(ST)  ST  ST  MOVE : ST  ST  MOVE +0    ST    ST   >+0    ST  NUMOP  ST  NUMOP G+ 0    O+*0: {+40:scan for entry matching all 3 fields +>0  OPPTR  ST  NUMOP +H0    OPCODE$(OPPTR)  OP$  0   :failed +R0    OPCODE$(OPPTR)  OP$  z0 ,\0    (SRCTYPE(OPPTR)  STYPE)  FALSE  z0 J,f0    (DSTTYPE(OPPTR)  DTYPE)  FALSE  z0 a,p0    0 :found! p,z0    OPPTR ,0:failure exit ,0 FOUND  FALSE ,0  ,0:successful exit ,0 FOUND  TRUE ,0  ,0:*************************************** ,-0:* SUBROUTINE UPDATE_LOCTR             * [-0:* Decodes operation & advances loctr. * -0:* On pass 2, generates obj. code.     * -0:*************************************** -0: -0:set operand types & values  .1  :destination operand 0.1   TARGET$  DEST$:  <2   :type_operand H.1   DTYPE  TARGTYPE `.$1   DVAL1  TARGVAL1 x..1   DVAL2  TARGVAL2 .81  :source operand .B1    :special case: RET op .L1      OP$  "RET"  STYPE  PROCTYPE(STKTOP):  1 /V1    :normal source 6/`1     TARGET$  SOURCE$:  <2   :type_operand P/j1     STYPE  TARGTYPE j/t1     SVAL1  TARGVAL1 /~1     SVAL2  TARGVAL2 /1: /1:find op in op table (not there: error) /1 TARGET$  OP$ /1  /   :lookup_op /1  FOUND  
2 01    PASS     Q01   ERRS  ERRS  : #,"****Syntax Error: ";OP$;DTYPE;STYPE 01    ((ACUM8  ACUM16  REG8  REG16  SEG  CS)                                 (DTYPE  STYPE))   2 01      (STYPE  (NONE  IMMED8  IMMED16))  FALSE   2 %11        ("BW",(OP$,))     2 B11         DIAG  DIAG   11         #,"****Diagnostic: Specify word or byte operation" 1 2    1
2 FLAG  OFLAG(OPPTR) 12: 12:branch for mach ops & pseudo-ops to update loctr 2(2  FLAG  MACHOP   8; :  b> 222 S2<2:********************************************************* 2F2:* SUBROUTINE TYPE_OPERAND                               * 2P2:* Sets TARGTYPE to reflect TARGET$'s type.  Sets        * 3Z2:* TARGVAL1 to its' value. If the operand is a register, * W3d2:* sets TARVAL2 to its' val2. If an offset appears,      * 3n2:* NEEDOFFSET gets the its' type, and OFFSET its' value. * 3x2:********************************************************* 32: 32:any operand? 42  (TARGET$)    2 )42   TARGTYPE  NONE 242    G42:in sym table? f42  .   :operand_lookup {42   FOUND  2 42   TARGTYPE  SYMTYPE(TABLEPTR) 42   TARGVAL1  VAL1(TABLEPTR) 42    TABLEPTR  PREDEF  TARGVAL2  VAL2(TABLEPTR) 52    52:number? ,53  4   :test_number A53   FOUND  63 [53   TARGTYPE  NUMTYPE t5"3   TARGVAL1  NUMVAL }5,3    563:direct mem. ref.? 5@3  5   :memref 5J3   FOUND  r3 5T3   TARGTYPE  MEM 5^3   TARGVAL1  MEMADDR 5h3    6r3:offset off register? :6|3  d7   :parse_disp_off_reg O63   FOUND  3 h63   TARGTYPE  MEMREG 63   TARGVAL1  REGVAL 63    63:offset? 63  9 :offset 63   FOUND  3 63   TARGTYPE  OFFSETYPE 63   TARGVAL1  OFFSETVAL 73    73:charactor? !73  : 673   FOUND  &4 Z74    TARGTYPE  IMMED8  IMMED16 u74    TARGVAL1  CHARVAL 74     7&4:string? 704  (TARGET$,)  "'"  X4 7:4   TARGTYPE  STRING 7D4    7N4: 8X4:not found? assume near label or mem ref. (error on pass 2) {8b4  PASS    #,"****Error: Undefined symbol ";TARGET$:                  ERRS  ERRS   8l4 TARGTYPE  NEAR  MEM 8v4 84:******************************************* 94:* SUBROUTINE TEST_NUMBER                  * 594:* Trys to interpret TARGET$ as a number.  * h94:* If sucessful, sets FOUND true, NUMVAL   * 94:* to its' value and NUMTYPE to its' type. * 94:******************************************* 94: 94FOUND  FALSE :4TN$  TARGET$  :working copy :4: &:4:hex number? D:4  (TN$,)  "H"  z5 W:4  :lop off H v:5   TN$  (TN$,(TN$)) :5  :scan for non-hex digits (exit) :5   I   : 5    I    (TN$) :*5     C$  (TN$,I,) 
;45      ("0123456789ABCDEF",C$)     ;>5      I *;H5  :get value I;R5   NUMVAL  ("&H"  TN$) c;\5  :set type, return p;f5    5 x;p5: ;z5:decimal number? ;5  :scan for non-dec digits (exit) ;5    I    (TN$) ;5     C$  (TN$,I,) <5      ("0123456789-+",C$)     <5      I 2<5  :get value J<5   NUMVAL  (TN$) R<5: e<5:sucess exit w<5 FOUND  TRUE <5  ((NUMVAL))     NUMTYPE  IMMED16  IMMED8                        : NUMTYPE  IMMED16 <5 =5:******************************************** I=6:* SUBROUTINE MEMREF                        * }=6:* Trys to interpret target$ as a direct    * =6:* mem ref.  If sucessful, sets FOUND true, * =$6:* & MEMADDR to the address referanced.     * >.6:******************************************** !>86: A>B6MR$  TARGET$  :save copy I>L6: Z>V6:brackets? >`6  (MR$,)  "["  (MR$,)  "]"   >j6: >t6:strip off brackets >~6 TARGET$  (MR$,,(MR$)) >6:try to interpret as addr. ?6  :might be number &?6    4   :test_number =?6     FOUND  6 W?6     MEMADDR  NUMVAL n?6      F7 :exit v?6: ?6  :or might be symbol ?6    .  :operand_lookup ?6     FOUND  7  @6      (SYMTYPE(TABLEPTR)  IMMED16)  FALSE  7 $@6       MEMADDR  VAL1(TABLEPTR) =@ 7        F7 :exit E@
7: Y@7:failure exit l@7 FOUND  FALSE @(7 TARGET$  MR$ @27  @<7: @F7:sucessful exit @P7 TARGET$  MR$ @Z7  @d7:***************************************************** 8An7:* SUBROUTINE PARSE_DISP_OFF_REG                     * uAx7:* Trys to parse TARGET$ as an offset off a register * A7:* If sucessful, sets FOUND true, sets NEEDOFFSET    * A7:* to the offset's type, and OFFSET to it's value .  * ,B7:***************************************************** 4B7: VB7PDOR$  TARGET$  :save copy ^B7: rB7:special case B7  TARGET$  "[BP]"  REGVAL  : NEEDOFFSET  IMMED8: OFFSET  :               N9 B7: B7:parse reg spec. C7 :set ptr to candidate #C7  PTR  (TARGET$,"[") LC7   PTR    v9  :no disp, exit fC8 :isolate candidate C8  REG$  (PDOR$,(PDOR$)PTR) C8 :valid reg. spec? C"8   REG$  "[BP]"  REGVAL  :  h8 C,8  TARGET$  REG$ D68   .  :operand_lookup 8D@8    FOUND  SYMTYPE(TABLEPTR)  MEMREG  v9 QDJ8   :save reg value qDT8    REGVAL  VAL1(TABLEPTR) yD^8: Dh8:now parse disp. Dr8 :isolate candidate D|8  DISP$  (PDOR$,PTR) D8 :valid disp? D8  TARGET$  DISP$ E8   :might be symbol .E8     .   :operand_lookup SE8      FOUND  8   :not sym E8     (SYMTYPE(TABLEPTR)  (IMMED16  IMMED8))  FALSE  8 E8      NEEDOFFSET  SYMTYPE(TABLEPTR) E8      OFFSET  VAL1(TABLEPTR) E8       N9 F8   :or number "F8     4   :test_number :F8      FOUND  9 YF8      NEEDOFFSET  NUMTYPE sF9      OFFSET  NUMVAL F9           N9 F9   :or offset F&9     9 :offset F09      FOUND  v9 F:9      NEEDOFFSET  OFFSETYPE 	GD9      OFFSET  OFFSETVAL GN9:sucess exit 1GX9 TARGET$  PDOR$ CGb9 FOUND  TRUE JGl9  ^Gv9:failure exit sG9 TARGET$  PDOR$ G9 FOUND  FALSE G9  G9:*************************************************** H9:* SUBROUTINE OFFSET                               * >H9:* Trys to interpret TARGET$ as an offset operand. * yH9:* If sucessful, set FOUND, set OFFSETYPE          * H9:* immed16, and TARGVAL1 to the label's offset.    * H9:*************************************************** H9: 	I9OS$  TARGET$ I9: AI9 (OS$,)  "OFFSET("  FOUND  FALSE:  VI: PASS    : ^I:: sI::isolate label I :  TARGET$  (TARGET$,,(TARGET$)) I*:: I4::look it up I>:   . :operand_lookup IH:: JR: FOUND  (SYMTYPE(TABLEPTR)  (MEM  NEAR))  : ,J\:  ERRS  ERRS   mJf:  #, "****Error: Illegal or undefined argument for Offset" Jp:  OFFSETVAL   Jz:   : J:: J:OFFSETVAL  VAL1(TABLEPTR) J:: J:FOUND  TRUE J:OFFSETYPE  IMMED16 J:TARGET$  OS$ J: ,K::*************************************** [K::* SUBROUTINE CHAR                     * K::* Trys to interpret TARGET$ as a char * K::*************************************** K:FOUND  FALSE K: (TARGET$)     L; (TARGET$,)  "'"   $L; (TARGET$,)  "'"   8L;   FOUND  TRUE ]L$;   CHARVAL  ((TARGET$,,)) cL.; L8;:************************************* LB;:* SUBROUTINE MACHOP                 * LL;:* Updates loctr based on op length. * MV;:* On pass 2, generates obj. code.   * DM`;:************************************* LMj;: bMt; =  :op_type jM~;: xM;:opcode M; LOCTR  LOCTR   M;  PASS     >  :build_opcode M;: M;:2nd op byte? N;  (OPVAL(OPPTR)   )  (OPVAL(OPPTR)   )  ; (N;   LOCTR  LOCTR   cN;    PASS    OBJLEN  OBJLEN  : OBJ(OBJLEN)  
  kN;: N;:room for m. byte disp. (must go here, modebyte modifys offset) N;  NEEDOFFSET  NONE  
< 9O;    (NEEDOFFSET  IMMED8)  LOCTR  LOCTR                                    : LOCTR  LOCTR   AO <: zO
<:if direct addr. mode byte, leave room for address O<  (FLAG  (NEEDMODEBYTE  NEEDEXT))  FALSE  2< O<    (DTYPE  STYPE)  MEM  LOCTR  LOCTR   O(<: P2<:extension byte? )P<<  (FLAG  NEEDEXT)  FALSE  d< BPF<   LOCTR  LOCTR   kPP<    PASS     ?   :build_ext sPZ<: Pd<:mode byte? Pn<  (FLAG  NEEDMODEBYTE)  FALSE  < Px<   LOCTR  LOCTR   P<    PASS     L@  :build_modebyte P<: Q<:8 bit disp.? 9Q<  (FLAG  NEEDISP8)  FALSE  < RQ<   LOCTR  LOCTR   |Q<    PASS     ^B  :build_disp8 Q<: Q<:16 bit disp.? Q<  (FLAG  NEEDISP16)  FALSE  < Q<   LOCTR  LOCTR   R<    PASS     :C :build_disp16 R<: #R<:immediate byte? LR=  (FLAG  NEEDIMMED8)  FALSE  "= eR=   LOCTR  LOCTR   R=    PASS     D R"=  WORD  ((FLAG  NEEDIMMED)  FALSE)  J= R,=   LOCTR  LOCTR   R6=    PASS     D   :build_immed8 R@=: SJ=:immediate word(s)? KST=  (WORD)  ((FLAG  NEEDIMMED)  FALSE)  |= S^=    DTYPE  IMMED16  LOCTR  LOCTR   : LOCTR  LOCTR   Sh=    PASS     D  :build_immed16 Sr=: S|=:mem. addr.? S=  (FLAG  NEEDMEM)  FALSE  = T=   LOCTR  LOCTR   :T=    PASS     BE  :mem_addr BT=: HT= tT=:************************************ T=:* SUBROUTINE OP_TYPE               * T=:* Decides between word & byte ops. * T=:************************************  U=: :U= (DTYPE  STYPE)  (REG16  ACUM16  SEG  CS)  > gU= (DTYPE  STYPE)  (REG8  ACUM8)  D> oU=: U> (OP$,)  "B"  D> U>: U>:word U&> WORD  TRUE U0>  U:>: UD>:byte UN> WORD  FALSE UX>  Vb>:********************************************** PVl>:* SUBROUTINE PSEUDO-OP                       * Vv>:* Branches to routines to handle each pseudo * V>:* op using the value field as an index.      * V>:********************************************** V>: ,W> OPVAL(OPPTR)  E, F, F, NH, 4I, I qW>:                      EQU    ORG    DB     DS     PROC   ENDP wW> W>:********************************************************** W>:* SUBROUTINE BUILD_OPCODE                                * =X>:* Builds opcode, stores it in obj. Increments objlength. * X>:********************************************************** X>: X>OBJLEN  OBJLEN   X>OBJ(OBJLEN)  OPVAL(OPPTR) X?: X?:add reg. field if requested Y?  (FLAG  ADDREG)  FALSE  f? %Y ?   :segment reg. UY*?     DTYPE  (SEG  CS)  R  DVAL2:  R? kY4?   :normal reg. Y>?     (FLAG  DIRECTION)  R  SVAL2 : R  DVAL2 YH?: YR?   OBJ(OBJLEN)  OBJ(OBJLEN)  R Y\?: Yf?:auto word bit? Zp?  (FLAG  AUTOW)  FALSE  ? BZz?    WORD  OBJ(OBJLEN)  OBJ(OBJLEN)   JZ?: aZ?:auto count bit? Z?  (FLAG  AUTOC)  FALSE  ? Z?    STYPE  CL  OBJ(OBJLEN)  OBJ(OBJLEN)   Z?: Z? [?:************************************************** ;[?:* SUBROUTINE BUILD_EXTENSION_BYTE                * u[?:* Builds an opcode extension byte.  The ext. val * [?:* is extracted from bits 3-5 of the flag word.   * [?:************************************************** [?: \?:get ext. \@ MASK  8  (\@ EXT  FLAG  MASK 0\@: g\$@:define proper operand as ext. & build mode byte \.@   FLAG  DIRECTION  DVAL2  EXT : SVAL2  EXT \8@   L@  :build_modebyte \B@ 	]L@:*************************************************************** P]V@:* SUBROUTINE BUILD_MODE_BYTE                                  * ]`@:* Given direction flag, memreg values in dval1 and sval1 and  * ]j@:* reg values in dval2 and sval2, builds an addressing mode    * %^t@:* byte.  If necessary, also builds displacement byte(s).      * l^~@:*************************************************************** t^@: ^@OBJLEN  OBJLEN   ^@: ^@:special case: direct mem. addressing? ^@  ((DTYPE  STYPE)  MEM)  FALSE  @ _@    DTYPE  MEM   M  SVAL2 : M  DVAL2 :_@     OBJ(OBJLEN)    M \_@      BE  :build_mem_addr g_@      o_@: _@:normal mode byte _@ :operands in normal or reverse order? _ A   FLAG  DIRECTION  M  SVAL1  DVAL2 : M  DVAL1  SVAL2 _
A: `A OBJ(OBJLEN)  M `A: 2`(A:offset byte(s)? :`2A: X`<A NEEDOFFSET  NONE  A ``FA: s`PA:8 bit disp. `ZA OFFSET    OFFSET    A `dA  OBJ(OBJLEN)  OBJ(OBJLEN)  @  :set mod field `nA  :crunch neg. offset to 8 bits $axA     OFFSET    OFFSET  OFFSET    >aA  OBJLEN  OBJLEN   YaA  OBJ(OBJLEN)  OFFSET aaA   iaA: }aA:16 bit disp. aA OBJ(OBJLEN)  OBJ(OBJLEN)    :set mod field aA OBJLEN  OBJLEN   aA :convert to hi/low form bA    NUMLOW  OFFSET:  A  :hi/low 1bA OBJ(OBJLEN)  NUMLOW LbA OBJ(OBJLEN)  NUMHIGH RbA bA:************************************************ bB:* SUBROUTINE HI/LOW                            * bB:* Splits 16 bit number in numlow, into two     * 2cB:* byte-sized componants in numhigh and numlow. * jc"B:************************************************ ~c,BH$  (NUMLOW) c6BH$  ((H$),"0")  H$ c@BNUMLOW   ("&H"  (H$,)) cJBNUMHIGH  ("&H"  (H$,)) cTB d^B:********************************************* PdhB:* SUBROUTINE BUILD_DISP8                    * drB:* Calculates the disp. from the present     * d|B:* loc to the loc given as an operand.       * dB:* Prints error message if disp. exceeds 127.* $eB:********************************************* ,eB: CeB:calculate disp. ZeB D  DVAL1  LOCTR beB: teB:check size eB  (D)    B eB   D   eB    PASS    #,"****Error: Too far for short jump":                     ERRS  ERRS   fB: "fB:if neg. crunch to 8 bits =fB  D    D  D    EfC: \fC:build obj. code ufC OBJLEN  OBJLEN   f&C OBJ(OBJLEN)  D f0C f:C:******************************************** fDC:* SUBROUTINE BUILD_DISP16                  * ,gNC:* Builds 16 bit displacement. Prints error * `gXC:* msg. for negative disps not on CALL ops. * gbC:******************************************** glC: gvC:calculate disp. gC D  DVAL1  LOCTR gC: -hC OP$  "JMP"  D  #, "****Diagnostic: Could use JMPS" :        DIAG  DIAG   5hC: ChC:legal? fhC  D    OP$  "CALL"  C shC   D   hC    PASS    #,"****Error: Illegal reverse long jump":                  ERRS  ERRS   hC: hC:build obj. code iC NUMLOW  D:  A  :hi/low .iC OBJLEN  OBJLEN   JiC OBJ(OBJLEN)  NUMLOW eiD OBJ(OBJLEN)  NUMHIGH kiD iD:************************************ i D:* SUBROUTINE BUILD_IMMED16         * i*D:* Builds word(s) of immediate data * j4D:************************************ #j>D: OjHD DTYPE  IMMED16  IVAL  DVAL1:  fD {jRD STYPE  IMMED16  IVAL  SVAL1:  fD j\D jfD:internal subroutine immed16 jpDNUMLOW  IVAL:  A   :hi/low jzDOBJLEN  OBJLEN   jDOBJ(OBJLEN)  NUMLOW kDOBJ(OBJLEN)  NUMHIGH kD FkD:********************************** pkD:* SUBROUTINE BUILD_IMMED8        * kD:* Builds byte of immediate data. * kD:********************************** kD: kD DTYPE  IMMED8  IVAL  DVAL1:  D "lD STYPE  IMMED8  IVAL  SVAL1:  D (lD @lD:int. sub. immed8 clD IVAL    IVAL    $E rlE  IVAL   lE   PASS    ERRS  ERRS  : #,"****Error: Data too long" lE: l$EOBJLEN  OBJLEN   l.EOBJ(OBJLEN)  IVAL l8E mBE:********************************* DmLE:* SUBROUTINE MEMREF             * mmVE:* Builds a memory address word. * m`E:********************************* mjE: mtE:get addr. in hi/low form m~E  DTYPE  MEM  NUMLOW  DVAL1 : NUMLOW  SVAL1 mE  A nE:build word *nE OBJLEN  OBJLEN   FnE OBJ(OBJLEN)  NUMLOW anE OBJ(OBJLEN)  NUMHIGH gnE nE:*************************** nE:* SUBROUTINE EQU          * nE:* Handles equ pseudo-op.  * nE:*************************** nE: oE (LABEL$  "")   F ]o F   PASS    ERRS  ERRS: #,"****Error: EQU without symbol" eo
F   moF: oF PASS    xF o(F: o2F DTYPE  (NEAR  MEM)  dF   :pass 1 default if not found o<F  ERRS  ERRS   "pFF  #, "****Error: EQU with forward referance in ";LINENUM *pPF   2pZF: KpdFVAL1(NUMSYM)  DVAL1 gpnFSYMTYPE(NUMSYM)  DTYPE mpxF pF:************************** pF:* SUBROUTINE ORG         * pF:* Handles org pseudo-op. * pF:************************** pF: qF:set loctr to new value .qF LOCTR  DVAL1 4qF UqF:************************* vqF:* SUBROUTINE DB         * qF:* Handles db pseudo-op. * qF:************************* qF: qF PASS    "G qG:label? set type to mem rG  LABEL$  ""  SYMTYPE(NUMSYM)  MEM 'rG: Tr"G:scan operand area, building obj. code }r,G LINEPTR  OPDPTR: LINEPTR2  OPDPTR r6G  LINEPTR  ENDPTR r@G  :get operand rJG    ,  :get_field rTG     FOUND  G  :exit s^G  :branch for byte value or string ;shG   TARGET$  FLD$:  4 :test_number osrG     FOUND  (NUMTYPE  IMMED8)  FALSE  G s|G      G  :build_byte sG      G sG    (FLD$,)  "'"  G sG      H  :build_stg sG      G tG  :if not byte or string, error on pass 2 ztG    PASS    #,"****Error: unrecognized operand ";FLD$:                 ERRS  ERRS   tG   tGLOCTR  LOCTR  OBJLEN tG tG:subroutine build_byte tGOBJLEN  OBJLEN   tGOBJ(OBJLEN)  NUMVAL tG uH:subroutine build_stg DuHFLD$  (FLD$,,(FLD$)) :strip off 's [uH I    (FLD$) uu&H  OBJLEN  OBJLEN   u0H  OBJ(OBJLEN)  ((FLD$,I,)) u:H   I uDH uNH:************************* uXH:* SUBROUTINE DS         * 
vbH:* Handles ds pseudo-op. * .vlH:************************* 6vvH: `vHDSFLAG  TRUE  :signal this is a ds vH PASS    H :skip type setting second time vH: vH:label? set type to mem vH  LABEL$  ""  SYMTYPE(NUMSYM)  MEM vH: wH:set output code :wH  STYPE  IMMED8  DSVAL  SVAL1 : DSVAL   BwH: pwH:on pass 2, generate obj. code directly wH  PASS    I wH    I    DVAL1 wH      BYTE$  (DSVAL):  # wH      I wI: wI:advance loctr, update bytesgen 5xI LOCTR  LOCTR  DVAL1: BYTESGEN  BYTESGEN  DVAL1 =x I: Cx*I fx4I:*************************** x>I:* SUBROUTINE PROC         * xHI:* Handles proc pseudo-op. * xRI:*************************** x\I: xfI STKTOP  MAXSTK  I 
ypI   PASS    I "yzI    ERRS  ERRS   YyI    #, "****Error: Procedures nested too deeply" ayI   iyI: yI:push new proc type for returns yI STKTOP  STKTOP   yI PROCTYPE(STKTOP)  DTYPE yI yI:******************** zI:* SUBROUTINE ENDP  *  zI:* Pops proc stack. * <zI:******************** DzI: [zI STKTOP    8J rzJ   PASS    $J zJ    ERRS  ERRS   zJ    #, "****Error: ENDP without PROC" z$J   z.J: z8JSTKTOP  STKTOP   zBJ {LJ:************************************ <{VJ:* SUBROUTINE OUTPUT                * h{`J:* Outputs obj code & listing line, * {jJ:* given code in obj(objlength).    * {tJ:************************************ {~J: {J:update number of bytes generated |J BYTESGEN  BYTESGEN  OBJLEN O|J DSFLAG  H$  (LOCTRDVAL1) : H$  (LOCTROBJLEN) m|JH$  ((H$),"0")  H$ ~|J#, ) H$; |J:first 6 bytes |J I   |J #, ) |J  I   |J    I  OBJLEN  K |J    BYTE$  (OBJ(I)):  # .}J   H$  (OBJ(I)):  (H$)    H$  "0"  H$ >}J   #, H$; O}J   I  I   X} K    `}
K: }K:source (truncate if necessary) }K #, ) }(K #,  "####"; LINENUM; }2K #, () (INPLINE$, LWIDTH) }<K: }FK:rest of obj. code ~PK  I  OBJLEN -~ZK    I      #, ) Q~dK    BYTE$  (OBJ(I)):  # ~nK   H$  (OBJ(I)):  (H$)    H$  "0"  H$ ~xK   #, H$; ~K   I  I   ~K    ~K OBJLEN    #, ~K ~K:*************************** K:* SUBROUTINE PASSTWO_INIT * 7K:*************************** ?K: WK:reset input file rK  #:  SC$   AS # zK: KPASS   KLOCTR    LLINENUM   	LBYTESGEN   L: L "L:************************ ,L:* SUBROUTINE FINALPROC * &6L:* Cleanup              * F@L:************************ NJL: TL STKTOP    ERRS  ERRS  : #,"****Error: missing ENDP" ^L: ǀhL#,: #,: #, ERRS; "Error(s) detected" rL#, DIAG; "Diagnostic(s) offered" (wL#,: #, BYTESGEN; "Bytes of object code generated" >|L:dump sym table IL  L iL:return printer to normal L  L$  "lpt1:"  #, PMODEOFF$ L:hang onto screen listing ɁL  L$  "scrn:"  L ܁L   : :  , L    ) "Hit any key to exit" O); %L   C$  :  C$  ""  L 2L    , 8L ]L:***************************** L:* SUBROUTINE DUMP_SYM_TABLE * L:***************************** M: ӂM#,: #, "SYMBOL TABLE DUMP:" MI  PREDEF   &MF$   "\        \!\  \\  \"  :format /0MPERLINE  LWIDTH  (F$) B:M I  NUMSYM tDM  H$  (VAL1(I)): H$  ((H$),"0")  H$ NM  #,  F$; SYM$(I); " ";  H$; "    "; XM  I  I   ؃bM   (IPREDEF)  PERLINE    #, lM   vM#, M M:************************************* IM:* SUBROUTINE PROGESS REPORT         * vM:* Maintains reassuring msg. on scrn * M:************************************* M: ؄MX  (): Y  :  ,:  ,:  ); M PASS     "First"; :  "Second"; ;M " pass in progress. Lines processed = "; LINENUM; UM O);:  ,:  Y,X [M M:**************************************** M:* SUBROUTINE SET_UP_SYMBOL_TABLE       * N:* Sets up sym table, & opens obj. file * N:**************************************** #N: Q N#, PREDEF, MAXSYM:  #, C$:  #, C$ *N SYM$(MAXSYM), VAL1(MAXSYM), VAL2(PREDEF), SYMTYPE(MAXSYM) 4N: Ȇ>N I    PREDEF  :# of pre-defined syms HN  #, SYM$(I), VAL1(I), VAL2(I), SYMTYPE(I) RN   I \NNUMSYM  PREDEF fN: (pN # NzN O$ AS # :  #, AS BYTE$ TN ~P:********************************** Z:* SUBROUTINE INIT                * ҇d:* Initializes all but sym table. * n:********************************** x: í AZ %ERRS  : DIAG   -: ?:title page J   b:define constants m   :open files    :op table    :listing header ƈ   ̈Ď :************************************************* >:* SUBROUTINE TITLE                              * w":* Prints title page, & waits for user response. * ,:************************************************* 6: ܉@ ,,:  P:  : :  ,, Jđ )"";(8,"");" Tđ )""E)" 8^đ )"" )"CHASM  version 2.01"E)" Lhđ )""E)" rđ )"")"Cheap Assembler for the IBM PC"E)" |đ )""E)" ފđ )"      If you have used this program and found it of      $đ )"   value, your $20 contribution will be appreciated.     8đ )""E)" _đ )"")"David Whitman"E)" đ )"")"Dept. of Chemistry"E)" đ )"")"Dartmouth College"E)" đ )"")"Hanover, NH  03755"E)" đ )""E)" <đ )"   You are encouraged to copy and share this program.    Pđ )""E)" ođ ) "";(8,"");"": đ ) "Hit any key to continue...":: I$  :  I$  ""   :  :**************************** :* SUBROUTINE SET_CONSTANTS * ,&:**************************** ;0:general l: TRUE  : FALSE  : DELIM$  " ,"  () tD: N:flag values X:bits 3-5 reserved for ext. values b MACHOP  : AUTOW  : ADDREG  @: NEEDEXT   1l NEEDISP8   : NEEDISP16   : NEEDMODEBYTE   : NEEDIMMED8    sv NEEDIMMED   : DIRECTION    : NEEDMEM   @: AUTOC    {: :operand types ֎ ACUM8  : ACUM16  : REG8  : REG16  : MEMREG  : CS     SEG  @: MEM  : IMMED8   : IMMED16   : NONE    J STRING   : NEAR   : FAR    : CL   @ R: `:arrays MAXOBJ  2:  OBJ(MAXOBJ) MAXSTK  
:  PROCTYPE(MAXSTK): STKTOP   Ŏ :***************************************************** /:* SUBROUTINE OPEN_FILES                             * l:* Prompts user for i/o filenames, then opens files. * :***************************************************** : ƕ   8 ǐ : ِ*:input file 4  ,: "Source code file name? [.asm] ", S$ %>  S$  ""  :  4 JH :if no extension, add default R     (S$,".")                                                                 SC$  S$  ".asm"                                                          : SC$  S$: S$  (S$,(S$,".")) (\    SC$   AS # 3f  , vp "Direct listing to Printer (P), Screen (S), or Disk (D)?",L$ z  L$  ""  :  f ̒    ("PpSsDd",L$)    :  f  :invalid response 
    L$  "P"  L$  "p"  L$  "lpt1:" :    :printer? M    L$  "S"  L$  "s"  L$  "scrn:" :    :screen? n      ,:  (O);:  ,      "Name for listing file? [";S$;".lst] ";       "",L$       L$  ""  L$  S$  ".lst"  :default to source name 
    L$  OUTPUT AS # -Ƒ#, :test listing device @:object file v  ,:  "Name for object file?  [";S$;".com] ";   "",O$  :default to source file name.com ϔ    O$  ""  O$  S$  ".com"  :will open after symtable setup Ǖ      :kill error trapping ($ : :  ..ǎ F8:**************** ^B:*Error Handler * vL:**************** ~V: `ǋ   5  j eǋ ((  4)  (  \))   ĕj   ,:  t   SC$; " not found.  Press Esc to exit, anything else to continue."; /~  SC$  :  SC$  ""  ~ I   SC$  ()   f   ,:  ,:  (P);    ,:  (0); :  ,:  4 : ǋ          #:  ,:     "Printer not available.  Press any key to continue.";    L$   :  L$  ""   :    ,:  ,:  (O); `    ,8:  ();:  ,:  p nǕ      :***********************  :* SUBROUTINE OP_TABLE * ˗
:*********************** ӗ: :put reassuring message on screen ! X  (): Y  :  ,:  , J  ) "*Set-up in progress*" O); \  ,:  Y,X d: Ⱥ "chasm.dat"   AS # (:note: c$ used to skip data comments 2: ט<ȅ#, NUMOP:  #,C$:  #, C$ 
FȆ OPCODE$(NUMOP), OPVAL(NUMOP), SRCTYPE(NUMOP) -PȆ DSTTYPE(NUMOP), OFLAG(NUMOP) 5Z: IdȂ I    NUMOP n  #, OPCODE$(I),OPVAL(I),DSTTYPE(I),SRCTYPE(I),OFLAG(I) x   #, C$    I Ȏ ș:************************* 陠:* SUBROUTINE HEADER     * 
:* Prints listing header.* +:************************* 3: ULWIDTH  O  :default width ]: q:title & date  D$  (,)  "/"  (,,)  "/"   (,) Ԛ #, SC$ LWIDTH(D$)) D$:#,:#, ܚ: :printer set up?   L$  "lpt1:"  T T   :for NEC 8023 printer, remove quotes for auto condensed mode "   :similar code may be substituted for other printers. ,  LWIDTH  :  #, LWIDTH   ٛ6  #, ()  "Q" :pmodeon @  PMODEOFF$  ()  "N"  J: T:column headings I^ #,"LOC")"OBJ")"LINE")"SOURCE":#, Qh: WrɎ                                               