;
;  EXTND.INC  --
;       WRITTEN FOR THE MICROSOFT ASSEMBLER TO DEFINE
;       THE UNIQUE INSTRUCTIONS IN NEC'S PD70108/PD70116
;       MICROPROCESSOR
;
	IF1				;;WE NEED ONLY INVOLVE PASS 1
;
;       WE NEED TO DEFINE SOME LABELS TO HELP US DIFERENTIATE BETWEEN
;       8 BIT REGISTER ARG.S AND 16 BIT REGISTER ARG.S TO OUR MACROS
;       AND TO GIVE THE REGISTERS VALUES WITH WHICH TO BUILD INSTRUCTIONS
;
	.VAL	= 0
	IRPC	Z,ACDB			;; DEFINE THE FIRST 4 16 BIT REGGIES
.&Z&X	EQU THIS WORD
@&Z&X	= .VAL
	.VAL = .VAL + 1
	ENDM

        .VAL    = 0
        IRPC    Z,ACDB                  ;; DEFINE ALL OF THE 8 BIT REGISTERS
.&Z&L   EQU THIS BYTE
@&Z&L	= .VAL
.&Z&H   EQU THIS BYTE
@&Z&H	= .VAL + 4
	.VAL = .VAL + 1
        ENDM
;
;SET_TYPE -
;       GIVEN AN ARGUMENT, SETS THE VARIABLE 'TYPE_OF_ARG' TO
;               0   IF IT IS AN IMMEDIATE VALUE
;               1            A  BYTE VARIABLE REFERENCE
;               2               WORD VARIABLE
;               ...        ETC
;             101               BYTE REGISTER
;             102               WORD REGISTER
;             201               BYTE PTR TYPE REFERENCE
;             202               WORD PTR TYPE REFERENCE
;
SET_TYPE MACRO ARG
        IFIDN <ARG>,<BYTE>
		TYPE_OF_ARG = 201H
	ELSE
		IFIDN <ARG>,<WORD>
			TYPE_OF_ARG = 202H
		ELSE
			TYPE_OF_ARG = TYPE ARG
			IFE TYPE_OF_ARG
				IFDEF .&ARG
					TYPE_OF_ARG = TYPE .&ARG
					IF TYPE_OF_ARG
						TYPE_OF_ARG = TYPE_OF_ARG + 100H
					ENDIF
				ENDIF
			ENDIF
		ENDIF
	ENDIF
	ENDM
;
;OK WE CAN NOW BEGIN DEFINING THE NEC UNIQUE INSTRUCTIONS

;THE BCD INSTRUCTIONS-
;       THESE HAVE NO ARGUMENTS, SO JUST PUT THE OPCODE

ADD4S	MACRO
		DB	0FH,20H
	ENDM

SUB4S	MACRO
		DB	0FH,22H
	ENDM

CMP4S	MACRO
		DB	0FH,26H
	ENDM



;THE BIT FIELD INSTRUCTIONS-
;       THESE ALLOW EITHER TWO ONE BYTE REGISTERS OR ELSE A BYTE REGISTER
;       AND AN IMMEDIATE BYTE VALUE.  HERE WE CAN DO ALMOST COMPLETE ERROR
;       CHECKING BECAUSE OF THE SIMPLE ARGUMENT TYPES.
;       DEFINE A TEMPLATE TO DO THAT.

BIT_FIELD MACRO OC,ARG1,ARG2

	.OK = 1
	SET_TYPE ARG1			;;CHECK ARGUMENT 1 FOR VALIDITY (REG8)
	IF TYPE_OF_ARG - 101H
		ARG1	; ARGUMENT MUST BE BYTE REGISTER
		.OK = 0
        ENDIF

	OPCODE = OC
	IF .OK
		SET_TYPE ARG2		;;NOW CHECK ARGUMENT 2 (REG8 OR IMM8)
		IFE TYPE_OF_ARG
			OPCODE = OPCODE + 8	;;IMMEDIATE ARG
		ELSE
			IF TYPE_OF_ARG-101H	;;CHECK FOR REG8
				ARG2	ARGUMENT MUST BE BYTE REG OR IMMED
				.OK = 0
			ENDIF
		ENDIF
	ENDIF

	IF .OK				;;IF ARGUMENTS OK, BUILD INSTR.
		DB	0FH
		DB	OPCODE
		IFE TYPE_OF_ARG
			DB 0C0H+@&ARG1	;;IMMED8 TYPE SECOND ARG
			DB ARG2
		ELSE
			DB 0C0H + (@&ARG2 SHL 3) + @&ARG1 ;;REG8 TYPE 2ND ARG
		ENDIF
	ENDIF
	ENDM

;INS-

INS     MACRO   ARG1,ARG2
		BIT_FIELD 31H,ARG1,ARG2
        ENDM

;EXT-

EXT     MACRO   ARG1,ARG2
		BIT_FIELD 33H,ARG1,ARG2
        ENDM

;NOW THE BIT INSTRUCTIONS
;       THE BIT INSTRUCTIONS HAVE A COMPLICATED STRUCTURE, ALLOWING
;       EITHER CL OR ELSE AN IMMED VALUE FOLLOWED BY ANY REGISTER OR MEMORY
;       REFERENCE (IT WAS NECESSARY TO REVERSE THE ARGUMENTS FROM NEC'S
;       DEFINITION BECAUSE OF THE COMPLESITY OF THE ADDRESSING MODES ALLOWED.
;       THIS TEMPLATE BUILDS USES THE 'INC' INSTRUCTION
;       TO BUILD THE MORE COMPLICATED ADDRESSING MODES FOR IT (THE OPCODE
;       OF THE INC INSTRUCTION IS OVERWRITTEN WITH THE PROPER CODE AFTER
;       THE ASSEMBLER GENERATES IT)

BIT	MACRO	OC,ARG1,ARG2,ARG3,ARG4
	LOCAL	OPC,CONT

	OPCODE = OC
	.OK = 1

	IFDIF <ARG1>,<CL>		;;1ST ARG MUST BE CL OR IMMED
		SET_TYPE ARG1
		IF TYPE_OF_ARG
			ARG1	; ARGUMENT MUST BE CL OR IMMEDIATE VALUE
                        .OK = 0
		ELSE
			OPCODE = OPCODE + 8	;;IF CL, SET CL BIT IN OPCODE
		ENDIF
	ENDIF

	IF .OK
		SET_TYPE ARG2
		IFE TYPE_OF_ARG ;;2ND ARG ANYTHING BUT IMMED
			ARG2	; ARGUMENT MAY NOT BE IMMEDIATE VALUE
			.OK = 0
		ENDIF
		IFE (TYPE_OF_ARG-2H) MOD 100H	;;IF MEM16 OR REG16 SET W BIT IN OPCODE
			OPCODE = OPCODE + 1
		ENDIF
        ENDIF

	IF .OK
		DB	0FH
		IFE (TYPE_OF_ARG-102H)	;;FOR REG16 WE MUST BUILD INSTR
			DB OPCODE
			DB 0C0H+@&ARG2
		ELSE
OPC:			INC ARG2 ARG3 ARG4	;;LET 'INC' BUILD THE ARGUMENT
CONT:			ORG OPC
			DB OPCODE		;;NOW OVERWRITE OPCODE W/ OURS
			ORG CONT
		ENDIF
		IFDIF <ARG1>,<CL>
			DB ARG1
		ENDIF
	ENDIF
        ENDM

;TEST1 -

TEST1	MACRO	ARG1,ARG2,ARG3,ARG4
		BIT	10H,ARG1,ARG2,ARG3,ARG4
	ENDM

;NOT1 -

NOT1    MACRO   ARG1,ARG2,ARG3,ARG4
		BIT	16H,ARG1,ARG2,ARG3,ARG4
	ENDM

;CLR1 -

CLR1    MACRO   ARG1,ARG2,ARG3,ARG4
		BIT	12H,ARG1,ARG2,ARG3,ARG4
        ENDM

;SET1 -

SET1    MACRO   ARG1,ARG2,ARG3,ARG4
		BIT	14H,ARG1,ARG2,ARG3,ARG4
	ENDM



;NEW STRING PREFIXES
;       NO ARGUMENTS ALLOWED HERE

REPC	MACRO
		DB	65H
	ENDM

REPNC	MACRO
		DB	64H
	ENDM




;THE BCD ROTATES
;       ONLY ONE ARGUMENT BEING ANY VALID ONE BYTE REFERENCE.  AGAIN
;       WE USE THE 'INC' INSTRUCTION TO BUILD THE PROPER ADDRESSING BYTES
;       AND THEN OVERWRITE THE OPCODE WITH OUR OWN

BCD_ROT MACRO	OPCODE,ARG1,ARG2,ARG3
	LOCAL	OPC,CONT

	SET_TYPE ARG1
	IF (TYPE_OF_ARG - 01H) MOD 100H
		ARG1	ARG2 ARG3; ARGUMENT MUST BE A BYTE REFERENCE
        ELSE
		DB	0FH
OPC:		INC	ARG1 ARG2 ARG3
CONT:		ORG	OPC
		DB	OPCODE
		ORG	CONT
	ENDIF
        ENDM

;ROL4-

ROL4    MACRO ARG1,ARG2,ARG3,ARG4
		BCD_ROT 28H,ARG1,ARG2,ARG3
	ENDM

;ROR4-

ROR4	MACRO ARG1,ARG2,ARG3,ARG4
		BCD_ROT 2AH,ARG1,ARG2,ARG3
	ENDM

	ENDIF				;;END OF MACRO INCLUDE FILE

;
;SEGMENT OVERRIDE
;       PROVIDE A METHOD FOR INCLUDING SEGMENT OVERRIDES
;
CS_	MACRO ARG1,ARG2,ARG3,ARG4,ARG5
	DB	2EH
	ARG1	ARG2,ARG3,ARG4,ARG5
	ENDM

ES_	MACRO ARG1,ARG2,ARG3,ARG4,ARG5
	DB	26H
	ARG1	ARG2,ARG3,ARG4,ARG5
	ENDM

SS_	MACRO ARG1,ARG2,ARG3,ARG4,ARG5
	DB	36H
	ARG1	ARG2,ARG3,ARG4,ARG5
	ENDM

;J_NOT_NEC <LABEL>
;       NOT STRICTLY A NEC UNIQUE INSTRUCTION, THIS MACRO TESTS
;       THE CPU TO DETERMINE IF IT IS AN INTEL 8086/88 OR NEC
;       V20/V30; IF IT IS THE 86/88 IT JUMPS TO THE LABEL ARGUMENT,
;       ELSE IT CONTINUES.  ALL REGISTERS ARE RETAINED EXCEPT CX.

J_NOT_NEC MACRO ARG
	LOCAL	V_SERIES

	PUSH	CS		;;PUSH CS IN CASE IT'S INTEL
	XOR	CX,CX
	SET1	0,CX		;;INTEL WILL POP CS, NEC WILL SET BIT IN CX
	OR	CX,CX		;;IS CX STILL 0?
	JNZ	V_SERIES
	JMP	ARG		;;YES -- AHA, ITS AN INTEL CHIP
V_SERIES:
	POP	CX		;;NO -- ITS NEC, BUT READJUST THE STACK
	ENDM
