       PAGE 62,132
;
; Assembler Utilities : clear screen
;                       locate
;                       clear input buffer
;                       set attribute byte
;                       write to screen buffer
;                       read from screen buffer
;-----------------------------------------
cseg   segment para public 'code'
;
; cls    - subroutine to clear the screen
;        - called from PASCAL
;
;Procedure CLS;         PASCAL statement
;
;AUTHOR: Barry Shiffrin
;
       public cls
cls    proc  far         ;called from pascal
       assume cs:cseg
       push  bp          ;save frame pointer
       mov  bp,sp    ;to address parms
;
       mov cx,0
       mov dx,184Fh
       mov bh,7
       mov ax,600h
       int 10h
;
retrun: pop  bp          ;get frame pointer
        ret
cls    endp
page
;
; locate - subroutine to locate the cursor
;        - called from PASCAL
;
; Author:Barry Shiffrin
;
;Procedure LOCATE (row,col: integer);   PASCAL statement
;
;first parameter is 1 origin row
;second parameter is 1 origin column
;
;ex: LOCATE(1,1)   - locates cursor at upper left corner of screen
;    LOCATE(25,80) - locates cursor at lower right corner of screen
;
;The next write after a locate will write the data at the located
;    cursor position.
;
;FRAME:
;        row     ; 8
;        col     ; 6
;     <ret/bp>   ; 0
;
;
       public locate
locate proc  far         ;called from pascal
;
       push  bp          ;save frame pointer
       mov  bp,sp        ;to address parms
;
       mov dl,[bp+6]
       mov dh,[bp+8]
       dec dh
       dec dl
       mov bh,0
       mov ah,2
       int 10h
;
       pop  bp          ;get frame pointer
       ret   4          ;return pop 2
locate endp
;
page
;clrbuf - routine to clear keyboard buffer
;       - called from PASCAL
;
; Author:Barry Shiffrin
;
;Procedure CLRBUF;     PASCAL statement
;
;When called, this procedure will clear out the keyboard buffer
;     removing any keys which the user may have 'typed ahead'
;
;
        public clrbuf
clrbuf  proc far
;
        push bp
        mov bp,sp
        mov dl,0ffh
        mov ah,0ch
        mov al,06h
        int 21h
        pop bp
        ret
clrbuf  endp
page
;
;
; attrib - subroutine to write attribute bytes on the screen
;        - called from PASCAL
;
; Author:Barry Shiffrin
;
;Procedure ATTRIB (r,c:integer; at:integer; ct:integer);     PASCAL statement
;
;first parameter is 1 origin row
;second parameter is 1 origin column
;third parameter is the attribute byte to be written
;                  (the lower byte of the integer is used)
;fourth parameter is the number of these attributes to write
;
;ex: ATTRIB(1,1,16#70,5); writes attribute 70H starting at 1,1 for 5 bytes
;
;
;FRAME:
;        r       : 12
;        c       : 10
;        at      ; 8
;        ct      ; 6
;     <ret/bp>   ; 0
;
;
;
        public attrib
attrib  proc far
;
        push bp
        mov bp,sp
        push es
;
        cld
        mov ah,15
        int 10H
        cmp al,7
        jne col
        mov ax,0B000H        ;setup segment for mono card
        jmp l1
    col:mov ax,0B800H        ;setup segment for color card
     l1:mov es,ax
;
        sub di,di            ;calculate offset into segment
        mov cx,[bp+6]        ;get count
        mov ax,[bp+12]       ;get row
        dec ax               ; make it 0 origin
        mov dx,160
        mul dx               ;perform the multiplication
        mov di,ax            ;store results in di
        mov ax,[bp+10]       ;get column byte
        dec ax               ;make it 0 origin
        shl ax,1             ;perform multiplication
        add di,ax            ;add to previous calculation
        add di,1             ;add 1 to point to attribute byte
;
        mov al,[bp+8]        ;get attribute byte
;
    agn:stosb                ;write attribute and inc di by 1
        inc di               ;increment address by 1 more to next attrib
        loop agn
;
        pop es
        pop bp
        ret 8
attrib  endp
;
page
;
; writeat - subroutine to write attribute bytes and data on the screen
;        - called from PASCAL
;
; Author:Barry Shiffrin
;
;Procedure WRITEAT (r,c,at:integer; var sp:lstring);     PASCAL statement
;    or
;Procedure WRITEAT (r,c,at:integer; const sp:lstring);     PASCAL statement
;
;first parameter is 1 origin row
;second parameter is 1 origin column
;third parameter is the attribute byte to be written
;                  (the lower byte of the integer is used)
;fourth parameter is the lstring to be written
;                 the length of this string is passed automatically
;ex: abc := 'test string';
;    WRITEAT(1,1,16#70,abc); writes attribute 70H starting at 1,1 for
;                               10 bytes and also writes the string
;
;NOTE:if the second form of the declare is used a constant string may be
;      included as immediate data.
;FRAME:
;        r       : 14
;        c       : 12
;        at      : 10
;        length  : 8      note that this is max length of lstring
;        sp      : 6
;     <ret/bp>   ; 0
;
;          the actual length of lstring is the first byte of the string
;
        public writeat
writeat proc far
;
        push bp
        mov bp,sp
        push es
;
        cld
        mov ah,15
        int 10H
        cmp al,7
        jne wcol
        mov ax,0B000H        ;setup segment for mono card
        jmp wl1
   wcol:mov ax,0B800H        ;setup segment for color card
    wl1:mov es,ax
;
        sub di,di            ;calculate offset into segment
        mov bx,[bp+6]        ;get address of string
        sub cx,cx
        mov cl,[bx]          ;get count from first byte of string
        mov ax,[bp+14]       ;get row
        dec ax               ; make it 0 origin
        mov dx,160
        mul dx               ;perform the multiplication
        mov di,ax            ;store results in di
        mov ax,[bp+12]       ;get column byte
        dec ax               ;make it 0 origin
        shl ax,1             ;perform multiplication
        add di,ax            ;add to previous calculation
;                            ;this now points to character byte
        mov ah,[bp+10]       ;get attribute byte
        mov si,[bp+6]        ;get address of string
        inc si               ;increment past length byte of lstring
;
        mov al,[si]          ;get character from string
   wagn:stosw                ;write character and attribute-reversed in mem
        inc si               ;increment to next character in string
        mov al,[si]          ;get next character
        loop wagn
;
        pop es
        pop bp
        ret 10
writeat endp
;
page
;
; readat - subroutine to read data from the screen
;        - called from PASCAL
;
; Author:Barry Shiffrin
;
;Procedure READAT (r,c:integer; var sp:string);     PASCAL statement
;
;first parameter is 1 origin row
;second parameter is 1 origin column
;third parameter is the string into which the data should be placed
;                 the length of this string is passed automatically
;    var abc : string(5);
;    READAT(1,1,abc); reads the 5 bytes starting at 1,1
;                               and places them into string abc
;
;FRAME:
;        r       : 12
;        c       : 10
;        length  : 8
;        sp      : 6
;     <ret/bp>   ; 0
;
;
;
        public readat
readat  proc far
;
        push bp
        mov bp,sp
        push ds
        mov ax,ds
        mov es,ax            ;setup es to point to ds
;
        cld
        mov ah,15
        int 10H
        cmp al,7
        jne rcol
        mov ax,0B000H        ;setup segment for mono card
        jmp rl1
   rcol:mov ax,0B800H        ;setup segment for color card
    rl1:mov ds,ax
;
        sub si,si            ;calculate offset into segment
        mov cx,[bp+8]        ;get count
        mov ax,[bp+12]       ;get row
        dec ax               ; make it 0 origin
        mov dx,160
        mul dx               ;perform the multiplication
        mov si,ax            ;store results in di
        mov ax,[bp+10]       ;get column byte
        dec ax               ;make it 0 origin
        shl ax,1             ;perform multiplication
        add si,ax            ;add to previous calculation
;                            ;this now points to character byte
        mov di,[bp+6]        ;get address of string
;
   ragn:movsb                ;read character from screen
        inc si               ;increment to next character position
        loop ragn
;
        pop ds
        pop bp
        ret 8
readat  endp
page
;
; mem    - subroutine to find out how much memory is installed
;        - called from PASCAL
;
; Author:Barry Shiffrin
;
;Function MEM:word  PASCAL statement
;
;
;
;
        public mem
mem     proc far
        push  bp          ;save frame pointer
        mov  bp,sp    ;to address parms
        int 12h
        pop bp
        ret
mem     endp
;
page
;
; readatl - subroutine to read data from the screen - returns an lstring
;           containing data up to the last non-blank field on a line
;         - called from PASCAL
;
; Author:Barry Shiffrin
;
;Procedure READATL (r,c,w:integer; var sp:lstring);     PASCAL statement
;
;first parameter is 1 origin row
;second parameter is 1 origin column
;third parameter is the width of the field to check
;fourth parameter is the lstring into which the data should be placed
;    var abc : lstring(5);
;    READAT(12,23,3,abc); reads the 3 bytes starting at 12,23
;                               and places them into lstring abc
;    if the 3 characters were 'a b' then returns 'a b'
;    if the 3 characters were 'ab ' then returns lstring 'ab'
;
;
;FRAME:
;        r       : 14
;        c       : 12
;        w       : 10
;        length  : 8
;        sp      : 6
;     <ret/bp>   ; 0
;
;
;
        public readatl
readatl proc far
;
        push bp
        mov bp,sp
        push ds
        mov ax,ds
        mov es,ax            ;setup es to point to ds
;
        std
        mov ah,15
        int 10H
        cmp al,7
        jne rlcol
        mov ax,0B000H        ;setup segment for mono card
        jmp rll1
  rlcol:mov ax,0B800H        ;setup segment for color card
   rll1:mov ds,ax
;
        sub si,si            ;calculate offset into segment
        mov cx,[bp+10]       ;get count
        mov ax,[bp+14]       ;get row
        dec ax               ; make it 0 origin
        mov dx,160
        mul dx               ;perform the multiplication
        mov si,ax            ;store results in di
        mov ax,[bp+12]       ;get column byte
        dec ax               ;make it 0 origin
        shl ax,1             ;perform multiplication
        add si,ax            ;add to previous calculation
;                            ;this now points to character byte
        sub si,2
        shl cx,1             ;multiply cx by 2
        add si,cx            ;point to end of string
        shr cx,1             ;restore count
        mov di,[bp+6]        ;points to lstring length
        push di              ;save for later
        add di,[bp+10]       ;point to last character of lstring
        push di              ;save for later
        mov ah,[bp+8]        ;get max length of lstring
        mov al,[bp+10]       ;get width of read
        cmp ah,al            ;compare max length to request
        jge rlgo             ;jump if ok
        pop di
        pop di
        jmp rldn
;
   rlgo:movsb                ;move character
        dec si               ;point to next character
        loop rlgo            ;loop until done
;
        mov cx,[bp+10]       ;restore count
        pop di               ;restore pointer to end of string
     l3:cmp es:byte ptr[di],20H ; compare to a blank
        jne l2
        dec di
        loop l3
     l2:pop di
        mov es:[di],cl        ;set string length
;
;
   rldn:cld
        pop ds
        pop bp
        ret 10
readatl endp
;
page
;
; prtstat - subroutine to check printer status - returns non-zero if
;           printer not available
;         - called from PASCAL
;
; Function PRTSTAT : Byte
;
        public prtstat
prtstat proc far
;
        push bp
        mov bp,sp
        mov ax,0200H
        xor dx,dx
        int 17H
        mov al,ah
        xor ah,ah
        xor al,90H            ;flip selected and busy bits
        pop bp
        ret
PRTSTAT endp
cseg    ends
        end
