        TITLE CHDIR - DOS 2.0 Change Directory Function
;       BASCOM Callable subroutine to invoke CHDIR function from DOS
;              From an idea by Jim Button:
;       Written By    John Chapman       CompuServ [70205,1217]
;       Version 1.1   January 1984
;INVOCATION:   This procedure is called as follows:
;           CALL CHDIR(DIRSTR$,RETCODE%)
;	    DIRSTR$ is a string WHICH MUST BE BUILT BY CONCATENATION !!
;           (DIRSTR$ = "NEWDIR" + CHR$(0) - for example) Creation of the
;           the string by CONCAT moves the string to string space, and the	
;           REQUIRED CHR$(0) at the end produces an ASCIIZ string of the 
;           format required by the DOS service.  RETCODE% will be set to 
;           the DOS return code provided by INT 21 FC=3B as described in
;           the DOS 2.0 manual, or the DOS 2.1 Techical Reference
;
; It is suggested that the routine calling the service perform some simple	
; edit and validity checking on the directory name, if input/variable data
; is used.
; 
;
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
DATA    SEGMENT WORD PUBLIC 'DATA'
DATA    ENDS
DGROUP  GROUP  DATA,CONST
CODE    SEGMENT BYTE PUBLIC 'CODE'
        PUBLIC  CHDIR
        ASSUME  CS:CODE,DS:DGROUP
CHDIR   PROC    FAR             ; (NO PARAMETERS)
        PUSH    BP              ; SAVE ENVIRONMENT
        MOV     BP,SP           ; POINT TO PARM LIST IN STACK SPACE
        MOV     SI,[BP]+8       ; ==> TO STRING DESCRIPTOR (PARM 1)
        MOV     DX,2[SI]        ; ACTUAL ADDR OF STRING VARIABLE 
        MOV     AH,3BH          ; SETUP FOR DOS CALL 3B
        INT     21H             ; DOS CALL
        JC      RC_SAVE         ; PASS RETURN CODE IF THERE (CARRY FLAG SET)
        XOR     AX,AX           ; CLEAR AX (rc=0) IF CARRY FLAG NOT SET
RC_SAVE:
        MOV     SI,[BP]+6       ; POINT TO SECOND PARAMETER
        MOV     [SI],AX         ; STORE RETURN CODE IN SECOND PARAMETER
        POP     BP              ; RESTORE ENVIRONMENT
        RET     4
TAGIT   DB      "$$$CHDIR$$$"
CHDIR   ENDP
CODE    ENDS
        END
