title XMODEM CRC Algorithm 8086 / Lattice C Compiler
page ,132
;
;************************************************************************
;* CRCSUBS (Cyclic Redundancy Code Subroutines) version 1.20		*
;* 8086 Mnemonics							*
;*									*
;*	8086 Version: Lattice C callable				*
;*									*
;*     	These subroutines will compute and check a true 16-bit		*
;*	Cyclic Redundancy Code for a message of arbitrary length.	*
;*									*
;*	The  use  of this scheme will guarantee detection of all	*
;*	single and double bit errors, all  errors  with  an  odd	*
;*	number  of  error bits, all burst errors of length 16 or	*
;*	less, 99.9969% of all 17-bit error bursts, and  99.9984%	*
;*	of  all  possible  longer  error bursts.  (Ref: Computer	*
;*	Networks, Andrew S.  Tanenbaum, Prentiss-Hall, 1981)		*
;*									*
;*									*
;*	There are four entry points, which are used as follows:		*
;*									*
;*	clrcrc();							*
;*	CLRCRC - A call to this entry resets the CRC accumulator.	*
;*		 It must be called at the start of each message.	*
;*									*
;*		 Entry Parameters: None.				*
;*									*
;*		 Exit Conditions:  CRC accumulator cleared.		*
;*									*
;*	udcrc(c);							*
;*	char c;								*
;*	UPDCRC - A call to this entry updates the CRC accumulator.	*
;*		 It must be called once for each byte in the		*
;*		 message for which the CRC is being calculated.		*
;*									*
;*		 Entry Parameters:       a byte to be included		*
;*					 in the CRC calculation.	*
;*									*
;*		 Exit Conditions:  CRC accumulator updated.		*
;*									*
;*									*
;*	crc= fincrc();							*
;*	unsigned crc;							*
;*	FINCRC - A call to this entry finishes the CRC calculation	*
;*		 for a message which is to be TRANSMITTED. It must	*
;*		 be called after the last byte of the message has	*
;*		 been passed thru UPDCRC. It returns the calculated	*
;*		 CRC bytes, which must be transmitted as the final	*
;*		 two bytes of the message.				*
;*									*
;*		Note that this returns a single 16 bit value; 		*
;*		if transmitting bytes, it must be transmitted 		*
;*		upper half first then lower half:			*
;*									*
;*			output (crc >> 8);				*
;*			output (crc);					*
;*									*
;*									*
;*		 Entry Parameters: None.				*
;*									*
;*		 Exit Conditions:  calculated CRC bytes.		*
;*									*
;*	error= chkcrc();						*
;*	int error;							*
;*	CHKCRC - A call to this routine checks the CRC bytes of		*
;*		 a RECEIVED message and returns a code to indicate	*
;*		 whether the message was received correctly. It must	*
;*		 be called after the message AND the two CRC bytes	*
;*		 have been received AND passed thru UPDCRC.		*
;*									*
;*		 Entry Parameters: None.				*
;*									*
;*		 Exit Conditions:  0 if message ok.			*
;*				   non-zero if message garbled.		*
;*									*
;************************************************************************
;*									*
;*	Designed & coded by Paul Hansknecht, June 13, 1981		*
;*	Converted to 8086 mnemonics by T. Jennings 25 Jan 84		*
;*									*
;*	Copyright (c) 1981, Carpenter Associates			*
;*			    Box 451					*
;*			    Bloomfield Hills, MI 48013			*
;*			    313/855-3074				*
;*									*
;*	This program may be freely reproduced for non-profit use.	*
;*									*
;************************************************************************
;
pgroup group prog
dgroup group data
;
;Our very own little bit of data space.
;
data segment word public 'data'

crc	dw (?)		;calculated CRC,

data ends

prog segment byte public 'prog'
assume cs:pgroup,ds:dgroup

public clrcrc,updcrc,fincrc,chkcrc
page
;
;Initialize the CRC.
;
clrcrc:	mov	crc,0
	ret
	RET
;
;Update the CRC with the new byte. The method used is 
;the CCITT polynomial:
;
;	x^16 + x^12 + x^5 + 1
;
;An alternate method often used in synchronous
;protocols is:
;
;	x^16 + x^15 + x^2 + 1
;
;Which can be generated by changing the XOR pattern
;from 1021 hex to 8005 hex.
;
updcrc:
	push	bp
	mov	bp,sp
	mov	bx,crc		;BX == CRC a reg for speed,
	mov	cx,8		;CX == bits in a byte,
	mov	ax,[bp+4]	;AL == msg byte,

u1:	rcl	al,1		;MSB -> carry,
	rcl	bx,1		;    -> CRC LSB,
	jnc	u2
	xor	bx,1021h
u2:	loop	u1

	mov	crc,bx
	pop	bp
	ret
;
;Finish off the CRC.
;
fincrc:
	xor	ax,ax		;do two zeros
	push	ax
	call	updcrc
	call	updcrc
	pop	ax
	mov	ax,crc		;return finished CRC
	ret
;
;Check the calculated CRC. Return 0 if OK.
;
chkcrc:
	mov	ax,crc
	ret

prog ends

	end
