PAGE	,132	
NAME	CV
TITLE	Change/create volume name

COMMENT *	Syntax: CV [d:]volname
					(no blanks between [d:] and
					 first character of volname;
					 volname itself may contain
					 blanks)

		Changes directory of drive specified to root; if a volume 
	entry exists, it is renamed 'volname'; otherwise a volume entry 
	with that name is created in the root directory. 
			- 16 Sept. 1983, Thomas G. Roberts -
	* 
CODE	SEGMENT
	ORG 100H
	ASSUME CS:CODE,DS:CODE,ES:CODE
CVOL	PROC	FAR
	JMP START

;--------	Data area	--------

FCB	DB	0FFH
	DB	5 DUP(0)
ATTR	DB	8
DRV	DB	0
VNAME	DB	11 DUP('?')
	DB	5 DUP(?)
NEW	DB	20 DUP(?)
CDSTR	DB	?,':\',0
ERMSG	DB	'Incorrect DOS version.$'
DUMMY	DB	?,':XYZZY',0
M2	DB	'CV: Cannot create volume entry' 
LM2	EQU	$ - M2

;----------------------------- 

START:	MOV AH,30H
	INT 21H		;get vers.#
	CMP AL,2
	JNB OK
	MOV DX,OFFSET ERMSG
	MOV AH,9
	INT 21H
	INT 20H

OK:	MOV SI,82H
	SUB CX,CX
	MOV CL,[SI-2]
	CMP CL,2
	JB EXIT		;no parms
	DEC CX		;separator at 81H
	MOV DI,SI
LSPC:	MOV AL,[SI]
	CMP AL,20H	;scan leading blanks
	JNZ NXT
	INC SI
	LOOP LSPC
	JMP EXIT	;all blanks ??
NXT:
REP	MOVSB
	MOV BX,5CH
	MOV AL,[BX]	;get drive byte
	CMP AL,0
	JNZ SKP
	MOV AH,19H	;get deflt driv #
	INT 21H
	INC AL
SKP:	MOV DRV,AL
	OR AL,40H	;make drive letter
	MOV CDSTR,AL
	MOV DUMMY,AL	;in case no vol.exists
	MOV DX,OFFSET CDSTR
	MOV AX,3B00H
	INT 21H		;cd drv:\
	MOV DX,OFFSET FCB
	MOV AH,1AH
	INT 21H		;set DTA
BACK:	MOV AH,11H
	INT 21H		;get vol.name
	CMP AL,0FFH	;none
	JNE GO			
	MOV DX,OFFSET DUMMY
	MOV CX,8	;vol.attr.
	MOV AH,3CH	;create
	INT 21H		;dummy vol.
	CMP AX,2	;this is returned with CY (?)
	JNE ERR		;cant create
	MOV DX,OFFSET FCB
	JMP BACK
GO:	MOV CX,90H
	SUB CX,DI
	MOV AL,20H
REP	STOSB		;pad w/blanks
	MOV CX,11
	MOV SI,82H
	MOV AL,[BX]	;drive byte again
	CMP AL,0	;is drive @ 82H?	
	JZ DFLT
	INC SI		
	INC SI
DFLT:	MOV DI,OFFSET NEW
REP	MOVSB		;setup
	MOV AH,17H	;rename
	INT 21H		;could do msg/errorlevel if CF=1
EXIT:	INT 20H		 
ERR:	MOV BX,2	;std err
	MOV CX,LM2 
	MOV DX,OFFSET M2 
	MOV AH,40H
	INT 21H
	INT 20H
CVOL	ENDP
CODE	ENDS
	END CVOL
                                                                                              