        TITLE GETDIR - DOS 2.0 Get Current Directory Function
;       BASCOM Callable subroutine to invoke GETDIR function from DOS
;              
;       Written By    John Chapman       CompuServ [70205,1217]
;       Version 1.0   January 1984
;INVOCATION:   This procedure is called as follows:
;           CALL GETDIR(DIRSTR$,drive$,RETCODE%)
;	    DIRSTR$ is a string WHICH MUST BE BUILT BY CONCATENATION !!
;           (DIRSTR$ = 64blanks$ + CHR$(0) - for example) Creation of the
;           the string by CONCAT moves the string to string space, and the	
;           REQUIRED CHR$(0) at the end produces an ASCIIZ string of the 
;           format required by the DOS service. DIRSTR$ M U S T be 64 bytes
;           in length, on entry to GETDIR. The field RETCODE% will be set to 
;           the DOS return code provided by INT 21 FC=3B as described in
;           the DOS 2.0 manual, or the DOS 2.1 Techical Reference
;           For stability, the BASIC program must adjust the string length
;           of the returned directory name: On return, the directory name 
;           is terminated with a binary zero. Use of the INSTR fuction
;	    will allow creation of a string with correct length.
;
; NOTE: The DRIVE$ string must contain a valid drive letter, or "@" 
;       if the default drive is required. DRIVE$ is not reset on return.
;
; It is suggested that the routine calling the service perform some simple	
; edit and validity checking on the drive letter.
; 
;
CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS
DATA    SEGMENT WORD PUBLIC 'DATA'
DATA    ENDS
DGROUP  GROUP  DATA,CONST
CODE    SEGMENT BYTE PUBLIC 'CODE'
        PUBLIC  GETDIR
        ASSUME  CS:CODE,DS:DGROUP
GETDIR  PROC    FAR             ; (NO PARAMETERS)
        PUSH    BP              ; SAVE ENVIRONMENT
        XOR     DX,DX           ; CLEAR OUT dx FOR DRIVE LETTER
        MOV     BP,SP           ; POINT TO PARM LIST IN STACK SPACE
        MOV     SI,[BP]+8       ; POINT TO SECOND PARAMETER
        MOV     BX,2[SI]        ; ACTUAL ADDR OF DRIVE LETTER
        MOV     DL,[BX]         ; LOAD THE DRIVE LETTER
        CMP     DL,90           ; CHECK FOR LOWER CASE,
        JG      LOWER           ; AND GO ADJUST IF LOWER
        SUB     DL,64           ; ADJUST DRIVE LETTER FROM UPPER CASE.
        JMP     DO_STRING       ; GO TO BUILD STRING
LOWER:  SUB     DL,96           ; ADJUST DRIVE LETTER FROM LOWER CASE.
do_string:
        MOV     SI,[BP]+10      ; ==> TO STRING DESCRIPTOR (PARM 1)
        MOV     AX,63           ; LENGTH OF STRING REQUIRED
        CMP     [SI],AX         ; LENGTH : 64
        JNG     BAD_LENGTH      ; EXIT IF STRING TOO SHORT
        MOV     SI,2[SI]        ; ACTUAL ADDR OF STRING VARIABLE 
        MOV     AH,47H          ; SETUP FOR DOS CALL 47
        INT     21H             ; DOS CALL
BAD_LENGTH:
        JC      RC_SAVE         ; PASS RETURN CODE IF THERE (CARRY FLAG SET)
        XOR     AX,AX           ; CLEAR AX (rc=0) IF CARRY FLAG NOT SET
RC_SAVE:
        MOV     SI,[BP]+6       ; POINT TO THIRD  PARAMETER
        MOV     [SI],AX         ; STORE RETURN CODE IN THIRD  PARAMETER
EXIT:   POP     BP              ; RESTORE ENVIRONMENT
        RET     4
TAGIT   DB      "$$$GETDIR$$$"
GETDIR   ENDP
CODE    ENDS
        END
