         name      hello
         page      55,132
         title     'HELLO --- print Hello on terminal'
;
; HELLO utility to demonstrate various parts
; of a functional assembly language program,
; use of segments, and a PC-DOS function call.
;
; Ray Duncan, September 1983
;
                             ;show use of some EQUATES:
cr       equ       0dh       ;ASCII carriage return
lf       equ       0ah       ;ASCII line feed
                             ;
;
                             ;begin the "Code" segment
                             ;containing executable
                             ;machine code
cseg     segment   para public 'CODE'
;
         assume    cs:cseg,ds:dseg,ss:stack
;
print    proc      far       ;actual program code
                             ;is completely contained
                             ;in the "procedure" named
                             ;"PRINT".
                             ;
         push      ds        ;save DS:0000 on stack
         xor       ax,ax     ;for final exit to PC-DOS.
         push      ax
                             ;set Data Segment Register
                             ;to point to the Data Segment
                             ;of this program, so that the
                             ;message we want to print is
                             ;addressable.
         mov       ax,seg dseg
         mov       ds,ax
                             ;now put the offset of the
                             ;message text into DX,
         mov       dx,offset message
                             ;now DS:DX specifies the
                             ;full address of the message.
         mov       ah,9      ;use the PC-DOS function 9
         int       21h       ;to print the string.
                             ;
         ret                 ;now return to PC-DOS using
                             ;the addresses we pushed on
                             ;the stack at entry.
                             ;
print    endp                ;end of the "procedure"
                             ;named "PRINT"
                             ;
cseg     ends                ;end of the code segment
                             ;containing executable
                             ;program.
                             ;
                             ;now we define a data segment
                             ;containing our program's
                             ;constants and variables.
dseg     segment   para 'DATA'
                             ;
message  db        cr,lf,'Hello!',cr,lf,'$'
                             ;
dseg     ends
                             ;
                             ;lastly, we define a Stack
                             ;Segment which contains
                             ;a scratch area of memory
                             ;for use by our program's stack
stack    segment   para stack 'STACK'
                             ;allow 64 bytes in this case
         db        64 dup (?)
                             ;
stack    ends
                             ;the final "End" statement
                             ;signals the end of this
                             ;program source file, and gives
                             ;the starting address of
                             ;the executable program
         end       print
