1 REM This is a sample program that illustrates how to use several of
2 REM the BASICA graphics commands.  Specifically, animation of objects
3 REM is presented ... along with how to display lines, boxes, and circles.
4 REM
5 REM
6 REM  The following statement defines the Graphics Array where objects will
7 REM  be saved.
8 REM
10 DIM OBJ$(1000)
11 REM
12 REM  The following statement sets up error handling.
13 REM
15 ON ERROR GOTO 20000
16 REM
17 REM  The following few statements check to see if the color monitor
18 REM  is being used.  If it is, control is transferred to stmt 140.
19 REM  If not, BASIC statements are executed that cause the color
20 REM  monitor to be activated.
21 REM
25 DEF SEG=0
30 IF (PEEK(&H410) AND &H30) <> &H30 THEN DEF SEG: GOTO 140
40 KEY OFF
50 CLS
60 WIDTH 80: DEF SEG=0: A=PEEK(&H410): POKE &H410,(A AND &HCF) OR &H20
70 WIDTH  40 :SCREEN 1: SCREEN 0: LOCATE ,,1,6,7
80 KEY OFF
90 SCREEN 0,1
100 COLOR 15,9,4
110 WIDTH 40
140 REM
141 REM The following statements set the appropriate color for the
142 REM program and screen width.  COLOR  0,0 means that background
143 REM is going to be black, with color palette 0 chosen.  This palette
144 REM allows us to use the colors black, green, red, and brown.
145 REM
150 WIDTH 40:COLOR 0,0:SCREEN 1,0:CLS:LOCATE 2,1
160 REM
161 REM Now we begin doing some real graphics processing.  We will begin
162 REM by drawing the object we wish to animate.  Then we will store it
163 REM into our array (obj$) for use later in the program.
164 REM
170 LINE (1,1)-(31,31),3,B ' draw a box
180 CIRCLE (16,16),14,2  ' draw a circle within the box
185 PAINT (16,16),2
190 GET (1,1)-(31,31),OBJ$ ' save object into array
200 CLS
260 REM
261 REM Now we get down to business.  We begin by drawing some lines on the
262 REM screen that will be used as a background.  These lines need not be
263 REM here, but are used for visual effect.
264 REM
270 FOR X%=1 TO 319 STEP 15
280 LINE (X%,1)-(X%,199),1
290 NEXT
300 FOR Y%=1 TO 199 STEP 15
310 LINE (1,Y%)-(319,Y%),1
320 NEXT
400 REM
401 REM Now we begin doing the animation process.  This particular program
402 REM allows the object to randomly move about the screen until it "hits"
403 REM the edge of the screen.  Once this occurs, the direction changes
404 REM and movement continues.  To stop the program requires the ESC key
405 REM to be pressed.
406 REM
410 X%=100:Y%=100:PUT (X%,Y%),OBJ$,XOR
420 DIREC%=1:YDIREC%=0:QUITIT=0:SPEED%=1
430 WHILE QUITIT=0
440 NEWX%=X%+DIREC%*SPEED%:IF NEWX%>287 THEN DIREC%=-1:GOTO 440 ELSE IF NEWX%<1 THEN DIREC%=1:GOTO 440  ' compute new x coordinate
450 NEWY%=Y%+YDIREC%*SPEED%:IF NEWY%>167 THEN YDIREC%=-1:GOTO 450 ELSE IF NEWY%<1 THEN YDIREC%=1:GOTO 450   ' compute new y coordinate
455 REM Check for arrow keys or carrots (<,>). Arrows control direction.
456 REM Carrots control speed (<=slow down, >=speed up)
460 K$=INKEY$:IF K$="" THEN 540
470 IF K$=CHR$(0)+CHR$(77) THEN DIREC%=1
480 IF K$=CHR$(0)+CHR$(75) THEN DIREC%=-1
490 IF K$=CHR$(0)+CHR$(72) THEN YDIREC%=-1
500 IF K$=CHR$(0)+CHR$(80) THEN YDIREC%=1
510 IF K$=CHR$(62) THEN SPEED%=SPEED%+1
520 IF K$=CHR$(60) THEN SPEED%=SPEED%-1:IF SPEED%<0 THEN SPEED%=0
530 IF K$=CHR$(27) THEN QUITIT=1
531 REM
532 REM Display graphics image at new location
533 REM
540 PUT (NEWX%,NEWY%),OBJ$,XOR
541 REM
542 REM Erase graphics image at old location
543 REM
550 PUT (X%,Y%),OBJ$,XOR
560 X%=NEWX%:Y%=NEWY%
570 WEND
580 LOCATE 23,1
590 CLS:RUN "MENU.PGM"
20000 PRINT "error encountered";ERL;"=error line";:RESUME
=NEWX%:Y%=NEWY%
570 WEND
580 LOCATE 23,1
590 CLS:RUN "MENU.PGM"
20000 PRINT "error encountered";E