/* BOOT_COM - Make the boot record into a .COM file. COM files are loaded
           at location 100h. The boot record is loaded at 7C00h. To make
           up for the difference, we pad the COM file with NOP's. The first
           instruction in the COM file is a JMP 7C00.

           The boot record is taken from A:
           The output is BOOT_REC.COM
*/

#include <stdio.h>
#define BOOTLOC 0x7C00
#define COMORG  0x0100
#define JMP_DISP BOOTLOC - COMORG - 3
#define JMP_OPCODE  0xD9
#define NOP 0x90
#define NUM_NOP JMP_DISP

main ()
{
   struct regval reg;

   char  buf[512];      /* Data buffer */
   unsigned int seg;    /* Buffer segment */
   unsigned int off;    /* Buffer offset  */

   FILE *fptr;
   int  i, stat;

/* Get location of buffer */
   seg = ((unsigned long) buf >> 16);
   off = (unsigned int) buf;

/* Set up registers for BIOS call */
   reg.ax = 0;          /* Drive A:             */
   reg.cx = 1;          /* Number of sectors    */
   reg.dx = 0;          /* Logical sector number */
   reg.ds = seg;        /* Buffer address       */
   reg.bx = off;

/* Read the disk sector */
   stat = sysint (0x0025, &reg, &reg);

/* Create the output COM file. The first thing in it is a JMP 7C00. The
   space between the JMP and 7C00 is padded with NOP's */
   if (! (fptr = fopen ("a.dat", "wb")))
       {
       printf ("Unable to open output file\n");
       return;
       }

/* The JMP 7C00 */
   fputc (JMP_OPCODE, fptr);
   putw (JMP_DISP, fptr);

/* NOP's */
   for (i = 0; i < NUM_NOP; i++)
       fputc (NOP, fptr);

/* Now the boot */
   for (i = 0; i < 512; i++)
       fputc (buf[i], fptr);

   fclose (fptr);
}


