	TITLE	SPEEDKEY - CURSOR ACCELERATOR, Version 1.1
	PAGE	64,132

;			Speedkey - cursor accelerator
;
;
;	This routine supercedes BIOS kb_int and looks for
;	keyboard input every clock tick (timer_tick) thus
;	accelerating keyboard/screen I/O.
;
;	This program uses INT 27 'terminate, but stay resident'
;	and will probably conflict with a number of programs of
;	the same ilk.
;
;
cseg	segment para public 'code'

	org 100h			;let us make this a com file

iport	equ	20h
kb_data	equ	60h
kb_ctrl	equ	61h
kbdbeg	equ	001ch
kbdend	equ	001ah
kbdbuf	equ	001eh

speedkey proc	far
	assume cs:cseg,ds:cseg,es:cseg

	jmp	entry_point		;mainline program

flg	db	0ffh
cntdwn	db	00h
romvec	dw	00h

kb_int:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es
	cld
	mov	ax,cs
	mov	ds,ax
	in	al,kb_data
	push	ax
	in	al,kb_ctrl
	mov	ah,al
	or	al,80h
	out	kb_ctrl,al
	xchg	ah,al
	out	kb_ctrl,al
	pop	ax
	mov	ah,al
	call	l7
	jnz	l1
	mov	[flg],0ffh
	jmp	l2
	nop
l1:	test	al,80h
	jz	l3
	mov	[flg],al
l2:	mov	[cntdwn],05h
	mov	bx,0f000h
	push	bx
	mov	bx,[romvec]
	push	bx
	mov	bx,0040h
	mov	ds,bx
	sti
	ret
l3:	cmp	al,[flg]
	jz	l4
	mov	[flg],al
	jmp	l2
l4:	mov	al,20h
	out	iport,al
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	iret
timer_tick:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es
	mov	ax,cs
	mov	ds,ax
	cmp	[cntdwn],00h
	jnz	l5
	mov	dh,[flg]
	test	dh,80h
	jnz	l6
	mov	bx,0040h
	mov	ds,bx
	call	l7
	jz	l6
	cld
	mov	al,dh
	mov	ah,al
	mov	bx,0f000h
	push	bx
	mov	bx,0e9a8h
	push	bx
	sti
	ret
l5:	sub	[cntdwn],01h
l6:	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	iret
l7	proc
	push	ds
	push	bx
	mov	bx,0040h
	mov	ds,bx
	mov	bx,[kbdbeg]
	add	bx,2
	cmp	bx,3eh
	jnz	l8
	mov	bx,kbdbuf
l8:	cmp	bx,[kbdend]
	pop	bx
	pop	ds
	ret
l7	endp
endprg	label	byte
logo	db	'--Speedkey Version 1.01--is now installed.$'
biover1	db	'5700051'
biover2	db	'5700671'
biover3	db	'1501476'
biover4	db	'1501512'
err_msg	db	'Unsuported version of BIOS - Speedkey not installed.$'

;	program entry point
;
entry_point:
	mov	ax,0f000h
	mov	es,ax
	mov	si,offset biover1	;get first rom number
	mov	di,0e000h
	mov	[romvec],0e9a8h
	mov	cx,0007h		;compare for 7 bytes
	cld
	repz	cmpsb
	jz	main_line		;good rom so far, continue
	mov	si,offset biover2
	mov	di,0e000h
	mov	[romvec],0e9a8h
	mov	cx,0007h
	cld
	repz	cmpsb
	jz	main_line
	mov	si,offset biover3
	mov	di,0e000h
	mov	[romvec],0e9a6h
	mov	cx,0007h
	cld
	repz	cmpsb
	jz	main_line
	mov	si,offset biover4
	mov	di,0e000h
	mov	[romvec],0e9a6h
	mov	cx,0007h
	cld
	repz	cmpsb
	jz	main_line		;continue otherwise fall thru to terminate
	mov	dx,offset err_msg	;stuff wrong rom msg in dx
	mov	ah,09h			;set up dos to print
	int	21h			;let dos do it.
	int	20h			;terminate, rom number didn't match
main_line:
	mov	dx,offset kb_int	;processing routine for keyboard
	mov	ah,25h			;set interrupt vector
	mov	al,09h			;for kb_int entry
	int	21h			;let dos do it.
	cli				;clear interrupt flags
	mov	dx,offset timer_tick	;processing routine for keyboard check
	mov	ah,25h			;set interrupt vector
	mov	al,1ch			;for dummy_return entry
	int	21h			;let dos do it
	sti				;enable interrupts
	mov	dx,offset logo		;print install msg
	mov	ah,09h			;print string
	int	21h			;let dos do it
	mov	dx,offset endprg	;print install message
	int	27h			;terminate but stay resident

speedkey endp

cseg	ends

	end speedkey

