n;**************************************************************************
;	Quellenprogramm:	AUTOASK.ASM
;	Sprache:	ASSEMBLER
;	Autor:	SYROVATKA 1989
;	Lauf-Programm:	AUTOASK.COM
;	Funktion:	Kann als Verzgerung fr 1-99 Sekunden ver-
;		wendet werden und bergibt, wenn keine Ein-
;		gabe erfolgt automatisch ERRORLEVEL 0, wenn
;		N fr nein eingegeben wird ERRORLEVEL 1.
;**************************************************************************
;**************************************************************************
;	K O N S T A N T E N  ( E Q U A L S )  UND  M A K R O S
;**************************************************************************

	BEL  EQU  07h	;dez  7
	TAB  EQU  09h	;dez  9
	CR   EQU  0Dh	;dez 13
	LF   EQU  0Ah	;dez 10
	ESC  EQU  1Bh	;dez 27
	BLANK EQU 20h

BEEP	MACRO	;gibt Beep aus, kann auch als Verzgerung dienen
;	LOCAL BP3
	MOV  DL,07h	;ASCII-Zeichen BEL (7 dez)
	MOV  AH,02h	;Funktions-Nummer fr Ausgabe auf Konsole (Standard-
	INT  21h	;Ausgabe-Einheit ... kann umgeleitet werden)
;	PUSH CX 	;CX sichern
;	MOV  CX,7000h	;"Pause-Zhler" laden
;  BP3: DEC  CX 	;"Pause" auszhlen
;	LOOP BP3
;	POP  CX 	;CX restaurieren
;	MOV  DL,07h
;	MOV  AH,02h
;	INT  21h
	ENDM

;****** BEGINN DES  C O D E - SEGMENTS ************************************

CSEG	SEGMENT  PUBLIC  PARA 'CODE'    ;Definition des CODE-Segments

	ORG   100h			;jedes .COM-Programm beginnt an der
					;OFFSET-Adresse 0100h mit einem
					;ausfhrbaren Befehl

	ASSUME CS:CSEG,DS:CSEG,SS:CSEG,ES:CSEG

			;Beim Programmstart eines .COM-Programmes
			;sind alle SEGMENTREGISTER auf das CODE-
			;SEGMENT gesetzt! IP = 0100h  SP = FFFEh
			;CX = Offset Programmende, alle brigen
			;Register sind 0000h

;**************************************************************************

START	PROC	NEAR	
	NOP		;Erster ausfhrbarer Befehl fr autoask.COM
	NOP
	NOP
	JMP  INIT1

;*** DATEN  UND VARIABLE **************************************************

MELDUNG  DB CR,LF
DB	"** AUTOASK.COM - V1.0 * Syrovatka-TGM-1989 ** Programm gibt entweder nach einer",CR,LF
DB	"Tastatureingabe sofort   oder nach einer  Verzgerung von 0-99 Sek. automatisch",CR,LF
DB	"den ERRORLEVEL 0 fr J (ja) zurck,      bzw. nach Tastatureingabe von N (nein)",CR,LF
DB	"sofort den ERRORLEVEL 1 zurck **",CR,LF
DB	"AUFRUF:",CR,LF
DB	"AUTOASK Fr die voreingestellte Verzgerungszeit von 5 Sekunden!",CR,LF
DB	"AUTOASK 25 fr 25 Sek. Verzgerungszeit * ",CR,LF
DB	"AUTOASK ? bringt diesen Hilfe-Text",CR,LF,"$"

TIMER	DW  0,0 	;Zwischenspeicher fr alten USER-TIMER-INT

ZEHNER	DB  0	;Vorgegebener Wert fr Verzgerung 05 Sekunden
EINER	DB  5

DLY	DB  0
COUNT	DB  18	;Vorgabe, weil Timer-Interrupt alle 18,2 Sekunden!

ERR	DB  0

;*** PROGRAMM *************************************************************

HELP:	BEEP
	MOV  DX,OFFSET MELDUNG
	MOV  AH,09h
	INT  21h
	JMP  ENDE2

INIT1:	MOV  SI,80h	;80h = Beginn des Kommandopuffers
	MOV  AL,[SI]	;Anzahl der Zeichen im Puffer (ohne abschlieendes CR)
	CMP  AL,0	;wenn 0 keine weitere Eingabe
	JE   INIT2

	XOR  AH,AH
	ADD  SI,AX	; = letztes Zeichen im Eingabepuffer (vor CR)
	MOV  AL,[SI]
	CMP  AL,"?"     	;bei ? Helpmen aufrufen und beenden
	JE   HELP

	CMP  AL,30h	;ASCII-Zahl 0 = 30h
	JC   INIT2	;wenn CARRY - keine Zahl
	CMP  AL,40h	;ASCII-Zahl 9 = 39h
	JNC  INIT2	;wenn noch kein CARRY, dann keine Zahl
	SUB  AL,30h	;ASCII-Zahl in Dezimalwert umwandeln
	MOV  EINER,AL	;Einerstelle sichern

	DEC  SI
	MOV  AL,[SI]
	CMP  AL,30h	;ASCII-Zahl 0 = 30h
	JC   INIT2	;wenn CARRY - keine Zahl
	CMP  AL,40h	;ASCII-Zahl 9 = 39h
	JNC  INIT2	;wenn noch kein CARRY, dann keine Zahl
	SUB  AL,30h	;ASCII-Zahl in Dezimalwert umwandeln
	MOV  ZEHNER,AL	;Zehnerstelle sichern

INIT2:	MOV  AL,EINER	;Verzgerungszeit ermitteln: Fr jede
	MOV  AH,ZEHNER	;Zehnerstelle in AH werden 10 zu AL, in
IN2:	SUB  AH,1		;dem bereits die Einer stehen, addiert.
	JC   IN4
	ADD  AL,10
	JMP  IN2

IN4:	MOV  DLY,AL	;Verzgerungszeit in DLY


INIT3:	MOV  AH,35h	;Funktions-Nr.: Interrupt - Vektor feststellen
	MOV  AL,1Ch	;Interrupt-Nr.: User - Timer - Interrupt
	INT  21h		;DOS - Funktionsaufruf
			;Rckgabe des gesuchten Vektors in ES:BX

	MOV  TIMER,BX		;BX = OFFSET des Vektors
	MOV  BX,ES		;ES = SEGMENT des Vektors
	MOV  TIMER+2,BX 	;unter TIMER speichern

	MOV  DX,OFFSET DELAY	;neue Vektoradresse in DS:DX
	MOV  AH,25h		;Funktions-Nr.: Interrupt - Vektor setzen
	MOV  AL,1Ch		;Interrupt-Nr.: User - Timer - Interrupt
	INT  21h		;DOS - Funktionsaufruf

;********** ZEITSCHLEIFE ANFANG *******************************************

BEGINN: BEEP
BEG2:	MOV  AH,0Bh	;Wurde ein Zeichen ber Tastatur eingegeben?
	INT  21h		;Rckgabe:  AL = 00   kein Zeichen
	OR   AL,AL	;	AL = FF   Zeichen verfgbar
	JNZ  EINGABE
	MOV  AL,DLY
	OR   AL,AL
	JZ   EIN2
	JMP  BEG2		;Solange, bis entweder eine Eingabe erfolgt
			;oder DLY Null geworden ist.

;********** ZEITSCHLEIFE ENDE *********************************************

EINGABE:
	MOV  AH,07h	;Console Char.Input ohne Echo, Zeichen in AL
	INT  21h
	OR   AL,00100000b	;Gro- in Kleinbuchstaben umwandeln
	CMP  AL,"j"
	JE   EIN2
	CMP  AL,"n"
	JE   EIN4
	JMP  BEGINN

EIN2:	MOV  ERR,0
	JMP  SHORT ENDE

EIN4:	MOV  ERR,1
	JMP  SHORT ENDE

ENDE:			;USER-TIMER-Vektor rcksetzen und beenden
	PUSH DS 		;DS sichern
	MOV  DX,TIMER	;DX = wieder alte OFFSET-Adresse des Vektors
	MOV  BX,TIMER+2 	;als Doppelwort (DD) unter TIMER speichern
	MOV  DS,BX	;DS = wieder alte SEGMENT-Adresse des Vektors
			;alte Vektoradresse in DS:DX
	MOV  AH,25h	;Funktions-Nr.: Interrupt - Vektor setzen
	MOV  AL,1Ch	;Interrupt-Nr.: User - Timer - Interrupt
	INT  21h		;DOS - Funktionsaufruf
	POP  DS

ENDE2:	BEEP

	MOV  AL,ERR	; AL = Beendigungscode (ERRORLEVEL ERR)
	MOV  AH,4Ch	; Programm beenden
	INT  21h

;***** USER-TIMER-Interrupt Einsprung hier ********************************


DELAY:	STI		;Interrupts wieder zulassen
	PUSH DS
	PUSH CX
	PUSH CS
	POP  DS 		;da Einsprung ber INT Datensegment setzen
	MOV  CL,COUNT	;Timer-Interrupt kommt 18,2 mal pro Sekunde,
	DEC  CL		;nach 18 mal, also nach etwa 1 Sekunde ist
	JZ   DLY4		;CL und damit COUNT = Null geworden.
DLY2:	MOV  COUNT,CL
	POP  CX
	POP  DS 		;altes Datensegment wiederherstellen
	JMP  DWORD PTR CS:TIMER

DLY4:	MOV  CL,DLY
	OR   CL,CL	;ist DLY schon Null ? Wenn nicht
	JZ   DLY6
	DEC  CL		;DLY um 1 verringern und COUNT wieder
	MOV  DLY,CL
DLY6:	MOV  CL,18	;auf 18 stellen fr neuen Durchgang
	JMP  DLY2

;**************************************************************************

START	ENDP

;**************************************************************************

CSEG	ENDS

;**************************************************************************

END	START

;**************************************************************************


