                              title INTPRUEF
page 72,80
comment ?   Programm - Datei  \MASM\SOURCE\INTPRUEF.ASM

                 ********************************************
                 *                                          *
                 *             MASM Version 5.0             *
                 *                                          *
                 *            PROGRAMM INTPRUEF             *
                 *                                          *
                 *     Copyright (c) by Christoph Ferstl    *
                 *                                          *
                 ********************************************



 Programm zur berprfung der Interruptvektortabelle. Wird das Programm zum
 erstenmal gestartet, so wird die gesamte Vektortabelle erfat und in der Datei
 INT_TAB.DAT gespeichert. Kann die Datei nicht erstellt oder geffnet werden,
 wird dies durch eine Fehlermeldung angezeigt. Bei Wiederaufruf wird die
 aktuelle Vektortabelle mit der alten Tabelle in INT_TAB.DAT verglichen und auf
 Fehler in der bereinstimmung geprft. Die Datei mu dabei im selben
 Unterverzeichnis stehen, wie das Programm INTPRUEF.COM . Sollten sich Vektoren
 verndert haben, so werden sie am Bildschirm dargestellt. Weiters wird bei
? Vernderungen abgefragt, ob die Datei INT_TAB.DAT aktualisiert werden soll.
;
code segment
     org 100h
     assume cs:code,ds:code
;
public start
start:             jmp anfang
;
LF             equ  0Ah
CR             equ  0Dh
;
int_tab        db 'INT_TAB.DAT',0
Fehlertext_1   db CR,LF,CR,LF,'Kein Zugriff mglich (Disk vermutlich voll) !',CR,LF,'$'
Fehlertext_2   db CR,LF,CR,LF,'Zu viele Dateien geffnet !',CR,LF,'$'
Ueberschrift   db CR,LF,'          PRFUNG DER INTERRUPTVEKTORTABELLE',CR,LF,'$'
Text           db CR,LF,'   Interrupt   Bestand    Segment:Offset  Vergleich','$'
Meldung_1      db CR,LF,CR,LF,'Aktuelle Vektortabelle in Int_tab.dat gespeichert !','$'
Meldung_2      db CR,LF,CR,LF,CR,LF,'In der Vektortabelle sind keine Vernderungen aufgetreten!','$'
Meldung_3      db 'OK$'
Meldung_4      db 'UNGLEICH$'
Meldung_5      db CR,LF,'Die Datei Int_tab.dat wurde geschlossen.',CR,LF,'$'
Frage_1        db CR,LF,CR,LF,CR,LF,'Soll die aktuelle Vektortabelle abgespeichert werden ?','$'
Neu            db 'neu =>$'
Alt            db 'alt =>$'
Int_num        db 1 dup (0)
Int_seg        dw ?
Int_off        dw ?
Handle         dw ?
Vmodus         db ?
Bseite         db ?
Zeile          db 1 dup (5)
Spalte         db ?
Zeichen        db ?
Schalter       dB 1 dup (0)
Schleife       dw ?
Vek_add_puf    dw 512 dup (0)
;
;
Int_tab_erstellen  proc
                   mov ah,5bh                ;Funktion Datei erstellen
                   mov cx,00                 ;Dateiattribut / 0 = normal
                   lea dx,Int_tab            ;Offset des Dateinamens bergeben
                   int 21h
                   jnc OK1                   ;wenn CF=0 wurde Datei erstellt
                   cmp ax,5                  ;wenn CF=1/Fehlercode 5 =>
                   jz Fehler1                ;Zugriff verweigert (Disk voll)
                   cmp ax,80                 ;wenn CF=1/Fehlercode 80 =>
                                             ;          Datei existiert bereits
                   mov Schalter,1            ;Schalter setzen: Datei existiert
                   jz Int_tab_oeffnen        ;Datei Int_tab ffnen
             OK1:  mov Handle,ax             ;sichern des Dateihandles
                   ret
Int_tab_erstellen  endp
;
Vek_add_schreiben  proc                      ;schreiben in die Datei Int_tab
                   mov ah,40h                ;Funktion Datei schreiben
                   mov bx,Handle             ;Dateihandle bergeben
                   mov cx,400h               ;Anzahl der zu schreibenden Bytes
                   lea dx,Vek_add_puf        ;Offset d. Schreibpuffers bergeben
                   int 21h
                   cmp ax,0                  ;wenn ax = 0:Disk voll
                   jnz OK3
                   cmp ax,400h               ;wenn ax < 400h:Disk voll
                   jz OK3
                   call Int_tab_loeschen     ;Datei Int_tab lschen
                   call Fehler1              ;Zugriff verweigert (Disk voll)
              OK3: ret
Vek_add_schreiben  endp
;
Fehler1            proc                      ;Fehler: Zugriff verweigert
                   lea dx,Fehlertext_1
                   call String_ausgabe
                   jmp Fin                   ;Programm beenden
                   ret
Fehler1            endp
;
Fehler2            proc                      ;Fehler: Zu viele Dateien geffnet
                   lea dx,Fehlertext_2
                   call String_ausgabe
                   jmp Fin                   ;Programm beenden
                   ret
Fehler2            endp
;
Int_tab_loeschen   proc
                   mov ah,41h                ;Funktion Datei lschen
                   lea dx,Int_tab            ;Offset des Dateinames bergeben
                   int 21h
                   ret
Int_tab_loeschen   endp
;
Int_tab_oeffnen    proc
                   mov ah,3dh                ;Funktion Datei ffnen
                   lea dx,Int_tab            ;Offset des Dateinamens bergeben
                   mov al,02                 ;Schreib- und Lesezugriff
                   int 21h
                   jnc OK2                   ;wenn CF=0 wurde Datei geffnet
                   cmp ax,4                  ;wenn CF=1/Fehlercode 4 => zuviele
                   jz Fehler2                ;                 Dateien geffnet
             OK2:  mov handle,ax             ;sichern des Dateihandles
                   ret
Int_tab_oeffnen    endp
;
Int_tab_schlieszen proc
                   mov ah,3eh                ;Funktion Datei schlieen
                   mov bx,Handle             ;Dateihandle bergeben
                   int 21h
                   ret
Int_tab_schlieszen endp
;
Int_tab_schreiben  proc                      ;Vek_add_puf mit Adressen laden
                   mov cx,100h               ;Schleifenzhler auf 256 setzen
        Puf_laden: xor ax,ax                 ;ax-Register lschen
                   mov al,Int_num            ;al mit laufender Int_num laden
                   push cx                   ;sichern des Schleifenzhlers
                   mov cl,2
                   sal ax,cl                 ;Displacement: 4 * Int_num
                   mov di,ax                 ;Index setzen
                   call Vek_add_holen        ;Int_add aus Speicher holen
                   mov ax,Int_off
                   mov Vek_add_puf[di],ax    ;Offset bertragen
                   mov ax,Int_seg
                   mov Vek_add_puf[di]+2,ax  ;Segment bertragen
                   inc Int_num               ;nchste Interruptnummer festlegen
                   pop cx                    ;Schleifenzhler vom Stack holen
                   loop Puf_laden            ;solange cx > 0:Sprung
                                             ;Vek_add in Int_tab schreiben
                   call Vek_add_schreiben    ;Vek_add_puf auf Disk schreiben
                   ret
Int_tab_schreiben  endp
;
Vek_add_holen      proc                      ;aus aktueller Tabelle im Speicher
                   mov ah,35h                ;Funktion Interruptadresse lesen
                   mov al,Int_num            ;Interruptnummer bergeben
                   int 21h
                   mov Int_seg,es            ;Segment des Interrupts festhalten
                   mov Int_off,bx            ;Offset des Interrupts festhalten
                   ret
Vek_add_holen      endp
;
Vek_add_lesen      proc                      ;aus der Datei Int_tab
                   mov ah,3fh                ;Funktion Datei lesen
                   mov bx,Handle             ;Dateihandle bergeben
                   mov cx,400h               ;Anzahl der zu lesenden Bytes
                   lea dx,Vek_add_puf        ;Offset des Lesepuffers bergeben
                   int 21h
                   ret
Vek_add_lesen      endp
;
String_ausgabe     proc
                   mov ah,9                  ;Funktion: Ausgabe eines Strings
                   int 21h
                   ret
String_ausgabe     endp
;
Zeichen_ausgabe    proc
                   push cx                   ;alten Schleifenzhler sichern
                   push dx                   ;dx-Register sichern
                   mov cl,4                  ;Vorbereitung f. 4 bit-Verschiebung
                   mov bl,2                  ;neuen Schleifenzhler setzen
                   rol dl,cl                 ;vertauschen v.unteren 4 mit oberen
           Loop_1: and dl,0fh                ;auszugebende Hexziffer isolieren
                   cmp dl,9                  ;Vergleich mit 9
                   jbe kleiner_gleich_9      ;wenn Zahl kleiner/gleich 9: Sprung
                   add dl,37h                ;Ascii-Zeichen A-F vorbereiten
                   jmp weiter
 kleiner_gleich_9: add dl,30h                ;Ascii_Zeichen 0-9 vorbereiten
           weiter: mov ah,02                 ;Funktion Zeichen ausgeben
                   int 21h
                   pop dx                    ;dx v.Stack holen f.nchste Hexzif.
                   push dx
                   dec bl                    ;Schleifenzhler um 1 erniedrigen
                   jnz Loop_1                ;Sprung,solange bis dl = 0
                   pop dx                    ;dx-Register vom Stack holen
                   pop cx                    ;alt. Schleifenzhler v.Stack holen
                   ret
Zeichen_ausgabe    endp
;
Zeichen_eingabe    proc
                   mov ah,01                 ;Funktion Zeicheneingabe
                   int 21h
                   mov Zeichen,al            ;Ascii-Wert in Zeichen bergeben
                   ret
Zeichen_eingabe    endp
;
Alt_ausgabe        proc
                   add Zeile,1               ;Cursor in die nchste Zeile
                   mov Spalte,17             ;Cursor unter 'Bestand' setzen
                   call Cursor_position
                   lea dx,Alt                ;Ausgabe von 'alt'
                   call String_ausgabe
                   mov Spalte,27             ;Cursor unter 'Segment' setzen
                   call Cursor_position
                   mov dl,byte ptr Vek_add_puf[di]+3 ;altes Segment ausgeben
                   call Zeichen_ausgabe
                   mov dl,byte ptr Vek_add_puf[di]+2
                   call Zeichen_ausgabe
                   mov Spalte,35             ;Cursor unter 'Offset' setzen
                   call Cursor_position
                   mov dl,byte ptr Vek_add_puf[di]+1 ;alten Offset ausgeben
                   call Zeichen_ausgabe
                   mov dl,byte ptr Vek_add_puf[di]
                   call Zeichen_ausgabe
                   sub Zeile,1
                   ret
Alt_ausgabe        endp
;
Videomodus         proc
                   mov ah,0fh                ;Bestimmung des Videomodus
                   int 10h
                   mov Vmodus,al             ;Videomodus festhalten
                   mov Bseite,bh             ;akt. Bildschirmseite festhalten
                   ret
Videomodus         endp
;
Bloesch            proc
                   mov ah,00                 ;Bild lschen d. Videom. setzen
                   mov al,Vmodus             ;Videomodus bergeben
                   int 10h
                   ret
Bloesch            endp
;
Cursor_position    proc
                   mov ah,02                 ;Funktion Cursor positionieren
                   mov bh,Bseite             ;Nummer d.aktuellen Bildschirmseite
                   mov dh,Zeile              ;Zeilennummer bergeben
                   mov dl,Spalte             ;Spaltennummer bergeben
                   int 10h
                   ret
Cursor_position    endp
;
Curs_pos_bestimmen proc
                   mov ah,03                 ;Funktion Cursorposition bestimmen
                   mov bh,Bseite             ;Nummer d.aktuellen Bildschirmseite
                   int 10h
                   mov Zeile,dh              ;Ausgabe der aktuellen Zeilennummer
                   mov Spalte,dl             ;Ausgabe d. akt.  Spaltenposition
                   ret
Curs_pos_bestimmen endp
;
;
Anfang:            call Int_tab_erstellen    ;Datei Int_tab erstellen
                                             ;wenn vorhanden: ffnen
                                             ;wenn nicht vorh.:erstellen+ffnen
                   cmp Schalter,1            ;Prfung ob Int_tab vorhanden
                   jz Vergleich              ;Sprung zu Vergleich
;
                   call Int_tab_schreiben    ;aktuelle Vektortabelle schreiben
;
                   lea dx,Meldung_1          ;Adresse von Meldung_1 bergeben
                   call String_ausgabe       ;Meldung_1 ausgeben
                   jmp Ende                  ;Programm beenden
;
                                             ;Bildschirmaufbau
        Vergleich: mov Schalter,0            ;Schalter rcksetzen
                   call Videomodus           ;Vmodus und Bseite feststellen
                   call Bloesch              ;Bildschirm lschen
                   lea dx,Ueberschrift       ;Programmtitel ausgeben
                   call String_ausgabe
                   lea dx,Text               ;Textzeile ausgeben
                   call String_ausgabe
;
                   call Vek_add_lesen        ;Adressen von Int_tab in d.Puffer
;
                   mov cx,100h               ;Schleifenregister initialisieren
;
           Loop_2:                           ;Ausgabe der Interruptnummer
                   mov Spalte,7              ;Cursor unter 'Interrupt' setzen
                   call Cursor_position
                   mov dl,Int_num            ;Interruptnummer ins dl-Register
                   call Zeichen_ausgabe      ;Ausgabe der Interruptnummer
;
                   mov Spalte,17             ;Cursor unter 'Bestand' setzen
                   call Cursor_position
                   lea dx,Neu                ;Ausgabe von 'neu'
                   call String_ausgabe

                                             ;Ausgabe des neuen Segments
                   mov Spalte,27             ;Cursor unter 'Segment' setzen
                   call Cursor_position
;
                   call Vek_add_holen        ;Vek_add aus Speicher bestimmen
                   mov dl,byte ptr Int_seg+1 ;hherwertige Byte v.Seg.vorbereit.
                   call Zeichen_ausgabe      ;Ausgabe des hherwertigen Bytes
                   mov dl,byte ptr Int_seg   ;niederwertiges Byte vorbereiten
                   call Zeichen_ausgabe      ;niederwertiges Byte ausgeben
;
                                             ;Ausgabe des neuen Offsets
                   mov Spalte,35             ;Cursor unter 'Offset' setzen
                   call Cursor_position
                   mov dl,byte ptr Int_off+1 ;hherwertiges Byte v.Offset vorbe.
                   call Zeichen_ausgabe      ;Ausgabe des hherwertigen Bytes
                   mov dl,byte ptr Int_off   ;niederwertiges Byte vorbereiten
                   call Zeichen_ausgabe      ;Ausgabe des niederwertigen Bytes
;
                                             ;Vergleich durchfhren
                   xor ax,ax                 ;ax-Register auf 0 setzen
                   mov al,Int_num            ;Interruptnummer bergeben
                   push cx                   ;Schleifenzhler sichern
                   mov cl,2
                   sal ax,cl                 ;Displacement: 4 * Int_num
                   mov di,ax                 ;Displacement setzen
                   jmp Bruecke
;
            Hilfe: jmp loop_2
;
          Bruecke: call Alt_ausgabe          ;Ausgabe von 'alt' mit Seg+Off
                                             ;Vergleich durchfhren
                   mov ax,Int_seg            ;Int_seg vom Speicher laden
                   cmp ax,Vek_add_puf[di]+2  ;Vergleich mit Int_seg aus Int_tab
                   jnz Ungleich              ;wenn nicht gleich: Sprung
                   mov ax,Int_off            ;Int_off vom Speicher laden
                   cmp ax,Vek_add_puf[di]    ;Vergleich mit Int_off aus Int_tab
                   jnz Ungleich              ;wenn nicht gleich: Sprung
;
                   mov Spalte,45             ;Cursor unter 'Status' setzen
                   call Cursor_position
                   lea dx,Meldung_3          ;Meldung_3 bergeben
                   call String_ausgabe       ;Meldung_3 ausgeben
                   jmp short Neuer
;
         Ungleich: mov Schalter,1            ;wenn ungleich  => Frage
                   mov Spalte,43
                   call Cursor_position
                   lea dx,Meldung_4          ;Meldung_4 bergeben
                   call String_ausgabe       ;Meldung_4 ausgeben
                   add Zeile,2               ;Zeilenvariable um 2 erhhen
            Neuer: pop cx                    ;Schleifenzhler vom Stack holen
                   inc Int_num               ;nchster Interrupt
                   loop Hilfe
;
            Frage: cmp Schalter,1            ;Vergleich, ob Schalter gesetzt
                   jnz Alles_klar            ;wenn cx = 0: Frage ausgeben
                   lea dx,Frage_1            ;Offset von Frage bergeben
                   call String_ausgabe
                   call curs_pos_bestimmen   ;aktuelle Cursorposition bestimmen
                   inc Spalte                ;Cursor um 1 nach rechts
                   call Cursor_position      ;Cursor auf Eingabeplatz
                   call Zeichen_eingabe      ;J/N eingeben
                   cmp Zeichen,'j'           ;Vergleich mit 'j'
                   jz Ueberschreiben         ;wenn 'j':Sprung zu Int_tab schrei.
                   cmp Zeichen,'J'           ;Vergleich mit 'J'
                   jz Ueberschreiben         ;wenn 'J':Sprung zu Int_tab schrei.
                   jmp Ende                  ;wenn nicht: Programm beenden
;
       Alles_klar: lea dx,Meldung_2          ;Meldung_2 bergeben
                   call String_ausgabe       ;Ausgabe von Meldung_2
                   jmp short Ende            ;Programm beenden
;
   Ueberschreiben: call Int_tab_schlieszen   ;Int_tab schlieen
                   call Int_tab_oeffnen      ;Int_tab ffnen
                   mov Int_num,0             ;Interruptnummer auf Beginn stellen
                   call Int_tab_schreiben    ;aktuelle Vektortabelle schreiben
;
Ende:              call Int_tab_schlieszen   ;Int_tab schlieen
                   lea dx,Meldung_5          ;Meldung_5 ausgeben
                   call String_ausgabe
              Fin: mov ah,4ch
                   int 21h
;
code ends
     end start
