         TITLE    'SKC.ASM: SideKick einstellen: 15 k / 45 k, invers / normal'
; Aufruf mit SKC pq, wobei die Parameter p und q sein knnen:
;        i oder n, - oder + (invers oder normal, klein 15 k oder gro 45 k)
CodeSeg  SEGMENT  PARA PUBLIC 'Code'
         ASSUME   CS:CodeSeg,SS:CodeSeg
         ASSUME   DS: CodeSeg,ES:CodeSeg
         ORG      100h
Begin:   JMP      Start
DatNam   DB       'SK.COM'   ; Name der Zieldatei auf dem aktuellen Laufwerk
Displ    DW       0          ; Displacement fr Dateizeiger
KdoZLng  DB       0          ; Lnge der Kommandozeile
Kdo      DW       0          ; Adresse des Kommandos
Codes    DB       'IN'       ; Codezeichen in Kommandozeile
         DB       0Bh        ; "+" nach Bitlschen
         DB       0Dh        ; "-" nach Bitlschen
Schalter DB       0          ; Bit 7 = I, 6 = N, 5 = -, 4 = +
TabAktu  DW       0          ; zum Sichern der Adresse der aktuellen Tabelle
SKSize   DB       0          ; Sektor
         DB       51         ; Displacement
SKSizeL  DB       2          ; Anzahl Bytes
SK15k    DB       98h,3Ah    ; Inhalt fr 15 k
SK45k    DB       50h,0C3h   ;        fr 45 k
SKColors DB       16         ; Sektor
         DB       102        ; Displacement
SKColoL  DB       33         ; Anzahl Bytes ( = Pufferlnge )
SKInvers DB       70h,60h,0,0,60h,0Fh,0,0,0,70h,60h,0Fh,0,0,0,70h,60h,0Fh
         DB       0,0,0,0,60h,0Fh,70h,60h,0Fh,0,75h,0Fh,70h,60h,0Fh
                  ; 0 = unverndert
SKNormal DB       7Fh,70h,0,0,75h,7Fh,0,0,0,06h,70h,70h,0,0,0,06h,70h,70h
         DB       0,0,0,0,06h,70h,06h,70h,70h,0,06h,06h,06h,70h,70h
Handle   DW       0          ; Dateinummer (File Handle)
FehlMdg  DB       10,13,'SK.COM nicht da oder schreibgeschtzt',10,13,"$"
;
Start:   CALL     OpenSK     ; SK.COM erffnen
         CALL     KdoZUpCase ; Kommandozeile in Grobuchstaben umsetzen
         CALL     Analyse    ; Kommandozeile analysieren
         CALL     Patch      ; SK.COM patchen
         JMP      CloseSK
;
OpenSK:  ; SK.COM im aktuellen Pfad erffnen
         MOV      CX,0       ; Dateiattribut 0 (keine besonderen Attribute)
         LEA      DX,DatNam  ; Dateiname
         MOV      AH,3Dh     ; Xenix-orientiertes Erffnen eines Zugriffspfads
         MOV      AL,2       ; erffnen fr Schreiben und Lesen
         INT      21h        ; Funktion ausfhren
         JC       Fehler     ; Wenn Erffnen nicht mglich (sonst CF=0)
         MOV      Handle,AX  ; Dateinummer (Handle) sichern
         RET
Fehler:  LEA      DX,FehlMdg
         MOV      AH,9
         INT      21h
         JMP      Exit
;
KdoZUpCase:    ; Kommandozeile in Grobuchstaben umsetzen
         XOR      CH,CH
         MOV      CL,CS:80h  ; Kdo-Zeilenlnge steht auf PSP+80h
         MOV      KdoZLng,CL ; Lnge sichern
         MOV      DI,81h     ; Adresse erstes Byte der Kommandozeile
         MOV      Kdo,DI     ; sichern
KdoZU0:  AND      BYTE PTR [DI],0DFh   ; Bit 5 lschen
         INC      DI
         LOOP     KdoZU0
         RET
;
Analyse: MOV      DI,OFFSET Codes
         MOV      SI,OFFSET Schalter
         MOV      CX,4       ; 4 mgliche Codes
         MOV      AH,80h     ; Bitcode fr Code "L"
         PUSH     CS
         POP      ES
Ana0:    MOV      AL,[DI]    ; Codebuchstaben laden
         PUSH     CX
         PUSH     DI
         MOV      CL,KdoZLng ; Lnge der Kommandozeile
         MOV      DI,Kdo     ; Adresse des Kommandos
         XOR      CH,CH      ; Nullsetzen
         REPNE SCASB         ; nach Codebuchstaben durchsuchen
         JNZ      AnaLoop    ; wenn nicht gefunden: Schleife fortsetzen
         OR       Schalter,AH ; wenn gefunden: Schalterbit setzen
AnaLoop: SHR      AH,1       ; Schaltermuster fr nchsten Code
         POP      DI
         INC      DI         ; nchster Code
         POP      CX
         LOOP     Ana0
         RET
;
Patch:   TEST     Schalter,0C0h  ; I oder N gesetzt ?
         JZ       PatchLS        ; keines gesetzt
         LEA      SI,SKColors    ; eines gesetzt: Parameter fr Sektor lesen
         MOV      TabAktu,SI     ; Tabellenadresse sichern
         MOV      BL,[SI+2]      ; Lnge der Tabelle
         CALL     Read           ; Sektor lesen
         TEST     Schalter,80h   ; I gesetzt ?
         JZ       PatN           ; nein, also N gesetzt
         LEA      DI,SKInvers    ; Bytetabelle fr Invers
         AND      Schalter,3Fh   ; Bits 7 und 6 lschen
PatCall: CALL     Einsetz        ; Bytes aus Tabelle einsetzen
         CALL     Write          ; Sektor zurckschreiben
         JMP      Patch          ; nochmals anfangen fr Bits 5 und 4
PatN:    LEA      DI,SKNormal    ; Bytetabelle fr Normal
         AND      Schalter,3Fh   ; Bits 7 und 6 lschen
         JMP      PatCall
PatchLS: TEST     Schalter,30h   ; + oder - gesetzt ?
         JZ       PatchEx        ; keines gesetzt: keine Vernderung
         LEA      SI,SKSize      ; eines gesetzt: Parameter fr Sektor lesen
         MOV      TabAktu,SI     ; Tabellenadresse sichern
         MOV      BL,[SI+2]      ; Lnge der Tabelle
         CALL     READ           ; Sektor lesen
         TEST     Schalter,20h   ; + gesetzt ?
         JZ       PatS           ; nein, also - gesetzt
         LEA      DI,SK45k       ; Bytetabelle fr 45 k
         AND      Schalter,0CFh  ; Bits 5 und 4 lschen
         JMP      PatCall
PatS:    LEA      DI,SK15k       ; Bytetabelle fr 15 k
         AND      Schalter,0CFh  ; Bits 5 und 4 lschen
         JMP      PatCall
PatchEx: RET
;
Read:    MOV      AX,512         ; Sektorgre
         XOR      CX,CX
         MOV      SI,TabAktu     ; Tabellenadresse holen
         MUL      WORD PTR [SI]  ; Multiplikator = Sektornummer
         PUSH     BX
         MOV      BL,[SI+1]      ; Displacement
         XOR      BH,BH
         ADD      AX,BX          ; Displacement dazu
         PUSH     CX
         PUSH     AX
         POP      DX
         POP      CX             ; CX:DX = Offset fr Logical Seek-Funktion
         MOV      Displ,DX       ; Offset fr spteres Write sichern
         CALL     LSeek          ; Dateizeiger stellen
         MOV      AH,3Fh         ; Lesen von Zugriffspfad
         MOV      BX,Handle      ; Dateinummer
         XOR      CX,CX
         MOV      SI,TabAktu     ; Tabellenadresse holen
         MOV      CL,[SI+2]      ; Anzahl zu lesender Bytes
         LEA      DX,Puffer      ; Adresse des Datenpuffers
         INT      21h
         POP      BX
         RET
;
LSeek:   MOV      AH,42h         ; Logical Seek
         MOV      AL,0           ; Zeiger auf Dateianfang + Offset
         MOV      BX,Handle
         INT      21h
         RET
;
Einsetz: ; Bytes laut Tabelle einsetzen
         MOV      CL,BL          ; Anzahl Bytes
         XOR      CH,CH
         LEA      SI,Puffer
Eins0:   CMP      BYTE PTR [DI],0 ; Eintragen ntig ?
         JE       Eins1          ; nein
         MOV      AL,[DI]
         MOV      BYTE PTR [SI],AL ; ja: Byte einsetzen
Eins1:   INC      DI             ; nchstes Byte in Tabelle
         INC      SI             ; nchstes Byte im Puffer
         LOOP     Eins0
         RET
;
Write:   MOV      DX,Displ   ; Displacement wieder holen
         CALL     LSeek      ; Dateizeiger einstellen
         MOV      BX,Handle  ; Dateinummer (File-Handle) nach BX
         XOR      CH,CH
         MOV      SI,TabAktu ; Tabellenadresse holen
         MOV      CL,[SI+2]  ; Pufferlnge (=Anzahl zu schreibender Bytes)
         LEA      DX,Puffer
         MOV      AH,40h     ; Funktion Schreiben auf Zugriffspfad
         INT      21h        ; ausfhren
         RET
;
CloseSK: MOV      AH,3Eh     ; Funktion Schlieen eines Zugriffspfads
         MOV      BX,Handle
         INT      21h
Exit:    MOV      AH,4Ch
         INT      21h
;
Puffer   EQU      $          ; Dateipuffer
;
CodeSeg  ENDS
         END      Begin

