title   DRUCKER PUFFER FR IBM PC's
        page 66,80

        dos     equ 21h                    ; DOS Interrupt
        intr    equ 16h                    ; Keyboard interrupt
        print   equ 17h                    ; BIOS Drucker I/O
        printer equ 0                      ; erster Drucker

comment *

        DOS Drucker-Puffer mit  64 kByte als Pufferspeicher

        *

        d0      segment para 'data'             ; 1. Datensegment
                buf0    dw 4000h dup (?)
        d0      ends

        d1      segment byte 'data'             ; 2. Datensegment
                buf1    dw 4000h dup (?)
        d1      ends

c               segment para 'code'             ; Programm-Segment
                assume  cs:    c, ds:c

                org     100h

pr_buf          proc far
                sti                             ; Setzen des Interrupt-Flags
                push    ds                      ; Register sichern
                push    bx
                push    dx
                push    ax
                pushf
                mov     ax,cs                   ; Datensegment holen
                mov     ds,ax
                mov     bx,[pi]
                cmp     bx,[pp]                 ; Ist etwas zu drucken ?
                je      no_print                ; Nein - weiter mit Interrupt
                                                ; chain
                mov     ah,2
                mov     dx, [printer]           ; Drucker-Status  holen
                pushf
                call    ds:[pr_intr]            ; BIOS Routine aufrufen
                test    ah,80h                  ; Drucker bereit ?
                jz      no_print                ; Nein
                push    ds
                mov     ds,cs:[d_seg]           ; Datensegment holen
                mov     al,[bx]                 ; Character holen
                pop     ds
                xor     ah,ah                   ; Kommando um ein Zeichen zu
                                                ; drucken
                mov     dx,printer              ; Drucker-Nummer holen
                pushf                           ; Datenregister sichern
                call    ds:  [pr_intr]
                inc     bx
                mov     [pi],bx
no_print:
                popf
                pop     ax
                test    ah,ah                   ; Hole Tastatur-Kommando ?
                jnz     l1                      ; Nein - Rufe BIOS-Routine
;
l0:
                mov     ah,1                    ; Warten auf einen Character
                int     intr                    ; Aufruf der Intr-routine
                jz      l0
                xor     ah,ah
l1:
                pop     dx
                pop     bx
                pop     ds
                jmp     cs:[key_intr]           ; Aufruf der BIOS-Routine
pr_buf          endp

pr_irq          proc    near
                push    ds
                push    bx
                push    dx                      ; Registers abspeichern
                push    ax
                test    ah,ah
                jz      pr_buf0                 ; Ist ein zeichen zu drucken ?
                pop     ax
                mov     ah,90h                  ; Das aufrufende Programm erhlt
                                                ; Signal "Drucker fertig"
                jmp     short cont0
pr_buf0:
                mov     bx,cs
                mov     ds,bx                   ; Datensegment holen
                mov     bx, [pp]                ; Zeiger des Druckerpuffers
                                                ; holen
                push    ds
                mov     ds,cs:[d_seg]           ; Puffersegment holen
                mov     [bx],al                 ; Speichere Byte
                pop     ds
                inc     bx                      ; Erhhe Puffer um 1
                mov     [pp],bx                 ; Wenn 64k erledigt sind ,
                                                ; BX wird geteilt durch 0
                pop     ax
                mov     ah,90h                  ; Das aufrufende Programm erhlt
                                                ; Signal "Alles in Ordnung"
cont0:
                pop     dx
                pop     bx                      ; Register zurckholen
                pop     ds
                iret                            ; Return from interrupt
pr_irq          endp

                pp       dw 0
                pi       dw 0
                key_intr dd ?
                pr_intr  dd ?
                d_seg    dw ?
;
start           proc    near
                mov     ax,cs
                mov     ds,ax
                mov     ax,35h shl 8+intr       ; Hole alten Keyboard Vector
                int     dos
                cmp     bx,offset pr_buf        ; Puffer bereits installiert ?
                jnz     not_inst                ; Nein
                mov     ah,9
                mov     dx,offset mess          ; Print Fehlermeldung
                int     dos
                mov     ah,1                    ; Hole Tastatureingabe
                int     dos
                or      al,20h                  ; Umwandeln in Grobuchstaben
                cmp     al,"j"                  ; Pufferspeicher lschen ?
                jne     no_clear                ; Nein
                xor     ax,ax
                mov     es:[pp],ax              ; Pointer zurcksetzen
                mov     es:[pi],ax
                mov     es,es:[d_seg]           ; Puffersegment holen
                mov     cx,length buf0*2        ; Pufferlnge in words
                mov     di,ax                   ; Start-Adresse
                rep     stosw                   ; Puffer lschen
no_clear:
                mov     ax,4c00h                ; Abbruch des Programmes mit
                                                ; MS-DOS Call
                int     dos
not_inst:
                mov     word ptr [key_intr],bx  ; Sichern fr die Interruptkette
                mov     word ptr [key_intr+2],es
                mov     dx,offset pr_buf
                mov     ax,25h shl 8+intr       ; Neuen Tastaturvektor setzen
                int     dos
                mov     ax,35h shl 8+print      ; Alten Drucker-I/0-Interr.-
                                                ; Vektor sichern
                int     dos
                mov     word ptr [pr_intr],bx   ; Sichere alten 17h Vektor
                mov     word ptr [pr_intr+2],es
                mov     dx, offset pr_irq
                mov     ax,25h shl 8+print      ; Neuen Drucker-I/0-Interr.-
                                                ; Vektor setzen
                int     dos
                xor     ax,ax
                mov     word ptr [pi],ax        ; Zhler lschen
                mov     word ptr [pp],ax
                mov     ax,d0
                mov     [d_seg],ax              ; Puffer Segment Adresse lagern
                mov     es,ax
                xor     ax,ax
                mov     di,ax                   ; Start bei 0
                mov     cx,length buf0*2        ; 32768 words zu lschen
                push    cx
                rep     stosw
;
                mov     dx,offset m             ; Drucker Begrungsbotschaft
                mov     ah,9
                int     dos
                mov     dx,1000h                ; Puffer Gre (64k) in
                                                ; Abschnitten
                mov     bx,100h                 ; Berechne Programmgre
                add     bx,offset start
                mov     cl,4
                shr     bx,cl                   ; In Abschnitte umwandeln
                add     dx,bx
                inc     dx
                mov     ax,3100h                ; DOS - Resident Aufruf
                int     dos
                start   endp
                mess    db 13,10,"Drucker-Puffer bereits installiert!",13,10
                        db "Drucker-Puffer lschen (j/n)? $"
                m       db 13,10, "Drucker-Puffer ist jetzt fertig installiert."
                        db " Druckerdaten werden in 64 kByte"
                        db 13,10, "des Systemspeichers gepuffert.",13,10,"$"
c               ends

            end start
