REM **************** Programm: ACHSEN UND WELLEN *****************************
REM ********** geschrieben in TURBO-BASIC im Juli 1988 ***********************
REM ******* von Abt.Vorst. OStR. Dipl.-Ing. Wilhelm Junker *******************

SUB KOPFZEILE
LPRINT CHR$(27);"E"
LPRINT "******************************************************************************
LPRINT "              ABTEILUNG FR MASCHINENBAU-AUTOMATISIERUNGSTECHNIK
LPRINT "                 ABTEILUNSVORSTAND: Dipl.Ing. Wilhelm JUNKER
LPRINT "******************************************************************************
LPRINT: LPRINT
LPRINT TAB(35) "PROGRAMM"
LPRINT TAB(30); CHR$(27);"-"; CHR$(1);
LPRINT "ACHSEN UND WELLEN";
LPRINT CHR$(27);"-";CHR$(0)
LPRINT CHR$(27);"F"
LPRINT: LPRINT: LPRINT
END SUB

SUB GROESSENFAKTOREN (GR)
SCREEN 0
CLS: COLOR 0,3
AA$="   TABELLE DER GRSSENFAKTOREN  GR   "
Z=9: CALL EINMITTEN (A,Z,AA$)
COLOR 13,0: PRINT: PRINT
PRINT "d   =   10      20       40       60       80       100       200       300   mm
PRINT
COLOR 11: PRINT "B0  =";: COLOR 6: PRINT "   1.0     0.94     0.88     0.85     0.82     0.80      0.75      0.70
COLOR 2: LOCATE 22: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 23,1
INPUT "Bitte GRSSENFAKTOR (ev. geschtzt) eingeben (Hauptwert: 0.9)  ! ", GR
IF GR=0 THEN GR=.9
LOCATE 22: PRINT SPACE$(80)
END SUB

SUB OBERFLFAKTOR (OBFL)
SCREEN 0
CLS: COLOR 0,3
AA$="TABELLE DER  O B E R F L  C H E N E I N F L U S S F A K T O R E N   BS  "
Z=1: CALL EINMITTEN (A,Z,AA$)
PRINT : COLOR 14,0: LOCATE 3,26: PRINT "fr bearbeitete ,blanke Wellen
COLOR 3: PRINT : PRINT "Rauhtiefe RT =   1    2    4    6    8    10   20   40   60   80  100  200  " ; CHR$(230); "m"
COLOR 1 :PRINT "                poliert         geschlichtet       geschruppt"
PRINT "                       geschliffen      feingedreht    grob geschruppt
COLOR 5: PRINT CHR$(229); "B = 400 N/mm2";: COLOR 7: PRINT "  1.0  .99  .97  .96  .95  .94  .91  .88  .87  .85  .83  .79
COLOR 5: PRINT CHR$(229); "B = 600 N/mm2";: COLOR 7: PRINT "  1.0  .97  .95  .93  .92  .90  .86  .82  .79  .77  .76  .71
COLOR 5: PRINT CHR$(229); "B = 800 N/mm2";: COLOR 7: PRINT "  1.0  .96  .94  .91  .88  .87  .82  .76  .73  .70  .67  .61
COLOR 5: PRINT CHR$(229); "B =1000 N/mm2";: COLOR 7: PRINT "  1.0  .96  .93  .90  .87  .85  .79  .72  .67  .64  .62  .53
COLOR 5: PRINT CHR$(229); "B =1200 N/mm2";: COLOR 7: PRINT "  1.0  .95  .91  .88  .85  .83  .76  .68  .63  .59  .56  .46
PRINT
COLOR 14: LOCATE ,26: PRINT "fr rohe und korrodierte Wellen
PRINT : COLOR 3: PRINT "               mit Walzhaut | in Swasser korrodiert | in Salzwasser korrodiert
COLOR 5: PRINT CHR$(229); "B = 400 N/mm2";: COLOR 7: PRINT "      .74               .62                         .44
COLOR 5: PRINT CHR$(229); "B = 600 N/mm2";: COLOR 7: PRINT "      .61               .50                         .36
COLOR 5: PRINT CHR$(229); "B = 800 N/mm2";: COLOR 7: PRINT "      .50               .38                         .26
COLOR 5: PRINT CHR$(229); "B =1000 N/mm2";: COLOR 7: PRINT "      .42               .31                         .19
COLOR 5: PRINT CHR$(229); "B =1200 N/mm2";: COLOR 7: PRINT "      .37               .24                         .13
COLOR 2,0: : LOCATE 22: FOR I=1 TO 80: PRINT "_";: NEXT I: COLOR 2,0
IF T<> 12 THEN PRINT "Die Zugfestigkeit "; CHR$(229); "B des Werkstoffes war "; MID$(WERK$(T),22,9)
IF T=12 THEN PRINT "Die Zugfestigkeit "; CHR$(229); "B des Werkstoffes war "; ZFEST
LOCATE 23,1
INPUT "Bitte OBERFLCHENEINFLUSSFAKTOR eingeben (Hauptwert: 0.9)  !   ", OBFL
IF OBFL=0 THEN OBFL=.9
END SUB

SUB WERKSTOFFE (WERKSTOFF$)
SHARED ZFEST, BWF, BSF, VWF, VSF, WNR, WERK$()
DIM WERK$(12)
SCREEN 0
CLS: COLOR 0,3
AA$="  Tabelle der gebruchlichen Wellenwerkstoffe  "
Z=2: CALL EINMITTEN (A,Z,AA$): A=5
COLOR 11,0
LOCATE A,1
PRINT "Bezeichung   Art   Zugfestigkeit   Biegedauerfestigkeit  Torsionsdauerfest.  Nr.
COLOR 14: PRINT "alle Werte in N/mm2              ";: COLOR 5: PRINT "  Wechself.  Schwellf.  Wechself. Schwellf.
COLOR 1: PRINT "                       ";CHR$(229); "B"; "             "; CHR$(229);"bW       "; CHR$(229); "bSch       "; CHR$(231); "tW      "; CHR$(231); "tSch"
LOCATE A+4: COLOR 5
WERK$(1)= "ST 430 B      B      420-500          220        360        150       180     1
PRINT WERK$(1)
WERK$(2)= "St 490        B      500-600          260        420        180       210     2
PRINT WERK$(2)
COLOR 3
WERK$(3)= "St 590        B      600-720          300        470        210       230     3
PRINT WERK$(3)
WERK$(4)= "St 690        B      700-850          340        520        240       260     4
PRINT WERK$(4)
COLOR 5
WERK$(5)= "C 22, Ck 22   V      500-650          280        490        190       250     5
PRINT WERK$(5)
WERK$(6)= "C 35, Ck 35   V      590-740          330        550        230       300     6
PRINT WERK$(6)
WERK$(7)= "C 45, Ck 45   V      670-820          370        630        260       340     7
PRINT WERK$(7)
COLOR 3
WERK$(8)= "25 CrMo 4     V      800-950          430        730        300       450     8
PRINT WERK$(8)
WERK$(9)= "34 Cr 4       V      900-1100         480        810        330       550     9
PRINT WERK$(9)
COLOR 5
WERK$(10)= "C 15, Ck 15   E      500-650          260        420        180       210    10
PRINT WERK$(10)
WERK$(11)= "16 MnCr 5     E      800-1100         390        670        270       430    11"
PRINT WERK$(11)
COLOR 2
LOCATE 21: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 22,5
PRINT "WERKSTOFF ? Tippen sie die entsprechende Zeile ein (Hauptzeile: 6) ! "
     WIEDER:
LOCATE 23,5
INPUT "Bei Eingabe der Zahl <12> wird nach neuen Werkstoffdaten gefragt  ", WNR
IF WNR=12 GOTO 9450
IF WNR<1 OR WNR>12 THEN WIEDER
WERKSTOFF$=WERK$(WNR)
9450 IF WNR=12 THEN CALL NEUWERKSTOFF (WERKSTOFF$,ZFEST,BWF,BSF,VWF,VSF)
IF WNR=0 THEN WNR=6
END SUB

SUB TASTENDRUCK
COLOR 2,0 : LOCATE 23,1: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 24,23: PRINT "Bitte eine beliebige Taste drcken  !  ";
WHILE INKEY$="": WEND
END SUB

SUB EINMITTEN (A,Z,AA$)
B=(80-LEN(AA$))/2+1
LOCATE Z,B: PRINT AA$
END SUB

SUB BETRIEBSFAKTOR (C)
SCREEN 0
CLS: COLOR 0,3
AA$="  WAHL EINES BETRRIEBSFAKTORS C  "
Z=2: CALL EINMITTEN (A,Z,AA$)
LOCATE 7: COLOR 7,0
PRINT "Es folgt eine Tabelle der Betriebsfaktoren C (Betriebsspannung gebrochen durch
PRINT "Nennspannung) fr einige Anwendungsbeispiele
LOCATE 11,10: COLOR 14: PRINT "umlaufende Maschinen inkl. E-Motoren   1.0 bis 1.1
LOCATE ,10: PRINT "Kolbenmaschinen, Hobelmaschinen,
LOCATE ,15: PRINT "Stomaschinen, Krananlagen        1.2 bis 1.5
LOCATE ,10: PRINT "Schmiedepressen, Abkantpressen,
LOCATE ,15: PRINT "Lochmaschinen, Kollergnge        1.6 bis 2.0
LOCATE ,10: PRINT "Mechanische Hmmer, Steinbrecher,
LOCATE ,15: PRINT "Walzwerkmaschinen                 2.0 bis 3.0
COLOR 2,0: LOCATE 22: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 23,1: PRINT "Ihre Wahl fr den Betriebsfaktor (Hauptwert: 1.1) :";
INPUT "", C
IF C=0 THEN C=1.1
END SUB

SUB NEUWERKSTOFF (WERKSTOFF$,ZFEST,BWF,BSF,VWF,VSF)
CLS: COLOR 0,3
AA$="  E I N G A B E   der Daten des von Ihnen gewhlten WERKSTOFFES  "
Z=2: CALL EINMITTEN (A,Z,AA$): A=13: B=14: X=40
COLOR A,0: LOCATE 5,1
INPUT "DIN-Bezeichnung des Werkstoffes:      ",WERKSTOFF$
LOCATE 5,X-1: COLOR B: PRINT WERKSTOFF$
LOCATE 8,1:  COLOR A: INPUT "Zugfestigkeit (N/mm2):                 ",ZFEST
LOCATE 8,X:  COLOR B: PRINT USING "###.#"; ZFEST
LOCATE 10,1: COLOR A: INPUT "Biegewechselfestigkeit (N/mm2):        ",BWF
LOCATE 10,X: COLOR B: PRINT USING "###.#"; BWF
LOCATE 12,1: COLOR A: INPUT "Biegeschwellfestigkeit (N/mm2):        ",BSF
LOCATE 12,X: COLOR B: PRINT USING "###.#"; BSF
LOCATE 14,1: COLOR A: INPUT "Verdrehwechselfestigkeit (N/mm2):      ",VWF
LOCATE 14,X: COLOR B: PRINT USING "###.#"; VWF
LOCATE 16,1: COLOR A: INPUT "Verdrehschwellfestigkeit (N/mm2):      ",VSF
LOCATE 16,X: COLOR B: PRINT USING "###.#"; VSF
CALL TASTENDRUCK
END SUB

SUB KERBZIFFER
SHARED BKB,BKT
COLOR 2,0: : LOCATE 22,1: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 23,5: PRINT "Ihr Wert fr die Biegekerbziffer (Hauptwert:";
PRINT USING "##.#"; BKB;: PRINT ") : ";
INPUT "",BKB1$
LOCATE 23,1: PRINT SPACE$(79)
IF BKB1$<>"" THEN BKB=VAL(BKB1$)
LOCATE 23,5: PRINT "Ihr Werte fr die Verdrehkerbziffer (Hauptwert:";
PRINT USING "##.#"; BKT;: PRINT ") : ";
INPUT "",BKT1$
IF BKT1$<>"" THEN BKT=VAL(BKT1$)
END SUB

SUB SICHERHEIT (SICHER)
CLS: COLOR 0,3
AA$="  W A H L   D E R   S I C H E R H E I T  "
Z=1: CALL EINMITTEN (A,Z,AA$)
COLOR 7,0
LOCATE 10: PRINT "Fr die Sicherheit werden folgende Werte empfohlen:
PRINT : COLOR 14: LOCATE ,10: PRINT "S = 1.5 bis 3   bei Dauerbruchgefahr
LOCATE ,10: PRINT "S = 1.2 bis 2   bei Gefahr von unzulssiger Verformung
LOCATE ,10: PRINT "S = 2   bis 4   bei statischer Bruchgefahr
LOCATE ,10: PRINT "S = 3   bis 5   bei Knickgefahr
COLOR 2
LOCATE 22: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 23,5
INPUT "Bitte SICHERHEIT S  eingeben (Hauptwert: 1.2) ! ", SICHER
IF SICHER=0 THEN SICHER=1.2
END SUB

CLEAR
SCREEN 0
OPTION BASE 1
DEFDBL M
CLS
COLOR 0,3
AA$="  A C H S E N     U N D     W E L L E N  "
A=6: Z=A-1: CALL EINMITTEN (A,Z,AA$)
COLOR 3,0: AA$="  nach Prof. Niemann  "
Z=A+2: CALL EINMITTEN (A,Z,AA$)
COLOR 5: AA$="fr den eigenen Unterricht modifiziert von
Z=A+5: CALL EINMITTEN (A,Z,AA$)
COLOR 23: AA$="DIPL.-ING. WILHELM JUNKER
Z=A+8: CALL EINMITTEN (A,Z,AA$)
COLOR 7: AA$="Abteilungsvorstand fr Maschinenbau-Automatisierungstechnik
Z=A+10: CALL EINMITTEN (A,Z,AA$)
AA$="Siedlungsstrae 2    A 3340 Waidhofen/Ybbs
Z=A+12: CALL EINMITTEN (A,Z,AA$)
COLOR 5: AA$="Copyright 1985"
Z=A+14: CALL EINMITTEN (A,Z,AA$)
CALL TASTENDRUCK

DATA 200, 190, 180, 170, 160, 150, 140, 132, 125, 118, 112, 106, 100, 95, 90
DATA 85, 80, 75, 71, 67, 63, 60, 56, 53, 50, 47.5, 45, 42.5, 40, 37.5, 35.5
DATA 33.5, 31.5, 30, 28, 26.5, 25, 23.6, 22.4, 21.2, 20, 19, 18, 17, 16, 15
DATA 14, 13.2, 12.5, 11.8

HAUPTMEN:
CLS: COLOR 0,3
AA$="    B  E  R  S  I  C  H  T  (Hauptmen)  "
Z=2: CALL EINMITTEN (A,Z,AA$)
COLOR 14,0: A=6
LOCATE A,5
PRINT "1     WERKSTOFFAUSWAHL, GESTALTFESTIGKEIT und KERBWIRKUNG";
COLOR 4: PRINT " (>>>EINSTIEG)
COLOR 14
LOCATE A+2,5
PRINT "2     ACHSEN berschlgig auf Biegung
LOCATE A+4,5
PRINT "3     WELLEN berschlgig auf Torsion
LOCATE A+6,5
PRINT "4     FESTIGKEITSBEMESSUNG von WELLEN auf BIEGUNG und TORSION
LOCATE A+8,5
PRINT "5     NACHRECHNUNG von WELLEN  (inkl. Verdrehwinkel)
LOCATE A+10,5
PRINT "6     BIEGEKRITISCHE DREHZAHLEN (nach Dunkerley)
LOCATE A+12,5: COLOR 3
PRINT "7     ENDE DER ARBEIT"
LOCATE A+14,11: COLOR 4
PRINT "--- Nach dem Einstieg setzen Sie mit Ziffer 2,3,4 oder 5 fort ! ---
COLOR 2: LOCATE 21,1: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 22,5
PRINT "WELCHE ARBEIT WOLLEN SIE TTIGEN ? Tippen sie die entsprechende Ziffer ein"
    RETOUR:
LOCATE 23,5: PRINT "und besttigen Sie durch Drcken der Taste <ENTER> !"
HALT1:
A$=INKEY$
IF A$="" THEN GOTO HALT1
A=VAL(A$)
IF A<1 OR A>7 OR A<>INT(A) THEN GOTO RETOUR
ON A GOTO KERB, BIEG, VERDREHUNG, BIEGUNDVERDR, WELLE, KRIT, SCHLUSS


BIEG:
MB=0: MT=0
CLS: COLOR 0,3
AA$="  A C H S E N   A U F   B I E G U N G  "
CALL EINMITTEN (A,1,AA$)
COLOR 7,0: A=4
LOCATE A
PRINT "Die Berechnung der Achsen auf Biegung erfolgt nach der Formel: "
COLOR 5
LOCATE A+2,10: PRINT "MB = Wb . ";: PRINT CHR$(229);: PRINT "b"
COLOR 7
LOCATE A+4: PRINT "oder wenn fr Wb der Wert von ";: PRINT CHR$(247);
PRINT "0.1 D^3 eingesetzt wird "
COLOR 5
LOCATE A+6,10: PRINT "d >= 2.17 . (MB / ";
PRINT CHR$(229);: PRINT "b,zul ) ^ (1/3)"
COLOR 7
PRINT: PRINT "Der Wert fr ";: PRINT CHR$(229);
PRINT "b,zul wird mit Hilfe der folgenden Formel berechnet:
COLOR 5
PRINT: LOCATE ,10: PRINT CHR$(229); "b,zul = "; CHR$(229);
PRINT "bWK / Sicherheit S / Betriebsfaktor C
CALL TASTENDRUCK
CALL SICHERHEIT (SICHER)
CALL BETRIEBSFAKTOR (C)
CLS: COLOR 0,3
AA$="  B E R E C H N U N G   D E R   A C H S E  "
Z=1: CALL EINMITTEN (A,Z,AA$)
COLOR 7,0
PRINT: PRINT: PRINT "Sie haben folgende Daten im ersten Arbeitsgang festgelegt:
COLOR 11
PRINT: LOCATE ,10: PRINT "Werkstoff:                           ";
IF ZEI=12 THEN PRINT WERKSTOFF$
COLOR 14: IF ZEI<>12 THEN PRINT LEFT$(WERKSTOFF$,11)
PRINT
IF ZEI<>12 GOTO NORMAL
COLOR 11: LOCATE ,10: PRINT "Biegewechselfestigkeit        "; CHR$(229); "bWN = ";
COLOR 14: PRINT USING "###.##"; BWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Biegeschwellfestigkeit        "; CHR$(229); "bSN = ";
COLOR 14: PRINT USING "###.##"; BSFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehwechselfestigkeit      "; CHR$(231); "tWN = ";
COLOR 14: PRINT USING "###.##"; VWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehschwellfestigkeit      "; CHR$(231); "tSN = ";
COLOR 14: PRINT USING "###.##"; VSFK;: PRINT "  N/mm2
GOTO GESAMT
NORMAL:
COLOR 11: LOCATE ,10: PRINT "Biegewechselfestigkeit        "; CHR$(229); "bWK = ";
COLOR 14: PRINT USING "###.##"; BWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Biegeschwellfestigkeit        "; CHR$(229); "bSK = ";
COLOR 14: PRINT USING "###.##"; BSFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehwechselfestigkeit      "; CHR$(231); "tWK = ";
COLOR 14: PRINT USING "###.##"; VWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehschwellfestigkeit      "; CHR$(231); "tSK = ";
COLOR 14: PRINT USING "###.##"; VSFK;: PRINT "  N/mm2
GESAMT:
COLOR 10: LOCATE 15
PRINT "Bitte das Biegemoment in Nmm eingeben !  ";: INPUT "", MB
LOCATE 15,41: PRINT "             "
LOCATE 15,40: COLOR 14: PRINT MB
MB100=MB
SIGZUL=BWFK/SICHER/C
D=2.17*(MB/SIGZUL)^(1/3)
LOCATE 18: COLOR 11,0: PRINT " Der Durchmesser betrgt rechnerisch:";
COLOR 14: PRINT "   D = ";: PRINT USING "###.#"; D;: PRINT " mm
W=212
RESTORE
IF D < 5 THEN X = 5: GOTO AUSDR
IF D > 200 THEN X = D: GOTO AUSDR
  2310  X=W: READ W: IF W > D GOTO 2310
LOCATE 20: COLOR 11: PRINT " Aufgerundet nach Normzahlreihe R 40:";
COLOR 14: PRINT "   D = ";: PRINT USING "###.#"; X;
PRINT  " mm ";: COLOR 11: PRINT "(gltig fr 5 <= d <= 200)
AUSDR:
COLOR 2,0: LOCATE 22: FOR I=1 TO 79: PRINT "_";: NEXT I
LOCATE 23,20: PRINT "Wnschen Sie einen Ausdruck der Daten ? (J/N)";
FORTS2:
R$=INKEY$
IF R$="" THEN GOTO FORTS2
IF R$="J" OR R$="j" THEN GOTO AUSDRUCKACHSEUNDWELLE
IF R$<>"J" OR R$<>"j" THEN GOTO HAUPTMEN

KRIT:
SCREEN 0
CLS: COLOR 3,0
AA$="  B I E G E K R I T I S C H E   D R E H Z A H L E N  (nach Dunkerley)  "
Z=5: CALL EINMITTEN (A,Z,AA$)
AA$= "Sie verlassen jetzt das Hauptprogramm.
COLOR 6,0: Z=12: CALL EINMITTEN (A,Z,AA$)
AA$= "Das zutreffende Drehzahlprogramm wird jetzt nachgeladen !
Z=16: CALL EINMITTEN (A,Z,AA$)
CALL TASTENDRUCK
CHAIN "DUNKERLY.BAS


VERDREHUNG:
MB=0: MT=0
CLS: COLOR 0,3
AA$="  W E L L E N   A U F   V E R D R E H U N G  "
CALL EINMITTEN (A,1,AA$)
COLOR 7,0: A=4
LOCATE A: PRINT "Die Berechnung der Wellen auf Verdrehung erfolgt nach der Formel: "
COLOR 5
LOCATE A+2,10: PRINT "MT = Wp . ";: PRINT CHR$(231);: PRINT "t"
COLOR 7
LOCATE A+4: PRINT "oder wenn fr WD der Wert von ";: PRINT CHR$(247);: PRINT "0.2 D^3 eingesetzt wird "
COLOR 5
LOCATE A+6,10: PRINT "d >= 1.71 . (MT / ";: PRINT CHR$(231);: PRINT "t,zul ) ^ (1/3)"
COLOR 7
LOCATE A+8: PRINT "Der Wert fr ";: PRINT CHR$(231);: PRINT "t,zul wird mit Hilfe der folgenden Formel berechnet:
COLOR 5
LOCATE A+10,10: PRINT CHR$(231);"t,zul = "; CHR$(231); "tSK / Sicherheit S / Betriebsfaktor C
CALL BETRIEBSFAKTOR (C)
CALL SICHERHEIT (SICHER)
CLS: COLOR 0,3
AA$="  B E R E C H N U N G   D E R   W E L L E  "
CALL EINMITTEN (A,1,AA$)
COLOR 7,0
PRINT: PRINT: PRINT "Sie haben folgende Daten im ersten Arbeitsgang festgelegt:
COLOR 11
PRINT: LOCATE ,10: PRINT "Werkstoff:                           ";
IF ZEI=12 THEN PRINT WERKSTOFF$
COLOR 14: IF ZEI<>12 THEN PRINT LEFT$(WERKSTOFF$,11)
PRINT
IF ZEI<>12 GOTO NORMAL1
COLOR 11: LOCATE ,10: PRINT "Biegewechselfestigkeit        "; CHR$(229); "bWN = ";
COLOR 14: PRINT USING "###.##"; BWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Biegeschwellfestigkeit        "; CHR$(229); "bSN = ";
COLOR 14: PRINT USING "###.##"; BSFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehwechselfestigkeit      "; CHR$(231); "tWN = ";
COLOR 14: PRINT USING "###.##"; VWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehschwellfestigkeit      "; CHR$(231); "tSN = ";
COLOR 14: PRINT USING "###.##"; VSFK;: PRINT "  N/mm2
GOTO GESAMT1
NORMAL1:
COLOR 11: LOCATE ,10: PRINT "Biegewechselfestigkeit        "; CHR$(229); "bWK = ";
COLOR 14: PRINT USING "###.##"; BWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Biegeschwellfestigkeit        "; CHR$(229); "bSK = ";
COLOR 14: PRINT USING "###.##"; BSFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehwechselfestigkeit      "; CHR$(231); "tWK = ";
COLOR 14: PRINT USING "###.##"; VWFK;: PRINT "  N/mm2
COLOR 11: LOCATE ,10: PRINT "Verdrehschwellfestigkeit      "; CHR$(231); "tSK = ";
COLOR 14: PRINT USING "###.##"; VSFK;: PRINT "  N/mm2
GESAMT1:
COLOR 10: LOCATE 15
PRINT "Bitte das Torsionsmoment in Nmm eingeben !  ";: INPUT "", MT
LOCATE 15,45: PRINT "             "
LOCATE 15,45: COLOR 14: PRINT MT
TAUZUL=VSFK/SICHER/C
D=1.72*(MT/TAUZUL)^(1/3)
LOCATE 18: COLOR 11,0: PRINT " Der Durchmesser betrgt rechnerisch:";
COLOR 14: PRINT "   D = ";: PRINT USING "###.#"; D;: PRINT " mm
W=212
RESTORE
IF D < 5 THEN X = 5: GOTO AUSDR1
IF D > 200 THEN X = D: GOTO AUSDR1
ANF7:
X=W: READ W: IF W > D GOTO ANF7
LOCATE 20: COLOR 11: PRINT " Aufgerundet nach Normzahlreihe R 40:";
COLOR 14: PRINT "   D = ";: PRINT USING "###.#"; X;
PRINT  " mm ";: COLOR 11: PRINT "(gltig fr 5 <= d <= 200)
AUSDR1:
COLOR 2,0: LOCATE 22: FOR I=1 TO 79: PRINT "_";: NEXT I
LOCATE 23,20: PRINT "Wnschen Sie einen Ausdruck der Daten ? (J/N)";
FORTS3:
R$=INKEY$
IF R$="" THEN GOTO FORTS3
IF R$="J" OR R$="j" THEN GOTO AUSDRUCKACHSEUNDWELLE
IF R$<>"J" OR R$<>"j" THEN GOTO HAUPTMEN

BIEGUNDVERDR:
MB=0: MT=0
CLS: COLOR 0,3
AA$="  BEMESSUNG von WELLEN auf BIEGUNG und VERDREHUNG  "
CALL EINMITTEN (A,1,AA$)
COLOR 14,0: A=4
LOCATE A: PRINT "Die Bemessung der Wellen auf Biegung und Verdrehung erfolgt nach den Formeln:"
COLOR 5
LOCATE A+2,10: PRINT "MV = SQR ( MB ^ 2 + (A / 2 * MT ) ^ 2 )";
COLOR 7: PRINT "     und
LOCATE A+4,10: COLOR 5: PRINT "D = 2.17 * ( B * MV / "; CHR$(229); "b,zul ) ^ ( 1/3))
COLOR 14
LOCATE A+6: PRINT "Hiebei gelten folgende Werte fr A:
COLOR 9
LOCATE A+8,10: PRINT "A = 1.2    fr "; CHR$(231); ",t schwellend und "; CHR$(229);
PRINT ",b wechselnd";: COLOR 7: PRINT "      und
COLOR 9: LOCATE A+9,10: PRINT "A = 1.7    fr "; CHR$(231); ",t wechselnd  und "; CHR$(229); ",b wechselnd
COLOR 14
PRINT: PRINT "Weiters wird bei Hohlwellen (fr Vollwellen ist B = 1) folgender Wert verwendet:
PRINT: COLOR 5: LOCATE ,10: PRINT "B = 1 / ( 1 - (DI/DA) ^ 4 )
COLOR 14: PRINT
PRINT "Der Wert fr ";: PRINT CHR$(229);: PRINT "b,zul wird mit Hilfe der folgenden Formel berechnet:
COLOR 5
PRINT: LOCATE ,10: PRINT CHR$(229); "b,zul = "; CHR$(229); "bWK / Sicherheit S / Betriebsfaktor C
COLOR 2: LOCATE 22: FOR I=1 TO 79: PRINT "_";: NEXT I
LOCATE 23,15: PRINT "Bitte Ihren Wert fr <A> (Hauptwert: 1.5) eingeben!";
LOCATE 23,70: INPUT "",A$
IF A$="" THEN A$="1.5"
CALL SICHERHEIT (SICHER)
CALL BETRIEBSFAKTOR (C)
CLS: COLOR 0,3
AA$="  WELLENBERECHNUNG AUF BIEGUNG UND VERDREHUNG  "
CALL EINMITTEN (A,1,AA$)
LOCATE 4: COLOR 11,0: PRINT "Verhltnis DI/DA eingeben oder schtzen !  ";
COLOR 11: INPUT "",VH
LOCATE 4,40: PRINT "                 "
COLOR 13: LOCATE 4,40: PRINT USING "########.#"; VH
PRINT: COLOR 11: PRINT "Torsionsmoment in Nmm eingeben !           ";
COLOR 11: INPUT "",MT
LOCATE 6,40: PRINT "                 "
COLOR 13: LOCATE 6,40: PRINT USING "########.#"; MT
PRINT: COLOR 11: PRINT "Biegemoment in Nmm eingeben !              ";
COLOR 11: INPUT "",MB
LOCATE 8,40: PRINT "                "
COLOR 13: LOCATE 8,40: PRINT USING "########.#"; MB
SIGZUL = BWFK / SICHER / C
MV = SQR ( MB*MB + (VAL(A$)/2 * MT)^2 )
B = 1 / (1-VH^4)
D = 2.17 * (B * MV / SIGZUL )^(1/3)
LOCATE 10: COLOR 11: PRINT "Das Vergleichsmoment betrgt:      ";
COLOR 14: PRINT "MV = ";: PRINT USING "#######.#"; MV;: PRINT " Nmm
LOCATE 12: COLOR 11: PRINT "Die zulssige Spannung betrgt:  ";
COLOR 14: PRINT "SZUL = ";: PRINT USING "#######.#"; SIGZUL;: PRINT " N/mm2
LOCATE 14: COLOR 11: PRINT "Der Wert B betrgt:                 ";
COLOR 14: PRINT "B = ";: PRINT USING "#######.#"; B
LOCATE 18: COLOR 11: PRINT "Der Durchmesser betrgt rechnerisch: ";
COLOR 14: PRINT "   D = ";: PRINT USING "###.#"; D;: PRINT " mm
W=212
RESTORE
IF D < 5 THEN X = 5: GOTO AUSDR2
IF D > 200 THEN X = D: GOTO AUSDR2
ANF9:
X=W: READ W: IF W > D GOTO ANF9
LOCATE 20: COLOR 11: PRINT " Aufgerundet nach Normzahlreihe R 40:";
COLOR 14: PRINT "   D = ";: PRINT USING "###.#"; X;
PRINT  " mm ";: COLOR 11: PRINT "(gltig fr 5 <= d <= 200)
AUSDR2:
COLOR 2,0: LOCATE 22: FOR I=1 TO 79: PRINT "_";: NEXT I
LOCATE 23,20: PRINT "Wnschen Sie einen Ausdruck der Daten ? (J/N)";
FORTS4:
R$=INKEY$
IF R$="" THEN GOTO FORTS4
IF R$="J" OR R$="j" THEN GOTO AUSDRUCKBIEGUNGUNDTORSION
IF R$<>"J" OR R$<>"j" THEN GOTO HAUPTMEN

WELLE:
REM ********** NACHRECHNUNG EINER WELLE bez. VERFORMUNGEN
CLS: COLOR 0,3
AA$="  NACHRECHNUNG von WELLEN auf BIEGUNG und VERDREHUNG  "
CALL EINMITTEN (A,1,AA$)
COLOR 14,0: A=4
LOCATE A: PRINT "Die Festigkeitskontrolle der Wellen auf Biegung und Verdrehung erfolgt nach der
PRINT "Hypothese der grten Gestaltnderungsarbeit. Es wird eine Vergleichsspannung
PRINT "nach folgender Formel berechnet:
PRINT
COLOR 5: LOCATE A+4,10: PRINT CHR$(229); "v  <=  SQR ( "; CHR$(229); "^2 + 3 * ("; CHR$(224); "0*"; CHR$(231); " )^2 )
PRINT: COLOR 14: PRINT "Dabei berechnet man das Anstrengungsverhltnis "; CHR$(224); "0 nach der Formel:
PRINT: LOCATE ,10: COLOR 5: PRINT CHR$(224); "0 = "; CHR$(229); "b,zul / 1.73 / "; CHR$(231); "t,zul
PRINT: COLOR 14: PRINT "Die Spannungen "; CHR$(229); " und "; CHR$(231); " sowie der Verdrehwinkel werden nach den blichen Ver-
PRINT "fahren ermittelt.
PRINT: PRINT "Bei Biegung wird Wechselbeanspruchung angenommen.
PRINT: COLOR 3: PRINT "Fr Verdrehung wird zugrunde gelegt, da Schwellbeanspruchung vorliegt.
CALL TASTENDRUCK
CLS: COLOR 0,3
AA$="  BERECHNUNG des VERDREHWINKELS  "
Z=1: CALL EINMITTEN (A,Z,AA$)
COLOR 11,0: PRINT: PRINT "Die Ermittlung des Verdrehwinkels geschieht mit der blichen Formel
PRINT: COLOR 5: LOCATE ,10: PRINT CHR$(224); " = MT * L / G / IP    im Bogenma
PRINT: COLOR 11,0: LOCATE 7,1: PRINT " EINGABEN: "
LOCATE 9
PRINT: COLOR 6: PRINT      "Biegemoment in Nmm:     ";
INPUT "", MB: IF MB=0 THEN MB=MB100
COLOR 14: LOCATE ,25: PRINT USING "#######.#"; MB
COLOR 6: PRINT            "Torsionsmoment in Nmm:   ";
INPUT "", MT: IF MT=0 THEN MT=MT100
COLOR 14: LOCATE ,25: PRINT USING "#######.#"; MT
COLOR 6: PRINT "Lnge der Welle in mm:  ";: INPUT "", L
COLOR 14: LOCATE 10,25: PRINT USING "#######.#"; L
COLOR 6: PRINT "Auendurchmesser in mm: ";: INPUT "", DA
COLOR 14: LOCATE 11,25: PRINT USING "#######.#"; DA
COLOR 6: PRINT "Innendurchmesser in mm: ";: INPUT "", DI
COLOR 14: LOCATE 12,25: PRINT USING "#######.#"; DI
COLOR 3,0: LOCATE 14: PRINT " ERGEBNIS "
PI=4*ATN(1)
ALFA = MT/81*L/1000/(DA^4-DI^4)*32/PI*180/PI
COLOR 5: LOCATE 16: PRINT "Der Verdrehwinkel betrgt ";
COLOR 14: LOCATE 16,30: PRINT USING "###.#####"; ALFA;: PRINT " Altgrad
CALL BETRIEBSFAKTOR (C)
CLS: COLOR 0,3
AA$="  NACHRECHNUNG von WELLEN auf BIEGUNG und VERDREHUNG  "
CALL EINMITTEN (A,1,AA$)
LOCATE 4
SIGZUL = BWFK/C
SIGZUL = BSFK/C
TAUZUL = VWFK/C': GOTO 8540
TAUZUL = VSFK/C
ALNU = SIGZUL/1.73/TAUZUL
WIDBIE = PI/32*(DA^4-DI^4)/DA
WIDVER = PI/16*(DA^4-DI^4)/DA
SIGBIE = MB/WIDBIE
TAUVER = MT/WIDVER
SIGVER = SQR(SIGBIE^2+3*(ALNU*TAUVER)^2)
LOCATE 10: COLOR 0,3: PRINT "  ERGEBNISSE:  "
PRINT: COLOR 6,0: PRINT "Zul. Spannung "; CHR$(229); "b,zul:                     ";
COLOR 14: PRINT USING "###.##"; SIGZUL;: PRINT " N/mm2
COLOR 6: PRINT "Anstrengungsverhltnis "; CHR$(224); "0:                ";
COLOR 14: PRINT USING "###.##"; ALNU
COLOR 6:         PRINT "Widerstandsmoment fr Biegung:         " ;
COLOR 14: PRINT USING "######.##"; WIDBIE;: PRINT " mm3
COLOR 6:         PRINT "Widerstandsmoment fr Verdrehung :     " ;
COLOR 14: PRINT USING "######.##"; WIDVER;: PRINT " mm3
COLOR 6:         PRINT "Biegespannung:                         " ;
COLOR 14: PRINT USING "######.##"; SIGBIE;: PRINT " N/mm2
COLOR 6:         PRINT "Verdrehspannung :                      " ;
COLOR 14: PRINT USING "######.##"; TAUVER;: PRINT " N/mm2
ALFA = MT/81/(DA^4-DI^4)*32/PI*180/PI
COLOR 6:         PRINT "Verdrehwinkel pro m Wellenlnge:       " ;
COLOR 14: PRINT USING "######.##"; ALFA;: PRINT " Altgrad
PRINT: COLOR 6,0: PRINT "Vergleichsspannung:" ;: COLOR 14: LOCATE ,42
PRINT USING "####.##"; SIGVER;: PRINT " N/mm2
PRINT: COLOR 6: PRINT "Die Sicherheit betrgt rechnerisch:";: COLOR 14
LOCATE ,44: PRINT USING "##.#"; (SIGZUL/SIGVER)
COLOR 2,0: LOCATE 22: PRINT SPACE$(79);
LOCATE 23,5: PRINT "Wnschen Sie einen Ausdruck der Daten ? (J/N)";
R$=INKEY$
IF R$="J" OR R$="j" THEN GOTO AUSDRUCKNACHRECHNUNG
IF R$<>"J" OR R$<>"j" THEN GOTO HAUPTMEN


SCHLUSS:
CLS: CLOSE: END


KERB:
REM ********** ERMITTLUNG DER DAUERFESTIGKEIT BEI KERBWIRKUNG ***************
YYY=2
CLS: COLOR 0,3
AA$="  DAUERFESTIGKEIT bei KERBWIRKUNG  "
Z=1: CALL EINMITTEN (A,Z,AA$)
COLOR 7,0: A=4
LOCATE A: PRINT "Die Berechnung der Gestaltfestigkeit einer dauerbeanspruchten gekerbten Welle
PRINT "wird nach einer der folgenden Formeln berechnet:
PRINT: COLOR 14: PRINT "BIEGUNG:    ";: COLOR 11
PRINT CHR$(229); "bWK = "; CHR$(229); "bW . BS . B0 / "; CHR$(225); "kb         "; CHR$(229); "bSK = "; CHR$(229); "bS . BS . B0 / "; CHR$(225); "kb
PRINT: COLOR 7: PRINT "oder"
PRINT: COLOR 14: PRINT "VERDREHUNG: ";: COLOR 11
PRINT CHR$(231); "tWK = "; CHR$(231); "tW . BS . B0 / "; CHR$(225); "kt         "; CHR$(231); "tSK = "; CHR$(231); "tS . BS . B0 / "; CHR$(225); "kt
PRINT
COLOR 7: PRINT "Die Bedeutung der diversen Indizes ist folgende:
COLOR 5
PRINT: LOCATE ,10
PRINT "b .... Biegung                       t .... Torsion
LOCATE ,10: PRINT "W .... Wechselbeanspruchung          S .... Schwellbeanspruchung
LOCATE ,10: PRINT "K .... Kerbwirkungseinflu           N .... nutzbare Festigkeit einer
SPEICHER=BWF
LOCATE ,10: PRINT "BS ... Oberflcheneinflufaktor                  ungekerbten Welle
LOCATE ,10: PRINT "RT ... Rauhtiefe Rt in "; CHR$(230); "m"
LOCATE ,10: PRINT CHR$(225); "k ... Kerbwirkungszahl
LOCATE ,10: PRINT "B0 ... Grenfaktor (Abweichung von Nenndurchmesser 10 mm)
CALL TASTENDRUCK
CALL WERKSTOFFE (WERKSTOFF$)
GOTO KERBTABELLE



KERBTABELLE:
CLS: COLOR 0,3
AA$="  TABELLE DER VERSCHIEDENEN KERBBMGLICHKEITEN  "
Z=2: CALL EINMITTEN (A,Z,AA$)
LOCATE 5: COLOR 5,0
PRINT "   1     Welle mit Rundkerbe, feingedreht
PRINT "   2     Welle mit Absatz, feingedreht
PRINT "   3     Welle mit Pafedernut, mit Fingerfrser hergestellt
PRINT "   4     Welle mit Bund
COLOR 6: PRINT
PRINT "   5     Welle mit Querbohrung
PRINT "   6     Glatte Welle mit Presitz
PRINT "   7     Welle mit Absatz und Festsitz
PRINT "   8     Welle mit Rechtecknut
COLOR 5: PRINT
PRINT "   9     Welle mit Kerbverzahnung
PRINT "  10     Welle mit Vielnut-Zahnwellenprofil
PRINT "  11     Welle mit Ringfeder-Spannelement
PRINT "  12     Welle mit Spitzkerbe
COLOR 7: PRINT
PRINT "  13     Glatte Welle ohne Kerbwirkung (";CHR$(225);"k = 1.0)
COLOR 2,0: LOCATE 22: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 23,5
INPUT "Bitte ZEILENNUMER eingeben und mit<RETURN> abschlieen !   ", ZEI
SCREEN 9
ON ZEI GOTO FALL1,FALL2,FALL3,FALL4,FALL5,FALL6,FALL7,FALL8,FALL9,FALL10,FALL11,FALL12,FALL13


FALL1:
REM ** EINSTIEG bei WELLE mit RUNDKERBE, fein gedreht ** 1 **
CLS: COLOR 14,0
AA$="W E L L E    m i t    R U N D K E R B E,    f e i n    g e d r e h t"
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
LOCATE 16,1: PRINT "TABELLE DER BIEGEWECHSELFESTIGKEITEN VON WELLEN  ";
PRINT CHR$(229); "bWk10:"
PRINT: COLOR 7,0: PRINT CHR$(229); "B in N/mm2:    ";: COLOR 13
PRINT "                400      600      800      1000    1200    1400
COLOR 5: PRINT: PRINT "d/D=0.8    D-d=2r         ";: COLOR 7
PRINT "      130      170      195       215     230     235": COLOR 5
PRINT "d/D=0.6    D-d=2r        ";: COLOR 7
PRINT "       140      190      230       260     282     300"
COLOR 6: LINE (100,50)-(200,50): LINE (220,50)-(320,50)
LINE (200,50)-(200,100): LINE (220,50)-(220,100)
CIRCLE (210,50), 10,, 3, 6.25
COLOR 7: LINE (90,90)-(330,90)
LOCATE 5,45: COLOR 9: PRINT CHR$(225);
PRINT "kb = 1.4 fr d/D=0.8 (geschtzt)
LOCATE 6,45: PRINT CHR$(225);
PRINT "kb = 1.6 fr d/D=0.6 (geschtzt)
LOCATE 7,45: PRINT CHR$(225);: PRINT "kt = 1.3 (geschtzt)
BKB=1.6: BKT=1.3: QQ=1
COLOR 11: LOCATE 11,10: PRINT "D ... Wellennenndurchmesser
LOCATE ,10: PRINT "d ... Durchmesser der Welle am Kerbgrund
LOCATE ,10: PRINT "r ... Radius der Einkerbung
CALL KERBZIFFER
CALL OBERFLFAKTOR (OBFL)
CALL GROESSENFAKTOREN (GR)
GOTO ERGKERB

FALL2:
REM ********** EINSTIEG bei ABSATZ, fein gedreht ********************* 2 *
CLS: COLOR 14,0
AA$="  W E L L E   m i t   A B S A T Z,   f e i n    g e d r e h t
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 14: LOCATE 14: PRINT "TABELLE DER BIEGEWECHSELFESTIGKEITEN VON WELLEN  ";: PRINT CHR$(229); "bWk10:
PRINT: COLOR 7,0: PRINT CHR$(229); "B in N/mm2:       ";
COLOR 13: PRINT "             400      600      800      1000    1200    1400
COLOR 5: PRINT: PRINT "d/D=0.8    r/d=0.1        ";: COLOR 7
PRINT "      140      185      220       250     265     275"
COLOR 5: PRINT "d/D=0.8    r/d=0.05      ";
COLOR 7: PRINT "       130      170      200       220     230     235"
COLOR 5: PRINT "d/D=0.8    r/d=0.025     ";
COLOR 7: PRINT "       115      145      170       180     185     188"
COLOR 6: LINE (100,50)-(200,50)
LINE (200,50)-(200,100): LINE (220,62)-(300,62)
CIRCLE (216,50), 16,, 3.2, 4.8
COLOR 7: LINE (90,90)-(330,90)
BKB=2.5: BKT=1.9
COLOR 11: LOCATE 4,45: PRINT "D ... Wellenauendurchmesser
LOCATE ,45: PRINT "d ... kleinerer Wellendurchmesser
LOCATE ,45: PRINT "r ... Radius der Ausrundung
LOCATE 10: COLOR 14,0: PRINT "TABELLE DER ABSATZFAKTOREN   Q:": COLOR 5,0
PRINT: PRINT "d/D";: COLOR 13
PRINT "            0.3    0.4    0.5    0.6    0.7    0.8    0.9
COLOR 5: PRINT "Q  ";
COLOR 7: PRINT "            0.86   0.87   0.88   0.90   0.95   1.0    1.12
LOCATE 22,1: COLOR 2: FOR I=1 TO 79: PRINT "_";: NEXT I
LOCATE 23,5: PRINT "Eine passende Zahl fr Q eingeben (Hauptwert: 0.9) !";
INPUT "", QQ
IF QQ=0 THEN QQ=0.9
CALL KERBZIFFER
CALL OBERFLFAKTOR (OBFL)
CALL GROESSENFAKTOREN (GR)
GOTO ERGKERB

FALL3:
REM ***** EINSTIEG bei WELLE mit PASSFEDERNUT, mit Fingerfrser ** 3 **
CLS: COLOR 3,0
AA$="  WELLE mit PASSFEDERNUT
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 14: LOCATE 16: PRINT "TABELLE DER BIEGEWECHSELFESTIGKEITEN VON WELLEN  ";: PRINT CHR$(229); "bWk10:"
PRINT: COLOR 7,0: PRINT CHR$(229); "B in N/mm2:    ";
COLOR 13: PRINT "                400      600      800      1000    1200    1400
COLOR 5: PRINT: PRINT "gefrst mit Fingerfrser  ";
COLOR 7: PRINT "      130      175      205       235     255     275"
COLOR 5: COLOR 5: PRINT "gefrst mit Scheibenfrser";
COLOR 7: PRINT "          alle obigen Werte sind etwa 30 % grer
COLOR 6: LINE (100,50)-(320,50): LINE (160,60)-(260,60)
LINE (160,50)-(160,60): LINE (260,50)-(260,60)
COLOR 7: LINE (90,90)-(330,90)
BKB=2.5: BKT=1.9: QQ=1
LOCATE 11,5: COLOR 9: PRINT CHR$(225);: LOCATE 11,6: PRINT "kb = 1.7 fr Fingerfrser   (geschtzt)
LOCATE 12,5: PRINT CHR$(225);: LOCATE 12,6: PRINT "kb = 2.5 fr Scheibenfrser (geschtzt)
LOCATE 13,5: PRINT CHR$(225);: LOCATE 13,6: PRINT "kt = 1.9 (geschtzt)
CALL KERBZIFFER
CALL GROESSENFAKTOREN (GR)
CALL OBERFLFAKTOR (OBFL)
GOTO ERGKERB

FALL4:
REM ********** EINSTIEG bei WELLE mit BUND *************************** 4 **
CLS: COLOR 3,0
AA$="  WELLE mit BUND  "
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 14: LOCATE 16: PRINT "TABELLE DER BIEGEWECHSELFESTIGKEITEN VON WELLEN  ";: PRINT CHR$(229); "bWk10:"
PRINT: COLOR 9: PRINT CHR$(229); "B in N/mm2:    ";
COLOR 13: PRINT "                400      600      800      1000    1200    1400
COLOR 5: PRINT: PRINT "d/D=0.8   r/d=0.05        ";
COLOR 7: PRINT "      130      170      200       220     230     235"
LINE (100,50)-(200,50): LINE (220,50)-(320,50)
LINE (200,40)-(200,100): LINE (220,40)-(220,100)
LINE (200,40)-(220,40)
COLOR 7: LINE (90,90)-(330,90)
LOCATE 6,45: COLOR 9: PRINT CHR$(225);: LOCATE 6,46: PRINT "kb = 1.5 (geschtzt)
LOCATE 7,45: PRINT CHR$(225);: LOCATE 7,46: PRINT "kt = 1.2 (geschtzt)
BKB=1.5: BKT=1.2: QQ=1
COLOR 11: LOCATE 11,10: PRINT "D ... Durchmesser des Wellenbundes
LOCATE ,10: PRINT "d ... Durchmesser der Welle
LOCATE ,10: PRINT "r ... Radius des berganges
CALL KERBZIFFER
CALL GROESSENFAKTOREN (GR)
CALL OBERFLFAKTOR (OBFL)
GOTO ERGKERB

FALL5:
REM ********** EINSTIEG bei WELLE mit QUERBOHRUNG ******************** 5 *
CLS: COLOR 3,0
AA$="  WELLE mit QUERBOHRUNG   "
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 14: LOCATE 14: PRINT "TABELLE DER BIEGEWECHSELFESTIGKEITEN VON WELLEN  ";
PRINT CHR$(229); "bWk10:
PRINT: COLOR 7,0: PRINT CHR$(229); "B in N/mm2:    ";
COLOR 13: PRINT "                400      600      800      1000    1200    1400
COLOR 5: PRINT: PRINT "d/D=0.1                   ";
COLOR 7: PRINT "      130      170      190       204     210     216"
COLOR 6: LINE (100,50)-(320,50)
LINE (200,50)-(200,100): LINE (220,50)-(220,100)
COLOR 7: LINE (90,90)-(330,90): LINE (210,40)-(210,100)
COLOR 7: LINE (90,90)-(330,90)
LOCATE 10,45: COLOR 9: PRINT CHR$(225);: LOCATE 10,46: PRINT "kb = 1.4 (geschtzt)
LOCATE 11,45: PRINT CHR$(225);: LOCATE 11,46: PRINT "kt = 1.3 (geschtzt)
BKB=1.4: BKT=1.3: QQ=1
COLOR 11: LOCATE 6,45: PRINT "D ... Wellenauendurchmesser
LOCATE ,45: PRINT "r ... Durchmesser der Querbohrung
CALL KERBZIFFER
CALL GROESSENFAKTOREN (GR)
CALL OBERFLFAKTOR (OBFL)
GOTO ERGKERB

FALL6:
REM ********** EINSTIEG bei glatter WELLE mit PRESSSITZ ************** 6 **
CLS: COLOR 3,0
AA$="  Glatte WELLE mit PRESZSITZ, geschliffen   "
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 14: LOCATE 16: PRINT "TABELLE DER WERKSTOFFAKTOREN:
PRINT: COLOR 7: PRINT CHR$(229); "B in N/mm2:       ";
COLOR 13: PRINT "             400      500      600       700     800    1000
PRINT: PRINT "Werkstoffaktor            ";
COLOR 7: PRINT "      1.1      1.0      .93       .85     .74     .71
COLOR 6: LINE (100,90)-(300,90)
COLOR 1: LINE (160,88)-(160,78): LINE -(190,78): LINE -(190,50): LINE -(210,50)
LINE (210,50)-(210,78): LINE -(240,78): LINE -(240,84)
CIRCLE (232,83),8,7,4.7, 6.28: LINE (160,88)-(232,88)
'PAINT (200,60), 1
COLOR 7: LINE (90,130)-(330,130): LINE (200,40)-(200,140)
BKB=1.4: BKT=1.3: QQ=1
COLOR 11: LOCATE 5,45: PRINT "D ... Wellenauendurchmesser
LOCATE ,45: PRINT "r ... Radius der Ausrundung
LOCATE 9,45: COLOR 5: PRINT "Form A ... ohne Ausrundung
LOCATE ,45: PRINT "Form B ... mit Ausrundung
LOCATE ,45: PRINT "Form C ... mit zustzl. Pafeder
LOCATE 6,17: PRINT "A"
LOCATE 6,33: PRINT "B"
COLOR 2: LOCATE 13,45: PRINT "Werte fr r/D=0.05
LOCATE ,45: PRINT "berma/D=1.5 bis 2*10^3
CALL KERBZIFFER
12875 CALL GROESSENFAKTOREN (GR)
12880 CALL OBERFLFAKTOR (OBFL)
12890 GOTO ERGKERB

FALL7:
REM ********** EINSTIEG bei WELLE mit ABSATZ und FESTSITZ ************ 7 *
CLS: COLOR 14,0
AA$="  WELLE mit ABSATZ und FESTSITZ, geschliffen  "
Z=1: CALL EINMITTEN (A,Z,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 14: LOCATE 14: PRINT "TABELLE DER BIEGEWECHSELFESTIGKEITEN VON WELLEN  ";: PRINT CHR$(229); "bWk10:
PRINT: COLOR 7: PRINT CHR$(229); "B in N/mm2:       ";
COLOR 5: PRINT "             400      600      800      1000    1200    1400
COLOR 5
PRINT: PRINT "d/D=0.8    r/d=0.1        ";
COLOR 7: PRINT "      140      185      220       250     265     275"
COLOR 5: PRINT "d/D=0.8    r/d=0.05      ";
COLOR 7: PRINT "       130      170      200       220     230     235"
COLOR 5: PRINT "d/D=0.8    r/d=0.025     ";
COLOR 7: PRINT "       115      145      170       180     185     188"
COLOR 6: LINE (100,50)-(200,50)
LINE (200,50)-(200,100): LINE (210,60)-(300,60)
CIRCLE (210,52), 8, 7, 3.2, 4.8
COLOR 7: LINE (90,90)-(330,90)
COLOR 1
LINE (202,52)-(202,35): LINE -(250,35): LINE -(250,58): LINE -(210,58)
CIRCLE (211,53), 10, 7, 3.2, 4.8
'PAINT (240,40), 1
BKB=1.4: BKT=1.3: QQ=1
COLOR 11: LOCATE 4,45: PRINT "D ... Wellenauendurchmesser
LOCATE ,45: PRINT "d ... kleinerer Wellendurchmesser
LOCATE ,45: PRINT "r ... Radius der Ausrundung
LOCATE 10: COLOR 3,0: PRINT "TABELLE DER ABSATZFAKTOREN   Q:"
COLOR 5,0: PRINT: PRINT "d/D";
COLOR 13: PRINT "            0.3    0.4    0.5    0.6    0.7    0.8    0.9
COLOR 5: PRINT "Q  ";
COLOR 7: PRINT "            0.86   0.87   0.88   0.89   0.95   1.0    1.12
COLOR 1: LOCATE 8,45: PRINT "zB Wlzlager
CALL KERBZIFFER
CALL GROESSENFAKTOREN (GR)
CALL OBERFLFAKTOR (OBFL)
GOTO ERGKERB

FALL8:
REM ********** EINSTIEG bei WELLE mit RECHTECKNUT ******************** 8 *
CLS: COLOR 3,0
AA$="  WELLE mit RECHTECKNUT (z.B. fr Seegerring)
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 6
LINE (100,50)-(200,50): LINE (220,50)-(320,50)
LINE (200,50)-(200,60): LINE -(220,60): LINE -(220,50)
LINE (200,50)-(200,100): LINE (220,50)-(220,100)
COLOR 7: LINE (90,90)-(330,90)
BKB=2.2: BKT=1.8: QQ=1
COLOR 5: LOCATE 11,5: PRINT "Kerbwirkungszahl bei Biegung:";
COLOR 11: PRINT "      "; CHR$(225); "kb = ";: PRINT USING "#.##"; BKB
COLOR 5: LOCATE 13,5: PRINT "Kerbwirkungszahl bei Torsion:";
COLOR 11: PRINT "      "; CHR$(225); "kt = ";: PRINT USING "#.##"; BKT
COLOR 7: PRINT: LOCATE 16,5: PRINT "Gilt unter folgenden Bedingungen:
COLOR 9: LOCATE 18,15: PRINT "Nenndurchmesser = Auendruchmesser
LOCATE ,15: PRINT "Wellenwerkstoff etwa St 490
LOCATE ,15: PRINT "Kerbziffer mit der Zugfestigkeit steigend
CALL KERBZIFFER
CALL OBERFLFAKTOR (OBFL)
CALL GROESSENFAKTOREN (GR)
GOTO ERGKERB

FALL9:
REM ********** EINSTIEG bei WELLE mit KERBVERZAHNUNG ***************** 9 *
CLS: COLOR 3,0
AA$="  WELLE mit KERBVERZAHNUNG   "
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 6: LINE (100,60)-(300,60): LINE (100,60)-(95,63)
LINE (95,63)-(95,100): LINE (95,66)-(200,66)
LOCATE 6,15: PRINT "WELLE
LINE (200,66)-(210,60): COLOR 5: LINE (100,59)-(100,40): LINE (180,59)-(180,40)
LOCATE 4,15: PRINT "NABE
COLOR 7: LINE (90,90)-(330,90): LINE (85,63)-(210,63)
BKB=1.4: BKT=3: QQ=1
COLOR 5: LOCATE 11,5: PRINT "Kerbwirkungszahl bei Biegung:";
COLOR 11: PRINT "      "; CHR$(225); "kb = ";: PRINT USING "#.##"; BKB
COLOR 5: LOCATE 13,5: PRINT "Kerbwirkungszahl bei Torsion:";
COLOR 11: PRINT "      "; CHR$(225); "kt = ";: PRINT USING "#.##"; BKT
13810 COLOR 7: PRINT: LOCATE 17,5: PRINT "Gilt unter folgenden Bedingungen:
13820 COLOR 9: LOCATE 19,15: PRINT "Nenndurchmesser = Auendruchmesser
13830 LOCATE ,15: PRINT "Wellenwekstoff etwa St 490
13840 LOCATE ,15: PRINT "Kerbziffer mit der Zugfestigkeit steigend
14070 CALL KERBZIFFER
14080 CALL OBERFLFAKTOR (OBFL)
14090 CALL GROESSENFAKTOREN (GR)
14100 GOTO ERGKERB

FALL10:
REM ********** EINSTIEG bei WELLE mit VIELNUT-ZAHNWELLENPROFIL ****** 10 *
CLS: COLOR 3,0
AA$="  WELLE mit VIELNUT-ZAHNWELLENPROFIL
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 6: LINE (100,60)-(300,60): LINE (100,60)-(95,63)
LINE (95,63)-(95,100): LINE (95,66)-(200,66)
LOCATE 6,15: PRINT "WELLE
LINE (200,66)-(210,60): COLOR 5: LINE (100,59)-(100,40): LINE (180,59)-(180,40)
LOCATE 4,15: PRINT "NABE
COLOR 7: LINE (90,90)-(330,90): LINE (85,63)-(210,63)
BKB=1.3: BKT1=2.7: BKT2=2: BKT3=1.5: BKT=2.7: QQ=1
COLOR 5: LOCATE 11,5: PRINT "Kerbwirkungszahl bei Biegung:";
COLOR 11: PRINT "      "; CHR$(225); "kb = ";: PRINT USING "#.##"; BKB
COLOR 5: LOCATE 13,5: PRINT "Kerbwirkungszahl bei Torsion:";
COLOR 11: PRINT "      "; CHR$(225); "kt = ";: PRINT USING "#.##"; BKT1;
COLOR 9: PRINT " (Einstiche an den Nutrndern)
COLOR 11: LOCATE ,46: PRINT: PRINT USING "#.##"; BKT2;
COLOR 9: PRINT "   (Nuten mit scharfen Kanten)
LOCATE ,46: PRINT: PRINT USING "#.##"; BKT3;
COLOR 9: PRINT " (Zahnflanke vorhanden)
COLOR 7: PRINT: LOCATE 17,5: PRINT "Gilt unter folgenden Bedingungen:
COLOR 9: LOCATE 19,15: PRINT "Nenndurchmesser = Auendurchmesser
LOCATE ,15: PRINT "Wellenwekstoff etwa St 490
LOCATE ,15: PRINT "Kerbziffer mit der Zugfestigkeit steigend
COLOR 4,0: LOCATE 22,1: FOR I=1 TO 80: PRINT "_";: NEXT I
CALL KERBZIFFER
CALL OBERFLFAKTOR (OBFL)
CALL GROESSENFAKTOREN (GR)
GOTO ERGKERB

FALL11:
REM ********** EINSTIEG bei WELLE mit RINGFEDER-SPANNELEMENT ******** 11 *
CLS: COLOR 3,0
AA$="  WELLE mit RINGFEDER-SPANNELEMENT  "
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 7: LINE (100,160)-(521,160): LINE (100,160)-(80,175)
LINE (80,175)-(80,250): LINE (100,160)-(100,250)
LINE (521,150)-(521,250): LINE (521,150)-(650,150)
LOCATE 16,30: PRINT "WELLE
COLOR 7: LINE (30,240)-(799,240)
LINE (482,110)-(520,159),3,BF
LINE (450,129)-(520,159),3,BF
FOR I=1 TO 4
   A=50+80*I
   LINE (A,130)-(A+55,130),11: LINE -(A+55,142),11: LINE -(A+10,148),11
   LINE -(A,148),11: LINE -(A,130),11
NEXT I
COLOR 14,0
FOR I=1 TO 4
   A=75+I*80
   LINE (A,148)-(A+45,142),9: LINE -(A+55,142),9: LINE -(A+55,159),9
   LINE -(A,159),9: LINE -(A,148),9
NEXT I
COLOR 1: LINE (100,40)-(100,129): LINE -(482,129): LINE -(482,40)
LOCATE 7,30: COLOR 7: PRINT "NABE
LINE (40,130)-(129,145),5,BF
LINE (40,145)-(62,250),5,BF
COLOR 2: LOCATE 23: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 24,5: PRINT "Bitte eine beliebige Taste drcken  !  ";
FOLGE7:
R$=INKEY$: IF R$="" THEN GOTO FOLGE7
CLS: COLOR 3,0
AA$="  WELLE mit RINGFEDER-SPANNELEMENT  "
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
BKB=1.8: BKT=1.2: QQ=1
COLOR 5: LOCATE 11,5: PRINT "Kerbwirkungszahl bei Biegung:";
COLOR 11: PRINT "      "; CHR$(225); "kb = ";: PRINT USING "#.##"; BKB
COLOR 5: LOCATE 13,5: PRINT "Kerbwirkungszahl bei Torsion:";
COLOR 11: PRINT "      "; CHR$(225); "kt = ";: PRINT USING "#.##"; BKT
COLOR 7: PRINT: LOCATE 16,5: PRINT "Gilt unter folgenden Bedingungen:
COLOR 9: LOCATE 18,15: PRINT "Nenndurchmesser = Auendurchmesser
LOCATE ,15: PRINT "Wellenwerkstoff etwa St 490
LOCATE ,15: PRINT "Kerbziffer mit der Zugfestigkeit steigend
CALL KERBZIFFER
CALL OBERFLFAKTOR (OBFL)
CALL GROESSENFAKTOREN (GR)
GOTO ERGKERB

FALL12:
REM ********** EINSTIEG bei WELLE mit SPITZKERBE ******************** 12 *
CLS: COLOR 3,0
AA$="  WELLE mit SPITZKERBE
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 6: LINE (100,50)-(200,50): LINE (220,50)-(320,50)
LINE (200,50)-(210,60): LINE -(220,50)
LINE (200,50)-(200,100): LINE (220,50)-(220,100): LINE (210,60)-(210,100)
LINE (90,90)-(330,90)
COLOR 9: LOCATE 7,50: PRINT "Flankenwinkel 60 Grad"
BKB=2.5: BKT=1: QQ=1
COLOR 5: LOCATE 11,5: PRINT "Kerbwirkungszahl bei Biegung:";
COLOR 11: PRINT "      "; CHR$(225); "kb = "; BKB
COLOR 7: PRINT: LOCATE 14,5: PRINT "Gilt unter folgenden Bedingungen:
COLOR 9: LOCATE 16,15: PRINT "Nenndurchmesser = Auendruchmesser
LOCATE ,15: PRINT "Wellenwekstoff etwa St 490
LOCATE ,15: PRINT "Kerbziffer mit der Zugfestigkeit steigend
CALL KERBZIFFER
CALL OBERFLFAKTOR (OBFL)
CALL GROESSENFAKTOREN (GR)
GOTO ERGKERB

FALL13:
REM ********** EINSTIEG bei GLATTER ACHSE oder WELLE OHNE KERBWIRKUNG *13*
CLS: COLOR 3,0
AA$="  GLATTE ACHSE oder WELLE OHNE KERBWIRKUNG  "
CALL EINMITTEN (A,1,AA$)
FOR I=1 TO 79: PRINT "";: NEXT I
COLOR 14: LOCATE 6,17: PRINT "TABELLE DER BIEGEWECHSELFESTIGKEITEN VON WELLEN
PRINT: COLOR 7: PRINT CHR$(229); "B=              ";
COLOR 13: PRINT "               400      600      800      1000    1200    1400
PRINT: COLOR 5: PRINT "glatt poliert             ";
COLOR 7: PRINT "      210      300      385       460     520     580"
COLOR 5: PRINT "glatt feingedreht        ";
COLOR 7: PRINT "       190      275      340       390     435     470"
COLOR 5: PRINT "glatt korrodiert         ";
COLOR 7: PRINT "       130      140      148       145     140     135"
PRINT: PRINT
COLOR 9: PRINT "Diese Werte dienen nur zur Information. Das Programm rechnet mit den Wechsel- ": PRINT "oder Schwellfestigkeiten und bercksichtigt ferner den Oberflcheneinflu- "
PRINT "und Grenfaktor. Der Kerbfaktor wird als 1 angenommen.
BKB=1: BKT=1: QQ=1
CALL KERBZIFFER
14913 CALL OBERFLFAKTOR (OBFL)
14914 CALL GROESSENFAKTOREN (GR)


ERGKERB:
      REM ** ERGEBNISSE DER KERBBERECHNUNG **
SCREEN 0
14917 CLS: COLOR 0,3
14918 AA$="  ERGEBNISSE der KERBBERECHNUNG  "
14919 Z=1: CALL EINMITTEN (A,Z,AA$)
14920 COLOR 14,0: PRINT: LOCATE 3
PRINT "Werkstoff:                                      ";: COLOR 5
IF WNR<>12 THEN PRINT LEFT$(WERKSTOFF$,11)
IF WNR=12 THEN PRINT WERKSTOFF$
COLOR 14: PRINT: LOCATE 5: PRINT "Dauerfestigkeitswerte dieses Werkstoffes:
PRINT: COLOR 5: LOCATE ,10: PRINT "Biegewechselfestigkeit (N/mm2)      ";
IF WNR=12 THEN GOTO 14000
BWF=VAL(MID$(WERKSTOFF$,39,3))
BSF=VAL(MID$(WERKSTOFF$,50,3))
VWF=VAL(MID$(WERKSTOFF$,61,3))
VSF=VAL(MID$(WERKSTOFF$,71,3))
  14000 REM
LOCATE ,10: PRINT "Biegeschwellfestigkeit (N/mm2)      ";
PRINT USING "####.##"; BWF
LOCATE ,10: PRINT "Biegewechselfestigkeit (N/mm2)      ";
PRINT USING "####.##"; BSF
LOCATE ,10: PRINT "Verdrehwechselfestigkeit (N/mm2)    ";
PRINT USING "####.##"; VWF
LOCATE ,10: PRINT "Verdrehschwellfestigkeit (N/mm2)    ";
PRINT USING "####.##"; VSF
PRINT: COLOR 11: LOCATE 12,20: PRINT "Oberflcheneinflufaktor     ";
PRINT USING "#.##"; OBFL
LOCATE ,20: PRINT "Kerbfaktoren (Bieg,Verdr)    ";: PRINT USING "#.##";BKB;
PRINT "        ";: PRINT USING "#.##"; BKT
LOCATE ,20: PRINT "Grenfaktor                 ";
PRINT USING "#.##"; GR
PRINT: COLOR 14: PRINT "Fr Ihre Annahme ergeben sich folgende kerbbedingte Dauerfestigkeiten: "
BWFK=BWF*OBFL*GR/BKB*QQ
BSFK=BSF*OBFL*GR/BKB*QQ
VWFK=VWF*OBFL*GR/BKT*QQ
VSFK=VSF*OBFL*GR/BKT*QQ: GOTO 14969
  14969  IF ZEI<>13 GOTO 14975
PRINT: COLOR 7: LOCATE ,10: PRINT "Biegewechselfestigkeit        "; CHR$(229);
PRINT "bWN = ";: PRINT USING "###.##"; BWFK;: PRINT "  N/mm2
LOCATE ,10: PRINT "Biegeschwellfestigkeit        "; CHR$(229); "bSN = ";
PRINT USING "###.##"; BSFK;: PRINT "  N/mm2
LOCATE ,10: PRINT "Verdrehwechselfestigkeit      "; CHR$(231); "tWN = ";
PRINT USING "###.##"; VWFK;: PRINT "  N/mm2
LOCATE ,10: PRINT "Verdrehschwellfestigkeit      "; CHR$(231); "tSN = ";
PRINT USING "###.##"; VSFK;: PRINT "  N/mm2
GOTO ZIEL5
  14975  PRINT: COLOR 7: LOCATE ,10: PRINT "Biegewechselfestigkeit        ";
PRINT  CHR$(229); "bWK = ";: PRINT USING "###.##"; BWFK;: PRINT "  N/mm2
LOCATE ,10: PRINT "Biegeschwellfestigkeit        "; CHR$(229); "bSK = ";
PRINT USING "###.##"; BSFK;: PRINT "  N/mm2
LOCATE ,10: PRINT "Verdrehwechselfestigkeit      "; CHR$(231); "tWK = ";
PRINT USING "###.##"; VWFK;: PRINT "  N/mm2
LOCATE ,10: PRINT "Verdrehschwellfestigkeit      "; CHR$(231); "tSK = ";
PRINT USING "###.##"; VSFK;: PRINT "  N/mm2
ZIEL5:
COLOR 2 : LOCATE 22: FOR I=1 TO 80: PRINT "_";: NEXT I
LOCATE 23,5: PRINT "Wnschen Sie einen Ausdruck der Daten ? (J/N)";
ZIEL4:
R$=INKEY$: IF R$="" THEN GOTO ZIEL4
IF R$="J" OR R$="j" GOTO AUSDRUCKWERKSTOFFPARAMETER
IF R$<>"J" OR R$<>"j" THEN GOTO HAUPTMEN


AUSDRUCKWERKSTOFFPARAMETER:
CALL KOPFZEILE
LPRINT CHR$(27); "E"; "ERGEBNISSE der KERBBERECHNUNG:"
LPRINT: LPRINT: LPRINT: LPRINT CHR$(27); "F";
LPRINT CHR$(27); "-"; CHR$(1); "Werkstoff: ";
LPRINT CHR$(27); "-"; CHR$(0);: LPRINT TAB(52); LEFT$(WERKSTOFF$,11)
LPRINT: LPRINT
LPRINT CHR$(27); "-"; CHR$(1);
LPRINT "Angaben: ";
LPRINT CHR$(27); "-"; CHR$(0)
LPRINT
LPRINT TAB(5); "Biegewechselfestigkeit                 "; CHR$(229);
LPRINT "bW = ";: LPRINT USING "###.##"; BWF;: LPRINT "  N/mm2
LPRINT TAB(5); "Biegeschwellfestigkeit                 "; CHR$(229);
LPRINT "bS = ";: LPRINT USING "###.##"; BSF;: LPRINT "  N/mm2
LPRINT TAB(5); "Verdrehwechselfestigkeit               "; CHR$(231);
LPRINT "tW = ";: LPRINT USING "###.##"; VWF;: LPRINT "  N/mm2
LPRINT TAB(5); "Verdrehschwellfestigkeit               "; CHR$(231);
LPRINT "tS = ";: LPRINT USING "###.##"; VSF;: LPRINT "  N/mm2
LPRINT
LPRINT TAB(5); "Oberflcheneinflufaktor                BS = ";
LPRINT USING "###.##"; OBFL
LPRINT TAB(5); "Kerbfaktor (Biegung)                   "; CHR$(225); "kb = ";: LPRINT USING "###.##"; BKB
LPRINT TAB(5); "Kerbfaktor (Verdrehung)                "; CHR$(225); "kt = ";: LPRINT USING "###.##"; BKT
LPRINT TAB(5); "Grenfaktor                            B0 = ";: LPRINT USING "###.##"; GR
LPRINT: LPRINT
LPRINT CHR$(27); "-"; CHR$(1); "Ergebnisse: "
LPRINT
LPRINT CHR$(27); "-"; CHR$(0);
LPRINT "Biegewechselfestigkeit mit Kerbwirkung    "; CHR$(229); "bWK = ";
LPRINT USING "###.##"; BWFK;: LPRINT "  N/mm2
LPRINT "Biegeschwellfestigkeit mit Kerbwirkung    "; CHR$(229); "bSK = ";: LPRINT USING "###.##"; BSFK;: LPRINT "  N/mm2
LPRINT "Verdrehwechselfestigkeit mit Kerbwirkung  "; CHR$(231); "tWK = ";: LPRINT USING "###.##"; VWFK;: LPRINT "  N/mm2
LPRINT "Verdrehschwellfestigkeit mit Kerbwirkung  "; CHR$(231); "tSK = ";
LPRINT USING "###.##"; VSFK;: LPRINT "  N/mm2
GOTO DRUCKWEITER


AUSDRUCKACHSEUNDWELLE:

REM ********* ERGEBNISAUSDRUCK ACHSE oder WELLE *******************
CALL KOPFZEILE
LPRINT CHR$(27); "E"; "ERGEBNISSE der ACHSEN- oder WELLENBERECHNUNG
LPRINT: LPRINT: LPRINT: LPRINT CHR$(27); "F";
LPRINT CHR$(27); "-"; CHR$(1);
LPRINT "Angaben: ";
LPRINT CHR$(27); "-"; CHR$(0)
LPRINT
IF MB=0 GOTO KEINBIEGM
LPRINT TAB(5); "Biegemoment                        Mb = ";
LPRINT USING "########.##"; MB;: LPRINT "  Nmm
IF MB<>0 GOTO KEINDREHM
KEINBIEGM:
LPRINT TAB(5); "Biegemoment                        Mb = ";
LPRINT "-----------
DREHM:
LPRINT TAB(5); "Verdreh- oder Torsionsmoment       Mt = ";
LPRINT USING "########.##"; MT;: LPRINT "  Nmm
IF MB=0 THEN GOTO WEITER5
KEINDREHM:
LPRINT TAB(5); "Verdreh- oder Torsionsmoment       Mt = ";
LPRINT "-----------
WEITER5:
LPRINT TAB(5); "Sicherheitsfaktor                   S = ";
LPRINT USING "########.##"; SICHER
LPRINT TAB(5); "Betriebsfaktor                      C = ";
LPRINT USING "########.##"; C
GOTO DRUCKENDE

AUSDRUCKBIEGUNGUNDTORSION:
CALL KOPFZEILE
LPRINT CHR$(27); "E"; "ERGEBNISSE der BERECHNUNG auf BIEGUNG und TORSION
LPRINT: LPRINT: LPRINT CHR$(27); "F";
LPRINT CHR$(27); "-"; CHR$(1);
LPRINT "Angaben: ";
LPRINT CHR$(27); "-"; CHR$(0)
LPRINT
LPRINT TAB(5); "Vh. Innen- zu Auendurchmesser  Di/Da = ";
LPRINT USING "########.##"; VH
LPRINT TAB(5); "Biegemoment                        Mb = ";
LPRINT USING "########.##"; MB;: LPRINT "  Nmm
LPRINT TAB(5); "Verdreh- oder Torsionsmoment       Mt = ";
LPRINT USING "########.##"; MT;: LPRINT "  Nmm
LPRINT TAB(5); "Betriebsfaktor                      C = ";
LPRINT USING "########.##"; C
LPRINT TAB(5); "Sicherheitsfaktor                   S = ";
LPRINT USING "########.##"; SICHER
LPRINT TAB(5); "Belastungskennwert                  A = ";
LPRINT USING "########.##"; VAL(A$)

DRUCKENDE:
LPRINT: LPRINT
LPRINT CHR$(27); "-"; CHR$(1); "Ergebnisse: "
LPRINT
LPRINT CHR$(27); "-"; CHR$(0)
LPRINT TAB(5); "Vergleichsmoment                   MV = ";
LPRINT USING "########.##"; MV;: LPRINT "  Nmm
LPRINT TAB(5); "Kennwert B f.d. Anstrengung         B = ";
LPRINT USING "########.##"; B
LPRINT TAB(5); "Zulssige Spannung             SIGZUL = ";
LPRINT USING "########.##"; SIGZUL
LPRINT: LPRINT
LPRINT TAB(5); "Errechneter Durchmesser             D = ";
LPRINT USING "########.##"; D;: LPRINT "  mm
LPRINT TAB(5); "Gem R 40 gerundeter Durchmesser  Dg = ";
LPRINT USING "########.##"; X;: LPRINT "  mm

DRUCKWEITER:
LPRINT: LPRINT: LPRINT
LPRINT TAB(5) DATE$
LPRINT:LPRINT
LPRINT TAB(5) "Sachbearbeiter: ______________
LPRINT: LPRINT
LPRINT TAB(5) "Abteilung:      ______________
LPRINT CHR$(12)
GOTO HAUPTMEN:

AUSDRUCKNACHRECHNUNG:
REM
GOTO DRUCKENDE:
END