Program Integral;

(* Dieses Programm berechnet das Integral einer beliebigen, durch die
   Prozedur f gegebenen numerischen Funktion wahlweise mittels der

     Trapezregel
     Simpsonregel
     einer dritten Regel, die aus der Simpsoregel durch
       I3(2n) = S(2n) + 1/15 * (S(2n) - S(n))
     wobei S(n) fr den Wert der Simpsonregel mit n Sttzstellen steht *)

Const FName = 'Integral.ERG';  (* Dateiname fr Abgabe *)

Var Eps, a, b:     Real;
    Regel:         Integer;
    Quit:          Char;

Function Pot (Basis: Real; Exponent: Integer): Real;

(* Diese Funktion berechnet die Funktion Basis ^ Exponent fr ganzzahligen
   Exponenten                                                                 *)

Var Hilf:          Real;     (* Hilfsvariable fr die Multiplikationen in der Schleife *)
    I:             Integer;  (* Zhlervariable *)

Begin (* Pot *)
      Hilf := 1;
      For I := 1 to Exponent do Hilf := Hilf * Basis;
      Pot := Hilf;
End;  (* Hilf *)

Function f (X: Real): Real;

(* Diese Funktion stellt den Integranden dar *)

Begin (* f *)
      f := sin (Pi * X / 180);
End;  (* f *)

Procedure Trapez (Var n: Integer; Tn, a, b: Real; Var T2n: Real);

(* Diese Prozedur berechnet den Wert einer Nherung mittels der Trapezregel,
   wobei jeweils auf einen vorher berechneten Wert (Tn) zurckgegriffen wird

   n:     Anzahl der Unterteilungen des Integrationsintervalls
   a, b:  Integrationsgrenzen
   Tn:    alte Nherung
   T2n:   neue Nherung                                                       *)

Var H:             Real;     (* Differenz zwischen zwei berechneten Funktionswerten *)
    I:             Integer;  (* Zhlvariable *)

Begin (* Trapez *)
      H := (b - a) / n;
      T2n := Tn / 2;
      For I := 0 to n - 1 do T2n := T2n + f(a + (2 * I + 1) * h / 2) * h / 2;
      n := 2 * n;
End;  (* Trapez *)

Procedure Integral1 (Eps, a, b: Real);

(* Diese Prozedur berechnet aufeinanderfolgende Nherungen nach der Trapezregel,
   bis sich zwei aufeinanderfolgende Werte um weniger als 3 * Eps unterscheiden

   Eps:   Verwendet als Abbruchbedingung
   a, b:  Integrationsgrenzen                                                 *)

Var n:             Integer;  (* Zhler fr Anzahl der Unterteilungen der nchsten Nherung *)
    Tn, T2n:       Real;     (* aufeinanderfolgende Werte fr die Nherung *)

Begin (* Integral1 *)
      n := 1;                (* Beginn mit einer Unterteilung *)
      T2n := (b - a) * (f(a) + f(b)) / 2;
                             (* Berechnung der ersten Nherung *)
      Writeln;
      Writeln ('   n         Tn          Fehler');
      Writeln ('');
      Repeat Tn := T2n;
             Trapez (n, Tn, a, b, T2n);
                             (* Berechnung der nchsten Nherung *)
             Writeln ('  ', (n div 2):5,'  ',T2n:11,'  ',Abs (T2n - Tn):11);
                             (* Ausgabe des Zwischenergebnisses *)
      Until Abs (T2n - Tn) < 3 * Eps;
      Writeln;
      Writeln ('letzte Nherung: ',T2n,', Fehler: ',Abs (T2n - Tn):11);
End;  (* Integral1 *)

Procedure Integral2 (Eps, a, b: Real);

(* Diese Prozedur berechnet die Nherungen fr das Integral nach der
   Trapezregel und aus diesen eine Nherung nach der Simpsonregel
   Diese Berechnung wird durchgefhrt, bis sich zwei Nherungen nach
   der Simpsonregel um weniger als 15 * Eps unterscheiden

   Eps:   Verwendet als Abbruchbedingung
   a, b:  Integrationsgrenzen                                                 *)

Var n:             Integer;  (* Zhler fr Anzahl der Unterteilungen bei nchster Trapeznherung *)
    Tn, T2n:       Real;     (* Nherungen nach der Trapezregel *)
    Sn, S2n:       Real;     (* Nherungen nach der Simpsonregel *)
    Faktor:        Integer;  (* Hilfsvariable zum Berechnen, wie oft noch unterteilt werden mte *)
    Stuetz:        Integer;  (* Hilfsvariable zum Berechnen der notwendigen Anzahl von Sttzstellen *)

Const ln4 = 1.386294361;

Begin (* Integral2 *)
      n := 1;                (* Beginn mit einer Unterteilung *)
      Tn := (b - a) * (f(a) + f(b)) / 2;
                             (* Berechnung der ersten Nherung *)
      Writeln;
      Writeln ('   n         Tn           Sn          Fehler');
      Writeln ('');
      Trapez (n, Tn, a, b, T2n);
                             (* Berechnung der zweiten Nherung *)
      Writeln ('  ', (n div 2):5,'  ',T2n:11,'        -           -');
                             (* Ausgabe des ersten Zwischenergebnisses (1. Trapeznherung) *)
      S2n := T2n + (1/3) * (T2n - Tn);
      Repeat Sn := S2n;
             Tn := T2n;
             Trapez (n,Tn,a,b,T2n);
             S2n := T2n + (1/3) * (T2n - Tn);
             Writeln ('  ', (n div 2):5,'  ',T2n:11,'  ',S2n:11,'  ',Abs (S2n - Sn):11);
                             (* Ausgabe des nchsten Zwischenergebnisses *)
      Until Abs (S2n - Sn) < 15 * Eps;
      Faktor := Trunc (ln (abs ((T2n - Tn) / (S2n - Sn))) / ln4 + 1);
      Stuetz := Trunc (Pot (2, Faktor));
      Stuetz := (n div 2) * Stuetz;
      Writeln;
      Writeln ('Der letzte Simpson-Wert wurde aus ',(n div 2):1,' Sttzstellen be-');
      Writeln ('rechnet, er hat einen Fehler von ungefhr ',Abs (S2n - Sn):8,'. Wenn');
      Writeln ('man weiter unterteilen mte, bis auch die Trapezregel');
      Writeln ('zu einem ebenso genauen Resultat fhrt, dann mte man');
      Writeln ('h noch ',Faktor:1,' mal halbieren, also bruchte man insgesamt');
      Writeln (Trunc (Stuetz):1,' Sttzstellen.');
End;  (* Integral2 *)

Procedure Integral3 (Eps, a, b: Real);

(* Diese Prozedur berechnet die Nherungen fr das Integral nach einer aus
   der Simpson Regel abgeleiteten Formel:
       I3(2n) = S(2n) + 1/15 * (S(2n) - S(n))
   Diese Berechnung wird durchgefhrt, bis sich zwei Nherungen nach dieser
   Regel um weniger als 63 * Eps unterscheiden

   Im folgenden wird diese Regel zur Vereinfachung des Textes nur mehr
   "Superregel" genannt

   Eps:   Verwendet als Abbruchbedingung
   a, b:  Integrationsgrenzen                                                 *)

Var n:             Integer;  (* Zhler fr Anzahl der Unterteilungen bei nchster Trapeznherung *)
    Tn, T2n:       Real;     (* Nherungen nach der Trapezregel *)
    Sn, S2n:       Real;     (* Nherungen nach der Simpsonregel *)
    I1n, I2n:      Real;     (* Nherungen nach der Superregel *)

Begin (* Integral3 *)
      n := 1;                (* Beginn mit einer Unterteilung *)
      Tn := (b - a) * (f(a) + f(b)) / 2;
                             (* Berechnung der ersten Nherung *)
      Writeln;
      Writeln ('   n         Tn           Sn           In        Fehler');
      Writeln ('');
      Trapez (n, Tn, a, b, T2n);
                             (* Berechnung der zweiten (Trapez-) Nherung *)
      Writeln ('  ', (n div 2):5,'  ',T2n:11,'       -            -            -');
                             (* Ausgabe des ersten Zwischenergebnisses (1. Trapeznherung) *)
      Sn := T2n + (1/3) * (T2n - Tn);
      Tn := T2n;
      Trapez (n, Tn, a, b, T2n);
                             (* Berechnung der dritten (Trapez-) Nherung *)
      S2n := T2n + (1/3) * (T2n - Tn);
      Writeln ('  ', (n div 2):5,'  ',T2n:11,'  ',S2n:11,'       -            -');
                             (* Ausgabe des zweiten Zwischenergebnisses *)
      I2n := S2n + (1/15) * (S2n - Sn);
      Repeat I1n := I2n;
             Sn := S2n;
             Tn := T2n;
             Trapez (n, Tn, a, b, T2n);
             S2n := T2n + (1/3) * (T2n - Tn);
             I2n := S2n + (1/15) * (S2n - Sn);
             Writeln ('  ', (n div 2):5,'  ',T2n:11,'  ',S2n:11,'  ',I2n:11,'  ',Abs (I2n - I1n):11);
                             (* Ausgabe des zweiten Zwischenergebnisses *)
      Until Abs (I2n - I1n) < 63 * Eps;
      Writeln;
      Writeln ('letzte Nherung: ',I2n,', Fehler: ',Abs (I2n - I1n):11);
End;  (* Integral3 *)

Procedure Eingabe (Var Eps, a, b: Real; Var I: Integer);

Begin (* Eingabe *)
      Repeat Writeln ('Es stehen 3 verschiedene Verfahren zur numerischen Integration zur');
             Writeln ('Verfgung:');
             Writeln;
             Writeln ('  1: Trapezregel');
             Writeln ('  2: Simpsonregel');
             Writeln ('  3: Superregel');
             Writeln;
             Write ('Bitte whlen Sie (1..3): ');
             Readln (I);
      Until (I >= 0) and (I <= 3);
      Writeln;
      Write  ('Eps = ');
      Readln ( Eps );
      Write  ('a   = ');
      Readln ( a );
      Write  ('b   = ');
      Readln ( b );
End;  (* Eingabe *)

Begin (* Integral *)
      Writeln ('Programm Integral von');
      Writeln;
      Writeln ('         Ronald  Hasenberger Matrikelnummer 8725055');
      Writeln ('         Andreas Hengl       Matrikelnummer 8725114');
      Writeln;
      Repeat Eingabe (Eps, a, b, Regel);
             Case Regel of 1: Integral1 (Eps, a, b);
                           2: Integral2 (Eps, a, b);
                           3: Integral3 (Eps, a, b);
             End;  (* Case *)
             Writeln;
             Writeln;
             Repeat Write ('Neue Berechnung ? (J/N): ');
                    Readln (Quit);
                    Quit := UpCase (Quit);
             Until Quit in (.'J','N'.);
      Until Quit = 'N';
End.  (* Integral *)