{ ************************************
  *                                  *
  *  L A B E L P R I N T   V  1 . 0  *
  *                                  *
  ************************************
  * Beginn           :  14.03.1990   *
  * Letzte Edition   :  23.03.1990   *
  ************************************ }

Uses PRINTER,CRT,DOS;

label loop;

const Max = 350;

type Datensatz = record
                   Nummer   : integer;
                   Titel    : string[25];
                   Nachname : string[20];
                   Vorname  : string[20];
                   Strasse  : string[30];
                   Bezirk   : string[5];
                   Ort      : string[15];
                   Land     : string[15];
                 end;

var Num,lw            : byte;
    Datei             : file of Datensatz;
    Name,Pfad         : string;
    datas             : array [1..Max] of Datensatz;
    frei              : array [1..Max] of boolean;
    n,i               : integer;
    dummy             : Datensatz;
    c                 : char;
    FehlerAlt,ExitAlt : POINTER;

PROCEDURE HardwareFehler(AX,BX,CX,DX,SI,DI,DS,ES,BP : Word); INTERRUPT;
VAR c : char;
BEGIN
  writeln('');
  HighVideo;
  WriteLn('ACHTUNG - Kritischer Hardwarefehler:');
  LowVideo;
  CASE lo(DI) OF
      0 : writeln('Gert ist schreibgeschtzt');
      1 : writeln('Unbekannte Einheit');
      2 : writeln('Laufwerk nicht bereit');
      3 : writeln('Unbekanntes Kommando');
      4 : writeln('CRC (bzw. ECC)-Fehler in den Daten');
      5 : writeln('Falsche Anforderungsblocklnge');
      6 : writeln('Seek-Fehler');
      7 : writeln('Unbekanntes Format');
      8 : writeln('Sektor nicht gefunden');
      9 : writeln('Kein Papier mehr im Drucker');
      10: writeln('Schreibfehler (z.B. Drucker nicht eingeschaltet)');
      11: writeln('Lesefehler');
    ELSE writeln('Allgemeiner nicht nher spezifizierter Fehler')
  END;
  writeln('');
  Write('Ignorieren, Wiederholen, Abbrechen? (I,W,A) ');
  REPEAT
    c:=upcase(ReadKey)
  UNTIL c IN ['I','W','A'];
  write(c);
  CASE c OF
      'I':AX:=AX AND $FF00;
      'W':AX:=AX AND $FF00 OR 1;
      'A':exit;
  END;
  writeln('');
END;

{$F+}
PROCEDURE ExitNeu;
{$F-}
BEGIN
  SetIntVec($24,FehlerAlt);
  ExitProc:=ExitAlt;
END;

procedure Init_Fehler;
begin
  GetIntVec($24,FehlerAlt);
  SetIntVec($24,@HardwareFehler);
  ExitAlt:=ExitProc; ExitProc:=@ExitNeu;
end;

procedure Beep;
begin
  writeln(#7);
end;

procedure getkey(n:integer);
var c:char;
begin
  c:=readkey;
  if ord(c)<>n then getkey(n);
end;

procedure Weiter;
begin
  writeln('');
  write('<CR> zum fortfahren ... ');
  getkey(13);
  writeln('');
end;

procedure Init;
begin
  for i:=1 to Max do frei[i]:=true;
  Pfad:='A:\';
  Name:='Adressen.dat';
  lw:=1;
end;

procedure Fehler_Disk(Code : integer);
begin
  writeln('');
  highvideo;
  writeln('Disketten - Fehler');
  lowvideo;
  writeln('Nummer des Fehlers : ',Code);
  writeln('');
  writeln('Kritischer Fehler oder Datei nicht gefunden');
  Weiter;
end;

function Exist_Disk(Name : string):boolean;
var dummy : integer;
begin
  assign(Datei,Name);
  {$I-}
  reset(Datei);
  close(Datei);
  {$I+}
  dummy:=ioresult;
  Exist_Disk:=(dummy = 0) and (Name <> '');
  if dummy<>0 then Fehler_Disk(dummy);
end;

procedure Fehler_Printer(Code : integer);
begin
  writeln('');
  highvideo;
  writeln('Drucker - Fehler');
  lowvideo;
  writeln('Nummer des Fehlers : ',Code);
  writeln('');
  case Code of
    200 : writeln('Drucker ist nicht eingeschaltet!');
     56 : writeln('Drucker hat kein Papier mehr!');
     24 : writeln('Drucker ist OFF-LINE!');
    144 : writeln('Drucker ist in Ordnung');
    else writeln('Unbekannter Druckerfehler!');
  end;
  Weiter;
end;

function Exist_Printer : boolean;
var regs : registers;
begin
  regs.ah:=$02;
  regs.dx:=$0000;
  intr($17,regs);
  if regs.ah<>144 then begin
    Exist_Printer:=false;
    Fehler_Printer(regs.ah);
  end;
  if regs.ah=144 then Exist_Printer:=true;
end;

procedure Datei_Erstellen(Name : string);
var dummy : integer;
begin
  assign(Datei,Name);
  {$I-}
  rewrite(Datei);
  close(Datei);
  {$i+}
  dummy:=ioresult;
  if dummy<>0 then Fehler_Disk(dummy);
end;

procedure Datei_Loschen(Name : string);
begin
  if Exist_Disk(Name) then begin
    assign(Datei,Name);
    erase(Datei);
  end;
end;

procedure Datei_Offnen(Name : string);
begin
  if Exist_Disk(Name) then begin
    assign(Datei,Name);
    reset(Datei);
    if filesize(Datei)<>0 then
      for i:=1 to filesize(Datei) do begin
        read(Datei,dummy);
        datas[dummy.nummer]:=dummy;
        frei[dummy.nummer]:=false;
      end;
  end;
end;

procedure Datei_Status(Name : string);
begin
  if Exist_Disk(Name) then begin
    assign(Datei,Name);
    reset(datei);
    writeln('');
    writeln('Pfad     : ',Pfad);
    writeln('Filename : ',Name);
    writeln('Gre    : ',FileSize(Datei),' Datenstze von ',Max,' mglichen');
    write('Freier Speicher auf Disk/Platte : ',diskfree(lw) div 1024,' kByte ');
    writeln('von ',disksize(lw) div 1024,' kByte Gesamtkapazitt');
  end;
end;

procedure Datei_Speichern(Name : string);
begin
  if Exist_Disk(Name) then begin
    assign(Datei,Name);
    Datei_Loschen(Name);
    Datei_Erstellen(Name);
    rewrite(Datei);
    for i:=1 to Max do
      if frei[i]=false then write(Datei,Datas[i]);
    close(Datei);
  end;
end;

procedure Out(Nummer : integer);
begin
  with Datas[Nummer] do begin
    writeln('Nummer : ',nummer);
    writeln(Titel);
    writeln(Nachname,' ',Vorname);
    writeln(Strasse);
    writeln(Bezirk,' ',Ort,' - ',Land);
  end;
end;

procedure Out_Drucker(Nummer : integer);
label loop;
begin
  loop:
  if exist_printer<>true then goto loop;
                             { Druckercodes fr SEIKOSHA SL-80 IP,
                               entspricht EPSON Standard }
    write(lst,#27,#80);      { 10 CPI }
    write(lst,#27,#120,#1);  { LQ }
    write(lst,#27,#65,#12);  { Zeilenvorschub 12/180" }
    writeln(lst);
    with Datas[Nummer] do begin
      writeln(lst,Titel);
      writeln(lst,Nachname,' ',Vorname);
      writeln(lst,Strasse);
      writeln(lst);
      write(lst,#27,#45,#1); { Unterstreichen EIN }
      write(lst,Bezirk,' ',Ort,' - ');
      write(lst,#27,#69);    { Schattenschrift EIN }
      writeln(lst,Land);
      write(lst,#27,#70);    { Schattenschrift AUS }
      write(lst,#27,#45,#0); { Unterstreichen AUS }
      write(lst,#27,#74,#21);{ Vorschub nchstes Blatt }
      writeln(lst);
    end;
end;

procedure Menu;
begin
clrscr;
writeln('               ͻ');
writeln('                    Ŀ     ');
writeln('                     LabelPRINT V 1.0 by Marcus Nefzger      ');
writeln('                         ');
writeln('                                                               ');
writeln('                             Bitte whlen Sie aus              ');
writeln('                                                               ');
writeln('               ͹');
writeln('                                                               ');
writeln('                   F1    ...  Neue Datei erstellen             ');
writeln('                   F2    ...  Existierende Datei lschen       ');
writeln('                   F3    ...  Existierende Datei ffnen        ');
writeln('                   F4    ...  Existierende Datei schlieen     ');
writeln('                   F5    ...  Existierende Datei drucken       ');
writeln('                   F6    ...  Existierende Datei sortieren     ');
writeln('                   F7    ...  Datenstze auflisten             ');
writeln('                   F8    ...  Einzelne Datenstze editieren    ');
writeln('                   F9    ...  Einzelne Datenstze lschen      ');
writeln('                   F10   ...  Einzelne Datenstze drucken      ');
writeln('                   ESC   ...  Programm beenden                 ');
writeln('                                                               ');
writeln('                                                               ');
writeln('                                   Wahl :                      ');
writeln('               ͼ');
gotoxy(44,23);
end;

procedure Wahl(var Ergebnis : byte);
var c:char;
begin
  Ergebnis:=255;
  repeat
    c:=readkey;
      if c=#27 then Ergebnis:=127;
                       { ESC : Ergebnis = 127 }
      if c=#0 then begin
                     c:=readkey;
                     if c in [#59..#68] then Ergebnis:=ord(c)-58;
                       { F1 - F10 : Ergebnis = 1 - 10 }
                     if c in [#84..#93] then Ergebnis:=ord(c)-73;
                       { Shift F1 - F10 : Ergebnis = 11 - 20 }
                     if c in [#94..#103] then Ergebnis:=ord(c)-73;
                       { Ctrl F1 - F10 : Ergebnis = 21 - 30 }
                     if c in [#104..#113] then Ergebnis:=ord(c)-73;
                       { Alt F1 - F10 : Ergebnis = 31 - 40 }
                    end;
  until Ergebnis<>255;
  Beep;
end;

procedure Neu_Datei_E;
begin
  clrscr;
  writeln('--- Datei erstellen');
  writeln('Pfad ist ',Pfad);
  chdir(Pfad);
  write('Dateiname : ');
  readln(Name);
  Datei_Erstellen(Name);
end;

procedure Ex_Datei_L;
begin
  clrscr;
  writeln('--- Datei lschen');
  write('Dateiname : ');
  readln(Name);
  Datei_Loschen(Name);
end;

procedure Ex_Datei_O;
begin
  clrscr;
  writeln('--- Datei ffnen');
  writeln('Pfad ist ',Pfad);
  chdir(Pfad);
  writeln('Dateiname ist ',Name);
  if Exist_Disk(Name) then begin
    Datei_Status(Name);
    Datei_Offnen(Name);
    if filesize(Datei)<>0 then writeln('--- Datenstze wurden gelesen ');
    Weiter;
  end;
end;

procedure Ex_Datei_S;
begin
  clrscr;
  writeln('--- Datei schlieen');
  Datei_Speichern(Name);
end;

procedure Ex_Datei_D;
begin
  clrscr;
  write('--- Datei drucken ');
  for i:=1 to Max do
    if frei[i]=false then begin
      Out_Drucker(i);
    end;
  writeln('');
  writeln('...fertig');
  Weiter;
end;

procedure Ex_Datei_Sort;
begin
  clrscr;
  writeln('--- Pfad ndern');
  writeln('Aktueller Pfad :',Pfad);
  write('Neuer Pfad fr Datendatei : ');
  readln(Pfad);
  c:=upcase(Pfad[1]);
  case c of
    'A' : lw:=1;
    'B' : lw:=2;
    'C' : lw:=3;
    'D' : lw:=4;
    'E' : lw:=5;
  end;
end;

procedure Daten_A;
begin
  clrscr;
  for i:=1 to Max do
    if frei[i]=false then begin
      Out(i);
      writeln('');
    end;
  Weiter;
end;

procedure Daten_E;
begin
  clrscr;
  write('Datensatz Nr : ');
  readln(n);
  writeln('');
  if frei[n]=false then begin
    Out(n);
    writeln('');
    writeln('Datensatz besteht bereits!');
    write('Trotzdem fortfahren J/N ');
    c:=upcase(readkey);
    if c<>'J' then exit;
    writeln('');
  end;
  if frei[n]<>false then writeln('Neuer Datensatz');
  writeln('');
  frei[n]:=false;
  with datas[n] do begin
    Nummer:=n;
    write('Titel    : ');readln(titel);
    write('Nachname : ');readln(nachname);
    write('Vorname  : ');readln(vorname);
    write('Strasse  : ');readln(strasse);
    write('Bezirk   : ');readln(bezirk);
    write('Ort      : ');readln(Ort);
    write('Land     : ');readln(land);
  end;
end;

procedure Daten_L;
begin
  clrscr;
  writeln('--- Daten lschen');
  write('Datensatz Nr : ');
  readln(n);
  frei[n]:=true;
end;

procedure Daten_D;
begin
  clrscr;
  writeln('--- Datensatz drucken');
  write('Datensatz Nr : ');
  readln(n);
  Out_Drucker(n);
  writeln('');
  writeln('Datensatz gedruckt');
  Weiter;
end;

procedure Quit;
begin
  clrscr;
  halt;
end;

begin { Hauptprogramm }
Init_Fehler;
Init;
loop:
  Menu; { Auswahlmen zeigen }
  Wahl(Num); { Auswahl treffen }
    case Num of { verzweigen }
      1 : Neu_Datei_E;
      2 : Ex_Datei_L;
      3 : Ex_Datei_O;
      4 : Ex_Datei_S;
      5 : Ex_Datei_D;
      6 : Ex_Datei_Sort;
      7 : Daten_A;
      8 : Daten_E;
      9 : Daten_L;
     10 : Daten_D;
    127 : Quit;
    end; { case }
goto loop; { Endlosschleife - nur mit QUIT zu verlassen }
end. { Hauptprogramm }