{$R-}                   {BEREICHSPRFUNG AUS}
{$B+}                   {VOLLSTNDIGE AUSWERTUNG BOOLSCHER AUSDRCKE}
{$S+}                   {STACKPRFUNG AN}
{$I+}                   {I/O-PRFUNG AN}
{$N+}                   {NUMERISCHER COPROZESSOR}
{$M 65500,16384,655360} {STANDARDVORGABEN FR STACK&HEAP}

{ ) FLCHE
  ) SCHWERPUNKT
  ) TRGHEITSMOMENT
  ) HAUPTTRGHEITSMOMENT
  ) TRGHEITSRADIUS      }

USES CRT,GRAPH;

LABEL BERECHNUNG,
      EINGABE,
      AUSGABE,
      ZEICHNUNG,
      ENDE,
      FEHLER;

CONST MIN = 3;
      MAX = 3500;
      PI  = 3.14159265359;
      RNG = 57.2957795131;
      BV  = 1.465;

TYPE LISTE_BERECHNUNG = ARRAY [1..MAX] OF REAL;
     LISTE_ZEICHNUNG  = ARRAY [1..MAX] OF POINTTYPE;

VAR
    X,Y                    : LISTE_BERECHNUNG;

    Z                      : LISTE_ZEICHNUNG;

    EH                     : STRING;

    TREIBER,MODUS,MDX,MDY,
    ZBX,ZBY,K,N,FLAG,Z1,Z2,
    ae,as                  : INTEGER;

    MX,MY,IX,IY,IZ,SX,SY,
    SZ,JX,JY,JZ,J1,J2,RI,
    RJ,A,R,S,P,Q,D,I,J,W,
    DUMMY,FACTX,FACTY,FACT,da : REAL;

    C                      : CHAR;

var AZ,EZ                  : longint;
    SysTick                : longint absolute $40:$6C;

procedure Time;
begin
  write((EZ-AZ)/18.20648193:4:2,' [Sec]  ->  ');
  write((ez-az)/(18.20648193*60):4:2,' [Min]');
end;

PROCEDURE GETKEY(N:INTEGER);
VAR C:CHAR;
BEGIN
  C:=READKEY;
  IF ORD(C)<>N THEN GETKEY(N);
END;

PROCEDURE CROSS(X,Y,DELTA:INTEGER);
BEGIN
  LINE(X-DELTA,Y,X+DELTA,Y);
  LINE(X,Y-ROUND(DELTA/BV),X,Y+ROUND(DELTA/BV));
END;

PROCEDURE GRAPHEIN;
BEGIN
  DETECTGRAPH(TREIBER,MODUS);
  INITGRAPH(TREIBER,MODUS,'');
  SETFILLSTYLE(LTSLASHFILL,0);
  DUMMY:=GETMAXX;MDX:=TRUNC(DUMMY/2);
  DUMMY:=GETMAXY;MDY:=TRUNC(DUMMY/2);
  ZBX:=MDX-10;ZBY:=MDY-6;
  CLEARDEVICE;
END;

PROCEDURE GRAPHAUS;
BEGIN
  CLEARDEVICE;
  CLOSEGRAPH;
  RESTORECRTMODE;
END;

BEGIN

az:=systick;

{******************}
EINGABE:
{******************}

  CLRSCR;
  GOTOXY(10,5);WRITE('ANZAHL DER ECKPUNKTE : ');
  READLN(N);
  FLAG:=1;
  IF N<MIN THEN GOTO FEHLER;
  FLAG:=2;
  IF N>MAX THEN GOTO FEHLER;
  GOTOXY(10,10);WRITE('EINHEIT DER WERTE : ');
  READLN(EH);
  FOR K:=1 TO N DO BEGIN
                     CLRSCR;
                     GOTOXY(10,7);WRITE(K:2,'. ECKPUNKT:   X-KOORDINATE : ');
                     READLN(X[K]);
                     GOTOXY(10,9);WRITE('                Y-KOORDINATE : ');
                     READLN(Y[K]);
                   END;

{******************}
BERECHNUNG:
{******************}

  A:=0;MX:=0;MY:=0;IX:=0;IY:=0;IZ:=0;
  R:=X[N];S:=Y[N];
  FOR K:=1 TO N DO BEGIN
                     P:=R;Q:=S;R:=X[K];S:=Y[K];D:=P*S-Q*R;
                     A:=A+D;
                     MX:=MX+D*(Q+S);
                     MY:=MY+D*(P+R);
                     IX:=IX+D*(Q*Q+Q*S+S*S);
                     IY:=IY+D*(P*P+P*R+R*R);
                     IZ:=IZ+D*(P*Q+R*S+(P*S+Q*R)/2);
                   END;
  A:=A/2;
 { FLAG:=3;IF A=0 THEN GOTO FEHLER; }
  MX:=MX/6;
  MY:=MY/6;
  IX:=IX/12;
  IY:=IY/12;
  IZ:=IZ/12;
  SX:=MY/A;
  SY:=MX/A;
  JX:=IX-A*SY*SY;
  JY:=IY-A*SX*SX;
  JZ:=IZ-A*SX*SY;
  J1:=(JY+JX)/2;
  J2:=(JY-JX)/2;
  W:=PI/2;
  IF ABS(JZ)<ABS(J1)*1E-6 THEN W:=0;
  IF ABS(J2)>ABS(J1)*1E-6 THEN W:=ARCTAN(JZ/J2);
  I:=J1-J2*COS(W)-JZ*SIN(W);
  J:=JX+JY-I;
  W:=W*RNG/2;
  RI:=SQRT(ABS(I/A));
  RJ:=SQRT(ABS(J/A));
  A:=ABS(A);
  CLRSCR;

{******************}
AUSGABE:
{******************}

  GOTOXY(1,25);
  WRITELN('        ---> ALLE WERTE BEZOGEN AUF DAS GEWHLTE KOORDINATENSYSTEM <---');
  GOTOXY(1,1);
  WRITELN('FLCHE                 A   : ',A:1:5,' ',EH,'^2');
  WRITELN;
  WRITELN('SCHWERPUNKTSABSTNDE   SX  : ',SX:1:5,' ',EH);
  WRITELN('                       SY  : ',SY:1:5,' ',EH);
  WRITELN;
  WRITELN('TRGHEITSMOMENTE       IX  : ',IX:1:5,' ',EH,'^4');
  WRITELN('  (KOORDINATENACHSE)   IY  : ',IY:1:5,' ',EH,'^4');
  WRITELN('                       IXY : ',IZ:1:5,' ',EH,'^4');
  writeln('                       IP  : ',ix+iy:1:5,' ',eh,'^4');
  WRITELN;
  WRITELN('TRGHEITSMOMENTE       IX  : ',JX:1:5,' ',EH,'^4');
  WRITELN('  (KOORDINATENACHSE    IY  : ',JY:1:5,' ',EH,'^4');
  WRITELN('   DURCH SCHWERPUNKT)  IXY : ',JZ:1:5,' ',EH,'^4');
  writeln('                       IP  : ',jx+jx:1:5,' ',eh,'^4');
  WRITELN;
  WRITELN('HAUPTTRGHEITSMOMENTE  I1  : ',I:1:5,' ',EH,'^4');
  WRITELN('  (SCHWERACHSE)        I2  : ',J:1:5,' ',EH,'^4');
  WRITELN;
  WRITELN('DREHWINKEL             W   : ',W:1:5,' ');
  WRITELN;
  WRITELN('TRGHEITSRADIEN        I1  : ',RI:1:5,' ',EH);
  WRITE('                       I2  : ',RJ:1:5,' ',EH,' ');
  GETKEY(13);
  CLRSCR;

{******************}
ZEICHNUNG:
{******************}

  GRAPHEIN;FLAG:=4;
  IF GRAPHRESULT<>0 THEN GOTO FEHLER;
  DUMMY:=ABS(X[1]);
  FOR K:=2 TO N DO IF ABS(X[K])>DUMMY THEN DUMMY:=ABS(X[K]);
  FACTX:=ZBX/DUMMY;
  DUMMY:=ABS(Y[1]);
  FOR K:=2 TO N DO IF ABS(Y[K])>DUMMY THEN DUMMY:=ABS(Y[K]);
  FACTY:=ZBY*BV/DUMMY;
  FACT:=FACTX;
  IF FACTX>FACTY THEN FACT:=FACTY;
  line(mdx,0,mdx,384);outtextxy(362,0,'y');
  line(0,mdy,720,mdy);outtextxy(712,173,'x');
  FOR K:=1 TO N DO BEGIN
                     Z[K].X:=ROUND(MDX+X[K]*FACT);
                     Z[K].Y:=ROUND(MDY-Y[K]*FACT/BV);
                   END;
  Z[N+1].X:=ROUND(MDX+X[1]*FACT);
  Z[N+1].Y:=ROUND(MDY-Y[1]*FACT/BV);
  Fillpoly(n+1,z);
  Z1:=ROUND(MDX+SX*FACT);
  Z2:=ROUND(MDY-SY*FACT/BV);
  CROSS(Z1,Z2,6);
  LINE(5,3,ROUND(5+FACT),3);
  CROSS(5,3,4);
  CROSS(ROUND(5+FACT),3,4);
  GETKEY(13);
  GRAPHAUS;

{******************}
ENDE:
{******************}

  CLRSCR;GOTOXY(10,8);
  WRITELN('B) ERECHNUNG WIEDERHOLEN');
  GOTOXY(10,10);WRITELN('G) RAPHIK WIEDERHOLEN');
  GOTOXY(10,12);WRITELN('N) EUE BERECHNUNG');
  GOTOXY(10,14);WRITE('E) NDE DES PROGRAMMES ');
  C:=READKEY;IF ORD(C)>=97 THEN C:=CHAR(ORD(C)-32);CLRSCR;
  IF C='B' THEN GOTO AUSGABE;
  IF C='N' THEN GOTO EINGABE;
  IF C='G' THEN GOTO ZEICHNUNG;
  ez:=systick;
  clrscr;
  write('Activ fr : ');Time;
EXIT;

{******************}
FEHLER:
{******************}

  IF FLAG=1 THEN BEGIN
                    CLRSCR;
                    GOTOXY(10,10);
                    WRITE(N:1,' PUNKT(E) BEGRENZEN KEINEN QUERSCHNITT ! ');
                    DELAY(3000);
                    CLRSCR;
                    GOTO EINGABE;
                  END;

  IF FLAG=2 THEN BEGIN
                    CLRSCR;
                    GOTOXY(10,10);
                    WRITE(N:1,' PUNKTE SIND ZUVIEL ! ');
                    DELAY(3000);
                    CLRSCR;
                    GOTO EINGABE;
                  END;

  IF FLAG=3 THEN BEGIN
                    CLRSCR;
                    GOTOXY(10,10);
                    WRITELN('KOORDINATEN UNGLTIG !');
                    GOTOXY(10,11);
                    WRITE('FLCHE IST 0 MM GROSS');
                    DELAY(3000);
                    CLRSCR;
                    GOTO EINGABE;
                  END;

  IF FLAG=4 THEN BEGIN
                    CLRSCR;
                    GOTOXY(10,10);
                    WRITE('GRAPHIKTREIBER KONNTE NICHT KORREKT INSTALLIERT WERDEn ! ');
                    DELAY(3000);
                    CLRSCR;
                    HALT;
                  END;

END.