program btx;
{-[ 23-03-89/nn ]----------------------------------------------------}
{                 datei ber mitteilungsdienst (*820#) empfangen,    }
{                 andere nachrichten grafisch ausdrucken             }
{-[ janussoft ]----------------------------------------------------}
 uses
    printer,                      { druckfunktionen                  }
    btxapi;                       { schnittstelle zum decoder        }
 var
    rc: word;                     { rckkehr code                    }
    s, r: string;                 { zwischenspeicher                 }
    p: byte;                      { suchposition                     }

procedure SeiteDrucken;
{-[ 23-03-89/nn ]----------------------------------------------------}
{                 aktuelle btx seite grafisch ausdrucken             }
{-[ janussoft ]----------------------------------------------------}
 var
    buf: printbuffer;             { puffer fr pixel daten           }
    len: integer;                 { lnge einer zeile                }
 begin
    writeln(lst,#27'3'#24);       { druck modus '8 lines per inch'   }
    repeat                        { komplette seite drucken:         }
       len:=PrintData(buf);       { zeile mit pixel daten abrufen    }
      if len<0                    { alles gedruckt?                  }
       then exit                  { ja: fertig                       }
       else begin                 { nein: zeile drucken:             }
          write(lst,#27'L'+            { drucker im grafischen..     }
           chr(lo(len))+chr(hi(len))); {..druckmodus starten         }
         for len:=1 to len             { alle pixeldaten..           }
          do write(lst,chr(buf[len])); {..ausdrucken                 }
         writeln(lst);            { drucker vorschub                 }
       end;                       {                                  }
    until false;                  {                                  }
 end;

function DatenSichern: word;
{-[ 23-03-89/nn ]----------------------------------------------------}
{                 transparente daten in datei 'EMPFANG' speichern;   }
{               > transparente daten abholbereit im decoder.         }
{               < letzten rckkehr code von BtxTerminal zurckgeben. }
{-[ janussoft ]----------------------------------------------------}
 var
    f: file;                      { datei die daten aufnimmt         }
    b: dataarea;                  { daten puffer                     }
    rc: word;                     { rckkehr ereignis                }
 begin
    assign(f,'empfang');          { datei lschen (falls vorhanden)..}
    rewrite(f,1);                 {..und zum beschreiben erffnen    }
    b.mxlang:=256;                { maximale puffergre angeben     }
    repeat                        { datei empfangen:                 }
      ReadData(1,true,b);         { transparente daten lesen/lschen }
       blockwrite(f,b.puffer,b.laenge); { daten in datei speichern   }
       rc:=BtxTerminal;           { eventuell mehr daten abwarten    }
    until rc<>$0801;              { bleiben solange daten kommen     }
    close(f);                     { datei schlieen                  }
    datensichern:=rc;             { rckkehr code weiter geben       }
 end;

 begin
   Initialize;                    { decoder fr btx initialisieren   }
   if Connect<3                   { verbindungsaufbau. gelungen?     }
    then begin                    { ja:                              }
      CmdPageEndCriteria($28);    { spezielles seitenende freigeben  }
      if CmdDataPath(1)=1         { transparente daten anfordern..   }
       then;                      {..(1 ist als parameter gltig)    }
       r:='#/kennwort#/';         { dialogschritte zum anmelden      }
       repeat                     {                                  }
          rc:=BtxTerminal;        { btx terminal betrieb             }
         if rc=$0801              { transparente daten?              }
          then rc:=DatenSichern;  { ja: speichern                    }
         case rc of               { welches rckkehrereignis?        }
         $2008..$2028:            { seitenende:                      }
         if length(r)>0           { mehr dialogschritte?             }
          then begin              { ja: nchsten schritt senden:     }
             p:=pos('/',r);       { suche nchstes trennzeichen      }
             s:=copy(r,1,pred(p)); { alle zeichen vor '/' bernehmen }
             r:=copy(r,succ(p),255); { alle zeichen nach '/' sichern }
          end                     {                                  }
          else begin              { nein: briefkasten ausdrucken:    }
             s:=ReadNumber;       { aktuelle systemnachricht lesen   }
            if (s='')             { auf anfangsseite oder..          }
             or (s='1B079')       {..nach 'nachricht gelscht'?      }
             then s:='*88#2'      { ja: nchste seite anfordern      }
            else if s='1B245'     { 'keine neuen nachrichten'?       }
             then s:='*9#'        { ja: verbindung beenden           }
            else if s='1B049'     { frage nach 'speichern?'?         }
             then begin           { ja: seite drucken:               }
               SeiteDrucken;      { seite grafisch ausdrucken        }
                s:='2';           { 'nicht speichern'                }
             end;                 {                                  }
          end;                    {                                  }
          end{case};              {                                  }
          s:=TransmitText(s);     { zeichenkette absenden            }
       until rc=$4000;            { nach verbindungsabbruch aufhren }
    end;                          {                                  }
   Terminate;                     { decoder in pc modus zurcksetzen }
 end.
