program btx;
{-[ 23-03-89/nn ]----------------------------------------------------}
{                 btx briefkasten leeren (grafisch ausdrucken)       }
{-[ janussoft ]----------------------------------------------------}
 uses
    printer,                      { druckfunktionen                  }
    btxapi;                       { schnittstelle zum decoder        }
 var
    rc: word;                     { rckkehr code                    }
    s, r: string;                 { zwischenspeicher                 }
    p: byte;                      { suchposition                     }

procedure SeiteDrucken;
{-[ 23-03-89/nn ]----------------------------------------------------}
{                 aktuelle btx seite grafisch ausdrucken             }
{-[ janussoft ]----------------------------------------------------}
 var
    buf: printbuffer;             { puffer fr pixel daten           }
    len: integer;                 { lnge einer zeile                }
 begin
    writeln(lst,#27'3'#24);       { druck modus '8 lines per inch'   }
    repeat                        { komplette seite drucken:         }
       len:=PrintData(buf);       { zeile mit pixel daten abrufen    }
      if len<0                    { alles gedruckt?                  }
       then exit                  { ja: fertig                       }
       else begin                 { nein: zeile drucken:             }
          write(lst,#27'L'+            { drucker im grafischen..     }
           chr(lo(len))+chr(hi(len))); {..druckmodus starten         }
         for len:=1 to len             { alle pixeldaten..           }
          do write(lst,chr(buf[len])); {..ausdrucken                 }
         writeln(lst);            { drucker vorschub                 }
       end;                       {                                  }
    until false;                  {                                  }
 end;

 begin
   Initialize;                    { decoder fr btx initialisieren   }
   if Connect<3                   { verbindungsaufbau. gelungen?     }
    then begin                    { ja:                              }
      CmdPageEndCriteria($28);    { spezielles seitenende freigeben  }
       r:='#/kennwort#/';         { dialogschritte zum anmelden      }
       repeat                     {                                  }
          rc:=BtxTerminal;        { btx terminal betrieb             }
         case rc of               { welches rckkehrereignis?        }
         $2008..$2028:            { seitenende:                      }
         if length(r)>0           { mehr dialogschritte?             }
          then begin              { ja: nchsten schritt senden:     }
             p:=pos('/',r);       { suche nchstes trennzeichen      }
             s:=copy(r,1,pred(p)); { alle zeichen vor '/' bernehmen }
             r:=copy(r,succ(p),255); { alle zeichen nach '/' sichern }
             s:=TransmitText(s);  { zeichenkette absenden            }
          end                     {                                  }
          else begin              { nein: briefkasten ausdrucken:    }
             s:=ReadNumber;       { aktuelle systemnachricht lesen   }
            if (s='')             { auf anfangsseite oder..          }
             or (s='1B079')       {..nach 'nachricht gelscht'?      }
             then s:='*88#2'      { ja: nchste seite anfordern      }
            else if s='1B245'     { 'keine neuen nachrichten'?       }
             then s:='*9#'        { ja: verbindung beenden           }
            else if s='1B049'     { frage nach 'speichern?'?         }
             then begin           { ja: seite drucken:               }
               SeiteDrucken;      { seite grafisch ausdrucken        }
                s:='2';           { 'nicht speichern'                }
             end;                 {                                  }
             s:=TransmitText(s);  { zeichenkette absenden            }
          end;                    {                                  }
          end{case};              {                                  }
       until rc=$4000;            { nach verbindungsabbruch aufhren }
    end;                          {                                  }
   Terminate;                     { decoder in pc modus zurcksetzen }
 end.
