                                        {                                      }
unit btxapi;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 anwendungsprogramm schnittstelle (BTXAPI) zum janussoft btx  }
{                 decoder (JaBtx)                                              }
{-[ janussoft ]--------------------------------------------------------------}

 interface

 uses

    dos;

 type

    decdata=record                      { decoder datenbereich:                }
    { verbindung: ------------------------------------------------------------ }
       modem: byte;                     { modemtyp                             }
       onlineflag: boolean;             { true falls online                    }
       notimeout: boolean;              { true falls ohne timeout              }
    { btx seite: ------------------------------------------------------------- }
       attribflag: boolean;             { true falls attribute unwirksam       }
       revealflag: boolean;             { true falls seite aufgedeckt          }
       cc: integer;                     { nicht benutzt                        }
       screenrows: byte;                { 19/23: 20 oder 24 zeilige seite      }
       cursoron: boolean;               { true falls cursor an                 }
       xc: byte;                        { x position des cursors               }
       yc: byte;                        { y position des cursors               }
       btxbuf: array[0..999] of word;   { zeichencodes und attribute           }
       btxatt: array[0..999] of word;   { farb- und blinkattribute             }
       pagemsg: string[17];             { seitennummer/systemnachricht         }
    { seitenende: ------------------------------------------------------------ }
       pageendflags: byte;              { aktuelles seitenende                 }
       pageendcrit: byte;               { siehe PageEndCriteria                }
       indbotlnchge: boolean;           { siehe BottomLineChange               }
       cursorfield: integer;            { siehe CursorPosition                 }
    { datenpfad: ------------------------------------------------------------- }
       datapathmask: byte;              { siehe DataPath                       }
       transblksize: byte;              { siehe TransparentBlockLength         }
       inxparency: boolean;             { true: transparente eingabe           }
       xbfofs: integer;                 { nicht..                              }
       xbfseg: integer;                 {..benutzt                             }
    { decodieren: ------------------------------------------------------------ }
       fastdecode: byte;                { nicht benutzt                        }
    { anzeige: --------------------------------------------------------------- }
       previdmode: byte;                { PC Video Mode vor Initialize         }
       btxdisplay: boolean;             { nicht benutzt                        }
       btxline25: boolean;              { siehe BtxLine25                      }
       stdatim: boolean;                { siehe Flags25                        }
       localcursor: boolean;            { nicht benutzt                        }
    { kontrolle: ------------------------------------------------------------- }
       openloop: boolean;               { siehe OpenLoop                       }
       keyboardmode: integer;           { $1000: MF-keyboard                   }
       keyexecmode: byte;               { siehe KeyboardMode                   }
       kycptr: ^byte;                   { zeiger auf tastaturtabelle           }
       proptr: ^byte;                   { zeiger auf profildaten               }
    end;                                {                                      }

    pagedataarea=array[1..$1100] of byte; { puffer fr statische btx-seite     }

    printbuffer=array[1..480] of byte;  { puffer fr druckdaten bergabe       }

    timeoutdata=record                  { parameter fr timeout definitionen   }
       time: byte;                      { zeiteinheit (in 6 sekunden)          }
      case word of                      {                                      }
       1: (strofs, strseg: word);       { offset/segment des strings           }
       2: (strptr: pointer);            { pointer auf string                   }
    end;

    dataarea=record                     { datenpuffer fr btx datenbergabe    }
       mxlang: word;                    { lnge des puffers (256)              }
       laenge: word;                    { aktuelle lnge des puffers           }
       puffer: array[1..256] of byte;   { datenbereich                         }
    end;                                {                                      }

 var
    _bx, _es: word;                     { zeiger auf decoder datenbereich      }
    dd:  ^decdata absolute _bx;         { zeiger auf decoder datenbereich      }

procedure Initialize;
function Connect: word;
procedure Disconnect;
procedure Terminate;
procedure ResetVideo;
procedure EnableVideo;
procedure AttributesOn;
procedure AttributesOff;
procedure ToggleAttributes;
procedure ToggleReveal;
procedure DisplayText;
function SetParameter(paramblock: string): word;
procedure ParameterDefaults;
function CloseBulk: word;
function BtxTerminal: word;
function TransmitCept(sendstr: string): string;
function TransmitText(sendstr: string): string;
procedure DisplayPage;
procedure ClearScreen;
procedure WriteString(zeile, spalte, index: byte; zeichen: string);
procedure SetAttribute(zeile, spalte, index, laenge, richtung: byte);
procedure LocalDecode(laenge: word; var datenpuffer);
procedure SavePage(var datenpuffer: pagedataarea);
procedure ReshowPage(var datenpuffer: pagedataarea);
function ReadString(zeile, spalte, laenge: byte): string;
function ReadNumber: string;
function ReadMsgCode: word;
procedure ReadData(art: byte; loesch: boolean; var daten: dataarea);
function SavePageData(laenge: word; var datenpuffer): integer;
function PrintData(var datenpuffer: printbuffer): integer;
procedure UnInstall;
function VersionNumber: word;
function Manufactorer: word;
function CmdModemType(modem: byte): integer;
function CmdInitModem(modeminit: string): integer;
function CmdKeyboardMode(keybmode: byte): integer;
procedure CmdPageEndCriteria(pageend: byte);
procedure CmdCursorPosition(zeile, spalte: byte);
function CmdBtxDisplay(modus: byte): integer;
procedure CmdBtxLine25(modus: boolean);
procedure CmdTimeout15(modus: timeoutdata);
procedure CmdBottomLineChange(modus: boolean);
function CmdDataPath(modus: byte): integer;
procedure CmdTransparentBlocklength(laenge: byte);
procedure CmdOpenLoop(modus: boolean);
procedure CmdFlagsInLine25(modus: boolean);

 implementation

 var
    r: registers;                       { register satz fr software interrupt }
    cmdstring: string[64];              { parameter block bergabe bereich     }

procedure Initialize;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 decoder initialisieren                                       }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0101;  r.es:=0;              { 'Initialize' decoder..               }
    intr($65,r);                        {..ohne parameter                      }
 end;

function Connect: word;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 verbindung zum btx system aufbauen                           }
{               < $0001: verbindung hergestellt                                }
{                 $0002: verbindung bestand bereits                            }
{                 $101b: verbindungsaufbau abgebrochen mit Esc                 }
{                 $4001: verbindungsaufbau nicht gelungen                      }
{                 $8000: 'OpenLoop' rckkehr                                   }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0102;  r.es:=0;              { 'Connect' ohne..                     }
    intr($65,r);                        {..parameter                           }
    connect:=r.ax;                      { ergebnis: 'verbindung'               }
 end;

procedure Disconnect;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 verbindung zum btx system abbrechen                          }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0103;                        { 'Dis-..                              }
    intr($65,r);                        {..connect'                            }
 end;

procedure Terminate;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 programmende vorbereiten                                     }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0104;                        { 'Ter-..                              }
    intr($65,r);                        {..minate'                             }
 end;

procedure ResetVideo;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 bildschirm temporr in pc modus bringen                      }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0105;                        { 'Reset-..                            }
    intr($65,r);                        {..Video'                              }
 end;

procedure EnableVideo;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 bildschirm wieder in btx modus bringen                       }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0106;                        { 'Enable-..                           }
    intr($65,r);                        {..Video'                              }
 end;

procedure AttributesOn;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 attribute wieder anzeigen (falls attribute ausgeschaltet)    }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0107;                        { 'Attributes..                        }
    intr($65,r);                        {..On'                                 }
 end;

procedure AttributesOff;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 attribute unwirksam machen                                   }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0108;                        { 'Attributes..                        }
    intr($65,r);                        {..Off'                                }
 end;

procedure ToggleAttributes;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 attributstatus umkehren                                      }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0109;                        { 'Toggle..                            }
    intr($65,r);                        {..Attributes'                         }
 end;

procedure ToggleReveal;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 status von 'verdeckte information sichtbar machen' wechseln  }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$010a;  intr($65,r);          { 'ToggleReveal'                       }
 end;

procedure DisplayText;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 seite ohne attribute und drcs darstellen                     }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0113;  intr($65,r);          { 'DisplayText'                        }
 end;

function SetParameter(paramblock: string): word;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 parameter block mit btx kommandos bergeben                  }
{               < $0001: parameter verarbeitet                                 }
{                 $ffff: parameter block ungltig                              }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(paramblock);              { zeiger auf..                         }
    r.bx:=ofs(paramblock);              {..parameterblock                      }
    r.ax:=$010b;                        { 'Set..                               }
    intr($65,r);                        {..Parameter'                          }
    setparameter:=r.ax;                 { ergebnis: 'ok' oder 'nicht ok'       }
 end;

procedure ParameterDefaults;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 alle decoder parameter auf anfangswert zurcksetzen          }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$010c;  r.es:=0;              { 'Parameter..                         }
    intr($65,r);                        {..Defaults' (ohne parameter)          }
 end;

function CloseBulk: word;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 transparente dateneingabe beenden                            }
{               < $0001: transparente dateneingabe beendet                     }
{               < $8000: warten, transparente dateneingabe noch nicht beendet  }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0112;  intr($65,r);          { 'CloseBulk'                          }
    closebulk:=r.ax;                    { 1/$8000                              }
 end;

function BtxTerminal: word;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 btx terminal betrieb                                         }
{               < $4000: verbindung besteht nicht (mehr)                       }
{                 $20XX: seitenendekriterium wurde erfllt                     }
{                 $1XXX: tastatur wurde bettigt                               }
{                 $080X: es liegen abholbereite daten vor                      }
{                 $0100: seitennummer/systemnachricht hat sich gendert        }
{                 $8000: 'OpenLoop' rckkehr                                   }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0201;  r.es:=0;              { 'BtxTerminal'..                      }
    intr($65,r);                        {..ohne parameter                      }
    btxterminal:=r.ax;                  { rckkehr status                      }
 end;

function TransmitCept(sendstr: string): string;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 sende zeichenkette unkonvertiert zum btx system              }
{               > SENDSTR enthlt die zu sendende zeichenkette.                }
{               < die funktion gibt den teil von SENDSTR zurck, der nicht     }
{                 sofort gepuffert werden konnte oder eine leere zeichenkette, }
{                 falls alle zeichen sofort bernommen wurden.                 }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(sendstr);                 { zeiger auf..                         }
    r.bx:=ofs(sendstr);                 {..zeichenkette                        }
    r.ax:=$0203;                        { 'Transmit..                          }
    intr($65,r);                        {..Cept'                               }
    transmitcept:=sendstr;              { rest der zeichenkette wieder zurck  }
 end;

function TransmitText(sendstr: string): string;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 sende zeichenkette nach btx umsetzung zum btx system         }
{               > SENDSTR enthlt die zu sendende zeichenkette.                }
{               < die funktion gibt den teil von SENDSTR zurck, der nicht     }
{                 sofort gepuffert werden konnte oder eine leere zeichenkette, }
{                 falls alle zeichen sofort bernommen wurden.                 }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(sendstr);                 { zeiger auf..                         }
    r.bx:=ofs(sendstr);                 {..zeichenkette                        }
    r.ax:=$0204;                        { 'Transmit..                          }
    intr($65,r);                        {..Text'                               }
    transmittext:=sendstr;              { rest der zeichenkette wieder zurck  }
 end;


procedure DisplayPage;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 btx bildschirm mit aktueller seite wieder anzeigen           }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0303;                        { 'Display..                           }
    intr($65,r);                        {..Page'                               }
 end;


procedure ClearScreen;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 btx bildschirm lschen und 24 zeilig machen, falls 20-zeilig }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$030b;  intr($65,r);          { 'ClearScreen'                        }
 end;


procedure WriteString(zeile, spalte, index: byte; zeichen: string);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 zeichenkette zur anzeige bringen                             }
{               > ZEILE (0..24); SPALTE (0..39); INDEX (0..15)                 }
{                 ZEICHEN enthlt die zeichenkette                             }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(zeichen);                 { zeiger auf..                         }
    r.bx:=ofs(zeichen);                 {..zeichenkette                        }
    r.ch:=index;  r.cl:=$80;            { indiziertes attribut angeben         }
    r.dl:=spalte;  r.dh:=zeile;         { bildschirm position angeben          }
    r.ax:=$0301;                        { 'Write..                             }
    intr($65,r);                        {..String'                             }
 end;


procedure SetAttribute(zeile, spalte, index, laenge, richtung: byte);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 attribute setzen                                             }
{               > ZEILE (0..24); SPALTE (0..39); INDEX (0..15); LAENGE(1..40)  }
{                 RICHTUNG (0: horizontal, 1: vertikal)                        }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ch:=index;                        { indiziertes attribut angeben         }
    r.cl:=$80 or richtung shl 6 or laenge; { lnge und richtung angeben        }
    r.dl:=spalte;  r.dh:=zeile;         { bildschirm position angeben          }
    r.ax:=$0302;                        { 'Set..                               }
    intr($65,r);                        {..Attribute'                          }
 end;

procedure LocalDecode(laenge: word; var datenpuffer);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 daten decodieren                                             }
{               > LAENGE (0..8KB-1)                                            }
{                 DATENPUFFER enthlt die zu decodierenden daten               }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(datenpuffer);             { zeiger auf..                         }
    r.bx:=ofs(datenpuffer);             {..datenpuffer                         }
    r.cx:=laenge;                       { lnge der daten in DATENPUFFER       }
    r.ax:=$030c;                        { 'Local..                             }
    intr($65,r);                        {..Decode'                             }
 end;

procedure SavePage(var datenpuffer: pagedataarea);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 statische btx seite abspeichern                              }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(datenpuffer);             { zeiger auf..                         }
    r.bx:=ofs(datenpuffer);             {..datenpuffer                         }
    r.ax:=$0306;  intr($65,r);          { 'SavePage'                           }
 end;

procedure ReshowPage(var datenpuffer: pagedataarea);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 statische btx seite anzeigen                                 }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(datenpuffer);             { zeiger auf..                         }
    r.bx:=ofs(datenpuffer);             {..datenpuffer                         }
    r.ax:=$0304;  intr($65,r);          { 'ReshowPage'                         }
 end;

function ReadString(zeile, spalte, laenge: byte): string;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 daten aus btx seite bernehmen                               }
{               > ZEILE (0..24); SPALTE (0..39); LAENGE(0..255)                }
{                 gelesene daten sind funktionsergebnis                        }
{-[ janussoft ]--------------------------------------------------------------}
 var
    str: string;                        { zwischenspeicher fr daten           }
 begin
    r.es:=seg(str);                     { zeiger auf..                         }
    r.bx:=ofs(str);                     {..zwischenspeicher                    }
    r.cx:=laenge;                       { lnge der daten in DATENPUFFER       }
    r.dl:=spalte;  r.dh:=zeile;         { bildschirm position angeben          }
    r.ax:=$0305;  intr($65,r);          { 'ReadString'                         }
    readstring:=str;                    { gelesene zeichenkette                }
 end;


function ReadNumber: string;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 aktuelle seitennummer/systemnachricht lesen                  }
{-[ janussoft ]--------------------------------------------------------------}
 var
    str: string;                        { zwischenspeicher fr daten           }
 begin
    r.es:=seg(str);                     { zeiger auf..                         }
    r.bx:=ofs(str);                     {..zwischenspeicher                    }
    r.ax:=$030a;  intr($65,r);          { 'ReadNumber'                         }
    readnumber:=str;                    { gelesene zeichenkette                }
 end;


function ReadMsgCode: word;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 code der aktuellen systemnachricht lesen                     }
{                 (z.B. SH399 => $0399 als Funktionsergebnis)                  }
{-[ janussoft ]--------------------------------------------------------------}
 var
    str: string;                        { zwischenspeicher fr daten           }
 begin
    r.es:=seg(str);                     { zeiger auf..                         }
    r.bx:=ofs(str);                     {..zwischenspeicher                    }
    r.ax:=$030a;  intr($65,r);          { 'ReadNumber'                         }
    readmsgcode:=r.ax;                  { gelesener code der nachricht         }
 end;


procedure ReadData(art: byte; loesch: boolean; var daten: dataarea);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 daten aus dem decoder bernehmen                             }
{               > ART=1: transparente daten (transparenz der ebene 2)          }
{                 ART=2: unbekannte decoder referenzen                         }
{                 LOESCH=TRUE: daten werden im decoder gelscht                }
{                 DATEN.MXLANG wird die gre des empfangspuffers              }
{                 (DATEN.PUFFER) angegeben                                     }
{               < in DATEN.LAENGE wird die lnge der zurckgegeben daten       }
{                 angegeben                                                    }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    daten.mxlang:=256;                  { maximale lnge vorgeben              }
    r.cl:=art;                          { art der daten                        }
    r.ch:=ord(loesch) xor 1;            { lschen (ja/nein)                    }
    r.es:=seg(daten);                   { zeiger auf..                         }
    r.bx:=ofs(daten);                   {..datenspeicher                       }
    r.ax:=$0307;  intr($65,r);          { 'ReadData'                           }
 end;

function SavePageData(laenge: word; var datenpuffer): integer;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 dynamische btx seite abspeichern                             }
{               > LAENGE gibt an, wie viele zeichen DATENPUFFER aufnehmen kann }
{               < funktionsergebnis ist die lnge der zurckgegebenen daten,   }
{                 oder 0, falls keine eingrenzung der seite mglich war,       }
{                 oder -1, falls der pufferbereich zu klein ist fr die seite. }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(datenpuffer);             { zeiger auf..                         }
    r.bx:=ofs(datenpuffer);             {..datenpuffer                         }
    r.cx:=laenge;                       { lnge des bereichs DATENPUFFER       }
    r.ax:=$030d;  intr($65,r);          { 'SavePage'                           }
    savepagedata:=r.ax;                 { lnge der zurckgegebenen daten      }
 end;

function PrintData(var datenpuffer: printbuffer): integer;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 pixeldaten der btx seite fr grafikdrucker bereitstellen     }
{               < funktionsergebnis ist die lnge der zurckgegebenen daten.   }
{                 es variiert zwischen 0 und 480, oder ist -1, falls die seite }
{                 komplett bergeben wurde.                                    }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.es:=seg(datenpuffer);             { zeiger auf..                         }
    r.bx:=ofs(datenpuffer);             {..datenpuffer                         }
    r.ax:=$0308;  intr($65,r);          { 'PrintData'                          }
    printdata:=r.ax;                    { lnge der zurckgegebenen daten      }
 end;

procedure UnInstall;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 decoder aus dem hauptspeicher entfernen                      }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0401;  intr($65,r);          { 'Uninstall'                          }
 end;

function VersionNumber: word;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 versionsnummer des decoders angeben                          }
{               < hi(x): hauptrelease; lo(x): unterrelease                     }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0402;  intr($65,r);          { 'VersionNumber'                      }
    versionnumber:=r.ax;                {                                      }
 end;

function Manufactorer: word;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 zeichen fr decoder hersteller zurckgeben                   }
{               < 'ja' ($616a)                                                 }
{-[ janussoft ]--------------------------------------------------------------}
 begin
    r.ax:=$0403;  intr($65,r);          { 'Manufactorer'                       }
    manufactorer:=r.ax;                 {                                      }
 end;


function CmdModemType(modem: byte): integer;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 modemtyp angeben                                             }
{               > MODEM:  1=d-bt03;  3=1200/1200;  4=2400/2400;  5=75/1200     }
{               < 1: modem erkannt;  -1: modemtyp nicht untersttzt            }
{-[ janussoft ]--------------------------------------------------------------}
 const
    modemcmd: string[3]=#2#8#1;         { parameter block fr modemangabe      }
 begin
    modemcmd[3]:=chr(modem);            { modem typ definieren                 }
    r.es:=seg(modemcmd);                { zeiger auf..                         }
    r.bx:=ofs(modemcmd);                {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
    cmdmodemtype:=r.ax;                 { gltig/nicht gltig                  }
 end;


function CmdInitModem(modeminit: string): integer;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 modemtyp initialisieren                                      }
{               > MODEMINIT enthlt die zeichenkette, mit der der modem zu     }
{                 initialisieren ist.                                          }
{               < 1: ok;             -1: falscher parameter                    }
{-[ janussoft ]--------------------------------------------------------------}
 const
    modeminitcmd: string[2]=#0#7;       { parameter block fr modemangabe      }
 begin
    modeminitcmd[1]:=chr(succ(length(modeminit))); { parameter block..         }
    insert(modeminitcmd,modeminit,1);   {..aufbauen                            }
    r.es:=seg(modeminit);               { zeiger auf..                         }
    r.bx:=ofs(modeminit);               {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
    cmdinitmodem:=r.ax;                 { gltig/nicht gltig                  }
 end;


function CmdKeyboardMode(keybmode: byte): integer;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 tastatur interpretations modus angeben                       }
{               > KEYBMODE:                                                    }
{               < 1: modus gesetzt;  -1: ungltiger modus                      }
{-[ janussoft ]--------------------------------------------------------------}
 const
    validmodes: string[9]=#0#1#$80#$41#$40#$21#$11#$8#$4;  { gltige modi      }
    keyboardcmd: string[3]=#2#3#0;      { parameter block fr tastaturmodus    }
 begin
   if pos(chr(keybmode),validmodes)=0   { gltiger modus?                      }
    then cmdkeyboardmode:=-1            { nein: 'nicht gltig'                 }
    else begin                          { ja:                                  }
       keyboardcmd[3]:=chr(keybmode);   { setze neuen modus                    }
       r.es:=seg(keyboardcmd);          { zeiger auf..                         }
       r.bx:=ofs(keyboardcmd);          {..parameter block                     }
       r.ax:=$010b;  intr($65,r);       { 'SetParameter'                       }
       cmdkeyboardmode:=1;              { 'gltig'                             }
    end;                                {                                      }
 end;


procedure CmdPageEndCriteria(pageend: byte);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 seitenende kriterium angeben                                 }
{               > PAGEEND (0..255)                                             }
{-[ janussoft ]--------------------------------------------------------------}
 const
    pageendcmd: string[3]=#2#6#0;       { parameter block fr seitenende       }
 begin
    pageendcmd[3]:=chr(pageend);        { setze neuen modus                    }
    r.es:=seg(pageendcmd);              { zeiger auf..                         }
    r.bx:=ofs(pageendcmd);              {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;


procedure CmdCursorPosition(zeile, spalte: byte);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 cursor position fr spezielles seitenende angeben            }
{               > ZEILE (0..23); SPALTE (0..39)                                }
{-[ janussoft ]--------------------------------------------------------------}
 const
    cursorposcmd: string[4]=#3#6#0#0;   { parameter block fr cursor position  }
 begin
    cursorposcmd[3]:=chr(zeile);        { cursor..                             }
    cursorposcmd[4]:=chr(spalte);       {..position angeben                    }
    r.es:=seg(cursorposcmd);            { zeiger auf..                         }
    r.bx:=ofs(cursorposcmd);            {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;


function CmdBtxDisplay(modus: byte): integer;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 art der bildschirm anzeige festlegen                         }
{               > MODUS=0: decodierte daten nicht anzeigen                     }
{                 MODUS=1: decodierte daten anzeigen                           }
{               < 1: ok;             -1: falscher parameter                    }
{-[ janussoft ]--------------------------------------------------------------}
 const
    btxdisplaycmd: string[3]=#2#2#0;    { parameter block fr bildschirm       }
 begin
   if modus>2                           { ungltiger wert?                     }
    then cmdbtxdisplay:=-1              { ja: 'ungltig'                       }
    else begin                          { nein:                                }
       btxdisplaycmd[3]:=chr(modus);    { bildschirmmodus angeben              }
       r.es:=seg(btxdisplaycmd);        { zeiger auf..                         }
       r.bx:=ofs(btxdisplaycmd);        {..parameter block                     }
       r.ax:=$010b;  intr($65,r);       { 'SetParameter'                       }
       cmdbtxdisplay:=1;                { 'ok'                                 }
    end;                                {                                      }
 end;


procedure CmdBtxLine25(modus: boolean);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 zeile 25 untersttzung ein- oder ausschalten                 }
{               > MODUS=TRUE: zeile 25 (1..25) anzeigen                        }
{                 MODUS=FALSE: zeile 25 nicht anzeigen                         }
{-[ janussoft ]--------------------------------------------------------------}
 const
    btxline25cmd: string[3]=#2#5#0;     { parameter block fr zeile 25         }
 begin
    btxline25cmd[3]:=char(modus);       { setze neuen modus                    }
    r.es:=seg(btxline25cmd);            { zeiger auf..                         }
    r.bx:=ofs(btxline25cmd);            {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;

procedure CmdTimeout15(modus: timeoutdata);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 15 minuten zeitkriterium ein- oder ausschalten               }
{               > MODUS.TIME=0: verbindungsabbruch mglich                     }
{                 MODUS.TIME>0: zeichenkette MODUS.STRPTR^ alle                }
{                 MODUS.TIME*6 sekunden senden => kein abbruch                 }
{-[ janussoft ]--------------------------------------------------------------}
 const
    timeout15cmd: string[7]=#6#9#0#0#0#0#0; { parameterblock fr zeitkriterium }
 begin
    move(modus,timeout15cmd[3],5);      { setze neuen modus                    }
    r.es:=seg(timeout15cmd);            { zeiger auf..                         }
    r.bx:=ofs(timeout15cmd);            {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;

procedure CmdBottomLineChange(modus: boolean);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 anzeige der nderungen in zeile 25 ein- oder ausschalten     }
{               > MODUS=TRUE: anzeigen wenn nderung in zeile 25 (1..25)       }
{                 MODUS=FALSE: keine anzeige von nderungen der zeile 25       }
{-[ janussoft ]--------------------------------------------------------------}
 const
    bottomlinecmd: string[3]=#2#$c#0;   { parameter block fr zeilennderung   }
 begin
    bottomlinecmd[3]:=char(modus);      { setze neuen modus                    }
    r.es:=seg(bottomlinecmd);           { zeiger auf..                         }
    r.bx:=ofs(bottomlinecmd);           {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;

function CmdDataPath(modus: byte): integer;
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 datenart angeben, die zur anwendung geleitet werden sollen   }
{               > MODUS (0..7)                                                 }
{               < 1: ok;             -1: falscher parameter                    }
{-[ janussoft ]--------------------------------------------------------------}
 const
    datapathcmd: string[3]=#2#$b#0;     { parameter block fr datenart         }
 begin
   if modus>7                           { ungltiger modus?                    }
    then cmddatapath:=-1                { ja: 'ungltig'                       }
    else begin                          { nein:                                }
       datapathcmd[3]:=chr(modus);      { datenart angeben                     }
       r.es:=seg(datapathcmd);          { zeiger auf..                         }
       r.bx:=ofs(datapathcmd);          {..parameter block                     }
       r.ax:=$010b;  intr($65,r);       { 'SetParameter'                       }
       cmddatapath:=1;                  { 'ok'                                 }
    end;                                {                                      }
 end;

procedure CmdTransparentBlocklength(laenge: byte);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 lnge der zu sendenden transparenten blcke angeben          }
{               > LAENGE (32..255, andere werte werden angepat)               }
{-[ janussoft ]--------------------------------------------------------------}
 const
    blocklength: string[3]=#2#$a#0;     { parameter block fr blocklnge       }
 begin
    blocklength[3]:=chr(laenge);        { setze neuen laenge                   }
    r.es:=seg(blocklength);             { zeiger auf..                         }
    r.bx:=ofs(blocklength);             {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;

procedure CmdOpenLoop(modus: boolean);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 angabe ob BtxTerminal und Connect die Kontrolle behalten     }
{                 oder stndig an die anwendung zurckgeben sollen.            }
{               > MODUS=TRUE: kontrolle zurckgeben                            }
{                 MODUS=FALSE: kontrolle behalten bis anderer rckkehrgrund    }
{-[ janussoft ]--------------------------------------------------------------}
 const
    openloopcmd: string[3]=#2#1#0;      { parameter block fr kontrolle        }
 begin
    openloopcmd[3]:=char(modus);        { setze neuen modus                    }
    r.es:=seg(openloopcmd);             { zeiger auf..                         }
    r.bx:=ofs(openloopcmd);             {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;

procedure CmdFlagsInLine25(modus: boolean);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 statusanzeige fr datenverkehr etc. in zeile 25 ein oder aus }
{               > MODUS=TRUE: stati anzeigen                                   }
{                 MODUS=FALSE: keine status anzeige in zeile 25                }
{-[ janussoft ]--------------------------------------------------------------}
 const
    flags25cmd: string[3]=#2#$f#0;      { parameter block fr statusanzeige    }
 begin
    flags25cmd[3]:=char(modus);         { setze neuen modus                    }
    r.es:=seg(flags25cmd);              { zeiger auf..                         }
    r.bx:=ofs(flags25cmd);              {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;

procedure CmdSetTFI(s: string);
{-[ 23-03-89/nn ]--------------------------------------------------------------}
{                 TFI zeichenfolge definieren                                  }
{-[ janussoft ]--------------------------------------------------------------}
 const
    settficmd: string[2]=#0#$10;        { parameter block fr tfi setzen       }
 begin
    settficmd[1]:=chr(succ(length(s))); { parameter block..                    }
    insert(settficmd,s,1);              {..aufbauen                            }
    r.es:=seg(settficmd);               { zeiger auf..                         }
    r.bx:=ofs(settficmd);               {..parameter block                     }
    r.ax:=$010b;  intr($65,r);          { 'SetParameter'                       }
 end;

 begin
   if memw[memw[0:$196]:memw[0:$194]-2]<>$534e { 'load marker' vorhanden?      }
    then begin                          { nein:                                }
       writeln(#$a'Janussoft Btx Decoder (JaBtx) nicht geladen'#7);
       halt(255);                       { aufhren mit errorlevel 255          }
    end;                                {                                      }
    r.ax:=$010b;  r.es:=0;              { 'SetParameter'..                     }
    intr($65,r);                        {..ohne parameter                      }
    _es:=r.es;  _bx:=r.bx;              { zeiger auf decoder daten sichern     }
 end.
                                        {                                      }
