          page 84,132           ;
          title Interface between Microfocus Cobol and Janussoft Btx-API
                                ;
;=[ 10-02-89/ns ]===============================================================
;
;               ? glue code for calling btx-api functions from micro focus cobol
;                 or code from any other compiler which does not allow to issue
;                 generic software interrupts.
;
;               > we expect a far address on the stack which addresses a buffer
;                 area called APIBUFFER, which holds:
;                 0   2   4   6   8   10  12  14
;                 AX, BX, CX, DX, ES, SI, DI, BP (words, that is 2 bytes each);
;                             16             17..271
;                 DATABUFFER (1 byte length, 255 bytes data).
;
;                 what we do:
;                 all registers are saved. then all registers but BX and ES are
;                 loaded with their APIBUFFER values; ES:BX is loaded to point
;                 to the length value of DATABUFFER.
;                 next a call to btx-api (interrupt 65h) is made.
;
;               < on return the registers are stored in their APIBUFFER position
;                 (even ES and BX); then registers are restored from the stack.
;                 note: we (and janussoft btx-api) use the stack of our caller.
;                 note: at this time, no btx-api function call makes use of
;                       registers SI, DI, BP, which are included for future use.
;
;               ! test environment for COBL2BTX.ASM in COBL2BTX.PAS.
;                 COBL2BTX has to be compiled by MASM (or TASM) and linked
;                 into the callers (e.g. micro focus cobol) code.
;
;=[ janussoft ]===============================================================
                                ;
code      segment byte
          assume  cs: code

          public cobl2btx

cobl2btx  proc  far

          ; start saving environment:
          push  bp              ; make stack values addressable..
          mov   bp,sp           ;..by SS:BP (-> BP, retf, pointer to APIBUFFER)
          push  ax              ; we save all registers, as we don't..
          push  bx              ;..
          push  cx              ;..
          push  dx              ;..
          push  es              ;..
          push  si              ;..
          push  di              ;..know which may be savely used

          ; environment is save now. now load registers from APIBUFFER:
          les   bx,[bp+6]       ; make ES:BX point to APIBUFFER
          mov   ax,es:[bx]      ; load AX from APIBUFFER
          mov   cx,es:[bx+4]    ; load CX from APIBUFFER
          mov   dx,es:[bx+6]    ; load DX from APIBUFFER
          mov   si,es:[bx+10]   ; load SI from APIBUFFER
          mov   di,es:[bx+12]   ; load DI from APIBUFFER
          mov   bp,es:[bx+14]   ; load BP from APIBUFFER

          ; all registers (but ES, BX) are ok. save pointer to APIBUFFER and
          ; make ES:BX point to DATABUFFER of APIBUFFER:
          push  es              ; save pointer to..
          push  bx              ;..APIBUFFER
          add   bx,16           ; make ES:BX point to DATABUFFER

          int   65h             ; call btx-api

          ; save result registers from btx-api call:
          push  es              ; save pointer to..
          push  bx              ;..decoder data area
          push  bp              ; save base pointer
          mov   bp,sp           ; make BP point to stack
                                ;
          les   bx,[bp+6]       ; restore pointer to APIBUFFER
          mov   es:[bx],ax      ; save function result (if any)
          pop   ax              ; restore base pointer
          mov   es:[bx+14],ax   ; save BP in APIBUFFER
          pop   ax              ; get offset of decoder data area
          mov   es:[bx+2],ax    ; save offset of decoder data area in APIBUFFER
          pop   ax              ; get segment of decoder data area
          mov   es:[bx+8],ax    ; save segment of decoder data area in APIBUFFER

          add   sp,4            ; keep stack clean (remove ptr to APIBUFFER)

          mov   es:[bx+4],cx    ; save CX in APIBUFFER
          mov   es:[bx+6],dx    ; save DX in APIBUFFER
          mov   es:[bx+10],si   ; save SI in APIBUFFER
          mov   es:[bx+12],di   ; save DI in APIBUFFER

          ; registers are saved. restore environment, return to caller:
          pop   di              ; restore..
          pop   si              ;..
          pop   es              ;..
          pop   dx              ;..
          pop   cx              ;..
          pop   bx              ;..
          pop   ax              ;..
          pop   bp              ;..environment
          ret                   ;

;===============================================================================
cobl2btx  endp

code      ends
          end
                                ;
